/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.yank;

import com.maddyhome.idea.vim.action.motion.updown.MotionDownLess1FirstNonSpaceAction;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import com.maddyhome.idea.vim.yank.VimYankGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JJ\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\tH\u0002J,\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00150\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0005J(\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0005H\u0016\u00a8\u0006 "}, d2={"Lcom/maddyhome/idea/vim/yank/YankGroupBase;", "Lcom/maddyhome/idea/vim/yank/VimYankGroup;", "<init>", "()V", "yankRange", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caretToRange", "", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "Lcom/maddyhome/idea/vim/common/TextRange;", "range", "type", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "startOffsets", "Lcom/maddyhome/idea/vim/api/VimCaret;", "", "getTextRange", "ranges", "", "Lkotlin/Pair;", "yankMotion", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "argument", "Lcom/maddyhome/idea/vim/command/Argument;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "yankLine", "count", "moveCursor", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nYankGroupBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YankGroupBase.kt\ncom/maddyhome/idea/vim/yank/YankGroupBase\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,189:1\n216#2,2:190\n*S KotlinDebug\n*F\n+ 1 YankGroupBase.kt\ncom/maddyhome/idea/vim/yank/YankGroupBase\n*L\n34#1:190,2\n*E\n"})
public class YankGroupBase
implements VimYankGroup {
    private final boolean yankRange(VimEditor editor, Map<ImmutableVimCaret, TextRange> caretToRange, TextRange range, SelectionType type, Map<VimCaret, Integer> startOffsets) {
        Map<VimCaret, Integer> map = startOffsets;
        if (map != null) {
            Map<VimCaret, Integer> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<VimCaret, Integer>> object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry<VimCaret, Integer> element$iv;
                Map.Entry<VimCaret, Integer> entry = element$iv = object.next();
                boolean bl = false;
                VimCaret caret = entry.getKey();
                int offset = ((Number)entry.getValue()).intValue();
                caret.moveToOffset(offset);
            }
        }
        VimInjectorKt.getInjector().getListenersNotifier().notifyYankPerformed(caretToRange);
        boolean result = true;
        for (Map.Entry<ImmutableVimCaret, TextRange> entry : caretToRange.entrySet()) {
            ImmutableVimCaret caret = entry.getKey();
            TextRange myRange = entry.getValue();
            result = caret.getRegisterStorage().storeText(editor, myRange, type, false) && result;
        }
        return result;
    }

    @Contract(value="_, _ -> new")
    @Nullable
    protected final TextRange getTextRange(@NotNull List<Pair<Integer, Integer>> ranges, @NotNull SelectionType type) {
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (ranges.isEmpty()) {
            return null;
        }
        int size = ranges.size();
        int[] starts = new int[size];
        int[] ends = new int[size];
        if (type == SelectionType.LINE_WISE) {
            starts[size - 1] = ((Number)ranges.get(size - 1).getFirst()).intValue();
            ends[size - 1] = ((Number)ranges.get(size - 1).getSecond()).intValue();
            int n = size - 1;
            for (int i = 0; i < n; ++i) {
                Pair<Integer, Integer> range = ranges.get(i);
                starts[i] = ((Number)range.getFirst()).intValue();
                ends[i] = ((Number)range.getSecond()).intValue() - 1;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                Pair<Integer, Integer> range = ranges.get(i);
                starts[i] = ((Number)range.getFirst()).intValue();
                ends[i] = ((Number)range.getSecond()).intValue();
            }
        }
        return new TextRange(starts, ends);
    }

    @Override
    public boolean yankMotion(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Argument argument, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        Command motion = argument.getMotion();
        SelectionType type = motion.isLinewiseMotion() ? SelectionType.LINE_WISE : SelectionType.CHARACTER_WISE;
        int nativeCaretCount = editor.nativeCarets().size();
        if (nativeCaretCount <= 0) {
            return false;
        }
        HashMap caretToRange = new HashMap(nativeCaretCount);
        ArrayList<Pair> ranges = new ArrayList<Pair>(nativeCaretCount);
        HashMap<VimCaret, Integer> startOffsets = argument.getMotion().getAction() instanceof MotionDownLess1FirstNonSpaceAction ? null : new HashMap<VimCaret, Integer>(nativeCaretCount);
        for (VimCaret caret : editor.nativeCarets()) {
            TextRange motionRange;
            boolean bl;
            if (VimInjectorKt.getInjector().getMotion().getMotionRange(editor, caret, context, argument, operatorArguments) == null) continue;
            boolean bl2 = bl = motionRange.size() == 1;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            ranges.add(TuplesKt.to((Object)motionRange.getStartOffset(), (Object)motionRange.getEndOffset()));
            HashMap<VimCaret, Integer> hashMap = startOffsets;
            if (hashMap != null) {
                hashMap.put(caret, motionRange.normalize().getStartOffset());
            }
            ((Map)caretToRange).put(caret, new TextRange(motionRange.getStartOffset(), motionRange.getEndOffset()));
        }
        TextRange textRange = this.getTextRange((List<Pair<Integer, Integer>>)ranges, type);
        if (textRange == null) {
            return false;
        }
        TextRange range = textRange;
        if (range.size() == 0) {
            return false;
        }
        return this.yankRange(editor, caretToRange, range, type, (Map<VimCaret, Integer>)startOffsets);
    }

    @Override
    public boolean yankLine(@NotNull VimEditor editor, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int caretCount = editor.nativeCarets().size();
        ArrayList<Pair> ranges = new ArrayList<Pair>(caretCount);
        HashMap caretToRange = new HashMap(caretCount);
        for (VimCaret caret : editor.nativeCarets()) {
            int start = VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineStart(editor, caret);
            int end = Math.min(VimInjectorKt.getInjector().getMotion().moveCaretToRelativeLineEnd(editor, caret, count - 1, true) + 1, (int)editor.fileSize());
            if (end == -1) continue;
            ranges.add(TuplesKt.to((Object)start, (Object)end));
            ((Map)caretToRange).put(caret, new TextRange(start, end));
        }
        TextRange textRange = this.getTextRange((List<Pair<Integer, Integer>>)ranges, SelectionType.LINE_WISE);
        if (textRange == null) {
            return false;
        }
        TextRange range = textRange;
        return this.yankRange(editor, caretToRange, range, SelectionType.LINE_WISE, null);
    }

    @Override
    public boolean yankRange(@NotNull VimEditor editor, @Nullable TextRange range, @NotNull SelectionType type, boolean moveCursor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (range == null) {
            return false;
        }
        HashMap caretToRange = new HashMap();
        if (type == SelectionType.LINE_WISE) {
            int n = range.size();
            for (int i = 0; i < n; ++i) {
                if (editor.offsetToBufferPosition(range.getStartOffsets()[i]).getColumn() != 0) {
                    range.getStartOffsets()[i] = EngineEditorHelperKt.getLineStartForOffset(editor, range.getStartOffsets()[i]);
                }
                if (editor.offsetToBufferPosition(range.getEndOffsets()[i]).getColumn() == 0) continue;
                range.getEndOffsets()[i] = RangesKt.coerceAtMost((int)(EngineEditorHelperKt.getLineEndForOffset(editor, range.getEndOffsets()[i]) + 1), (int)((int)editor.fileSize()));
            }
        }
        int[] rangeStartOffsets = range.getStartOffsets();
        int[] rangeEndOffsets = range.getEndOffsets();
        HashMap startOffsets = new HashMap(editor.nativeCarets().size());
        if (type == SelectionType.BLOCK_WISE) {
            ((Map)startOffsets).put(editor.primaryCaret(), range.normalize().getStartOffset());
            ((Map)caretToRange).put(editor.primaryCaret(), range);
        } else {
            Iterator iterator = ((Iterable)editor.nativeCarets()).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int i = n++;
                VimCaret caret = (VimCaret)iterator.next();
                TextRange textRange = new TextRange(rangeStartOffsets[i], rangeEndOffsets[i]);
                ((Map)startOffsets).put(caret, textRange.normalize().getStartOffset());
                ((Map)caretToRange).put(caret, textRange);
            }
        }
        return moveCursor ? this.yankRange(editor, caretToRange, range, type, startOffsets) : this.yankRange(editor, caretToRange, range, type, null);
    }
}

