/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.services;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.Key;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimStorageServiceKt;
import com.maddyhome.idea.vim.common.Direction;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.vimscript.model.ExecutableContext;
import com.maddyhome.idea.vim.vimscript.model.Script;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt;
import com.maddyhome.idea.vim.vimscript.model.expressions.Scope;
import com.maddyhome.idea.vim.vimscript.model.expressions.Variable;
import com.maddyhome.idea.vim.vimscript.model.statements.FunctionDeclaration;
import com.maddyhome.idea.vim.vimscript.model.statements.FunctionFlag;
import com.maddyhome.idea.vim.vimscript.services.VariableService;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0017\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0004J(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0016J0\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0016J0\u0010%\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0016J\u0014\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070'H\u0016J0\u0010(\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0016J*\u0010*\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0016J(\u0010+\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010\u00072\u0006\u0010-\u001a\u00020\u0006H\u0016J\u001a\u0010.\u001a\u0004\u0018\u00010\u00072\u0006\u0010-\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0019H\u0014J\u001a\u0010/\u001a\u0004\u0018\u00010\u00072\u0006\u0010-\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u001a\u00100\u001a\u0004\u0018\u00010\u00072\u0006\u0010-\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u001a\u00101\u001a\u0004\u0018\u00010\u00072\u0006\u0010-\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0019H\u0014J\u001a\u00102\u001a\u0004\u0018\u00010\u00072\u0006\u0010-\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0019H\u0014J\u001a\u00103\u001a\u0004\u0018\u00010\u00072\u0006\u0010-\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J*\u00104\u001a\u0004\u0018\u00010\u00072\u0006\u0010-\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0014J\u0018\u00105\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0007H\u0016J \u00106\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0019H\u0014J \u00107\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J \u00108\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J \u00109\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0019H\u0014J \u0010:\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0019H\u0014J \u0010;\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J0\u0010<\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0014J\b\u0010=\u001a\u00020\"H\u0016J\u0012\u00104\u001a\u0004\u0018\u00010\u00072\u0006\u0010-\u001a\u00020\u0006H\u0016J\u0018\u0010<\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0007H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006>"}, d2={"Lcom/maddyhome/idea/vim/vimscript/services/VimVariableServiceBase;", "Lcom/maddyhome/idea/vim/vimscript/services/VariableService;", "<init>", "()V", "globalVariables", "", "", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "windowVariablesKey", "Lcom/maddyhome/idea/vim/api/Key;", "bufferVariablesKey", "tabVariablesKey", "vimVariables", "getVimVariables", "()Ljava/util/Map;", "setVimVariables", "(Ljava/util/Map;)V", "getWindowVariables", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "getBufferVariables", "getTabVariables", "getDefaultVariableScope", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Scope;", "executable", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "isVariableLocked", "", "variable", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Variable;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "vimContext", "lockVariable", "", "depth", "", "unlockVariable", "getGlobalVariables", "", "storeVariable", "value", "getNullableVariableValue", "getNonNullVariableValue", "getGlobalVariableValue", "name", "getScriptVariable", "getWindowVariable", "getTabVariable", "getFunctionVariable", "getLocalVariable", "getBufferVariable", "getVimVariable", "storeGlobalVariable", "storeScriptVariable", "storeWindowVariable", "storeTabVariable", "storeFunctionVariable", "storeLocalVariable", "storeBufferVariable", "storeVimVariable", "clear", "vim-engine"})
public abstract class VimVariableServiceBase
implements VariableService {
    @NotNull
    private Map<String, VimDataType> globalVariables = new LinkedHashMap();
    @NotNull
    private final Key<Map<String, VimDataType>> windowVariablesKey = new Key("TabVariables");
    @NotNull
    private final Key<Map<String, VimDataType>> bufferVariablesKey = new Key("BufferVariables");
    @NotNull
    private final Key<Map<String, VimDataType>> tabVariablesKey = new Key("WindowVariables");
    @NotNull
    private Map<String, VimDataType> vimVariables = new LinkedHashMap();

    @NotNull
    protected final Map<String, VimDataType> getVimVariables() {
        return this.vimVariables;
    }

    protected final void setVimVariables(@NotNull Map<String, VimDataType> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.vimVariables = map;
    }

    private final Map<String, VimDataType> getWindowVariables(VimEditor editor) {
        return VimStorageServiceKt.getOrPutWindowData(VimInjectorKt.getInjector().getVimStorageService(), editor, this.windowVariablesKey, VimVariableServiceBase::getWindowVariables$lambda$0);
    }

    private final Map<String, VimDataType> getBufferVariables(VimEditor editor) {
        return VimStorageServiceKt.getOrPutBufferData(VimInjectorKt.getInjector().getVimStorageService(), editor, this.bufferVariablesKey, VimVariableServiceBase::getBufferVariables$lambda$1);
    }

    private final Map<String, VimDataType> getTabVariables(VimEditor editor) {
        return VimStorageServiceKt.getOrPutTabData(VimInjectorKt.getInjector().getVimStorageService(), editor, this.tabVariablesKey, VimVariableServiceBase::getTabVariables$lambda$2);
    }

    @NotNull
    protected final Scope getDefaultVariableScope(@NotNull VimLContext executable) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        return switch (WhenMappings.$EnumSwitchMapping$0[executable.getExecutableContext(executable).ordinal()]) {
            case 1, 2 -> Scope.GLOBAL_VARIABLE;
            case 3 -> Scope.LOCAL_VARIABLE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public boolean isVariableLocked(@NotNull Variable variable, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        VimDataType vimDataType = this.getNullableVariableValue(variable, editor, context, vimContext);
        return vimDataType != null ? vimDataType.isLocked() : false;
    }

    @Override
    public void lockVariable(@NotNull Variable variable, int depth, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        VimDataType vimDataType = this.getNullableVariableValue(variable, editor, context, vimContext);
        if (vimDataType == null) {
            return;
        }
        VimDataType value = vimDataType;
        value.setLockOwner(variable);
        value.lockVar(depth);
    }

    @Override
    public void unlockVariable(@NotNull Variable variable, int depth, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        VimDataType vimDataType = this.getNullableVariableValue(variable, editor, context, vimContext);
        if (vimDataType == null) {
            return;
        }
        VimDataType value = vimDataType;
        value.unlockVar(depth);
    }

    @Override
    @NotNull
    public Map<String, VimDataType> getGlobalVariables() {
        return this.globalVariables;
    }

    @Override
    public void storeVariable(@NotNull Variable variable, @NotNull VimDataType value, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        Scope scope = variable.getScope();
        if (scope == null) {
            scope = this.getDefaultVariableScope(vimContext);
        }
        Scope scope2 = scope;
        String name = variable.getName().evaluate(editor, context, vimContext).getValue();
        switch (WhenMappings.$EnumSwitchMapping$1[scope2.ordinal()]) {
            case 1: {
                this.storeGlobalVariable(name, value);
                break;
            }
            case 2: {
                this.storeScriptVariable(name, value, vimContext);
                break;
            }
            case 3: {
                this.storeWindowVariable(name, value, editor);
                break;
            }
            case 4: {
                this.storeTabVariable(name, value, editor);
                break;
            }
            case 5: {
                this.storeFunctionVariable(name, value, vimContext);
                break;
            }
            case 6: {
                this.storeLocalVariable(name, value, vimContext);
                break;
            }
            case 7: {
                this.storeBufferVariable(name, value, editor);
                break;
            }
            case 8: {
                this.storeVimVariable(name, value, editor, context, vimContext);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    @Nullable
    public VimDataType getNullableVariableValue(@NotNull Variable variable, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        Scope scope = variable.getScope();
        if (scope == null) {
            scope = this.getDefaultVariableScope(vimContext);
        }
        Scope scope2 = scope;
        String name = variable.getName().evaluate(editor, context, vimContext).getValue();
        return switch (WhenMappings.$EnumSwitchMapping$1[scope2.ordinal()]) {
            case 1 -> this.getGlobalVariableValue(name);
            case 2 -> this.getScriptVariable(name, vimContext);
            case 3 -> this.getWindowVariable(name, editor);
            case 4 -> this.getTabVariable(name, editor);
            case 5 -> this.getFunctionVariable(name, vimContext);
            case 6 -> this.getLocalVariable(name, vimContext);
            case 7 -> this.getBufferVariable(name, editor);
            case 8 -> this.getVimVariable(name, editor, context, vimContext);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @NotNull
    public VimDataType getNonNullVariableValue(@NotNull Variable variable, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        VimDataType vimDataType = this.getNullableVariableValue(variable, editor, context, vimContext);
        if (vimDataType == null) {
            throw new ExException("E121: Undefined variable: " + (String)(variable.getScope() != null ? variable.getScope().getC() + ":" : "") + variable.getName().evaluate(editor, context, vimContext).getValue());
        }
        return vimDataType;
    }

    @Override
    @Nullable
    public VimDataType getGlobalVariableValue(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.globalVariables.get(name);
    }

    @Nullable
    protected VimDataType getScriptVariable(@NotNull String name, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        Script script = vimContext.getScript();
        if (script == null) {
            throw new ExException("E121: Undefined variable: s:" + name);
        }
        Script script2 = script;
        return script2.getScriptVariables().get(name);
    }

    @Nullable
    protected VimDataType getWindowVariable(@NotNull String name, @NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.getWindowVariables(editor).get(name);
    }

    @Nullable
    protected VimDataType getTabVariable(@NotNull String name, @NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.getTabVariables(editor).get(name);
    }

    @Nullable
    protected VimDataType getFunctionVariable(@NotNull String name, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        List visibleVariables = new ArrayList();
        VimLContext node = vimContext;
        while (!node.isFirstParentContext()) {
            if (node instanceof FunctionDeclaration) {
                visibleVariables.add(((FunctionDeclaration)node).getFunctionVariables());
                if (!((FunctionDeclaration)node).getFlags().contains((Object)FunctionFlag.CLOSURE)) break;
            }
            node = node.getPreviousParentContext();
        }
        CollectionsKt.reverse((List)visibleVariables);
        Map functionVariablesMap = new LinkedHashMap();
        for (Map map : visibleVariables) {
            functionVariablesMap.putAll(map);
        }
        return (VimDataType)functionVariablesMap.get(name);
    }

    @Nullable
    protected VimDataType getLocalVariable(@NotNull String name, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        List visibleVariables = new ArrayList();
        VimLContext node = vimContext;
        while (!node.isFirstParentContext()) {
            if (node instanceof FunctionDeclaration) {
                visibleVariables.add(((FunctionDeclaration)node).getLocalVariables());
                if (!((FunctionDeclaration)node).getFlags().contains((Object)FunctionFlag.CLOSURE)) break;
            }
            node = node.getPreviousParentContext();
        }
        CollectionsKt.reverse((List)visibleVariables);
        Map localVariablesMap = new LinkedHashMap();
        for (Map map : visibleVariables) {
            localVariablesMap.putAll(map);
        }
        return (VimDataType)localVariablesMap.get(name);
    }

    @Nullable
    protected VimDataType getBufferVariable(@NotNull String name, @NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.getBufferVariables(editor).get(name);
    }

    @Nullable
    protected VimDataType getVimVariable(@NotNull String name, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        return switch (name) {
            case "count" -> {
                int count = KeyHandler.Companion.getInstance().getKeyHandlerState().getCommandBuilder().getCount();
                yield new VimInt(count);
            }
            case "count1" -> {
                int count1 = RangesKt.coerceAtLeast((int)KeyHandler.Companion.getInstance().getKeyHandlerState().getCommandBuilder().getCount(), (int)1);
                yield new VimInt(count1);
            }
            case "searchforward" -> {
                int searchForward = VimInjectorKt.getInjector().getSearchGroup().getLastSearchDirection() == Direction.FORWARDS ? 1 : 0;
                yield new VimInt(searchForward);
            }
            default -> throw new ExException("The 'v:' scope is not implemented yet :(");
        };
    }

    @Override
    public void storeGlobalVariable(@NotNull String name, @NotNull VimDataType value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.globalVariables.put(name, value);
    }

    protected void storeScriptVariable(@NotNull String name, @NotNull VimDataType value, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        Script script = vimContext.getScript();
        if (script == null) {
            throw new ExException("E461: Illegal variable name: s:" + name);
        }
        Script script2 = script;
        script2.getScriptVariables().put(name, value);
    }

    protected void storeWindowVariable(@NotNull String name, @NotNull VimDataType value, @NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.getWindowVariables(editor).put(name, value);
    }

    protected void storeTabVariable(@NotNull String name, @NotNull VimDataType value, @NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.getTabVariables(editor).put(name, value);
    }

    protected void storeFunctionVariable(@NotNull String name, @NotNull VimDataType value, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        VimLContext node = vimContext;
        while (!node.isFirstParentContext() && !(node instanceof FunctionDeclaration)) {
            node = node.getPreviousParentContext();
        }
        if (!(node instanceof FunctionDeclaration)) {
            throw new ExException("E461: Illegal variable name: a:" + name);
        }
        ((FunctionDeclaration)node).getFunctionVariables().put(name, value);
    }

    protected void storeLocalVariable(@NotNull String name, @NotNull VimDataType value, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        VimLContext node = vimContext;
        while (!node.isFirstParentContext() && !(node instanceof FunctionDeclaration)) {
            node = node.getPreviousParentContext();
        }
        if (!(node instanceof FunctionDeclaration)) {
            throw new ExException("E461: Illegal variable name: l:" + name);
        }
        ((FunctionDeclaration)node).getLocalVariables().put(name, value);
    }

    protected void storeBufferVariable(@NotNull String name, @NotNull VimDataType value, @NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.getBufferVariables(editor).put(name, value);
    }

    protected void storeVimVariable(@NotNull String name, @NotNull VimDataType value, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        throw new ExException("The 'v:' scope is not implemented yet :(");
    }

    @Override
    public void clear() {
        this.globalVariables.clear();
    }

    @Override
    @Nullable
    public VimDataType getVimVariable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.vimVariables.get(name);
    }

    @Override
    public void storeVimVariable(@NotNull String name, @NotNull VimDataType value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.vimVariables.put(name, value);
    }

    private static final Map getWindowVariables$lambda$0() {
        return new LinkedHashMap();
    }

    private static final Map getBufferVariables$lambda$1() {
        return new LinkedHashMap();
    }

    private static final Map getTabVariables$lambda$2() {
        return new LinkedHashMap();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ExecutableContext.values().length];
            try {
                nArray[ExecutableContext.SCRIPT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutableContext.COMMAND_LINE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutableContext.FUNCTION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Scope.values().length];
            try {
                nArray[Scope.GLOBAL_VARIABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scope.SCRIPT_VARIABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scope.WINDOW_VARIABLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scope.TABPAGE_VARIABLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scope.FUNCTION_VARIABLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scope.LOCAL_VARIABLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scope.BUFFER_VARIABLE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scope.VIM_VARIABLE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

