/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.GoalCommand;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.InvalidCommandException;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001:\u0001'B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J(\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J'\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020\u001cH\u00d6\u0001J\t\u0010&\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006("}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/UnknownCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "name", "", "argument", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Ljava/lang/String;Ljava/lang/String;)V", "getRange", "()Lcom/maddyhome/idea/vim/ex/ranges/Range;", "getName", "()Ljava/lang/String;", "getArgument", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "processPossiblyAliasCommand", "aliasCountdown", "", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "Constants", "vim-engine"})
public final class UnknownCommand
extends Command.SingleExecution {
    @NotNull
    private final Range range;
    @NotNull
    private final String name;
    @NotNull
    private final String argument;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;

    public UnknownCommand(@NotNull Range range, @NotNull String name, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super(range, argument);
        this.range = range;
        this.name = name;
        this.argument = argument;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_OPTIONAL, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.SELF_SYNCHRONIZED, new Command.Flag[0]);
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    @Override
    @NotNull
    protected Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        return this.processPossiblyAliasCommand(this.name + " " + this.argument, editor, context, 100);
    }

    private final ExecutionResult processPossiblyAliasCommand(String name, VimEditor editor, ExecutionContext context, int aliasCountdown) {
        if (VimInjectorKt.getInjector().getCommandGroup().isAlias(name)) {
            if (aliasCountdown > 0) {
                GoalCommand commandAlias = VimInjectorKt.getInjector().getCommandGroup().getAliasCommand(name, 1);
                GoalCommand goalCommand = commandAlias;
                if (goalCommand instanceof GoalCommand.Ex) {
                    ExecutionResult executionResult;
                    if (((CharSequence)((GoalCommand.Ex)commandAlias).getCommand()).length() == 0) {
                        Object[] objectArray = new Object[]{name};
                        String message = VimInjectorKt.getInjector().getMessages().message("notexcmd", objectArray);
                        throw new InvalidCommandException(message, null);
                    }
                    Command command = VimInjectorKt.getInjector().getVimscriptParser().parseCommand(((GoalCommand.Ex)commandAlias).getCommand());
                    if (command == null) {
                        throw new ExException("E492: Not an editor command: " + ((GoalCommand.Ex)commandAlias).getCommand());
                    }
                    Command parsedCommand = command;
                    if (parsedCommand instanceof UnknownCommand) {
                        executionResult = this.processPossiblyAliasCommand(((GoalCommand.Ex)commandAlias).getCommand(), editor, context, aliasCountdown - 1);
                    } else {
                        parsedCommand.setVimContext(this.getVimContext());
                        parsedCommand.execute(editor, context);
                        executionResult = ExecutionResult.Success.INSTANCE;
                    }
                    return executionResult;
                }
                if (goalCommand instanceof GoalCommand.Call) {
                    ((GoalCommand.Call)commandAlias).getHandler().execute(name, this.range, editor, context);
                    return ExecutionResult.Success.INSTANCE;
                }
                throw new NoWhenBranchMatchedException();
            }
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, VimInjectorKt.getInjector().getMessages().message("recursion.detected.maximum.alias.depth.reached", new Object[0]));
            VimInjectorKt.getInjector().getMessages().indicateError();
            return ExecutionResult.Error.INSTANCE;
        }
        throw new ExException("E492: Not an editor command: " + name);
    }

    @NotNull
    public final Range component1() {
        return this.range;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final String component3() {
        return this.argument;
    }

    @NotNull
    public final UnknownCommand copy(@NotNull Range range, @NotNull String name, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return new UnknownCommand(range, name, argument);
    }

    public static /* synthetic */ UnknownCommand copy$default(UnknownCommand unknownCommand, Range range, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            range = unknownCommand.range;
        }
        if ((n & 2) != 0) {
            string = unknownCommand.name;
        }
        if ((n & 4) != 0) {
            string2 = unknownCommand.argument;
        }
        return unknownCommand.copy(range, string, string2);
    }

    @NotNull
    public String toString() {
        return "UnknownCommand(range=" + this.range + ", name=" + this.name + ", argument=" + this.argument + ")";
    }

    public int hashCode() {
        int result = this.range.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.argument.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UnknownCommand)) {
            return false;
        }
        UnknownCommand unknownCommand = (UnknownCommand)other;
        if (!Intrinsics.areEqual((Object)this.range, (Object)unknownCommand.range)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)unknownCommand.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.argument, (Object)unknownCommand.argument);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/UnknownCommand$Constants;", "", "<init>", "()V", "MAX_RECURSION", "", "vim-engine"})
    private static final class Constants {
        @NotNull
        public static final Constants INSTANCE = new Constants();
        public static final int MAX_RECURSION = 100;

        private Constants() {
        }
    }
}

