/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimSelectionModel;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.commands.SortOption;
import java.util.Comparator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001+B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006,"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/SortCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "argument", "", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Ljava/lang/String;)V", "getRange", "()Lcom/maddyhome/idea/vim/ex/ranges/Range;", "getArgument", "()Ljava/lang/String;", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "getSortLineRange", "Lcom/maddyhome/idea/vim/ex/ranges/LineRange;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "parseSortOption", "Lcom/maddyhome/idea/vim/vimscript/model/commands/SortOption;", "arg", "extractPattern", "Lkotlin/ranges/IntRange;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "LineComparator", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nSortCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SortCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/SortCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
public final class SortCommand
extends Command.SingleExecution {
    @NotNull
    private final Range range;
    @NotNull
    private final String argument;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;

    public SortCommand(@NotNull Range range, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super(range, argument);
        this.range = range;
        this.argument = argument;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_OPTIONAL, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.WRITABLE, new Command.Flag[0]);
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    @Override
    @NotNull
    protected Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) throws ExException {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        SortOption sortOption = this.parseSortOption(this.argument);
        LineComparator lineComparator = new LineComparator(sortOption.getIgnoreCase(), sortOption.getNumeric(), sortOption.getReverse());
        boolean worked = true;
        for (VimCaret caret : editor.carets()) {
            LineRange range = this.getSortLineRange(editor, caret);
            if (!VimInjectorKt.getInjector().getChangeGroup().sortRange(editor, caret, range, lineComparator, sortOption)) {
                worked = false;
            }
            caret.moveToInlayAwareOffset(VimInjectorKt.getInjector().getMotion().moveCaretToLineStartSkipLeading(editor, range.startLine));
        }
        return worked ? (ExecutionResult)ExecutionResult.Success.INSTANCE : (ExecutionResult)ExecutionResult.Error.INSTANCE;
    }

    private final LineRange getSortLineRange(VimEditor editor, VimCaret caret) {
        LineRange range = this.getLineRange(editor, caret);
        if (range.getSize() == 1) {
            LineRange lineRange;
            VimSelectionModel selectionModel = editor.getSelectionModel();
            if (selectionModel.hasSelection()) {
                int start = selectionModel.getSelectionStart();
                int end = selectionModel.getSelectionEnd();
                int startLine = editor.offsetToBufferPosition(start).getLine();
                int endLine = editor.offsetToBufferPosition(end).getLine();
                lineRange = new LineRange(startLine, endLine);
            } else {
                lineRange = new LineRange(0, editor.lineCount() - 1);
            }
            return lineRange;
        }
        return range;
    }

    private final SortOption parseSortOption(String arg) {
        Object object;
        String pattern;
        block6: {
            block5: {
                IntRange patternRange;
                IntRange intRange = patternRange = this.extractPattern(arg);
                if (intRange != null) {
                    IntRange it = intRange;
                    boolean bl = false;
                    v1 = StringsKt.substring((String)arg, (IntRange)it);
                } else {
                    v1 = pattern = null;
                }
                if ((object = patternRange) == null) break block5;
                IntRange it = object;
                boolean bl = false;
                String string = ((Object)StringsKt.removeRange((CharSequence)arg, (IntRange)patternRange)).toString();
                object = string;
                if (string != null) break block6;
            }
            object = arg;
        }
        Object flags = object;
        boolean bl = StringsKt.contains$default((CharSequence)((CharSequence)flags), (CharSequence)"!", (boolean)false, (int)2, null);
        boolean bl2 = StringsKt.contains$default((CharSequence)((CharSequence)flags), (CharSequence)"i", (boolean)false, (int)2, null);
        boolean bl3 = StringsKt.contains$default((CharSequence)((CharSequence)flags), (CharSequence)"n", (boolean)false, (int)2, null);
        boolean bl4 = StringsKt.contains$default((CharSequence)((CharSequence)flags), (CharSequence)"u", (boolean)false, (int)2, null);
        boolean bl5 = StringsKt.contains$default((CharSequence)((CharSequence)flags), (CharSequence)"r", (boolean)false, (int)2, null);
        return new SortOption(bl2, bl3, bl, bl4, bl5, pattern);
    }

    private final IntRange extractPattern(String arg) {
        int startIndex = StringsKt.indexOf$default((CharSequence)arg, (char)'/', (int)0, (boolean)false, (int)6, null);
        int endIndex = StringsKt.indexOf$default((CharSequence)arg, (char)'/', (int)(startIndex + 2), (boolean)false, (int)4, null);
        if (startIndex >= 0 && endIndex >= 0) {
            return new IntRange(startIndex + 1, endIndex - 1);
        }
        return null;
    }

    @NotNull
    public final Range component1() {
        return this.range;
    }

    @NotNull
    public final String component2() {
        return this.argument;
    }

    @NotNull
    public final SortCommand copy(@NotNull Range range, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return new SortCommand(range, argument);
    }

    public static /* synthetic */ SortCommand copy$default(SortCommand sortCommand, Range range, String string, int n, Object object) {
        if ((n & 1) != 0) {
            range = sortCommand.range;
        }
        if ((n & 2) != 0) {
            string = sortCommand.argument;
        }
        return sortCommand.copy(range, string);
    }

    @NotNull
    public String toString() {
        return "SortCommand(range=" + this.range + ", argument=" + this.argument + ")";
    }

    public int hashCode() {
        int result = this.range.hashCode();
        result = result * 31 + this.argument.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SortCommand)) {
            return false;
        }
        SortCommand sortCommand = (SortCommand)other;
        if (!Intrinsics.areEqual((Object)this.range, (Object)sortCommand.range)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.argument, (Object)sortCommand.argument);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/SortCommand$LineComparator;", "Ljava/util/Comparator;", "", "ignoreCase", "", "numeric", "reverse", "<init>", "(ZZZ)V", "compare", "", "o1", "o2", "vim-engine"})
    private static final class LineComparator
    implements Comparator<String> {
        private final boolean ignoreCase;
        private final boolean numeric;
        private final boolean reverse;

        public LineComparator(boolean ignoreCase, boolean numeric, boolean reverse) {
            this.ignoreCase = ignoreCase;
            this.numeric = numeric;
            this.reverse = reverse;
        }

        @Override
        public int compare(@NotNull String o1, @NotNull String o2) {
            int n;
            String tmp;
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            String o1ToCompare = o1;
            String o2ToCompare = o2;
            if (this.reverse) {
                tmp = o2ToCompare;
                o2ToCompare = o1ToCompare;
                o1ToCompare = tmp;
            }
            if (this.ignoreCase) {
                tmp = o1ToCompare;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string = tmp.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                o1ToCompare = string;
                tmp = o2ToCompare;
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
                String string2 = tmp.toUpperCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                o2ToCompare = string2;
            }
            if (this.numeric) {
                Integer n1 = VimInjectorKt.getInjector().getSearchGroup().findDecimalNumber(o1ToCompare);
                Integer n2 = VimInjectorKt.getInjector().getSearchGroup().findDecimalNumber(o2ToCompare);
                n = n1 == null ? (n2 == null ? o1ToCompare.compareTo(o2ToCompare) : -1) : (n2 == null ? 1 : Intrinsics.compare((int)n1, (int)n2));
            } else {
                n = o1ToCompare.compareTo(o2ToCompare);
            }
            return n;
        }
    }
}

