/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCommandLine;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.helper.EngineModeExtensionsKt;
import com.maddyhome.idea.vim.mark.Mark;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/NormalCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "argument", "", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Ljava/lang/String;)V", "getRange", "()Lcom/maddyhome/idea/vim/ex/ranges/Range;", "getArgument", "()Ljava/lang/String;", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "vim-engine"})
public final class NormalCommand
extends Command.SingleExecution {
    @NotNull
    private final Range range;
    @NotNull
    private final String argument;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;

    public NormalCommand(@NotNull Range range, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super(range, argument);
        this.range = range;
        this.argument = argument;
        Command.Flag[] flagArray = new Command.Flag[]{Command.Flag.SAVE_VISUAL};
        this.argFlags = this.flags(Command.RangeFlag.RANGE_OPTIONAL, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.WRITABLE, flagArray);
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    @Override
    @NotNull
    protected Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        boolean useMappings = true;
        String argument = this.argument;
        if (StringsKt.startsWith$default((String)argument, (String)"!", (boolean)false, (int)2, null)) {
            useMappings = false;
            String string = argument.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            argument = string;
        }
        boolean rangeUsed = this.range.size() != 0;
        Mode mode = editor.getMode();
        if (mode instanceof Mode.VISUAL) {
            EngineModeExtensionsKt.exitVisualMode(editor);
            if (!rangeUsed) {
                Mark mark = VimInjectorKt.getInjector().getMarkService().getMark(editor.primaryCaret(), '<');
                Intrinsics.checkNotNull((Object)mark);
                Mark selectionStart = mark;
                editor.currentCaret().moveToBufferPosition(new BufferPosition(selectionStart.getLine(), selectionStart.getCol(), false, 4, null));
            }
        } else if (mode instanceof Mode.CMD_LINE) {
            VimCommandLine vimCommandLine = VimInjectorKt.getInjector().getCommandLine().getActiveCommandLine();
            if (vimCommandLine != null) {
                vimCommandLine.close(true, false);
            }
        } else if (Intrinsics.areEqual((Object)mode, (Object)Mode.INSERT.INSTANCE) || Intrinsics.areEqual((Object)mode, (Object)Mode.REPLACE.INSTANCE)) {
            editor.exitInsertMode(context, new OperatorArguments(false, 1, editor.getMode()));
        } else if (mode instanceof Mode.SELECT) {
            editor.exitSelectModeNative(false);
        } else if (!(mode instanceof Mode.OP_PENDING) && !(mode instanceof Mode.NORMAL)) {
            throw new NoWhenBranchMatchedException();
        }
        LineRange range = this.getLineRange(editor, editor.primaryCaret());
        int line = range.startLine;
        int n = range.endLine;
        if (line <= n) {
            while (true) {
                if (rangeUsed) {
                    if (editor.lineCount() < line) break;
                    int startOffset = editor.getLineStartOffset(line);
                    editor.currentCaret().moveToOffset(startOffset);
                }
                List<KeyStroke> keys = VimInjectorKt.getInjector().getParser().stringToKeys(argument);
                KeyHandler keyHandler = KeyHandler.Companion.getInstance();
                keyHandler.reset(editor);
                for (KeyStroke key : keys) {
                    keyHandler.handleKey(editor, key, context, useMappings, true, keyHandler.getKeyHandlerState());
                }
                Mode mode2 = editor.getMode();
                if (mode2 instanceof Mode.CMD_LINE) {
                    VimCommandLine vimCommandLine = VimInjectorKt.getInjector().getCommandLine().getActiveCommandLine();
                    if (vimCommandLine != null) {
                        vimCommandLine.close(true, false);
                    }
                }
                if (mode2 instanceof Mode.INSERT || mode2 instanceof Mode.REPLACE) {
                    editor.exitInsertMode(context, new OperatorArguments(false, 1, mode2));
                }
                if (line == n) break;
                ++line;
            }
        }
        return ExecutionResult.Success.INSTANCE;
    }

    @NotNull
    public final Range component1() {
        return this.range;
    }

    @NotNull
    public final String component2() {
        return this.argument;
    }

    @NotNull
    public final NormalCommand copy(@NotNull Range range, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return new NormalCommand(range, argument);
    }

    public static /* synthetic */ NormalCommand copy$default(NormalCommand normalCommand, Range range, String string, int n, Object object) {
        if ((n & 1) != 0) {
            range = normalCommand.range;
        }
        if ((n & 2) != 0) {
            string = normalCommand.argument;
        }
        return normalCommand.copy(range, string);
    }

    @NotNull
    public String toString() {
        return "NormalCommand(range=" + this.range + ", argument=" + this.argument + ")";
    }

    public int hashCode() {
        int result = this.range.hashCode();
        result = result * 31 + this.argument.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NormalCommand)) {
            return false;
        }
        NormalCommand normalCommand = (NormalCommand)other;
        if (!Intrinsics.areEqual((Object)this.range, (Object)normalCommand.range)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.argument, (Object)normalCommand.argument);
    }
}

