/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.register;

import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.Options;
import com.maddyhome.idea.vim.api.StringListOptionValue;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import com.maddyhome.idea.vim.options.GlobalOptionChangeListener;
import com.maddyhome.idea.vim.register.Register;
import com.maddyhome.idea.vim.register.VimRegisterGroup;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u000f\b&\u0018\u0000 Y2\u00020\u0001:\u0001YB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010(\u001a\u00020'J\u0010\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\bH\u0016J\u0010\u0010+\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\bH\u0016J\b\u0010,\u001a\u00020'H\u0016J\u0010\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020\u0011H\u0016J\b\u0010/\u001a\u00020\u0005H\u0016J\u0010\u0010/\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\bH\u0016J\b\u00100\u001a\u00020'H\u0016J\b\u00101\u001a\u00020\u0005H\u0002J>\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020\u0005J0\u0010?\u001a\u00020\u00052\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u0010;\u001a\u00020<2\u0006\u0010>\u001a\u00020\u0005H\u0016J\u0018\u0010@\u001a\u00020:2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0004J\u0018\u0010A\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\b2\u0006\u00109\u001a\u00020:H\u0016J \u0010?\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\b2\u0006\u00109\u001a\u00020:2\u0006\u0010B\u001a\u00020<H\u0016J\u0018\u0010?\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\b2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010C\u001a\u00020<2\u0006\u00109\u001a\u00020:H\u0002J\u0012\u0010D\u001a\u0004\u0018\u00010\u00142\u0006\u0010E\u001a\u00020\bH\u0002J\b\u0010F\u001a\u00020\u0005H\u0016J&\u0010G\u001a\u00020'2\u0006\u00109\u001a\u00020:2\u0006\u0010H\u001a\u00020:2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020K0JH\u0002J&\u0010L\u001a\u00020'2\u0006\u00109\u001a\u00020:2\u0006\u0010H\u001a\u00020:2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020K0JH\u0002J\n\u0010M\u001a\u0004\u0018\u00010\u0014H\u0002J\n\u0010D\u001a\u0004\u0018\u00010\u0014H\u0002J\u0012\u0010N\u001a\u0004\u0018\u00010\u00142\u0006\u0010E\u001a\u00020\bH\u0016J\u000e\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00140JH\u0016J\u0018\u0010P\u001a\u00020'2\u0006\u0010E\u001a\u00020\b2\u0006\u0010=\u001a\u00020\u0014H\u0016J\u0010\u0010Q\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\bH\u0016J\u0012\u0010R\u001a\u0004\u0018\u00010\u00142\u0006\u0010E\u001a\u00020\bH\u0016J\u0010\u0010S\u001a\u00020'2\u0006\u00109\u001a\u00020:H\u0016J\u001e\u0010T\u001a\u00020'2\u0006\u0010=\u001a\u00020\b2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00110JH\u0016J&\u0010T\u001a\u00020'2\u0006\u0010=\u001a\u00020\b2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00110J2\u0006\u0010;\u001a\u00020<H\u0016J\b\u0010V\u001a\u00020'H\u0016J\b\u0010W\u001a\u00020\bH\u0016J\u0010\u0010X\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\bH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006R*\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00108\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00140\u00138\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0006\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0018R\u0014\u0010 \u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0018R\u0016\u0010\"\u001a\u0004\u0018\u00010\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lcom/maddyhome/idea/vim/register/VimRegisterGroupBase;", "Lcom/maddyhome/idea/vim/register/VimRegisterGroup;", "<init>", "()V", "isRecording", "", "()Z", "value", "", "recordRegister", "getRecordRegister", "()Ljava/lang/Character;", "setRecordRegister", "(Ljava/lang/Character;)V", "Ljava/lang/Character;", "recordList", "", "Ljavax/swing/KeyStroke;", "myRegisters", "Ljava/util/HashMap;", "Lcom/maddyhome/idea/vim/register/Register;", "defaultRegisterChar", "lastRegisterChar", "getLastRegisterChar", "()C", "setLastRegisterChar", "(C)V", "isRegisterSpecifiedExplicitly", "setRegisterSpecifiedExplicitly", "(Z)V", "currentRegister", "getCurrentRegister", "defaultRegister", "getDefaultRegister", "lastRegister", "getLastRegister", "()Lcom/maddyhome/idea/vim/register/Register;", "onClipboardChanged", "Lkotlin/Function0;", "", "initClipboardOptionListener", "isValid", "reg", "selectRegister", "resetRegister", "recordKeyStroke", "key", "isRegisterWritable", "resetRegisters", "isSmallDeletionSpecialCase", "storeTextInternal", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "range", "Lcom/maddyhome/idea/vim/common/TextRange;", "text", "", "type", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "register", "isDelete", "storeText", "preprocessTextBeforeStoring", "storeTextSpecial", "selectionType", "guessSelectionType", "refreshClipboardRegister", "r", "isPrimaryRegisterSupported", "setSystemPrimaryRegisterText", "rawText", "transferableData", "", "", "setSystemClipboardRegisterText", "refreshPrimaryRegister", "getRegister", "getRegisters", "saveRegister", "startRecording", "getPlaybackRegister", "recordText", "setKeys", "keys", "finishRecording", "getCurrentRegisterForMulticaret", "isSystemClipboard", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimRegisterGroupBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimRegisterGroupBase.kt\ncom/maddyhome/idea/vim/register/VimRegisterGroupBase\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,547:1\n33#2,4:548\n33#2,4:552\n33#2,4:556\n33#2,4:560\n33#2,4:564\n33#2,4:568\n33#2,4:572\n33#2,4:576\n38#2:608\n1#3:580\n1#3:605\n827#4:581\n855#4,2:582\n488#5,11:584\n1029#5,9:595\n1179#5:604\n1180#5:606\n1038#5:607\n*S KotlinDebug\n*F\n+ 1 VimRegisterGroupBase.kt\ncom/maddyhome/idea/vim/register/VimRegisterGroupBase\n*L\n116#1:548,4\n203#1:552,4\n215#1:556,4\n219#1:560,4\n242#1:564,4\n277#1:568,4\n336#1:572,4\n344#1:576,4\n532#1:608\n454#1:605\n451#1:581\n451#1:582,2\n453#1:584,11\n454#1:595,9\n454#1:604\n454#1:606\n454#1:607\n*E\n"})
public abstract class VimRegisterGroupBase
implements VimRegisterGroup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Character recordRegister;
    @JvmField
    @Nullable
    protected List<KeyStroke> recordList;
    @JvmField
    @NotNull
    protected final HashMap<Character, Register> myRegisters = new HashMap();
    @JvmField
    protected char defaultRegisterChar;
    private char lastRegisterChar = this.defaultRegisterChar = (char)34;
    private boolean isRegisterSpecifiedExplicitly;
    @NotNull
    private final Function0<Unit> onClipboardChanged = () -> VimRegisterGroupBase.onClipboardChanged$lambda$0(this);
    @NotNull
    private static final VimLogger logger;

    @Override
    public boolean isRecording() {
        return this.getRecordRegister() != null;
    }

    @Override
    @Nullable
    public Character getRecordRegister() {
        return this.recordRegister;
    }

    public void setRecordRegister(@Nullable Character value) {
        this.recordRegister = value;
        if (value != null) {
            VimInjectorKt.getInjector().getListenersNotifier().notifyMacroRecordingStarted();
        } else {
            VimInjectorKt.getInjector().getListenersNotifier().notifyMacroRecordingFinished();
        }
    }

    @Override
    public char getLastRegisterChar() {
        return this.lastRegisterChar;
    }

    @Override
    public void setLastRegisterChar(char c) {
        this.lastRegisterChar = c;
    }

    @Override
    public boolean isRegisterSpecifiedExplicitly() {
        return this.isRegisterSpecifiedExplicitly;
    }

    public void setRegisterSpecifiedExplicitly(boolean bl) {
        this.isRegisterSpecifiedExplicitly = bl;
    }

    @Override
    public char getCurrentRegister() {
        return this.getLastRegisterChar();
    }

    @Override
    public char getDefaultRegister() {
        return this.defaultRegisterChar;
    }

    @Override
    @Nullable
    public Register getLastRegister() {
        return this.getRegister(this.getLastRegisterChar());
    }

    public final void initClipboardOptionListener() {
        Function0<Unit> function0 = this.onClipboardChanged;
        VimInjectorKt.getInjector().getOptionGroup().addGlobalOptionChangeListener(Options.INSTANCE.getClipboard(), new GlobalOptionChangeListener(function0){
            private final /* synthetic */ Function0 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onGlobalOptionChanged() {
                this.function.invoke();
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof GlobalOptionChangeListener ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
        this.onClipboardChanged.invoke();
    }

    @Override
    public boolean isValid(char reg) {
        return StringsKt.indexOf$default((CharSequence)"0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ+*-_\"/%:.#=", (char)reg, (int)0, (boolean)false, (int)6, null) != -1;
    }

    @Override
    public boolean selectRegister(char reg) {
        boolean bl;
        if (this.isValid(reg)) {
            this.setRegisterSpecifiedExplicitly(true);
            this.setLastRegisterChar(reg);
            VimLogger $this$debug$iv = logger;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebug()) {
                VimLogger vimLogger = $this$debug$iv;
                boolean bl2 = false;
                vimLogger.debug("register selected: " + this.getLastRegister());
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void resetRegister() {
        this.setRegisterSpecifiedExplicitly(false);
        this.setLastRegisterChar(this.getDefaultRegister());
        logger.debug("Last register reset to default register");
    }

    @Override
    public void recordKeyStroke(@NotNull KeyStroke key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        List<KeyStroke> myRecordList = this.recordList;
        if (this.isRecording() && myRecordList != null) {
            myRecordList.add(key);
        }
    }

    @Override
    public boolean isRegisterWritable() {
        return this.isRegisterWritable(this.getLastRegisterChar());
    }

    @Override
    public boolean isRegisterWritable(char reg) {
        return StringsKt.indexOf$default((CharSequence)"%:.#=", (char)reg, (int)0, (boolean)false, (int)6, null) < 0;
    }

    @Override
    public void resetRegisters() {
        this.setRegisterSpecifiedExplicitly(false);
        this.defaultRegisterChar = (char)34;
        this.setLastRegisterChar(this.getDefaultRegister());
        this.myRegisters.clear();
    }

    private final boolean isSmallDeletionSpecialCase() {
        Argument argument;
        Command currentCommand = VimInjectorKt.getInjector().getVimState().getExecutingCommand();
        if (currentCommand != null && (argument = currentCommand.getArgument()) != null) {
            Command motionCommand = argument.getMotion();
            EditorActionHandlerBase action = motionCommand.getAction();
            return Intrinsics.areEqual((Object)action.getId(), (Object)"VimMotionPercentOrMatchAction") || Intrinsics.areEqual((Object)action.getId(), (Object)"VimMotionSentencePreviousStartAction") || Intrinsics.areEqual((Object)action.getId(), (Object)"VimMotionSentenceNextStartAction") || Intrinsics.areEqual((Object)action.getId(), (Object)"VimMotionGotoFileMarkAction") || Intrinsics.areEqual((Object)action.getId(), (Object)"VimProcessExEntryAction") || Intrinsics.areEqual((Object)action.getId(), (Object)"VimSearchAgainNextAction") || Intrinsics.areEqual((Object)action.getId(), (Object)"VimSearchAgainPreviousAction") || Intrinsics.areEqual((Object)action.getId(), (Object)"VimMotionParagraphNextAction") || Intrinsics.areEqual((Object)action.getId(), (Object)"VimMotionParagraphPreviousAction");
        }
        return false;
    }

    public final boolean storeTextInternal(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, @NotNull TextRange range, @NotNull String text, @NotNull SelectionType type, char register, boolean isDelete) {
        Object transferableClasses;
        VimLogger vimLogger;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (this.getLastRegisterChar() == '_') {
            return true;
        }
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        if (isDelete && start == end) {
            return true;
        }
        if (start > end) {
            int t = start;
            start = end;
            end = t;
        }
        List<Object> transferableData = start != -1 ? VimInjectorKt.getInjector().getClipboardManager().getTransferableData(editor, range, text) : (List<Object>)new ArrayList();
        String processedText = start != -1 ? VimInjectorKt.getInjector().getClipboardManager().preprocessText(editor, range, text, transferableData) : text;
        VimLogger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            vimLogger = $this$debug$iv;
            boolean bl = false;
            transferableClasses = CollectionsKt.joinToString$default((Iterable)transferableData, (CharSequence)",", null, null, (int)0, null, VimRegisterGroupBase::storeTextInternal$lambda$3$lambda$2, (int)30, null);
            vimLogger.debug("Copy to '" + this.getLastRegister() + "' with transferable data: " + (String)transferableClasses);
        }
        if (Character.isUpperCase(register)) {
            char lreg = Character.toLowerCase(register);
            Register r = this.myRegisters.get(Character.valueOf(lreg));
            if (r != null) {
                r.addTextAndResetTransferableData(processedText);
            } else {
                transferableClasses = Character.valueOf(lreg);
                ((Map)this.myRegisters).put(transferableClasses, new Register(lreg, type, processedText, new ArrayList(transferableData)));
                VimLogger $this$debug$iv2 = logger;
                boolean $i$f$debug2 = false;
                if ($this$debug$iv2.isDebug()) {
                    vimLogger = $this$debug$iv2;
                    boolean bl = false;
                    vimLogger.debug("register '" + register + "' contains: \"" + processedText + "\"");
                }
            }
        } else {
            Character r = Character.valueOf(register);
            ((Map)this.myRegisters).put(r, new Register(register, type, processedText, new ArrayList(transferableData)));
            $this$debug$iv = logger;
            $i$f$debug = false;
            if ($this$debug$iv.isDebug()) {
                vimLogger = $this$debug$iv;
                boolean bl = false;
                vimLogger.debug("register '" + register + "' contains: \"" + processedText + "\"");
            }
        }
        if (register == '+') {
            VimInjectorKt.getInjector().getClipboardManager().setClipboardText(processedText, text, new ArrayList(transferableData));
            if (!this.isRegisterSpecifiedExplicitly() && !isDelete && this.isPrimaryRegisterSupported() && VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getClipboard().contains((Object)"unnamedplus")) {
                VimInjectorKt.getInjector().getClipboardManager().setPrimaryText(processedText, text, new ArrayList(transferableData));
            }
        }
        if (register == '*') {
            if (this.isPrimaryRegisterSupported()) {
                VimInjectorKt.getInjector().getClipboardManager().setPrimaryText(processedText, text, new ArrayList(transferableData));
                if (!this.isRegisterSpecifiedExplicitly() && !isDelete && VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getClipboard().contains((Object)"unnamed")) {
                    VimInjectorKt.getInjector().getClipboardManager().setClipboardText(processedText, text, new ArrayList(transferableData));
                }
            } else {
                VimInjectorKt.getInjector().getClipboardManager().setClipboardText(processedText, text, new ArrayList(transferableData));
            }
        }
        if (register != '\"' && StringsKt.indexOf$default((CharSequence)".:/", (char)register, (int)0, (boolean)false, (int)6, null) == -1) {
            ((Map)this.myRegisters).put(Character.valueOf('\"'), new Register('\"', type, processedText, new ArrayList(transferableData)));
            $this$debug$iv = logger;
            $i$f$debug = false;
            if ($this$debug$iv.isDebug()) {
                vimLogger = $this$debug$iv;
                boolean bl = false;
                vimLogger.debug("register '\"' contains: \"" + processedText + "\"");
            }
        }
        if (isDelete) {
            boolean smallInlineDeletion;
            boolean bl = smallInlineDeletion = (type == SelectionType.CHARACTER_WISE || type == SelectionType.BLOCK_WISE) && editor.offsetToBufferPosition(start).getLine() == editor.offsetToBufferPosition(end).getLine();
            if (!smallInlineDeletion && register == this.getDefaultRegister() || this.isSmallDeletionSpecialCase()) {
                char d = '8';
                while (Intrinsics.compare((int)d, (int)49) >= 0) {
                    Register t = this.myRegisters.get(Character.valueOf(d));
                    if (t != null) {
                        t.setName((char)(d + '\u0001'));
                        ((Map)this.myRegisters).put(Character.valueOf((char)(d + '\u0001')), t);
                    }
                    char c = d;
                    d = (char)(c + -1);
                }
                ((Map)this.myRegisters).put(Character.valueOf('1'), new Register('1', type, processedText, new ArrayList(transferableData)));
            }
            if (smallInlineDeletion && register == this.getDefaultRegister()) {
                ((Map)this.myRegisters).put(Character.valueOf('-'), new Register('-', type, processedText, new ArrayList(transferableData)));
            }
        } else if (register == this.getDefaultRegister()) {
            ((Map)this.myRegisters).put(Character.valueOf('0'), new Register('0', type, processedText, new ArrayList(transferableData)));
            $this$debug$iv = logger;
            $i$f$debug = false;
            if ($this$debug$iv.isDebug()) {
                vimLogger = $this$debug$iv;
                boolean bl = false;
                vimLogger.debug("register '0' contains: \"" + processedText + "\"");
            }
        }
        return true;
    }

    @Override
    public boolean storeText(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, @NotNull TextRange range, @NotNull SelectionType type, boolean isDelete) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (this.isRegisterWritable()) {
            String text = this.preprocessTextBeforeStoring(EngineEditorHelperKt.getText(editor, range), type);
            return this.storeTextInternal(editor, caret, range, text, type, this.getLastRegisterChar(), isDelete);
        }
        return false;
    }

    @NotNull
    protected final String preprocessTextBeforeStoring(@NotNull String text, @NotNull SelectionType type) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (type == SelectionType.LINE_WISE && (((CharSequence)text).length() == 0 || text.charAt(text.length() - 1) != '\n')) {
            return text + "\n";
        }
        return text;
    }

    @Override
    public boolean storeTextSpecial(char register, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (StringsKt.indexOf$default((CharSequence)"%:.#=", (char)register, (int)0, (boolean)false, (int)6, null) == -1 && register != '/' && register != '\"') {
            return false;
        }
        Character c = Character.valueOf(register);
        ((Map)this.myRegisters).put(c, new Register(register, SelectionType.CHARACTER_WISE, text, new ArrayList()));
        VimLogger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            VimLogger vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("register '" + register + "' contains: \"" + text + "\"");
        }
        return true;
    }

    @Override
    public boolean storeText(char register, @NotNull String text, @NotNull SelectionType selectionType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)selectionType), (String)"selectionType");
        if (!StringsKt.contains$default((CharSequence)"0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ+*-_\"/", (char)register, (boolean)false, (int)2, null)) {
            return false;
        }
        VimLogger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            VimLogger vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("register '" + register + "' contains: \"" + text + "\"");
        }
        if (Character.isUpperCase(register)) {
            Object object2 = this.getRegister(Character.toLowerCase(register));
            if (object2 == null || (object2 = ((Register)object2).getRawText()) == null) {
                object2 = "";
            }
            object = (String)object2 + text;
        } else {
            object = text;
        }
        String textToStore = object;
        Register reg = new Register(register, selectionType, textToStore, new ArrayList());
        this.saveRegister(register, reg);
        if (register == '/') {
            VimInjectorKt.getInjector().getSearchGroup().setLastSearchPattern(text);
        }
        return true;
    }

    @Override
    public boolean storeText(char register, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.storeText(register, text, SelectionType.CHARACTER_WISE);
    }

    private final SelectionType guessSelectionType(String text) {
        return StringsKt.endsWith$default((String)text, (String)"\n", (boolean)false, (int)2, null) ? SelectionType.LINE_WISE : SelectionType.CHARACTER_WISE;
    }

    private final Register refreshClipboardRegister(char r) {
        Register register;
        char c = r;
        if (c == '*') {
            register = this.refreshPrimaryRegister();
        } else if (c == '+') {
            register = this.refreshClipboardRegister();
        } else {
            throw new RuntimeException("Clipboard register expected, got " + r);
        }
        return register;
    }

    @Override
    public boolean isPrimaryRegisterSupported() {
        return System.getenv("DISPLAY") != null && VimInjectorKt.getInjector().getSystemInfoService().isXWindow();
    }

    private final void setSystemPrimaryRegisterText(String text, String rawText, List<? extends Object> transferableData) {
        logger.trace("Setting text: " + text + " to primary selection...");
        if (this.isPrimaryRegisterSupported()) {
            try {
                Transferable transferable = VimInjectorKt.getInjector().getClipboardManager().setPrimaryText(text, rawText, transferableData);
            }
            catch (Exception e) {
                logger.warn("False positive X11 primary selection support");
                logger.trace("Setting text to primary selection failed. Setting it to clipboard selection instead");
                this.setSystemClipboardRegisterText(text, rawText, transferableData);
                Unit unit = Unit.INSTANCE;
            }
        } else {
            logger.trace("X11 primary selection is not supporting. Setting clipboard selection instead");
            this.setSystemClipboardRegisterText(text, rawText, transferableData);
        }
    }

    private final void setSystemClipboardRegisterText(String text, String rawText, List<? extends Object> transferableData) {
        VimInjectorKt.getInjector().getClipboardManager().setClipboardText(text, rawText, transferableData);
    }

    private final Register refreshPrimaryRegister() {
        logger.trace("Syncing cached primary selection value..");
        if (!this.isPrimaryRegisterSupported()) {
            logger.trace("X11 primary selection is not supported. Syncing clipboard selection..");
            return this.refreshClipboardRegister();
        }
        try {
            Register register;
            List transferableData;
            Pair<String, List<Object>> pair = VimInjectorKt.getInjector().getClipboardManager().getPrimaryTextAndTransferableData();
            if (pair == null) {
                return null;
            }
            Pair<String, List<Object>> clipboardData = pair;
            Register currentRegister = this.myRegisters.get(Character.valueOf('*'));
            String text = (String)clipboardData.getFirst();
            List list = (List)clipboardData.getSecond();
            List list2 = transferableData = list != null ? CollectionsKt.toMutableList((Collection)list) : null;
            if (currentRegister != null && Intrinsics.areEqual((Object)text, (Object)currentRegister.getText())) {
                return currentRegister;
            }
            List list3 = transferableData;
            if (list3 != null) {
                List it = list3;
                boolean bl = false;
                register = new Register('*', this.guessSelectionType(text), text, it);
            } else {
                register = null;
            }
            return register;
        }
        catch (Exception e) {
            logger.warn("False positive X11 primary selection support");
            logger.trace("Syncing primary selection failed. Syncing clipboard selection instead");
            return this.refreshClipboardRegister();
        }
    }

    private final Register refreshClipboardRegister() {
        Register register;
        List transferableData;
        char systemAwareClipboardRegister = this.isPrimaryRegisterSupported() ? (char)'+' : '*';
        Pair<String, List<Object>> pair = VimInjectorKt.getInjector().getClipboardManager().getClipboardTextAndTransferableData();
        if (pair == null) {
            return null;
        }
        Pair<String, List<Object>> clipboardData = pair;
        Register currentRegister = this.myRegisters.get(Character.valueOf(systemAwareClipboardRegister));
        String text = (String)clipboardData.getFirst();
        List list = (List)clipboardData.getSecond();
        List list2 = transferableData = list != null ? CollectionsKt.toMutableList((Collection)list) : null;
        if (currentRegister != null && Intrinsics.areEqual((Object)text, (Object)currentRegister.getText())) {
            return currentRegister;
        }
        List list3 = transferableData;
        if (list3 != null) {
            List it = list3;
            boolean bl = false;
            register = new Register(systemAwareClipboardRegister, this.guessSelectionType(text), text, it);
        } else {
            register = null;
        }
        return register;
    }

    @Override
    @Nullable
    public Register getRegister(char r) {
        char myR = r;
        if (Character.isUpperCase(myR)) {
            myR = Character.toLowerCase(myR);
        }
        return StringsKt.indexOf$default((CharSequence)"+*", (char)myR, (int)0, (boolean)false, (int)6, null) >= 0 ? this.refreshClipboardRegister(myR) : this.myRegisters.get(Character.valueOf(myR));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Register> getRegisters() {
        void $this$mapNotNullTo$iv$iv;
        CharSequence $this$filterNotTo$iv$iv;
        void $this$filterNotTo$iv$iv2;
        Collection<Register> collection = this.myRegisters.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filterNot$iv = collection;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv2) {
            Register it = (Register)element$iv$iv;
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)"+*", (char)it.getName(), (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredRegisters = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        String $this$filterNot$iv2 = "+*";
        boolean $i$f$filterNot2 = false;
        destination$iv$iv = $this$filterNot$iv2;
        Object destination$iv$iv2 = new StringBuilder();
        boolean $i$f$filterNotTo2 = false;
        for (int element$iv$iv = 0; element$iv$iv < $this$filterNotTo$iv$iv.length(); ++element$iv$iv) {
            char element$iv$iv2;
            char it = element$iv$iv2 = $this$filterNotTo$iv$iv.charAt(element$iv$iv);
            boolean bl = false;
            if (it == '+' && !this.isPrimaryRegisterSupported()) continue;
            destination$iv$iv2.append(element$iv$iv2);
        }
        String string = ((StringBuilder)destination$iv$iv2).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        CharSequence $this$mapNotNull$iv = string;
        boolean $i$f$mapNotNull = false;
        $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv$iv$iv.length(); ++i) {
            Register it$iv$iv;
            char element$iv$iv$iv;
            char element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv.charAt(i);
            boolean bl = false;
            char it = element$iv$iv;
            boolean bl2 = false;
            if (this.refreshClipboardRegister(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List clipboardRegisters = (List)destination$iv$iv2;
        return CollectionsKt.sortedWith((Iterable)CollectionsKt.plus((Collection)filteredRegisters, (Iterable)clipboardRegisters), (Comparator)Register.KeySorter.INSTANCE);
    }

    @Override
    public void saveRegister(char r, @NotNull Register register) {
        Intrinsics.checkNotNullParameter((Object)register, (String)"register");
        int myR = Character.isUpperCase((char)r) ? Character.toLowerCase((char)r) : r;
        String text = register.getText();
        String rawText = register.getRawText();
        if (StringsKt.indexOf$default((CharSequence)"+*", (char)myR, (int)0, (boolean)false, (int)6, null) >= 0 && text != null && rawText != null) {
            int n = myR;
            if (n == 43) {
                if (!this.isPrimaryRegisterSupported()) {
                    myR = 42;
                }
                this.setSystemClipboardRegisterText(text, rawText, new ArrayList(register.getTransferableData()));
            } else if (n == 42) {
                this.setSystemPrimaryRegisterText(text, rawText, new ArrayList(register.getTransferableData()));
            }
        }
        Character c = Character.valueOf((char)myR);
        ((Map)this.myRegisters).put(c, register);
    }

    @Override
    public boolean startRecording(char register) {
        boolean bl;
        if (StringsKt.indexOf$default((CharSequence)"0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\"", (char)register, (int)0, (boolean)false, (int)6, null) != -1) {
            this.setRecordRegister(Character.valueOf(register));
            this.recordList = new ArrayList();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @Nullable
    public Register getPlaybackRegister(char r) {
        return StringsKt.indexOf$default((CharSequence)"0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\"\"+*.", (char)r, (int)0, (boolean)false, (int)6, null) != 0 ? this.getRegister(r) : null;
    }

    @Override
    public void recordText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        List<KeyStroke> myRecordList = this.recordList;
        if (this.isRecording() && myRecordList != null) {
            myRecordList.addAll((Collection<KeyStroke>)VimInjectorKt.getInjector().getParser().stringToKeys(text));
        }
    }

    @Override
    public void setKeys(char register, @NotNull List<? extends KeyStroke> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Character c = Character.valueOf(register);
        ((Map)this.myRegisters).put(c, new Register(register, SelectionType.CHARACTER_WISE, CollectionsKt.toMutableList((Collection)keys)));
    }

    @Override
    public void setKeys(char register, @NotNull List<? extends KeyStroke> keys, @NotNull SelectionType type) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Character c = Character.valueOf(register);
        ((Map)this.myRegisters).put(c, new Register(register, type, CollectionsKt.toMutableList((Collection)keys)));
    }

    @Override
    public void finishRecording() {
        Character register = this.getRecordRegister();
        if (register != null) {
            List<KeyStroke> myRecordList;
            Register reg = null;
            if (Character.isUpperCase(register.charValue())) {
                reg = this.getRegister(register.charValue());
            }
            if ((myRecordList = this.recordList) != null) {
                if (reg == null) {
                    reg = new Register(Character.toLowerCase(register.charValue()), SelectionType.CHARACTER_WISE, myRecordList);
                    ((Map)this.myRegisters).put(Character.valueOf(Character.toLowerCase(register.charValue())), reg);
                } else {
                    reg.addKeys(myRecordList);
                }
            }
        }
        this.setRecordRegister(null);
    }

    @Override
    public char getCurrentRegisterForMulticaret() {
        return (char)(this.isRegisterSpecifiedExplicitly() || !this.isSystemClipboard(this.getCurrentRegister()) ? this.getCurrentRegister() : 34);
    }

    @Override
    public boolean isSystemClipboard(char register) {
        return register == '+' || register == '*';
    }

    private static final Unit onClipboardChanged$lambda$0(VimRegisterGroupBase this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        StringListOptionValue clipboardOptionValue = VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getClipboard();
        this$0.defaultRegisterChar = (char)(clipboardOptionValue.contains((Object)"unnamedplus") ? (this$0.isPrimaryRegisterSupported() ? 43 : 42) : (clipboardOptionValue.contains((Object)"unnamed") ? 42 : 34));
        this$0.setLastRegisterChar(this$0.defaultRegisterChar);
        return Unit.INSTANCE;
    }

    private static final CharSequence storeTextInternal$lambda$3$lambda$2(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(VimRegisterGroupBase.class);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/register/VimRegisterGroupBase$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "getLogger", "()Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VimLogger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

