/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.regexp.engine.strategies;

import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.regexp.VimRegexErrors;
import com.maddyhome.idea.vim.regexp.engine.nfa.NFA;
import com.maddyhome.idea.vim.regexp.engine.nfa.NFAAssertion;
import com.maddyhome.idea.vim.regexp.engine.nfa.NFAState;
import com.maddyhome.idea.vim.regexp.engine.nfa.NFATransition;
import com.maddyhome.idea.vim.regexp.engine.nfa.matcher.MatcherResult;
import com.maddyhome.idea.vim.regexp.engine.strategies.NFASimulationResult;
import com.maddyhome.idea.vim.regexp.engine.strategies.NfaStateList;
import com.maddyhome.idea.vim.regexp.engine.strategies.SimulationResult;
import com.maddyhome.idea.vim.regexp.engine.strategies.SimulationStackFrame;
import com.maddyhome.idea.vim.regexp.engine.strategies.SimulationStrategy;
import com.maddyhome.idea.vim.regexp.match.VimMatchGroup;
import com.maddyhome.idea.vim.regexp.match.VimMatchGroupCollection;
import com.maddyhome.idea.vim.regexp.match.VimMatchResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016JH\u0010\u0006\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\b\u0002\u0010\u0018\u001a\u00020\rH\u0002J6\u0010\u0019\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J6\u0010\u001d\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J6\u0010\u001e\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J \u0010\u001f\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/maddyhome/idea/vim/regexp/engine/strategies/BacktrackingStrategy;", "Lcom/maddyhome/idea/vim/regexp/engine/strategies/SimulationStrategy;", "<init>", "()V", "groups", "Lcom/maddyhome/idea/vim/regexp/match/VimMatchGroupCollection;", "simulate", "Lcom/maddyhome/idea/vim/regexp/engine/strategies/SimulationResult;", "nfa", "Lcom/maddyhome/idea/vim/regexp/engine/nfa/NFA;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "startIndex", "", "isCaseInsensitive", "", "Lcom/maddyhome/idea/vim/regexp/engine/strategies/NFASimulationResult;", "index", "state", "Lcom/maddyhome/idea/vim/regexp/engine/nfa/NFAState;", "targetState", "possibleCursors", "", "Lcom/maddyhome/idea/vim/api/VimCaret;", "maxIndex", "handleAssertion", "currentIndex", "assertion", "Lcom/maddyhome/idea/vim/regexp/engine/nfa/NFAAssertion;", "handleAheadAssertion", "handleBehindAssertion", "updateCaptureGroups", "", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nBacktrackingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BacktrackingStrategy.kt\ncom/maddyhome/idea/vim/regexp/engine/strategies/BacktrackingStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,242:1\n1#2:243\n*E\n"})
public final class BacktrackingStrategy
implements SimulationStrategy {
    @NotNull
    private final VimMatchGroupCollection groups = new VimMatchGroupCollection(0, 1, null);

    @Override
    @NotNull
    public SimulationResult simulate(@NotNull NFA nfa, @NotNull VimEditor editor, int startIndex, boolean isCaseInsensitive) {
        Intrinsics.checkNotNullParameter((Object)nfa, (String)"nfa");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.groups.clear$vim_engine();
        if (BacktrackingStrategy.simulate$default(this, editor, startIndex, nfa.getStartState$vim_engine(), nfa.getAcceptState$vim_engine(), isCaseInsensitive, CollectionsKt.toMutableList((Collection)editor.carets()), 0, 64, null).getSimulationResult()) {
            VimMatchResult vimMatchResult;
            VimMatchGroup vimMatchGroup = this.groups.get(0);
            if (vimMatchGroup != null) {
                VimMatchGroup it = vimMatchGroup;
                boolean bl = false;
                vimMatchResult = new VimMatchResult.Success(it.getRange(), it.getValue(), this.groups);
            } else {
                BacktrackingStrategy $this$simulate_u24lambda_u241 = this;
                boolean bl = false;
                vimMatchResult = new VimMatchResult.Failure(VimRegexErrors.E486);
            }
            VimMatchResult vimMatchResult2 = vimMatchResult;
            return new SimulationResult.Complete(vimMatchResult2);
        }
        return new SimulationResult.Complete(new VimMatchResult.Failure(VimRegexErrors.E486));
    }

    private final NFASimulationResult simulate(VimEditor editor, int index, NFAState state, NFAState targetState, boolean isCaseInsensitive, List<VimCaret> possibleCursors, int maxIndex) {
        List stack = new ArrayList();
        stack.add(new SimulationStackFrame(index, state, NfaStateList.Companion.getEmpty()));
        while (!((Collection)stack).isEmpty()) {
            SimulationStackFrame currFrame = (SimulationStackFrame)CollectionsKt.removeLast((List)stack);
            if (currFrame.getCurrentIndex() > maxIndex) continue;
            this.updateCaptureGroups(editor, currFrame.getCurrentIndex(), currFrame.getCurrentState());
            if (currFrame.getCurrentState() == targetState) {
                return new NFASimulationResult(true, currFrame.getCurrentIndex());
            }
            if (currFrame.getCurrentState().getAssertion$vim_engine() != null) {
                NFAAssertion it;
                boolean bl = false;
                NFASimulationResult assertionResult = this.handleAssertion(editor, currFrame.getCurrentIndex(), isCaseInsensitive, it, possibleCursors);
                if (assertionResult.getSimulationResult()) {
                    int n = assertionResult.getIndex();
                    NFAAssertion nFAAssertion = currFrame.getCurrentState().getAssertion$vim_engine();
                    Intrinsics.checkNotNull((Object)nFAAssertion);
                    stack.add(new SimulationStackFrame(n, nFAAssertion.getJumpTo(), NfaStateList.Companion.getEmpty()));
                }
            }
            for (int i = CollectionsKt.getLastIndex(currFrame.getCurrentState().getTransitions$vim_engine()); -1 < i; --i) {
                NFATransition transition = currFrame.getCurrentState().getTransitions$vim_engine().get(i);
                MatcherResult transitionMatcherResult = transition.getMatcher().matches(editor, currFrame.getCurrentIndex(), this.groups, isCaseInsensitive, possibleCursors);
                if (!(transitionMatcherResult instanceof MatcherResult.Success)) continue;
                NFAState destState = transition.getDestState();
                if (((MatcherResult.Success)transitionMatcherResult).getConsumed() == 0 && currFrame.getEpsilonVisited().contains(destState)) continue;
                int nextIndex = currFrame.getCurrentIndex() + ((MatcherResult.Success)transitionMatcherResult).getConsumed();
                NfaStateList epsilonVisitedCopy = ((MatcherResult.Success)transitionMatcherResult).getConsumed() == 0 && !currFrame.getEpsilonVisited().contains(destState) ? new NfaStateList(currFrame.getCurrentState(), currFrame.getEpsilonVisited()) : NfaStateList.Companion.getEmpty();
                stack.add(new SimulationStackFrame(nextIndex, destState, epsilonVisitedCopy));
            }
        }
        return new NFASimulationResult(false, index);
    }

    static /* synthetic */ NFASimulationResult simulate$default(BacktrackingStrategy backtrackingStrategy, VimEditor vimEditor, int n, NFAState nFAState, NFAState nFAState2, boolean bl, List list, int n2, int n3, Object object) {
        if ((n3 & 0x40) != 0) {
            n2 = vimEditor.text().length();
        }
        return backtrackingStrategy.simulate(vimEditor, n, nFAState, nFAState2, bl, list, n2);
    }

    private final NFASimulationResult handleAssertion(VimEditor editor, int currentIndex, boolean isCaseInsensitive, NFAAssertion assertion, List<VimCaret> possibleCursors) {
        return assertion.isAhead() ? this.handleAheadAssertion(editor, currentIndex, isCaseInsensitive, assertion, possibleCursors) : this.handleBehindAssertion(editor, currentIndex, isCaseInsensitive, assertion, possibleCursors);
    }

    private final NFASimulationResult handleAheadAssertion(VimEditor editor, int currentIndex, boolean isCaseInsensitive, NFAAssertion assertion, List<VimCaret> possibleCursors) {
        NFASimulationResult assertionResult = BacktrackingStrategy.simulate$default(this, editor, currentIndex, assertion.getStartState(), assertion.getEndState(), isCaseInsensitive, possibleCursors, 0, 64, null);
        if (assertionResult.getSimulationResult() != assertion.isPositive()) {
            return new NFASimulationResult(false, currentIndex);
        }
        int newIndex = assertion.getShouldConsume() ? assertionResult.getIndex() : currentIndex;
        return new NFASimulationResult(true, newIndex);
    }

    private final NFASimulationResult handleBehindAssertion(VimEditor editor, int currentIndex, boolean isCaseInsensitive, NFAAssertion assertion, List<VimCaret> possibleCursors) {
        int minIndex = assertion.getLimit() == 0 ? 0 : Math.max(0, currentIndex - assertion.getLimit());
        boolean seenNewLine = false;
        for (int lookBehindStartIndex = currentIndex - 1; !(lookBehindStartIndex < minIndex || seenNewLine && editor.text().charAt(lookBehindStartIndex) != '\n'); --lookBehindStartIndex) {
            NFASimulationResult result;
            if (editor.text().charAt(lookBehindStartIndex) == '\n') {
                seenNewLine = true;
            }
            if (!(result = this.simulate(editor, lookBehindStartIndex, assertion.getStartState(), assertion.getEndState(), isCaseInsensitive, possibleCursors, currentIndex)).getSimulationResult() || result.getIndex() != currentIndex) continue;
            return assertion.isPositive() ? new NFASimulationResult(true, currentIndex) : new NFASimulationResult(false, currentIndex);
        }
        return assertion.isPositive() ? new NFASimulationResult(false, currentIndex) : new NFASimulationResult(true, currentIndex);
    }

    private final void updateCaptureGroups(VimEditor editor, int index, NFAState state) {
        int groupNumber;
        Iterator<Integer> iterator = state.getStartCapture$vim_engine().iterator();
        while (iterator.hasNext()) {
            groupNumber = ((Number)iterator.next()).intValue();
            this.groups.setGroupStart$vim_engine(groupNumber, index);
        }
        iterator = state.getEndCapture$vim_engine().iterator();
        while (iterator.hasNext()) {
            groupNumber = ((Number)iterator.next()).intValue();
            this.groups.setGroupEnd$vim_engine(groupNumber, index, editor.text());
        }
        iterator = state.getForceEndCapture$vim_engine().iterator();
        while (iterator.hasNext()) {
            groupNumber = ((Number)iterator.next()).intValue();
            this.groups.setForceGroupEnd$vim_engine(groupNumber, index, editor.text());
        }
    }
}

