/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.key.consumers;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.KeyProcessResult;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCommandLine;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.key.KeyConsumer;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import com.maddyhome.idea.vim.state.mode.Mode;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/ModeInputConsumer;", "Lcom/maddyhome/idea/vim/key/KeyConsumer;", "<init>", "()V", "consumeKey", "", "key", "Ljavax/swing/KeyStroke;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "allowKeyMappings", "mappingCompleted", "keyProcessResultBuilder", "Lcom/maddyhome/idea/vim/KeyProcessResult$KeyProcessResultBuilder;", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nModeInputConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModeInputConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/ModeInputConsumer\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,71:1\n27#2,4:72\n38#2:76\n*S KotlinDebug\n*F\n+ 1 ModeInputConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/ModeInputConsumer\n*L\n33#1:72,4\n23#1:76\n*E\n"})
public final class ModeInputConsumer
implements KeyConsumer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final VimLogger logger;

    @Override
    public boolean consumeKey(@NotNull KeyStroke key, @NotNull VimEditor editor, boolean allowKeyMappings, boolean mappingCompleted, @NotNull KeyProcessResult.KeyProcessResultBuilder keyProcessResultBuilder) {
        boolean isProcessed;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)keyProcessResultBuilder, (String)"keyProcessResultBuilder");
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("Entered ModeInputConsumer");
        }
        Mode mode = editor.getMode();
        if (Intrinsics.areEqual((Object)mode, (Object)Mode.INSERT.INSTANCE) || Intrinsics.areEqual((Object)mode, (Object)Mode.REPLACE.INSTANCE)) {
            logger.trace("Process insert or replace");
            v0 = keyProcessed = VimInjectorKt.getInjector().getChangeGroup().processKey(editor, key, keyProcessResultBuilder);
        } else if (mode instanceof Mode.SELECT) {
            logger.trace("Process select");
            v0 = keyProcessed = VimInjectorKt.getInjector().getChangeGroup().processKeyInSelectMode(editor, key, keyProcessResultBuilder);
        } else if (mode instanceof Mode.CMD_LINE) {
            VimCommandLine commandLine = VimInjectorKt.getInjector().getCommandLine().getActiveCommandLine();
            if (commandLine != null) {
                keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)(arg_0, arg_1, arg_2) -> ModeInputConsumer.consumeKey$lambda$1(commandLine, key, arg_0, arg_1, arg_2)));
            } else {
                keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)ModeInputConsumer::consumeKey$lambda$2));
            }
            v0 = true;
        } else {
            v0 = isProcessed = false;
        }
        if (isProcessed) {
            keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)ModeInputConsumer::consumeKey$lambda$3));
        }
        return isProcessed;
    }

    private static final Unit consumeKey$lambda$1(VimCommandLine $commandLine, KeyStroke $key, KeyHandlerState keyHandlerState, VimEditor vimEditor, ExecutionContext executionContext) {
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)keyHandlerState, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)vimEditor, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"<unused var>");
        $commandLine.focus();
        $commandLine.handleKey($key);
        return Unit.INSTANCE;
    }

    private static final Unit consumeKey$lambda$2(KeyHandlerState keyHandlerState, VimEditor lambdaEditor, ExecutionContext executionContext) {
        Intrinsics.checkNotNullParameter((Object)keyHandlerState, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)lambdaEditor, (String)"lambdaEditor");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"<unused var>");
        lambdaEditor.setMode(new Mode.NORMAL(null, 1, null));
        KeyHandler.Companion.getInstance().reset(lambdaEditor);
        return Unit.INSTANCE;
    }

    private static final Unit consumeKey$lambda$3(KeyHandlerState lambdaKeyState, VimEditor lambdaEditor, ExecutionContext executionContext) {
        Intrinsics.checkNotNullParameter((Object)lambdaKeyState, (String)"lambdaKeyState");
        Intrinsics.checkNotNullParameter((Object)lambdaEditor, (String)"lambdaEditor");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"<unused var>");
        lambdaKeyState.partialReset(lambdaEditor.getMode());
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(ModeInputConsumer.class);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/ModeInputConsumer$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

