/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.key.consumers;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.KeyProcessResult;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCommandLine;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.CommandBuilder;
import com.maddyhome.idea.vim.common.DigraphResult;
import com.maddyhome.idea.vim.common.DigraphSequence;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.key.KeyConsumer;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/DigraphConsumer;", "Lcom/maddyhome/idea/vim/key/KeyConsumer;", "<init>", "()V", "consumeKey", "", "key", "Ljavax/swing/KeyStroke;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "allowKeyMappings", "mappingCompleted", "keyProcessResultBuilder", "Lcom/maddyhome/idea/vim/KeyProcessResult$KeyProcessResultBuilder;", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nDigraphConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DigraphConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/DigraphConsumer\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,131:1\n27#2,4:132\n38#2:136\n*S KotlinDebug\n*F\n+ 1 DigraphConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/DigraphConsumer\n*L\n36#1:132,4\n26#1:136\n*E\n"})
public final class DigraphConsumer
implements KeyConsumer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final VimLogger logger;

    @Override
    public boolean consumeKey(@NotNull KeyStroke key, @NotNull VimEditor editor, boolean allowKeyMappings, boolean mappingCompleted, @NotNull KeyProcessResult.KeyProcessResultBuilder keyProcessResultBuilder) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)keyProcessResultBuilder, (String)"keyProcessResultBuilder");
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("Entered DigraphConsumer");
        }
        logger.debug("Handling digraph");
        KeyHandlerState keyState = keyProcessResultBuilder.getState();
        CommandBuilder commandBuilder = keyState.getCommandBuilder();
        DigraphSequence digraphSequence = keyState.getDigraphSequence();
        if (commandBuilder.getExpectedArgumentType() == Argument.Type.DIGRAPH) {
            logger.trace("Expected argument is digraph");
            if (digraphSequence.isDigraphStart(key)) {
                digraphSequence.startDigraphSequence();
                commandBuilder.addKey(key);
                return true;
            }
            if (digraphSequence.isLiteralStart(key)) {
                digraphSequence.startLiteralSequence();
                commandBuilder.addKey(key);
                return true;
            }
        }
        DigraphResult res = digraphSequence.processKey(key, editor);
        KeyHandler keyHandler = KeyHandler.Companion.getInstance();
        DigraphResult digraphResult = res;
        if (digraphResult instanceof DigraphResult.Handled) {
            keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)(arg_0, arg_1, arg_2) -> DigraphConsumer.consumeKey$lambda$1(keyHandler, res, key, arg_0, arg_1, arg_2)));
            return true;
        }
        if (digraphResult instanceof DigraphResult.Done) {
            VimCommandLine commandLine = VimInjectorKt.getInjector().getCommandLine().getActiveCommandLine();
            if (commandLine != null) {
                if (key.getKeyCode() == 67 && (key.getModifiers() & 0x80) != 0) {
                    return false;
                }
                keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)(arg_0, arg_1, arg_2) -> DigraphConsumer.consumeKey$lambda$2(commandLine, arg_0, arg_1, arg_2)));
            }
            keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)DigraphConsumer::consumeKey$lambda$3));
            KeyStroke keyStroke = res.getStroke();
            if (keyStroke == null) {
                return false;
            }
            KeyStroke stroke = keyStroke;
            keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)(arg_0, arg_1, arg_2) -> DigraphConsumer.consumeKey$lambda$4(key, keyHandler, stroke, arg_0, arg_1, arg_2)));
            return true;
        }
        if (digraphResult instanceof DigraphResult.Bad) {
            VimCommandLine commandLine = VimInjectorKt.getInjector().getCommandLine().getActiveCommandLine();
            if (commandLine != null) {
                if (key.getKeyCode() == 67 && (key.getModifiers() & 0x80) != 0) {
                    return false;
                }
                keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)(arg_0, arg_1, arg_2) -> DigraphConsumer.consumeKey$lambda$5(commandLine, arg_0, arg_1, arg_2)));
            }
            keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)DigraphConsumer::consumeKey$lambda$6));
            return true;
        }
        if (digraphResult instanceof DigraphResult.Unhandled) {
            if (commandBuilder.getExpectedArgumentType() == Argument.Type.DIGRAPH) {
                commandBuilder.fallbackToCharacterArgument();
                keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)(arg_0, arg_1, arg_2) -> DigraphConsumer.consumeKey$lambda$7(keyHandler, key, arg_0, arg_1, arg_2)));
                return true;
            }
            return false;
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final Unit consumeKey$lambda$1(KeyHandler $keyHandler, DigraphResult $res, KeyStroke $key, KeyHandlerState lambdaKeyState, VimEditor vimEditor, ExecutionContext executionContext) {
        Intrinsics.checkNotNullParameter((Object)$keyHandler, (String)"$keyHandler");
        Intrinsics.checkNotNullParameter((Object)$res, (String)"$res");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)lambdaKeyState, (String)"lambdaKeyState");
        Intrinsics.checkNotNullParameter((Object)vimEditor, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"<unused var>");
        $keyHandler.setPromptCharacterEx($res.getPromptCharacter());
        lambdaKeyState.getCommandBuilder().addKey($key);
        return Unit.INSTANCE;
    }

    private static final Unit consumeKey$lambda$2(VimCommandLine $commandLine, KeyHandlerState keyHandlerState, VimEditor vimEditor, ExecutionContext executionContext) {
        Intrinsics.checkNotNullParameter((Object)keyHandlerState, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)vimEditor, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"<unused var>");
        $commandLine.clearCurrentAction();
        return Unit.INSTANCE;
    }

    private static final Unit consumeKey$lambda$3(KeyHandlerState lambdaKeyState, VimEditor vimEditor, ExecutionContext executionContext) {
        Intrinsics.checkNotNullParameter((Object)lambdaKeyState, (String)"lambdaKeyState");
        Intrinsics.checkNotNullParameter((Object)vimEditor, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"<unused var>");
        if (lambdaKeyState.getCommandBuilder().getExpectedArgumentType() == Argument.Type.DIGRAPH) {
            lambdaKeyState.getCommandBuilder().fallbackToCharacterArgument();
        }
        return Unit.INSTANCE;
    }

    private static final Unit consumeKey$lambda$4(KeyStroke $key, KeyHandler $keyHandler, KeyStroke $stroke, KeyHandlerState lambdaKeyState, VimEditor lambdaEditorState, ExecutionContext lambdaContext) {
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)$keyHandler, (String)"$keyHandler");
        Intrinsics.checkNotNullParameter((Object)$stroke, (String)"$stroke");
        Intrinsics.checkNotNullParameter((Object)lambdaKeyState, (String)"lambdaKeyState");
        Intrinsics.checkNotNullParameter((Object)lambdaEditorState, (String)"lambdaEditorState");
        Intrinsics.checkNotNullParameter((Object)lambdaContext, (String)"lambdaContext");
        lambdaKeyState.getCommandBuilder().addKey($key);
        $keyHandler.handleKey(lambdaEditorState, $stroke, lambdaContext, lambdaKeyState);
        return Unit.INSTANCE;
    }

    private static final Unit consumeKey$lambda$5(VimCommandLine $commandLine, KeyHandlerState keyHandlerState, VimEditor vimEditor, ExecutionContext executionContext) {
        Intrinsics.checkNotNullParameter((Object)keyHandlerState, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)vimEditor, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"<unused var>");
        $commandLine.clearCurrentAction();
        return Unit.INSTANCE;
    }

    private static final Unit consumeKey$lambda$6(KeyHandlerState lambdaKeyState, VimEditor lambdaEditor, ExecutionContext executionContext) {
        Intrinsics.checkNotNullParameter((Object)lambdaKeyState, (String)"lambdaKeyState");
        Intrinsics.checkNotNullParameter((Object)lambdaEditor, (String)"lambdaEditor");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"<unused var>");
        if (lambdaKeyState.getCommandBuilder().getExpectedArgumentType() != null) {
            KeyHandler.Companion.getInstance().setBadCommand(lambdaEditor, lambdaKeyState);
        }
        return Unit.INSTANCE;
    }

    private static final Unit consumeKey$lambda$7(KeyHandler $keyHandler, KeyStroke $key, KeyHandlerState lambdaKeyState, VimEditor lambdaEditor, ExecutionContext lambdaContext) {
        Intrinsics.checkNotNullParameter((Object)$keyHandler, (String)"$keyHandler");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)lambdaKeyState, (String)"lambdaKeyState");
        Intrinsics.checkNotNullParameter((Object)lambdaEditor, (String)"lambdaEditor");
        Intrinsics.checkNotNullParameter((Object)lambdaContext, (String)"lambdaContext");
        $keyHandler.handleKey(lambdaEditor, $key, lambdaContext, lambdaKeyState);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(DigraphConsumer.class);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/DigraphConsumer$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

