/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.key.consumers;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.KeyProcessResult;
import com.maddyhome.idea.vim.action.change.LazyVimCommand;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCommandLine;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.CommandBuilder;
import com.maddyhome.idea.vim.command.CommandFlags;
import com.maddyhome.idea.vim.common.ArgumentCapturerKt;
import com.maddyhome.idea.vim.common.CurrentCommandState;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import com.maddyhome.idea.vim.key.CommandNode;
import com.maddyhome.idea.vim.key.CommandPartNode;
import com.maddyhome.idea.vim.key.KeyConsumer;
import com.maddyhome.idea.vim.key.Node;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import com.maddyhome.idea.vim.state.VimStateMachine;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.ModeExtensionsKt;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 %2\u00020\u0001:\u0001%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J8\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0002J8\u0010\u001a\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0002J\u001a\u0010#\u001a\u00020\u00052\b\u0010$\u001a\u0004\u0018\u00010 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a8\u0006&"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/CommandConsumer;", "Lcom/maddyhome/idea/vim/key/KeyConsumer;", "<init>", "()V", "consumeKey", "", "key", "Ljavax/swing/KeyStroke;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "allowKeyMappings", "mappingCompleted", "keyProcessResultBuilder", "Lcom/maddyhome/idea/vim/KeyProcessResult$KeyProcessResultBuilder;", "mapOpCommand", "Lcom/maddyhome/idea/vim/key/Node;", "Lcom/maddyhome/idea/vim/action/change/LazyVimCommand;", "node", "mode", "Lcom/maddyhome/idea/vim/state/mode/Mode;", "keyState", "Lcom/maddyhome/idea/vim/state/KeyHandlerState;", "handleCommandNode", "", "Lcom/maddyhome/idea/vim/key/CommandNode;", "processBuilder", "startWaitingForArgument", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "action", "Lcom/maddyhome/idea/vim/handler/EditorActionHandlerBase;", "argument", "Lcom/maddyhome/idea/vim/command/Argument$Type;", "editorState", "Lcom/maddyhome/idea/vim/state/VimStateMachine;", "checkArgumentCompatibility", "expectedArgumentType", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nCommandConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/CommandConsumer\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,172:1\n27#2,4:173\n38#2:177\n*S KotlinDebug\n*F\n+ 1 CommandConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/CommandConsumer\n*L\n47#1:173,4\n37#1:177\n*E\n"})
public final class CommandConsumer
implements KeyConsumer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final VimLogger logger;

    @Override
    public boolean consumeKey(@NotNull KeyStroke key, @NotNull VimEditor editor, boolean allowKeyMappings, boolean mappingCompleted, @NotNull KeyProcessResult.KeyProcessResultBuilder keyProcessResultBuilder) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)keyProcessResultBuilder, (String)"keyProcessResultBuilder");
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("Entered CommandConsumer");
        }
        CommandBuilder commandBuilder = keyProcessResultBuilder.getState().getCommandBuilder();
        logger.trace("Getting the node for the current mode");
        logger.trace("command builder - " + commandBuilder);
        Node<LazyVimCommand> node = this.mapOpCommand(key, commandBuilder.getChildNode(key), editor.getMode(), keyProcessResultBuilder.getState());
        logger.trace("node: " + node);
        Node<LazyVimCommand> node2 = node;
        if (node2 instanceof CommandNode) {
            logger.trace("Node is a command node");
            this.handleCommandNode((CommandNode)node, keyProcessResultBuilder);
            keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)(arg_0, arg_1, arg_2) -> CommandConsumer.consumeKey$lambda$1(key, arg_0, arg_1, arg_2)));
            return true;
        }
        if (node2 instanceof CommandPartNode) {
            logger.trace("Node is a command part node");
            commandBuilder.setCurrentCommandPartNode((CommandPartNode)node);
            commandBuilder.addKey(key);
            return true;
        }
        return false;
    }

    private final Node<LazyVimCommand> mapOpCommand(KeyStroke key, Node<LazyVimCommand> node, Mode mode, KeyHandlerState keyState) {
        Node<LazyVimCommand> node2;
        logger.trace("entered mapOpCommand. key = " + VimInjectorKt.getInjector().getParser().toKeyNotation(key) + ", node = " + node + ", mode = " + mode);
        if (KeyHandler.Companion.getInstance().isDuplicateOperatorKeyStroke(key, mode, keyState)) {
            logger.trace("it is a duplicate operator key stroke");
            CommandBuilder commandBuilder = keyState.getCommandBuilder();
            KeyStroke keyStroke = KeyStroke.getKeyStroke('_');
            Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getKeyStroke(...)");
            node2 = commandBuilder.getChildNode(keyStroke);
        } else {
            node2 = node;
        }
        return node2;
    }

    private final void handleCommandNode(CommandNode<LazyVimCommand> node, KeyProcessResult.KeyProcessResultBuilder processBuilder) {
        logger.trace("Handle command node");
        EditorActionHandlerBase action = (EditorActionHandlerBase)node.getActionHolder().getInstance();
        KeyHandlerState keyState = processBuilder.getState();
        if (action.getFlags().contains((Object)CommandFlags.FLAG_START_EX)) {
            keyState.enterCommandLine();
            VimInjectorKt.getInjector().getRedrawService().redrawStatusLine();
        }
        if (action.getFlags().contains((Object)CommandFlags.FLAG_END_EX)) {
            keyState.leaveCommandLine();
            VimInjectorKt.getInjector().getRedrawService().redrawStatusLine();
        }
        CommandBuilder commandBuilder = keyState.getCommandBuilder();
        Argument.Type expectedArgumentType = commandBuilder.getExpectedArgumentType();
        commandBuilder.pushCommandPart(action);
        if (!this.checkArgumentCompatibility(expectedArgumentType, action)) {
            logger.trace("Return from command node handling");
            processBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)CommandConsumer::handleCommandNode$lambda$2));
            return;
        }
        if (action.getArgumentType() == null) {
            logger.trace("Set command state to READY");
            commandBuilder.setCommandState(CurrentCommandState.READY);
        } else {
            processBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)(arg_0, arg_1, arg_2) -> CommandConsumer.handleCommandNode$lambda$3(action, this, arg_0, arg_1, arg_2)));
        }
        processBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)(arg_0, arg_1, arg_2) -> CommandConsumer.handleCommandNode$lambda$4(action, commandBuilder, arg_0, arg_1, arg_2)));
    }

    private final void startWaitingForArgument(VimEditor editor, ExecutionContext context, EditorActionHandlerBase action, Argument.Type argument, KeyHandlerState keyState, VimStateMachine editorState) {
        CommandBuilder commandBuilder = keyState.getCommandBuilder();
        if (argument == Argument.Type.MOTION) {
            if (editorState.isDotRepeatInProgress() && ArgumentCapturerKt.getArgumentCaptured() != null) {
                Argument argument2 = ArgumentCapturerKt.getArgumentCaptured();
                Intrinsics.checkNotNull((Object)argument2);
                commandBuilder.completeCommandPart(argument2);
            }
            editor.setMode(new Mode.OP_PENDING(ModeExtensionsKt.getReturnTo(editorState.getMode()), null, 2, null));
        }
        action.onStartWaitingForArgument(editor, context, keyState);
    }

    private final boolean checkArgumentCompatibility(Argument.Type expectedArgumentType, EditorActionHandlerBase action) {
        return expectedArgumentType != Argument.Type.MOTION || action.getType() == Command.Type.MOTION;
    }

    private static final Unit consumeKey$lambda$1(KeyStroke $key, KeyHandlerState lambdaKeyState, VimEditor vimEditor, ExecutionContext executionContext) {
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)lambdaKeyState, (String)"lambdaKeyState");
        Intrinsics.checkNotNullParameter((Object)vimEditor, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"<unused var>");
        lambdaKeyState.getCommandBuilder().addKey($key);
        return Unit.INSTANCE;
    }

    private static final Unit handleCommandNode$lambda$2(KeyHandlerState lambdaKeyState, VimEditor lambdaEditor, ExecutionContext executionContext) {
        Intrinsics.checkNotNullParameter((Object)lambdaKeyState, (String)"lambdaKeyState");
        Intrinsics.checkNotNullParameter((Object)lambdaEditor, (String)"lambdaEditor");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"<unused var>");
        KeyHandler.Companion.getInstance().setBadCommand(lambdaEditor, lambdaKeyState);
        return Unit.INSTANCE;
    }

    private static final Unit handleCommandNode$lambda$3(EditorActionHandlerBase $action, CommandConsumer this$0, KeyHandlerState lambdaKeyState, VimEditor lambdaEditor, ExecutionContext lambdaContext) {
        Argument.Type argumentType;
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)lambdaKeyState, (String)"lambdaKeyState");
        Intrinsics.checkNotNullParameter((Object)lambdaEditor, (String)"lambdaEditor");
        Intrinsics.checkNotNullParameter((Object)lambdaContext, (String)"lambdaContext");
        logger.trace("Set waiting for the argument");
        Argument.Type type = argumentType = $action.getArgumentType();
        Intrinsics.checkNotNull((Object)((Object)type));
        this$0.startWaitingForArgument(lambdaEditor, lambdaContext, $action, type, lambdaKeyState, VimInjectorKt.getInjector().getVimState());
        lambdaKeyState.partialReset(lambdaEditor.getMode());
        return Unit.INSTANCE;
    }

    private static final Unit handleCommandNode$lambda$4(EditorActionHandlerBase $action, CommandBuilder $commandBuilder, KeyHandlerState keyHandlerState, VimEditor vimEditor, ExecutionContext executionContext) {
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        Intrinsics.checkNotNullParameter((Object)$commandBuilder, (String)"$commandBuilder");
        Intrinsics.checkNotNullParameter((Object)keyHandlerState, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)vimEditor, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"<unused var>");
        if ($action.getFlags().contains((Object)CommandFlags.FLAG_END_EX)) {
            logger.trace("Processing ex_string");
            VimCommandLine vimCommandLine = VimInjectorKt.getInjector().getCommandLine().getActiveCommandLine();
            Intrinsics.checkNotNull((Object)vimCommandLine);
            VimCommandLine commandLine = vimCommandLine;
            String label = commandLine.getLabel();
            String text = commandLine.getActualText();
            Function1<String, Unit> processing = commandLine.getInputProcessing();
            commandLine.close(true, true);
            $commandBuilder.completeCommandPart(new Argument(label.charAt(0), text, processing));
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(CommandConsumer.class);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/CommandConsumer$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

