/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.history;

import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.history.HistoryBlock;
import com.maddyhome.idea.vim.history.HistoryConstants;
import com.maddyhome.idea.vim.history.HistoryEntry;
import com.maddyhome.idea.vim.history.VimHistory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0017J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\rH\u0016J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0017J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0004R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/maddyhome/idea/vim/history/VimHistoryBase;", "Lcom/maddyhome/idea/vim/history/VimHistory;", "<init>", "()V", "histories", "", "Lcom/maddyhome/idea/vim/history/VimHistory$Type;", "Lcom/maddyhome/idea/vim/history/HistoryBlock;", "getHistories", "()Ljava/util/Map;", "addEntry", "", "key", "", "text", "type", "getEntries", "", "Lcom/maddyhome/idea/vim/history/HistoryEntry;", "first", "", "last", "blocks", "getTypeForString", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimHistoryBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimHistoryBase.kt\ncom/maddyhome/idea/vim/history/VimHistoryBase\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,91:1\n33#2,4:92\n38#2:103\n381#3,7:96\n*S KotlinDebug\n*F\n+ 1 VimHistoryBase.kt\ncom/maddyhome/idea/vim/history/VimHistoryBase\n*L\n62#1:92,4\n88#1:103\n74#1:96,7\n*E\n"})
public class VimHistoryBase
implements VimHistory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<VimHistory.Type, HistoryBlock> histories = new LinkedHashMap();
    @NotNull
    private static final VimLogger logger;

    @NotNull
    public final Map<VimHistory.Type, HistoryBlock> getHistories() {
        return this.histories;
    }

    @Override
    @Deprecated(message="Please use fun addEntry(type: Type, text: String)")
    public void addEntry(@NotNull String key, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        VimHistory.Type type = this.getTypeForString(key);
        this.addEntry(type, text);
    }

    @Override
    public void addEntry(@NotNull VimHistory.Type type, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        HistoryBlock block = this.blocks(type);
        block.addEntry(text);
    }

    @Override
    @Deprecated(message="Please use fun getEntries(type: Type, text: String)")
    @NotNull
    public List<HistoryEntry> getEntries(@NotNull String key, int first, int last) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        VimHistory.Type type = this.getTypeForString(key);
        return this.getEntries(type, first, last);
    }

    @Override
    @NotNull
    public List<HistoryEntry> getEntries(@NotNull VimHistory.Type type, int first, int last) {
        HistoryEntry entry;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        int myFirst = 0;
        myFirst = first;
        int myLast = 0;
        myLast = last;
        HistoryBlock block = this.blocks(type);
        List<HistoryEntry> entries = block.getEntries();
        ArrayList<HistoryEntry> res = new ArrayList<HistoryEntry>();
        if (myFirst < 0) {
            if (-myFirst > entries.size()) {
                v0 = Integer.MAX_VALUE;
            } else {
                entry = entries.get(entries.size() + myFirst);
                v0 = myFirst = entry.getNumber();
            }
        }
        if (myLast < 0) {
            int n;
            if (-myLast > entries.size()) {
                n = Integer.MIN_VALUE;
            } else {
                entry = entries.get(entries.size() + myLast);
                n = entry.getNumber();
            }
            myLast = n;
        } else if (myLast == 0) {
            myLast = Integer.MAX_VALUE;
        }
        VimLogger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            VimLogger vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("first=" + myFirst + "\nlast=" + myLast);
        }
        for (HistoryEntry entry2 : entries) {
            int n = entry2.getNumber();
            boolean bl = myFirst <= n ? n <= myLast : false;
            if (!bl) continue;
            res.add(entry2);
        }
        return res;
    }

    private final HistoryBlock blocks(VimHistory.Type type) {
        HistoryBlock historyBlock;
        Map<VimHistory.Type, HistoryBlock> $this$getOrPut$iv = this.histories;
        boolean $i$f$getOrPut = false;
        HistoryBlock value$iv = $this$getOrPut$iv.get(type);
        if (value$iv == null) {
            boolean bl = false;
            HistoryBlock answer$iv = new HistoryBlock();
            $this$getOrPut$iv.put(type, answer$iv);
            historyBlock = answer$iv;
        } else {
            historyBlock = value$iv;
        }
        return historyBlock;
    }

    @NotNull
    protected final VimHistory.Type getTypeForString(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = key;
        return Intrinsics.areEqual((Object)string, (Object)HistoryConstants.SEARCH) ? (VimHistory.Type)VimHistory.Type.Search.INSTANCE : (Intrinsics.areEqual((Object)string, (Object)HistoryConstants.COMMAND) ? (VimHistory.Type)VimHistory.Type.Command.INSTANCE : (Intrinsics.areEqual((Object)string, (Object)HistoryConstants.EXPRESSION) ? (VimHistory.Type)VimHistory.Type.Expression.INSTANCE : (Intrinsics.areEqual((Object)string, (Object)HistoryConstants.INPUT) ? (VimHistory.Type)VimHistory.Type.Input.INSTANCE : (VimHistory.Type)new VimHistory.Type.Custom(key))));
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(VimHistoryBase.class);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/history/VimHistoryBase$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "getLogger", "()Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VimLogger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

