/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.handler;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.CommandFlags;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J0\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H$J(\u0010&\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J\u001e\u0010'\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%J(\u0010(\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010)\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010*\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006,"}, d2={"Lcom/maddyhome/idea/vim/handler/EditorActionHandlerBase;", "", "myRunForEachCaret", "", "<init>", "(Z)V", "id", "", "getId", "()Ljava/lang/String;", "type", "Lcom/maddyhome/idea/vim/command/Command$Type;", "getType", "()Lcom/maddyhome/idea/vim/command/Command$Type;", "argumentType", "Lcom/maddyhome/idea/vim/command/Argument$Type;", "getArgumentType", "()Lcom/maddyhome/idea/vim/command/Argument$Type;", "onStartWaitingForArgument", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "keyState", "Lcom/maddyhome/idea/vim/state/KeyHandlerState;", "flags", "Ljava/util/EnumSet;", "Lcom/maddyhome/idea/vim/command/CommandFlags;", "getFlags", "()Ljava/util/EnumSet;", "baseExecute", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "cmd", "Lcom/maddyhome/idea/vim/command/Command;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "postExecute", "execute", "doExecute", "process", "toString", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nEditorActionHandlerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorActionHandlerBase.kt\ncom/maddyhome/idea/vim/handler/EditorActionHandlerBase\n+ 2 EngineHelper.kt\ncom/maddyhome/idea/vim/helper/EngineHelperKt\n+ 3 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,169:1\n23#2:170\n38#3:171\n*S KotlinDebug\n*F\n+ 1 EditorActionHandlerBase.kt\ncom/maddyhome/idea/vim/handler/EditorActionHandlerBase\n*L\n73#1:170\n149#1:171\n*E\n"})
public abstract class EditorActionHandlerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean myRunForEachCaret;
    @NotNull
    private final String id;
    @Nullable
    private final Argument.Type argumentType;
    @NotNull
    private final EnumSet<CommandFlags> flags;
    @NotNull
    private static final VimLogger logger;
    @NonNls
    @NotNull
    private static final String VimActionPrefix = "Vim";

    public EditorActionHandlerBase(boolean myRunForEachCaret) {
        this.myRunForEachCaret = myRunForEachCaret;
        String string = this.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.id = Companion.getActionId(string);
        boolean $i$f$noneOfEnum = false;
        EnumSet<CommandFlags> enumSet = EnumSet.noneOf(CommandFlags.class);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(...)");
        this.flags = enumSet;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public abstract Command.Type getType();

    @Nullable
    public Argument.Type getArgumentType() {
        return this.argumentType;
    }

    public void onStartWaitingForArgument(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull KeyHandlerState keyState) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)keyState, (String)"keyState");
    }

    @NotNull
    public EnumSet<CommandFlags> getFlags() {
        return this.flags;
    }

    protected abstract boolean baseExecute(@NotNull VimEditor var1, @NotNull VimCaret var2, @NotNull ExecutionContext var3, @NotNull Command var4, @NotNull OperatorArguments var5);

    protected void postExecute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Command cmd, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
    }

    public final void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        Function1 action = arg_0 -> EditorActionHandlerBase.execute$lambda$0(this, editor, context, operatorArguments, arg_0);
        VimCaret currentCaret = editor.currentCaret();
        VimCaret primaryCaret = editor.primaryCaret();
        if (editor.isInForEachCaretScope()) {
            if (this.myRunForEachCaret) {
                action.invoke((Object)currentCaret);
            } else if (Intrinsics.areEqual((Object)currentCaret, (Object)primaryCaret)) {
                action.invoke((Object)primaryCaret);
            }
        } else if (this.myRunForEachCaret) {
            editor.forEachCaret((Function1<? super VimCaret, Unit>)action);
        } else {
            action.invoke((Object)primaryCaret);
        }
        if (Intrinsics.areEqual((Object)currentCaret, (Object)primaryCaret)) {
            Command command = VimInjectorKt.getInjector().getVimState().getExecutingCommand();
            if (command == null) {
                EditorActionHandlerBase $this$execute_u24lambda_u241 = this;
                boolean bl = false;
                VimInjectorKt.getInjector().getMessages().indicateError();
                return;
            }
            Command cmd = command;
            this.postExecute(editor, context, cmd, operatorArguments);
        }
    }

    private final void doExecute(VimEditor editor, VimCaret caret, ExecutionContext context, OperatorArguments operatorArguments) {
        if (!VimInjectorKt.getInjector().getEnabler().isEnabled()) {
            return;
        }
        logger.debug("Execute command with handler: " + this.getClass().getName());
        Command command = VimInjectorKt.getInjector().getVimState().getExecutingCommand();
        if (command == null) {
            EditorActionHandlerBase $this$doExecute_u24lambda_u242 = this;
            boolean bl = false;
            VimInjectorKt.getInjector().getMessages().indicateError();
            return;
        }
        Command cmd = command;
        if (!this.baseExecute(editor, caret, context, cmd, operatorArguments)) {
            VimInjectorKt.getInjector().getMessages().indicateError();
        }
    }

    public void process(@NotNull Command cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
    }

    @NotNull
    public String toString() {
        return "EditorActionHandlerBase(" + this.id + ")";
    }

    private static final Unit execute$lambda$0(EditorActionHandlerBase this$0, VimEditor $editor, ExecutionContext $context, OperatorArguments $operatorArguments, VimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$operatorArguments, (String)"$operatorArguments");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        this$0.doExecute($editor, caret, $context, $operatorArguments);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final Set<List<KeyStroke>> parseKeysSet(String ... keyStrings) {
        return Companion.parseKeysSet(keyStrings);
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(EditorActionHandlerBase.class);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bJ/\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0014\b\u0001\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\f\"\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000b8\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/maddyhome/idea/vim/handler/EditorActionHandlerBase$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "parseKeysSet", "", "", "Ljavax/swing/KeyStroke;", "keyStrings", "", "", "([Ljava/lang/String;)Ljava/util/Set;", "VimActionPrefix", "getActionId", "classFullName", "vim-engine"})
    @SourceDebugExtension(value={"SMAP\nEditorActionHandlerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorActionHandlerBase.kt\ncom/maddyhome/idea/vim/handler/EditorActionHandlerBase$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1557#2:170\n1628#2,3:171\n621#3,6:174\n1#4:180\n*S KotlinDebug\n*F\n+ 1 EditorActionHandlerBase.kt\ncom/maddyhome/idea/vim/handler/EditorActionHandlerBase$Companion\n*L\n151#1:170\n151#1:171,3\n164#1:174,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<List<KeyStroke>> parseKeysSet(@NotNull List<String> keyStrings) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(keyStrings, (String)"keyStrings");
            Iterable $this$map$iv = keyStrings;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(VimInjectorKt.getInjector().getParser().parseKeys((String)it));
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Set<List<KeyStroke>> parseKeysSet(String ... keyStrings) {
            Intrinsics.checkNotNullParameter((Object)keyStrings, (String)"keyStrings");
            int n = keyStrings.length;
            ArrayList<List<KeyStroke>> arrayList = new ArrayList<List<KeyStroke>>(n);
            int n2 = 0;
            while (n2 < n) {
                void it;
                int n3;
                int n4 = n3 = n2++;
                ArrayList<List<KeyStroke>> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(VimInjectorKt.getInjector().getParser().parseKeys(keyStrings[it]));
            }
            return CollectionsKt.toSet((Iterable)arrayList);
        }

        /*
         * WARNING - void declaration
         */
        @NonNls
        @NotNull
        public final String getActionId(@NotNull String classFullName) {
            String string;
            block1: {
                void var2_2;
                Intrinsics.checkNotNullParameter((Object)classFullName, (String)"classFullName");
                String $this$takeLastWhile$iv = classFullName;
                boolean $i$f$takeLastWhile = false;
                for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                    char it = $this$takeLastWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (it != '.') continue;
                    String string2 = $this$takeLastWhile$iv;
                    int n = index$iv + 1;
                    String string3 = string2.substring(n);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    break block1;
                }
                string = var2_2;
            }
            void it = string;
            boolean bl = false;
            return StringsKt.startsWith((String)it, (String)EditorActionHandlerBase.VimActionPrefix, (boolean)true) ? it : EditorActionHandlerBase.VimActionPrefix + (String)it;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

