/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimVisualMotionGroup;
import com.maddyhome.idea.vim.group.visual.EngineVisualGroupKt;
import com.maddyhome.idea.vim.group.visual.VisualChange;
import com.maddyhome.idea.vim.group.visual.VisualOperation;
import com.maddyhome.idea.vim.helper.EngineHelperKt;
import com.maddyhome.idea.vim.helper.EngineModeExtensionsKt;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.ModeExtensionsKt;
import com.maddyhome.idea.vim.state.mode.ReturnTo;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J2\u0010\u0011\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0004J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u0019\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/maddyhome/idea/vim/api/VimVisualMotionGroupBase;", "Lcom/maddyhome/idea/vim/api/VimVisualMotionGroup;", "<init>", "()V", "exclusiveSelection", "", "getExclusiveSelection", "()Z", "selectionAdj", "", "getSelectionAdj", "()I", "enterSelectMode", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "subMode", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "toggleVisual", "count", "rawCount", "selectionType", "returnTo", "Lcom/maddyhome/idea/vim/state/mode/ReturnTo;", "seemsLikeBlockMode", "autodetectVisualSubmode", "enterVisualMode", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimVisualMotionGroupBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimVisualMotionGroupBase.kt\ncom/maddyhome/idea/vim/api/VimVisualMotionGroupBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1557#2:174\n1628#2,3:175\n1053#2:178\n1872#2,3:180\n1734#2,3:183\n1863#2,2:186\n1#3:179\n*S KotlinDebug\n*F\n+ 1 VimVisualMotionGroupBase.kt\ncom/maddyhome/idea/vim/api/VimVisualMotionGroupBase\n*L\n101#1:174\n101#1:175,3\n104#1:178\n109#1:180,3\n132#1:183,3\n168#1:186,2\n*E\n"})
public abstract class VimVisualMotionGroupBase
implements VimVisualMotionGroup {
    @Override
    public boolean getExclusiveSelection() {
        return StringsKt.contains$default((CharSequence)VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getSelection(), (CharSequence)"exclusive", (boolean)false, (int)2, null);
    }

    @Override
    public int getSelectionAdj() {
        return this.getExclusiveSelection() ? 0 : 1;
    }

    @Override
    public boolean enterSelectMode(@NotNull VimEditor editor, @NotNull SelectionType subMode) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)subMode), (String)"subMode");
        EngineHelperKt.setSelectMode(editor, subMode);
        editor.forEachCaret((Function1<? super VimCaret, Unit>)((Function1)VimVisualMotionGroupBase::enterSelectMode$lambda$0));
        return true;
    }

    @Override
    public boolean toggleVisual(@NotNull VimEditor editor, int count, int rawCount, @NotNull SelectionType selectionType, @Nullable ReturnTo returnTo) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)selectionType), (String)"selectionType");
        if (!EditorExtensionsKt.getInVisualMode(editor)) {
            if (rawCount > 0) {
                Object object = editor.primaryCaret().getVimLastVisualOperatorRange();
                if (object == null || (object = object.getType()) == null) {
                    object = selectionType;
                }
                Object primarySubMode = object;
                EngineHelperKt.pushVisualMode(editor, (SelectionType)((Object)primarySubMode));
                editor.forEachCaret((Function1<? super VimCaret, Unit>)((Function1)arg_0 -> VimVisualMotionGroupBase.toggleVisual$lambda$1(selectionType, editor, count, arg_0)));
            } else {
                ReturnTo returnTo2 = returnTo;
                if (returnTo2 == null) {
                    returnTo2 = ModeExtensionsKt.getReturnTo(editor.getMode());
                }
                editor.setMode(new Mode.VISUAL(selectionType, returnTo2));
                editor.forEachCaret((Function1<? super VimCaret, Unit>)((Function1)VimVisualMotionGroupBase::toggleVisual$lambda$2));
            }
            return true;
        }
        if (selectionType == ModeExtensionsKt.getSelectionType(editor.getMode())) {
            EngineModeExtensionsKt.exitVisualMode(editor);
            return true;
        }
        Mode mode = editor.getMode();
        if (!(mode instanceof Mode.VISUAL)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        editor.setMode(Mode.VISUAL.copy$default((Mode.VISUAL)mode, selectionType, null, 2, null));
        for (VimCaret caret : editor.carets()) {
            if (!caret.isValid()) continue;
            EngineVisualGroupKt.vimUpdateEditorSelection(caret);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean seemsLikeBlockMode(@NotNull VimEditor editor) {
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Iterable $this$map$iv = editor.nativeCarets();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VimCaret vimCaret = (VimCaret)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int adj = editor.offsetToBufferPosition(it.getSelectionEnd()).getColumn() == 0 ? 1 : 0;
            collection.add(TuplesKt.to((Object)it.getSelectionStart(), (Object)RangesKt.coerceAtLeast((int)(it.getSelectionEnd() - adj), (int)0)));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List selections = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getFirst()));
            }
        });
        int selectionStartColumn = editor.offsetToBufferPosition(((Number)((Pair)CollectionsKt.first((List)selections)).getFirst()).intValue()).getColumn();
        int selectionStartLine = editor.offsetToBufferPosition(((Number)((Pair)CollectionsKt.first((List)selections)).getFirst()).intValue()).getLine();
        Iterator iterator = ((Iterable)selections).iterator();
        if (!iterator.hasNext()) {
            object = null;
        } else {
            Pair it = (Pair)iterator.next();
            boolean bl = false;
            Object object2 = editor.offsetToBufferPosition(((Number)it.getSecond()).intValue()).getColumn();
            while (iterator.hasNext()) {
                Object it2 = (Pair)iterator.next();
                $i$a$-maxOfOrNull-VimVisualMotionGroupBase$seemsLikeBlockMode$maxColumn$1 = false;
                if (object2.compareTo(it2 = (Comparable)Integer.valueOf(editor.offsetToBufferPosition(((Number)it2.getSecond()).intValue()).getColumn())) >= 0) continue;
                object2 = it2;
            }
            object = object2;
        }
        Integer n = (Integer)object;
        if (n == null) {
            return false;
        }
        int maxColumn = n;
        Iterable $this$forEachIndexed$iv = selections;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair adj = (Pair)item$iv;
            int i = n2;
            boolean bl = false;
            if (editor.offsetToBufferPosition(((Number)it.getFirst()).intValue()).getLine() != editor.offsetToBufferPosition(((Number)it.getSecond()).intValue()).getLine()) {
                return false;
            }
            if (editor.offsetToBufferPosition(((Number)it.getFirst()).intValue()).getColumn() != selectionStartColumn) {
                return false;
            }
            int lineEnd = editor.offsetToBufferPosition(EngineEditorHelperKt.getLineEndForOffset(editor, ((Number)it.getSecond()).intValue())).getColumn();
            if (editor.offsetToBufferPosition(((Number)it.getSecond()).intValue()).getColumn() != RangesKt.coerceAtMost((int)maxColumn, (int)lineEnd)) {
                return false;
            }
            if (editor.offsetToBufferPosition(((Number)it.getFirst()).intValue()).getLine() == selectionStartLine + i) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public SelectionType autodetectVisualSubmode(@NotNull VimEditor editor) {
        boolean all;
        block5: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (editor.carets().size() > 1 && this.seemsLikeBlockMode(editor)) {
                return SelectionType.BLOCK_WISE;
            }
            Iterable $this$all$iv = editor.nativeCarets();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v0 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    VimCaret caret = (VimCaret)element$iv;
                    boolean bl = false;
                    int selectionStart = caret.getSelectionStart();
                    int selectionEnd = caret.getSelectionEnd();
                    int startLine = editor.offsetToBufferPosition(selectionStart).getLine();
                    BufferPosition endPosition = editor.offsetToBufferPosition(selectionEnd);
                    int endLine = endPosition.getColumn() == 0 ? RangesKt.coerceAtLeast((int)(endPosition.getLine() - 1), (int)0) : endPosition.getLine();
                    int lineStartOfSelectionStart = editor.getLineStartOffset(startLine);
                    int lineEndOfSelectionEnd = EngineEditorHelperKt.getLineEndOffset(editor, endLine, true);
                    if (lineStartOfSelectionStart == selectionStart && (lineEndOfSelectionEnd + 1 == selectionEnd || lineEndOfSelectionEnd == selectionEnd)) continue;
                    v0 = false;
                    break block5;
                }
                v0 = all = true;
            }
        }
        if (all) {
            return SelectionType.LINE_WISE;
        }
        return SelectionType.CHARACTER_WISE;
    }

    @Override
    public boolean enterVisualMode(@NotNull VimEditor editor, @Nullable SelectionType subMode) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        SelectionType selectionType = subMode;
        if (selectionType == null) {
            selectionType = this.autodetectVisualSubmode(editor);
        }
        SelectionType autodetectedSubMode = selectionType;
        editor.setMode(new Mode.VISUAL(autodetectedSubMode, null, 2, null));
        if (autodetectedSubMode == SelectionType.BLOCK_WISE) {
            VimCaret $this$enterVisualMode_u24lambda_u248 = editor.primaryCaret();
            boolean bl = false;
            $this$enterVisualMode_u24lambda_u248.setVimSelectionStart(EngineVisualGroupKt.getVimLeadSelectionOffset($this$enterVisualMode_u24lambda_u248));
        } else {
            Iterable $this$forEach$iv = editor.nativeCarets();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VimCaret it = (VimCaret)element$iv;
                boolean bl = false;
                it.setVimSelectionStart(EngineVisualGroupKt.getVimLeadSelectionOffset(it));
            }
        }
        return true;
    }

    private static final Unit enterSelectMode$lambda$0(VimCaret it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setVimSelectionStart(EngineVisualGroupKt.getVimLeadSelectionOffset(it));
        return Unit.INSTANCE;
    }

    private static final Unit toggleVisual$lambda$1(SelectionType $selectionType, VimEditor $editor, int $count, VimCaret it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$selectionType), (String)"$selectionType");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        VisualChange visualChange = it.getVimLastVisualOperatorRange();
        if (visualChange == null) {
            visualChange = VisualChange.Companion.default($selectionType);
        }
        VisualChange range = visualChange;
        int end = VisualOperation.INSTANCE.calculateRange($editor, range, $count, it);
        int intendedColumn = range.getColumns() == 9999 ? 9999 : $editor.offsetToBufferPosition(end).getColumn();
        it.setVimLastColumn(intendedColumn);
        EngineVisualGroupKt.vimSetSelection(it, it.getOffset(), end, true);
        it.setVimLastColumn(intendedColumn);
        return Unit.INSTANCE;
    }

    private static final Unit toggleVisual$lambda$2(VimCaret it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EngineVisualGroupKt.vimSetSelection$default(it, it.getOffset(), 0, false, 6, null);
        return Unit.INSTANCE;
    }
}

