/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCommandLine;
import com.maddyhome.idea.vim.api.VimCommandLineService;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.ReturnableFromCmd;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J(\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH&J0\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0002J(\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016J(\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0015H\u0004\u00a8\u0006\u0018"}, d2={"Lcom/maddyhome/idea/vim/api/VimCommandLineServiceBase;", "Lcom/maddyhome/idea/vim/api/VimCommandLineService;", "<init>", "()V", "isCommandLineSupported", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "createPanel", "Lcom/maddyhome/idea/vim/api/VimCommandLine;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "label", "", "initText", "createCommandLinePrompt", "removeSelections", "initialText", "createSearchPrompt", "createCommandPrompt", "command", "Lcom/maddyhome/idea/vim/command/Command;", "getRange", "cmd", "vim-engine"})
public abstract class VimCommandLineServiceBase
implements VimCommandLineService {
    @Override
    public boolean isCommandLineSupported(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return !editor.isOneLineMode();
    }

    @NotNull
    public abstract VimCommandLine createPanel(@NotNull VimEditor var1, @NotNull ExecutionContext var2, @NotNull String var3, @NotNull String var4);

    private final VimCommandLine createCommandLinePrompt(VimEditor editor, ExecutionContext context, boolean removeSelections, String label, String initialText) {
        if (!this.isCommandLineSupported(editor)) {
            throw new ExException("Command line is not allowed in one line editors");
        }
        Mode currentMode = editor.getMode();
        if (!(currentMode instanceof ReturnableFromCmd)) {
            boolean bl = false;
            String string = "Cannot enable cmd mode from current mode " + currentMode;
            throw new IllegalStateException(string.toString());
        }
        if (removeSelections) {
            VimInjectorKt.getInjector().getMarkService().setVisualSelectionMarks(editor);
            editor.setMode(new Mode.NORMAL(null, 1, null));
        }
        editor.setMode(new Mode.CMD_LINE((ReturnableFromCmd)((Object)currentMode)));
        return this.createPanel(editor, context, label, initialText);
    }

    @Override
    @NotNull
    public VimCommandLine createSearchPrompt(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull String label, @NotNull String initialText) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        return this.createCommandLinePrompt(editor, context, false, label, initialText);
    }

    @Override
    @NotNull
    public VimCommandLine createCommandPrompt(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Command command, @NotNull String initialText) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        String rangeText = this.getRange(editor, command);
        return this.createCommandLinePrompt(editor, context, true, ":", rangeText + initialText);
    }

    @NotNull
    protected final String getRange(@NotNull VimEditor editor, @NotNull Command cmd) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        return EditorExtensionsKt.getInVisualMode(editor) ? "'<,'>" : (cmd.getRawCount() == 1 ? "." : (cmd.getRawCount() > 1 ? ".,.+" + (cmd.getCount() - 1) : ""));
    }
}

