/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 )2\u00020\u0001:\u0001)B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018J*\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u0002J\u000b\u0010 \u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0006H\u00c6\u0003J+\u0010#\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010$\u001a\u00020\u001a2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020\u001cH\u00d6\u0001J\t\u0010'\u001a\u00020(H\u00d6\u0001R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001f\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006*"}, d2={"Lcom/maddyhome/idea/vim/api/SelectionInfo;", "", "start", "Lcom/maddyhome/idea/vim/api/BufferPosition;", "end", "selectionType", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "<init>", "(Lcom/maddyhome/idea/vim/api/BufferPosition;Lcom/maddyhome/idea/vim/api/BufferPosition;Lcom/maddyhome/idea/vim/state/mode/SelectionType;)V", "getStart", "()Lcom/maddyhome/idea/vim/api/BufferPosition;", "setStart", "(Lcom/maddyhome/idea/vim/api/BufferPosition;)V", "getEnd", "setEnd", "getSelectionType", "()Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "startEndSorted", "Lkotlin/Pair;", "getStartEndSorted", "()Lkotlin/Pair;", "getSelectionRange", "Lcom/maddyhome/idea/vim/common/TextRange;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "isSelected", "", "offset", "", "sortBufferPositions", "pos1", "pos2", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nSelectionInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionInfo.kt\ncom/maddyhome/idea/vim/api/SelectionInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1557#2:85\n1628#2,3:86\n1557#2:89\n1628#2,3:90\n*S KotlinDebug\n*F\n+ 1 SelectionInfo.kt\ncom/maddyhome/idea/vim/api/SelectionInfo\n*L\n52#1:85\n52#1:86,3\n53#1:89\n53#1:90,3\n*E\n"})
public final class SelectionInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private BufferPosition start;
    @Nullable
    private BufferPosition end;
    @NotNull
    private final SelectionType selectionType;

    public SelectionInfo(@Nullable BufferPosition start, @Nullable BufferPosition end, @NotNull SelectionType selectionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)selectionType), (String)"selectionType");
        this.start = start;
        this.end = end;
        this.selectionType = selectionType;
    }

    @Nullable
    public final BufferPosition getStart() {
        return this.start;
    }

    public final void setStart(@Nullable BufferPosition bufferPosition) {
        this.start = bufferPosition;
    }

    @Nullable
    public final BufferPosition getEnd() {
        return this.end;
    }

    public final void setEnd(@Nullable BufferPosition bufferPosition) {
        this.end = bufferPosition;
    }

    @NotNull
    public final SelectionType getSelectionType() {
        return this.selectionType;
    }

    @Nullable
    public final Pair<BufferPosition, BufferPosition> getStartEndSorted() {
        return this.sortBufferPositions(this.start, this.end);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final TextRange getSelectionRange(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Pair<BufferPosition, BufferPosition> pair = this.getStartEndSorted();
        if (pair == null) {
            return null;
        }
        Pair<BufferPosition, BufferPosition> pair2 = pair;
        BufferPosition sortedStart = (BufferPosition)pair2.component1();
        BufferPosition sortedEnd = (BufferPosition)pair2.component2();
        switch (WhenMappings.$EnumSwitchMapping$0[this.selectionType.ordinal()]) {
            case 1: {
                return new TextRange(editor.bufferPositionToOffset(sortedStart), editor.bufferPositionToOffset(sortedEnd) + 1);
            }
            case 2: {
                int startOffset = editor.getLineStartOffset(sortedStart.getLine());
                int endOffset = EngineEditorHelperKt.getLineEndOffset(editor, sortedEnd.getLine(), true) + 1;
                return new TextRange(startOffset, endOffset);
            }
            case 3: {
                int n;
                Collection collection;
                void $this$mapTo$iv$iv;
                int topLine = sortedStart.getLine();
                int bottomLine = sortedEnd.getLine();
                int leftColumn = Math.min(sortedStart.getColumn(), sortedEnd.getColumn());
                int rightColumn = Math.max(sortedStart.getColumn(), sortedEnd.getColumn());
                Iterable $this$map$iv = (Iterable)new IntRange(topLine, bottomLine);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
                    collection = collection2;
                    n = 0;
                    collection.add(EngineEditorHelperKt.getOffset(editor, (int)it, leftColumn));
                }
                int[] startOffsets = CollectionsKt.toIntArray((Collection)((List)collection2));
                Iterable $this$map$iv2 = (Iterable)new IntRange(topLine, bottomLine);
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                Iterator iterator2 = iterable2.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    int item$iv$iv;
                    n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(EngineEditorHelperKt.getOffset(editor, (int)it, rightColumn) + 1);
                }
                int[] endOffsets = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
                return new TextRange(startOffsets, endOffsets);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final boolean isSelected(int offset, @NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        TextRange textRange = this.getSelectionRange(editor);
        return textRange != null ? textRange.contains(offset) : false;
    }

    private final Pair<BufferPosition, BufferPosition> sortBufferPositions(BufferPosition pos1, BufferPosition pos2) {
        if (pos1 == null || pos2 == null) {
            return null;
        }
        return pos1.getLine() != pos2.getLine() ? (pos1.getLine() < pos2.getLine() ? new Pair((Object)pos1, (Object)pos2) : new Pair((Object)pos2, (Object)pos1)) : (pos1.getColumn() < pos2.getColumn() ? new Pair((Object)pos1, (Object)pos2) : new Pair((Object)pos2, (Object)pos1));
    }

    @Nullable
    public final BufferPosition component1() {
        return this.start;
    }

    @Nullable
    public final BufferPosition component2() {
        return this.end;
    }

    @NotNull
    public final SelectionType component3() {
        return this.selectionType;
    }

    @NotNull
    public final SelectionInfo copy(@Nullable BufferPosition start, @Nullable BufferPosition end, @NotNull SelectionType selectionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)selectionType), (String)"selectionType");
        return new SelectionInfo(start, end, selectionType);
    }

    public static /* synthetic */ SelectionInfo copy$default(SelectionInfo selectionInfo, BufferPosition bufferPosition, BufferPosition bufferPosition2, SelectionType selectionType, int n, Object object) {
        if ((n & 1) != 0) {
            bufferPosition = selectionInfo.start;
        }
        if ((n & 2) != 0) {
            bufferPosition2 = selectionInfo.end;
        }
        if ((n & 4) != 0) {
            selectionType = selectionInfo.selectionType;
        }
        return selectionInfo.copy(bufferPosition, bufferPosition2, selectionType);
    }

    @NotNull
    public String toString() {
        return "SelectionInfo(start=" + this.start + ", end=" + this.end + ", selectionType=" + this.selectionType + ")";
    }

    public int hashCode() {
        int result = this.start == null ? 0 : this.start.hashCode();
        result = result * 31 + (this.end == null ? 0 : this.end.hashCode());
        result = result * 31 + this.selectionType.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SelectionInfo)) {
            return false;
        }
        SelectionInfo selectionInfo = (SelectionInfo)other;
        if (!Intrinsics.areEqual((Object)this.start, (Object)selectionInfo.start)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.end, (Object)selectionInfo.end)) {
            return false;
        }
        return this.selectionType == selectionInfo.selectionType;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/api/SelectionInfo$Companion;", "", "<init>", "()V", "collectCurrentSelectionInfo", "Lcom/maddyhome/idea/vim/api/SelectionInfo;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final SelectionInfo collectCurrentSelectionInfo(@NotNull VimCaret caret) {
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            VimEditor editor = caret.getEditor();
            Mode mode = editor.getMode();
            if (!(mode instanceof Mode.VISUAL)) {
                return null;
            }
            BufferPosition start = editor.offsetToBufferPosition(caret.getVimSelectionStart());
            BufferPosition end = editor.offsetToBufferPosition(caret.getOffset());
            return new SelectionInfo(start, end, ((Mode.VISUAL)mode).getSelectionType());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SelectionType.values().length];
            try {
                nArray[SelectionType.CHARACTER_WISE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SelectionType.LINE_WISE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SelectionType.BLOCK_WISE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

