/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.mark.Mark;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/maddyhome/idea/vim/api/LocalMarkStorage;", "", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "<init>", "(Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;)V", "getCaret", "()Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "setCaret", "marks", "Ljava/util/HashMap;", "", "Lcom/maddyhome/idea/vim/mark/Mark;", "getMarks", "", "getMark", "char", "setMark", "", "mark", "removeMark", "", "clear", "vim-engine"})
public final class LocalMarkStorage {
    @NotNull
    private ImmutableVimCaret caret;
    @NotNull
    private final HashMap<Character, Mark> marks;

    public LocalMarkStorage(@NotNull ImmutableVimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        this.caret = caret;
        this.marks = new HashMap();
    }

    @NotNull
    public final ImmutableVimCaret getCaret() {
        return this.caret;
    }

    public final void setCaret(@NotNull ImmutableVimCaret immutableVimCaret) {
        Intrinsics.checkNotNullParameter((Object)immutableVimCaret, (String)"<set-?>");
        this.caret = immutableVimCaret;
    }

    @NotNull
    public final Map<Character, Mark> getMarks() {
        return MapsKt.toMap((Map)this.marks);
    }

    @Nullable
    public final Mark getMark(char c) {
        if (this.caret.isPrimary()) {
            return VimInjectorKt.getInjector().getMarkService().getMark(this.caret, c);
        }
        return this.marks.get(Character.valueOf(c));
    }

    public final boolean setMark(@NotNull Mark mark) {
        Intrinsics.checkNotNullParameter((Object)mark, (String)"mark");
        if (this.caret.isPrimary()) {
            return VimInjectorKt.getInjector().getMarkService().setMark(this.caret, mark);
        }
        char markChar = mark.getKey();
        Character c = Character.valueOf(markChar);
        ((Map)this.marks).put(c, mark);
        return true;
    }

    public final void removeMark(char c) {
        if (this.caret.isPrimary()) {
            VimInjectorKt.getInjector().getMarkService().removeLocalMark(this.caret, c);
            return;
        }
        this.marks.remove(Character.valueOf(c));
    }

    public final void clear(@NotNull ImmutableVimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        if (caret.isPrimary()) {
            VimInjectorKt.getInjector().getMarkService().resetAllMarksForCaret(caret);
        } else {
            this.marks.clear();
        }
    }
}

