/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim;

import com.maddyhome.idea.vim.KeyProcessResult;
import com.maddyhome.idea.vim.action.change.LazyVimCommand;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCommandLine;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.CommandBuilder;
import com.maddyhome.idea.vim.command.CommandFlags;
import com.maddyhome.idea.vim.command.MappingMode;
import com.maddyhome.idea.vim.command.MappingProcessor;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.CurrentCommandState;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import com.maddyhome.idea.vim.impl.state.VimStateMachineImplKt;
import com.maddyhome.idea.vim.key.CommandPartNode;
import com.maddyhome.idea.vim.key.KeyConsumer;
import com.maddyhome.idea.vim.key.KeyStack;
import com.maddyhome.idea.vim.key.consumers.CharArgumentConsumer;
import com.maddyhome.idea.vim.key.consumers.CommandConsumer;
import com.maddyhome.idea.vim.key.consumers.CommandCountConsumer;
import com.maddyhome.idea.vim.key.consumers.DeleteCommandConsumer;
import com.maddyhome.idea.vim.key.consumers.DigraphConsumer;
import com.maddyhome.idea.vim.key.consumers.EditorResetConsumer;
import com.maddyhome.idea.vim.key.consumers.ModalInputConsumer;
import com.maddyhome.idea.vim.key.consumers.ModeInputConsumer;
import com.maddyhome.idea.vim.key.consumers.RegisterConsumer;
import com.maddyhome.idea.vim.key.consumers.SelectRegisterConsumer;
import com.maddyhome.idea.vim.register.VimRegisterGroup;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import com.maddyhome.idea.vim.state.VimStateMachine;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.ModeExtensionsKt;
import com.maddyhome.idea.vim.state.mode.ReturnTo;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0004\u0018\u0000 M2\u00020\u0001:\u0003LMNB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\rJ6\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u0010,\u001a\u00020\rJ.\u00100\u001a\u0002012\u0006\u0010)\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u00102\u001a\u000203J7\u00104\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010*\u001a\u00020+2\b\u0010)\u001a\u0004\u0018\u00010\u001e2\u0006\u00105\u001a\u00020.2\u0006\u0010,\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b6J\u0018\u00107\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\rH\u0002J\u0016\u00108\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\rJ\u001e\u00109\u001a\u00020.2\u0006\u0010)\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020;2\u0006\u0010,\u001a\u00020\rJ\u0016\u0010<\u001a\u00020.2\u0006\u0010:\u001a\u00020;2\u0006\u0010,\u001a\u00020\rJ(\u0010=\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010*\u001a\u00020+2\u0006\u0010>\u001a\u00020?2\u0006\u0010,\u001a\u00020\rH\u0002J\u000e\u0010@\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0006J\u000e\u0010A\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0006J\u0016\u0010A\u001a\u00020'2\u0006\u0010,\u001a\u00020\r2\u0006\u0010:\u001a\u00020;J\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020D0C2\u0006\u0010E\u001a\u00020FH\u0002J\u000e\u0010G\u001a\u00020'2\u0006\u0010,\u001a\u00020\rJ\u000e\u0010H\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0006J\u000e\u0010I\u001a\u00020'2\u0006\u0010J\u001a\u00020KR\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0012\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u000f\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R(\u0010!\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006O"}, d2={"Lcom/maddyhome/idea/vim/KeyHandler;", "", "<init>", "()V", "editorInFocusReference", "Ljava/lang/ref/WeakReference;", "Lcom/maddyhome/idea/vim/api/VimEditor;", "keyConsumers", "", "Lcom/maddyhome/idea/vim/key/KeyConsumer;", "handleKeyRecursionCount", "", "defaultKeyHandlerState", "Lcom/maddyhome/idea/vim/state/KeyHandlerState;", "getDefaultKeyHandlerState", "()Lcom/maddyhome/idea/vim/state/KeyHandlerState;", "defaultKeyHandlerState$delegate", "Lkotlin/Lazy;", "mutableKeyHandlerState", "value", "keyHandlerState", "getKeyHandlerState", "setKeyHandlerState", "(Lcom/maddyhome/idea/vim/state/KeyHandlerState;)V", "keyStack", "Lcom/maddyhome/idea/vim/key/KeyStack;", "getKeyStack", "()Lcom/maddyhome/idea/vim/key/KeyStack;", "modalEntryKeys", "", "Ljavax/swing/KeyStroke;", "getModalEntryKeys", "()Ljava/util/List;", "editorInFocus", "getEditorInFocus", "()Lcom/maddyhome/idea/vim/api/VimEditor;", "setEditorInFocus", "(Lcom/maddyhome/idea/vim/api/VimEditor;)V", "handleKey", "", "editor", "key", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "keyState", "allowKeyMappings", "", "mappingCompleted", "processKey", "Lcom/maddyhome/idea/vim/KeyProcessResult;", "processBuilder", "Lcom/maddyhome/idea/vim/KeyProcessResult$KeyProcessResultBuilder;", "finishedCommandPreparation", "shouldRecord", "finishedCommandPreparation$vim_engine", "onUnknownKey", "setBadCommand", "isDuplicateOperatorKeyStroke", "mode", "Lcom/maddyhome/idea/vim/state/mode/Mode;", "isOperatorPending", "executeCommand", "editorState", "Lcom/maddyhome/idea/vim/state/VimStateMachine;", "partialReset", "reset", "getKeyRoot", "Lcom/maddyhome/idea/vim/key/CommandPartNode;", "Lcom/maddyhome/idea/vim/action/change/LazyVimCommand;", "mappingMode", "Lcom/maddyhome/idea/vim/command/MappingMode;", "updateState", "fullReset", "setPromptCharacterEx", "promptCharacter", "", "ActionRunner", "Companion", "MutableBoolean", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nKeyHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyHandler.kt\ncom/maddyhome/idea/vim/KeyHandler\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,514:1\n27#2,4:515\n27#2,4:519\n27#2,4:523\n27#2,4:530\n27#2,4:536\n27#2,4:540\n27#2,4:544\n27#2,4:548\n27#2,4:552\n27#2,4:556\n38#2:560\n1755#3,3:527\n1863#3,2:534\n*S KotlinDebug\n*F\n+ 1 KeyHandler.kt\ncom/maddyhome/idea/vim/KeyHandler\n*L\n124#1:515,4\n131#1:519,4\n132#1:523,4\n153#1:530,4\n273#1:536,4\n283#1:540,4\n292#1:544,4\n303#1:548,4\n304#1:552,4\n315#1:556,4\n385#1:560\n149#1:527,3\n190#1:534,2\n*E\n"})
public final class KeyHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private WeakReference<VimEditor> editorInFocusReference;
    @NotNull
    private final List<KeyConsumer> keyConsumers;
    private int handleKeyRecursionCount;
    @NotNull
    private final Lazy defaultKeyHandlerState$delegate;
    @Nullable
    private KeyHandlerState mutableKeyHandlerState;
    @NotNull
    private final KeyStack keyStack;
    @NotNull
    private final List<KeyStroke> modalEntryKeys;
    @NotNull
    private static final Object lock = new Object();
    @NotNull
    private static final VimLogger logger;
    @NotNull
    private static final KeyHandler instance;

    public KeyHandler() {
        Object[] objectArray = new KeyConsumer[]{new ModalInputConsumer(), MappingProcessor.INSTANCE, new CommandCountConsumer(), new DeleteCommandConsumer(), new EditorResetConsumer(), new CharArgumentConsumer(), new RegisterConsumer(), new DigraphConsumer(), new CommandConsumer(), new SelectRegisterConsumer(), new ModeInputConsumer()};
        this.keyConsumers = CollectionsKt.listOf((Object[])objectArray);
        this.defaultKeyHandlerState$delegate = LazyKt.lazy(KeyHandler::defaultKeyHandlerState_delegate$lambda$0);
        this.keyStack = new KeyStack();
        this.modalEntryKeys = new ArrayList();
    }

    private final KeyHandlerState getDefaultKeyHandlerState() {
        Lazy lazy = this.defaultKeyHandlerState$delegate;
        return (KeyHandlerState)lazy.getValue();
    }

    @NotNull
    public final KeyHandlerState getKeyHandlerState() {
        KeyHandlerState keyHandlerState = this.mutableKeyHandlerState;
        if (keyHandlerState == null) {
            keyHandlerState = this.getDefaultKeyHandlerState();
        }
        return keyHandlerState;
    }

    private final void setKeyHandlerState(KeyHandlerState value) {
        this.mutableKeyHandlerState = value;
    }

    @NotNull
    public final KeyStack getKeyStack() {
        return this.keyStack;
    }

    @NotNull
    public final List<KeyStroke> getModalEntryKeys() {
        return this.modalEntryKeys;
    }

    @Nullable
    public final VimEditor getEditorInFocus() {
        WeakReference<VimEditor> weakReference = this.editorInFocusReference;
        return weakReference != null ? (VimEditor)weakReference.get() : null;
    }

    public final void setEditorInFocus(@Nullable VimEditor value) {
        this.editorInFocusReference = new WeakReference<VimEditor>(value);
    }

    public final void handleKey(@NotNull VimEditor editor, @NotNull KeyStroke key, @NotNull ExecutionContext context, @NotNull KeyHandlerState keyState) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)keyState, (String)"keyState");
        this.handleKey(editor, key, context, true, false, keyState);
    }

    public final void handleKey(@NotNull VimEditor editor, @NotNull KeyStroke key, @NotNull ExecutionContext context, boolean allowKeyMappings, boolean mappingCompleted, @NotNull KeyHandlerState keyState) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)keyState, (String)"keyState");
        KeyProcessResult result = this.processKey(key, editor, allowKeyMappings, mappingCompleted, new KeyProcessResult.SynchronousKeyProcessBuilder(keyState));
        if (result instanceof KeyProcessResult.Executable) {
            ((KeyProcessResult.Executable)result).execute(editor, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final KeyProcessResult processKey(@NotNull KeyStroke key, @NotNull VimEditor editor, boolean allowKeyMappings, boolean mappingCompleted, @NotNull KeyProcessResult.KeyProcessResultBuilder processBuilder) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)processBuilder, (String)"processBuilder");
        Object object = lock;
        synchronized (object) {
            KeyProcessResult keyProcessResult;
            boolean isProcessed;
            boolean shouldRecord;
            VimLogger vimLogger;
            block14: {
                int n;
                boolean bl = false;
                VimLogger $this$trace$iv = logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTrace()) {
                    vimLogger = $this$trace$iv;
                    boolean bl2 = false;
                    vimLogger.trace(StringsKt.trimIndent((String)("\n        ------- Key Handler -------\n        Start key processing. allowKeyMappings: " + allowKeyMappings + ", mappingCompleted: " + mappingCompleted + "\n        Key: " + key + "\n      ")));
                }
                $this$trace$iv = logger;
                $i$f$trace = false;
                if ($this$trace$iv.isTrace()) {
                    vimLogger = $this$trace$iv;
                    boolean bl3 = false;
                    vimLogger.trace(processBuilder.getState().toString());
                }
                $this$trace$iv = logger;
                $i$f$trace = false;
                if ($this$trace$iv.isTrace()) {
                    vimLogger = $this$trace$iv;
                    n = 0;
                    vimLogger.trace("Mode = " + editor.getMode());
                }
                int maxMapDepth = VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getMaxmapdepth();
                if (this.handleKeyRecursionCount >= maxMapDepth) {
                    processBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)(arg_0, arg_1, arg_2) -> KeyHandler.processKey$lambda$10$lambda$4(maxMapDepth, arg_0, arg_1, arg_2)));
                    return processBuilder.build();
                }
                VimInjectorKt.getInjector().getMessages().clearError();
                shouldRecord = this.handleKeyRecursionCount == 0 && VimInjectorKt.getInjector().getRegisterGroup().isRecording();
                n = this.handleKeyRecursionCount;
                this.handleKeyRecursionCount = n + 1;
                Iterable $this$any$iv = this.keyConsumers;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KeyConsumer it = (KeyConsumer)element$iv;
                        bl = false;
                        if (!it.consumeKey(key, editor, allowKeyMappings, mappingCompleted, processBuilder)) continue;
                        v0 = true;
                        break block14;
                    }
                    v0 = isProcessed = false;
                }
            }
            if (isProcessed) {
                VimLogger $this$trace$iv = logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTrace()) {
                    vimLogger = $this$trace$iv;
                    boolean bl = false;
                    vimLogger.trace("Key was successfully caught by consumer");
                }
                processBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)(arg_0, arg_1, arg_2) -> KeyHandler.processKey$lambda$10$lambda$7(this, key, shouldRecord, arg_0, arg_1, arg_2)));
                return processBuilder.build();
            }
            this.onUnknownKey(editor, processBuilder.getState());
            this.updateState(processBuilder.getState());
            KeyProcessResult.Unknown $this$processKey_u24lambda_u2410_u24lambda_u248 = keyProcessResult = KeyProcessResult.Unknown.INSTANCE;
            boolean bl = false;
            int n = this.handleKeyRecursionCount;
            this.handleKeyRecursionCount = n + -1;
            keyProcessResult = keyProcessResult;
            KeyProcessResult keyProcessResult2 = keyProcessResult;
            return keyProcessResult2;
            finally {
                processBuilder.setOnFinish((Function0<Unit>)((Function0)() -> KeyHandler.processKey$lambda$10$lambda$9(this)));
            }
        }
    }

    public final void finishedCommandPreparation$vim_engine(@NotNull VimEditor editor, @NotNull ExecutionContext context, @Nullable KeyStroke key, boolean shouldRecord, @NotNull KeyHandlerState keyState) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)keyState, (String)"keyState");
        CommandBuilder commandBuilder = keyState.getCommandBuilder();
        if (commandBuilder.isReady()) {
            logger.trace("Ready command builder. Execute command.");
            this.executeCommand(editor, context, VimInjectorKt.getInjector().getVimState(), keyState);
        }
        if (shouldRecord && VimInjectorKt.getInjector().getRegisterGroup().isRecording() && key != null) {
            VimInjectorKt.getInjector().getRegisterGroup().recordKeyStroke(key);
            Iterable $this$forEach$iv = this.modalEntryKeys;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KeyStroke it = (KeyStroke)element$iv;
                boolean bl = false;
                VimInjectorKt.getInjector().getRegisterGroup().recordKeyStroke(it);
            }
            this.modalEntryKeys.clear();
        }
        VimInjectorKt.getInjector().getMessages().updateStatusBar(editor);
        logger.trace("----------- Key Handler Finished -----------");
    }

    private final void onUnknownKey(VimEditor editor, KeyHandlerState keyState) {
        logger.trace("Command builder is set to BAD");
        keyState.getCommandBuilder().setCommandState(CurrentCommandState.BAD_COMMAND);
        editor.resetOpPending();
        VimInjectorKt.getInjector().getVimState().resetRegisterPending();
        editor.setReplaceCharacter(false);
        this.reset(keyState, editor.getMode());
    }

    public final void setBadCommand(@NotNull VimEditor editor, @NotNull KeyHandlerState keyState) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)keyState, (String)"keyState");
        this.onUnknownKey(editor, keyState);
        VimInjectorKt.getInjector().getMessages().indicateError();
    }

    public final boolean isDuplicateOperatorKeyStroke(@NotNull KeyStroke key, @NotNull Mode mode, @NotNull KeyHandlerState keyState) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)keyState, (String)"keyState");
        return this.isOperatorPending(mode, keyState) && keyState.getCommandBuilder().isDuplicateOperatorKeyStroke(key);
    }

    public final boolean isOperatorPending(@NotNull Mode mode, @NotNull KeyHandlerState keyState) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)keyState, (String)"keyState");
        return mode instanceof Mode.OP_PENDING && !keyState.getCommandBuilder().isEmpty();
    }

    private final void executeCommand(VimEditor editor, ExecutionContext context, VimStateMachine editorState, KeyHandlerState keyState) {
        logger.trace("Command execution");
        Command command = keyState.getCommandBuilder().buildCommand();
        OperatorArguments operatorArguments = new OperatorArguments(editor.getMode() instanceof Mode.OP_PENDING, command.getRawCount(), editorState.getMode());
        if (!command.getFlags().contains((Object)CommandFlags.FLAG_START_EX)) {
            editor.resetOpPending();
        }
        editorState.setExecutingCommand(command);
        Command.Type type = command.getType();
        if (type.isWrite() && !editor.isWritable()) {
            VimInjectorKt.getInjector().getMessages().indicateError();
            this.reset(keyState, editorState.getMode());
            logger.warn("File is not writable");
            return;
        }
        if (VimInjectorKt.getInjector().getApplication().isMainThread()) {
            Runnable action = new ActionRunner(editor, context, command, keyState, operatorArguments);
            EditorActionHandlerBase cmdAction = command.getAction();
            String name = cmdAction.getId();
            if (type.isWrite()) {
                VimInjectorKt.getInjector().getApplication().runWriteCommand(editor, name, action, action);
            } else if (type.isRead()) {
                VimInjectorKt.getInjector().getApplication().runReadCommand(editor, name, action, action);
            } else {
                VimInjectorKt.getInjector().getActionExecutor().executeCommand(editor, action, name, action);
            }
        }
    }

    public final void partialReset(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("Partial reset is executed");
        }
        this.getKeyHandlerState().partialReset(editor.getMode());
    }

    public final void reset(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("Reset is executed");
        }
        editor.setReplaceCharacter(false);
        editor.resetOpPending();
        this.getKeyHandlerState().partialReset(editor.getMode());
        this.getKeyHandlerState().getCommandBuilder().resetAll(this.getKeyRoot(VimStateMachineImplKt.toMappingMode(editor.getMode())));
    }

    public final void reset(@NotNull KeyHandlerState keyState, @NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)keyState, (String)"keyState");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("Reset is executed");
        }
        VimCommandLine vimCommandLine = VimInjectorKt.getInjector().getCommandLine().getActiveCommandLine();
        if (vimCommandLine != null) {
            vimCommandLine.clearCurrentAction();
        }
        this.getKeyHandlerState().partialReset(mode);
        keyState.getCommandBuilder().resetAll(this.getKeyRoot(VimStateMachineImplKt.toMappingMode(mode)));
    }

    private final CommandPartNode<LazyVimCommand> getKeyRoot(MappingMode mappingMode) {
        return VimInjectorKt.getInjector().getKeyGroup().getKeyRoot(mappingMode);
    }

    public final void updateState(@NotNull KeyHandlerState keyState) {
        VimLogger vimLogger;
        Intrinsics.checkNotNullParameter((Object)keyState, (String)"keyState");
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("State updated");
        }
        $this$trace$iv = logger;
        $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace(keyState.toString());
        }
        this.setKeyHandlerState(keyState);
    }

    public final void fullReset(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("Full reset");
        }
        VimInjectorKt.getInjector().getMessages().clearError();
        editor.setMode(new Mode.NORMAL(null, 1, null));
        VimInjectorKt.getInjector().getVimState().setExecutingCommand(null);
        this.getKeyHandlerState().getDigraphSequence().reset();
        this.reset(this.getKeyHandlerState(), editor.getMode());
        VimRegisterGroup vimRegisterGroup = VimInjectorKt.getInjector().getRegisterGroupIfCreated();
        if (vimRegisterGroup != null) {
            vimRegisterGroup.resetRegister();
        }
        editor.removeSelection();
    }

    public final void setPromptCharacterEx(char promptCharacter) {
        VimCommandLine vimCommandLine = VimInjectorKt.getInjector().getCommandLine().getActiveCommandLine();
        if (vimCommandLine == null) {
            return;
        }
        VimCommandLine commandLine = vimCommandLine;
        commandLine.setPromptCharacter(promptCharacter);
    }

    private static final KeyHandlerState defaultKeyHandlerState_delegate$lambda$0() {
        return new KeyHandlerState();
    }

    private static final Unit processKey$lambda$10$lambda$4(int $maxMapDepth, KeyHandlerState keyHandlerState, VimEditor lambdaEditor, ExecutionContext executionContext) {
        Intrinsics.checkNotNullParameter((Object)keyHandlerState, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)lambdaEditor, (String)"lambdaEditor");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"<unused var>");
        logger.warn("Key handling, maximum recursion of the key received. maxdepth=" + $maxMapDepth);
        VimInjectorKt.getInjector().getMessages().showStatusBarMessage(lambdaEditor, VimInjectorKt.getInjector().getMessages().message("E223", new Object[0]));
        VimInjectorKt.getInjector().getMessages().indicateError();
        return Unit.INSTANCE;
    }

    private static final Unit processKey$lambda$10$lambda$7(KeyHandler this$0, KeyStroke $key, boolean $shouldRecord, KeyHandlerState lambdaKeyState, VimEditor lambdaEditor, ExecutionContext lambdaContext) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)lambdaKeyState, (String)"lambdaKeyState");
        Intrinsics.checkNotNullParameter((Object)lambdaEditor, (String)"lambdaEditor");
        Intrinsics.checkNotNullParameter((Object)lambdaContext, (String)"lambdaContext");
        this$0.finishedCommandPreparation$vim_engine(lambdaEditor, lambdaContext, $key, $shouldRecord, lambdaKeyState);
        return Unit.INSTANCE;
    }

    private static final Unit processKey$lambda$10$lambda$9(KeyHandler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int n = this$0.handleKeyRecursionCount;
        this$0.handleKeyRecursionCount = n + -1;
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final KeyHandler getInstance() {
        return Companion.getInstance();
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(KeyHandler.class);
        instance = new KeyHandler();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lcom/maddyhome/idea/vim/KeyHandler$ActionRunner;", "Ljava/lang/Runnable;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "cmd", "Lcom/maddyhome/idea/vim/command/Command;", "keyState", "Lcom/maddyhome/idea/vim/state/KeyHandlerState;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "<init>", "(Lcom/maddyhome/idea/vim/api/VimEditor;Lcom/maddyhome/idea/vim/api/ExecutionContext;Lcom/maddyhome/idea/vim/command/Command;Lcom/maddyhome/idea/vim/state/KeyHandlerState;Lcom/maddyhome/idea/vim/command/OperatorArguments;)V", "getEditor", "()Lcom/maddyhome/idea/vim/api/VimEditor;", "getContext", "()Lcom/maddyhome/idea/vim/api/ExecutionContext;", "getCmd", "()Lcom/maddyhome/idea/vim/command/Command;", "getKeyState", "()Lcom/maddyhome/idea/vim/state/KeyHandlerState;", "getOperatorArguments", "()Lcom/maddyhome/idea/vim/command/OperatorArguments;", "run", "", "vim-engine"})
    public static final class ActionRunner
    implements Runnable {
        @NotNull
        private final VimEditor editor;
        @NotNull
        private final ExecutionContext context;
        @NotNull
        private final Command cmd;
        @NotNull
        private final KeyHandlerState keyState;
        @NotNull
        private final OperatorArguments operatorArguments;

        public ActionRunner(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Command cmd, @NotNull KeyHandlerState keyState, @NotNull OperatorArguments operatorArguments) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
            Intrinsics.checkNotNullParameter((Object)keyState, (String)"keyState");
            Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
            this.editor = editor;
            this.context = context;
            this.cmd = cmd;
            this.keyState = keyState;
            this.operatorArguments = operatorArguments;
        }

        @NotNull
        public final VimEditor getEditor() {
            return this.editor;
        }

        @NotNull
        public final ExecutionContext getContext() {
            return this.context;
        }

        @NotNull
        public final Command getCmd() {
            return this.cmd;
        }

        @NotNull
        public final KeyHandlerState getKeyState() {
            return this.keyState;
        }

        @NotNull
        public final OperatorArguments getOperatorArguments() {
            return this.operatorArguments;
        }

        @Override
        public void run() {
            VimStateMachine editorState = VimInjectorKt.getInjector().getVimState();
            this.keyState.getCommandBuilder().setCommandState(CurrentCommandState.NEW_COMMAND);
            Character register = this.cmd.getRegister();
            if (register != null) {
                VimInjectorKt.getInjector().getRegisterGroup().selectRegister(register.charValue());
            }
            VimInjectorKt.getInjector().getActionExecutor().executeVimAction(this.editor, this.cmd.getAction(), this.context, this.operatorArguments);
            if (editorState.getMode() instanceof Mode.INSERT || editorState.getMode() instanceof Mode.REPLACE) {
                VimInjectorKt.getInjector().getChangeGroup().processCommand(this.editor, this.cmd);
            }
            VimInjectorKt.getInjector().getRegisterGroup().resetRegister();
            Mode myMode = editorState.getMode();
            ReturnTo returnTo = ModeExtensionsKt.getReturnTo(myMode);
            if (myMode instanceof Mode.NORMAL && returnTo != null && !this.cmd.getFlags().contains((Object)CommandFlags.FLAG_EXPECT_MORE)) {
                ReturnTo returnTo2 = returnTo;
                if (Intrinsics.areEqual((Object)returnTo2, (Object)ReturnTo.INSERT.INSTANCE)) {
                    this.editor.setMode(Mode.INSERT.INSTANCE);
                } else if (Intrinsics.areEqual((Object)returnTo2, (Object)ReturnTo.REPLACE.INSTANCE)) {
                    this.editor.setMode(Mode.REPLACE.INSTANCE);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (this.keyState.getCommandBuilder().isDone()) {
                Companion.getInstance().reset(this.keyState, editorState.getMode());
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\t\u001a\u00020\n\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\rH\u0000\u00a2\u0006\u0002\b\u000fJ\b\u0010\u0012\u001a\u00020\u0011H\u0007R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/maddyhome/idea/vim/KeyHandler$Companion;", "", "<init>", "()V", "lock", "getLock", "()Ljava/lang/Object;", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "isPrefix", "", "T", "list1", "", "list2", "isPrefix$vim_engine", "instance", "Lcom/maddyhome/idea/vim/KeyHandler;", "getInstance", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Object getLock() {
            return lock;
        }

        public final <T> boolean isPrefix$vim_engine(@NotNull List<? extends T> list1, @NotNull List<? extends T> list2) {
            Intrinsics.checkNotNullParameter(list1, (String)"list1");
            Intrinsics.checkNotNullParameter(list2, (String)"list2");
            if (list1.size() > list2.size()) {
                return false;
            }
            int n = ((Collection)list1).size();
            for (int i = 0; i < n; ++i) {
                if (Intrinsics.areEqual(list1.get(i), list2.get(i))) continue;
                return false;
            }
            return true;
        }

        @JvmStatic
        @NotNull
        public final KeyHandler getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0011"}, d2={"Lcom/maddyhome/idea/vim/KeyHandler$MutableBoolean;", "", "value", "", "<init>", "(Z)V", "getValue", "()Z", "setValue", "component1", "copy", "equals", "other", "hashCode", "", "toString", "", "vim-engine"})
    public static final class MutableBoolean {
        private boolean value;

        public MutableBoolean(boolean value) {
            this.value = value;
        }

        public final boolean getValue() {
            return this.value;
        }

        public final void setValue(boolean bl) {
            this.value = bl;
        }

        public final boolean component1() {
            return this.value;
        }

        @NotNull
        public final MutableBoolean copy(boolean value) {
            return new MutableBoolean(value);
        }

        public static /* synthetic */ MutableBoolean copy$default(MutableBoolean mutableBoolean, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = mutableBoolean.value;
            }
            return mutableBoolean.copy(bl);
        }

        @NotNull
        public String toString() {
            return "MutableBoolean(value=" + this.value + ")";
        }

        public int hashCode() {
            return Boolean.hashCode(this.value);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MutableBoolean)) {
                return false;
            }
            MutableBoolean mutableBoolean = (MutableBoolean)other;
            return this.value == mutableBoolean.value;
        }
    }
}

