/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.jediterm.core.compatibility.Point;
import com.jediterm.core.util.CellPosition;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.ChangeWidthOperation;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.CyclicBufferLinesStorage;
import com.jediterm.terminal.model.LinesBuffer;
import com.jediterm.terminal.model.LinesStorage;
import com.jediterm.terminal.model.LinesStorageKt;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalHistoryBufferListener;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalModelListener;
import com.jediterm.terminal.model.TerminalResizeResult;
import com.jediterm.terminal.model.TerminalSelection;
import com.jediterm.terminal.model.TextBufferChangesListener;
import com.jediterm.terminal.model.TextBufferChangesMulticaster;
import com.jediterm.terminal.model.hyperlinks.TextProcessing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u009c\u00012\u00020\u0001:\u0002\u009c\u0001B+\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB/\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\rJ\u000e\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@J\u000e\u0010A\u001a\u00020>2\u0006\u0010?\u001a\u00020\u001eJ\u000e\u0010B\u001a\u00020>2\u0006\u0010C\u001a\u00020DJ\u0016\u0010E\u001a\u00020>2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020D0GH\u0002J\u000e\u0010H\u001a\u00020>2\u0006\u0010?\u001a\u00020+J\u000e\u0010I\u001a\u00020>2\u0006\u0010?\u001a\u00020+J\u0006\u0010J\u001a\u00020>J\u0016\u0010K\u001a\u00020>2\u0006\u0010L\u001a\u00020\u00032\u0006\u0010M\u001a\u00020\u0003J\u0006\u0010N\u001a\u00020>J\u0006\u0010O\u001a\u00020>J\u0006\u0010P\u001a\u00020>J\u0010\u0010P\u001a\u00020>2\u0006\u0010Q\u001a\u00020!H\u0002J\b\u0010R\u001a\u00020SH\u0002J\b\u0010T\u001a\u00020UH\u0002J\b\u0010V\u001a\u00020!H\u0002J\u0010\u0010W\u001a\u00020\u00152\u0006\u0010X\u001a\u00020!H\u0002J\b\u0010Y\u001a\u00020!H\u0002J\u001e\u0010Z\u001a\u00020>2\u0006\u0010[\u001a\u00020\u00032\u0006\u0010\\\u001a\u00020\u00032\u0006\u0010]\u001a\u00020\u0003J$\u0010^\u001a\b\u0012\u0004\u0012\u00020D0G2\u0006\u0010\\\u001a\u00020\u00032\u0006\u0010]\u001a\u00020\u00032\u0006\u0010_\u001a\u00020\u0003J\u001e\u0010`\u001a\u00020>2\u0006\u0010a\u001a\u00020\u00032\u0006\u0010b\u001a\u00020\u00032\u0006\u0010\\\u001a\u00020\u0003J\u000e\u0010c\u001a\u00020\u00032\u0006\u0010C\u001a\u00020DJ\b\u0010d\u001a\u00020>H\u0002J\b\u0010e\u001a\u00020>H\u0002J\b\u0010f\u001a\u00020>H\u0007J\u0016\u0010g\u001a\u00020h2\u0006\u0010[\u001a\u00020\u00032\u0006\u0010\\\u001a\u00020\u0003J\u0016\u0010i\u001a\u00020h2\u0006\u0010[\u001a\u00020\u00032\u0006\u0010\\\u001a\u00020\u0003J\u000e\u0010j\u001a\u00020D2\u0006\u0010k\u001a\u00020\u0003J\u0006\u0010l\u001a\u00020mJ\u0018\u0010n\u001a\u0004\u0018\u00010S2\u0006\u0010[\u001a\u00020\u00032\u0006\u0010\\\u001a\u00020\u0003J$\u0010o\u001a\u0010\u0012\u0004\u0012\u00020h\u0012\u0006\u0012\u0004\u0018\u00010S0p2\u0006\u0010[\u001a\u00020\u00032\u0006\u0010\\\u001a\u00020\u0003J\u001e\u0010q\u001a\u00020>2\u0006\u0010[\u001a\u00020\u00032\u0006\u0010\\\u001a\u00020\u00032\u0006\u0010]\u001a\u00020\u0003J\u001e\u0010r\u001a\u00020>2\u0006\u0010\\\u001a\u00020\u00032\u0006\u0010]\u001a\u00020\u00032\u0006\u0010_\u001a\u00020\u0003J\u0006\u0010s\u001a\u00020>J\u0014\u0010t\u001a\u00020>2\f\u0010u\u001a\b\u0012\u0004\u0012\u00020>0vJ\u000e\u0010t\u001a\u00020>2\u0006\u0010u\u001a\u00020wJ\u0006\u0010x\u001a\u00020>J\u001e\u0010y\u001a\u00020>2\u0006\u0010z\u001a\u00020\u00032\u0006\u0010{\u001a\u00020\u00032\u0006\u0010|\u001a\u00020}J\u001f\u0010~\u001a\u00020>2\u0006\u0010\u007f\u001a\u00020\u00032\u0007\u0010\u0080\u0001\u001a\u00020\u00032\u0006\u0010|\u001a\u00020}J\u0012\u0010\u0081\u0001\u001a\u00020\u00032\u0007\u0010\u0082\u0001\u001a\u00020\u0003H\u0002J\u000f\u0010\u0083\u0001\u001a\u00020>2\u0006\u0010?\u001a\u00020@J\u000f\u0010\u0084\u0001\u001a\u00020>2\u0006\u0010?\u001a\u00020\u001eJ\u000f\u0010\u0085\u0001\u001a\u00020>2\u0006\u0010?\u001a\u00020+J\u000f\u0010\u0086\u0001\u001a\u00020>2\u0006\u0010?\u001a\u00020+J(\u0010\u0087\u0001\u001a\u00030\u0088\u00012\b\u0010\u0089\u0001\u001a\u00030\u008a\u00012\b\u0010\u008b\u0001\u001a\u00030\u008c\u00012\n\u0010\u008d\u0001\u001a\u0005\u0018\u00010\u008e\u0001J!\u0010\u008f\u0001\u001a\u00020>2\u0007\u0010\u0090\u0001\u001a\u00020\u00032\u0007\u0010\u0091\u0001\u001a\u00020\u00032\u0006\u0010_\u001a\u00020\u0003J\u0018\u0010\u0092\u0001\u001a\u00020>2\u0006\u0010k\u001a\u00020\u00032\u0007\u0010\u0093\u0001\u001a\u00020\u000fJ\u0007\u0010\u0094\u0001\u001a\u00020\u000fJ\u0007\u0010\u0095\u0001\u001a\u00020>J\u0010\u0010\u0096\u0001\u001a\u00020>2\u0007\u0010\u0097\u0001\u001a\u00020\u000fJ!\u0010\u0098\u0001\u001a\u00020>2\u0006\u0010[\u001a\u00020\u00032\u0006\u0010\\\u001a\u00020\u00032\b\u0010\u0099\u0001\u001a\u00030\u009a\u0001J,\u0010\u0098\u0001\u001a\u00020>2\u0006\u0010[\u001a\u00020\u00032\u0006\u0010\\\u001a\u00020\u00032\b\u0010\u0099\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u009b\u0001\u001a\u00020SH\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R&\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00158\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0014R\u001e\u0010\"\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020!@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020!8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010$R\u001e\u0010(\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010.\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00158\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b/\u0010\u0018\u001a\u0004\b0\u0010\u001aR\u0010\u00101\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00102\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0014R\u001e\u00104\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020!@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010$R\u0010\u00106\u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\u00020!8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010$R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0014\u0010;\u001a\b\u0012\u0004\u0012\u00020+0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u0014\u00a8\u0006\u009d\u0001"}, d2={"Lcom/jediterm/terminal/model/TerminalTextBuffer;", "", "width", "", "height", "styleState", "Lcom/jediterm/terminal/model/StyleState;", "textProcessing", "Lcom/jediterm/terminal/model/hyperlinks/TextProcessing;", "(IILcom/jediterm/terminal/model/StyleState;Lcom/jediterm/terminal/model/hyperlinks/TextProcessing;)V", "initialWidth", "initialHeight", "maxHistoryLinesCount", "(IILcom/jediterm/terminal/model/StyleState;ILcom/jediterm/terminal/model/hyperlinks/TextProcessing;)V", "alternateBuffer", "", "changesMulticaster", "Lcom/jediterm/terminal/model/TextBufferChangesMulticaster;", "<set-?>", "getHeight", "()I", "Lcom/jediterm/terminal/model/LinesBuffer;", "historyBuffer", "getHistoryBuffer$annotations", "()V", "getHistoryBuffer", "()Lcom/jediterm/terminal/model/LinesBuffer;", "historyBufferBackup", "historyBufferListeners", "", "Lcom/jediterm/terminal/model/TerminalHistoryBufferListener;", "historyLinesCount", "getHistoryLinesCount", "Lcom/jediterm/terminal/model/LinesStorage;", "historyLinesStorage", "getHistoryLinesStorage", "()Lcom/jediterm/terminal/model/LinesStorage;", "historyLinesStorageBackup", "historyLinesStorageOrBackup", "getHistoryLinesStorageOrBackup$core", "isUsingAlternateBuffer", "()Z", "listeners", "Lcom/jediterm/terminal/model/TerminalModelListener;", "myLock", "Ljava/util/concurrent/locks/Lock;", "screenBuffer", "getScreenBuffer$annotations", "getScreenBuffer", "screenBufferBackup", "screenLinesCount", "getScreenLinesCount", "screenLinesStorage", "getScreenLinesStorage", "screenLinesStorageBackup", "screenLinesStorageOrBackup", "getScreenLinesStorageOrBackup$core", "getTextProcessing", "()Lcom/jediterm/terminal/model/hyperlinks/TextProcessing;", "typeAheadListeners", "getWidth", "addChangesListener", "", "listener", "Lcom/jediterm/terminal/model/TextBufferChangesListener;", "addHistoryBufferListener", "addLine", "line", "Lcom/jediterm/terminal/model/TerminalLine;", "addLinesToHistory", "linesToAdd", "", "addModelListener", "addTypeAheadModelListener", "clearHistory", "clearLines", "startRow", "endRow", "clearScreenAndHistoryBuffers", "clearScreenBuffer", "clearTypeAheadPredictions", "storage", "createEmptyStyleWithCurrentColor", "Lcom/jediterm/terminal/TextStyle;", "createFillerEntry", "Lcom/jediterm/terminal/model/TerminalLine$TextEntry;", "createHistoryLinesStorage", "createLinesBuffer", "delegate", "createScreenLinesStorage", "deleteCharacters", "x", "y", "count", "deleteLines", "scrollRegionBottom", "eraseCharacters", "leftX", "rightX", "findScreenLineIndex", "fireHistoryBufferLineCountChanged", "fireModelChangeEvent", "fireTypeAheadModelChangeEvent", "getBuffersCharAt", "", "getCharAt", "getLine", "index", "getScreenLines", "", "getStyleAt", "getStyledCharAt", "Lkotlin/Pair;", "insertBlankCharacters", "insertLines", "lock", "modify", "runnable", "Lkotlin/Function0;", "Ljava/lang/Runnable;", "moveScreenLinesToHistory", "processHistoryAndScreenLines", "scrollOrigin", "maximalLinesToProcess", "consumer", "Lcom/jediterm/terminal/StyledTextConsumer;", "processScreenLines", "yStart", "yCount", "removeBottomEmptyLines", "maxCount", "removeChangesListener", "removeHistoryBufferListener", "removeModelListener", "removeTypeAheadModelListener", "resize", "Lcom/jediterm/terminal/model/TerminalResizeResult;", "newTermSize", "Lcom/jediterm/core/util/TermSize;", "oldCursor", "Lcom/jediterm/core/util/CellPosition;", "selection", "Lcom/jediterm/terminal/model/TerminalSelection;", "scrollArea", "scrollRegionTop", "dy", "setLineWrapped", "isWrapped", "tryLock", "unlock", "useAlternateBuffer", "enabled", "writeString", "str", "Lcom/jediterm/terminal/model/CharBuffer;", "style", "Companion", "core"})
public final class TerminalTextBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StyleState styleState;
    private final int maxHistoryLinesCount;
    @Nullable
    private final TextProcessing textProcessing;
    private int width;
    private int height;
    @NotNull
    private LinesStorage historyLinesStorage;
    @NotNull
    private LinesStorage screenLinesStorage;
    @NotNull
    private LinesBuffer historyBuffer;
    @NotNull
    private LinesBuffer screenBuffer;
    @NotNull
    private final Lock myLock;
    @Nullable
    private LinesStorage historyLinesStorageBackup;
    @Nullable
    private LinesStorage screenLinesStorageBackup;
    @Nullable
    private LinesBuffer historyBufferBackup;
    @Nullable
    private LinesBuffer screenBufferBackup;
    private boolean alternateBuffer;
    private boolean isUsingAlternateBuffer;
    @NotNull
    private final List<TerminalModelListener> listeners;
    @NotNull
    private final List<TerminalModelListener> typeAheadListeners;
    @NotNull
    private final List<TerminalHistoryBufferListener> historyBufferListeners;
    @NotNull
    private final TextBufferChangesMulticaster changesMulticaster;
    @NotNull
    private static final Logger LOG;
    private static final boolean USE_CONPTY_COMPATIBLE_RESIZE = true;

    public TerminalTextBuffer(int initialWidth, int initialHeight, @NotNull StyleState styleState, int maxHistoryLinesCount, @Nullable TextProcessing textProcessing) {
        Intrinsics.checkNotNullParameter((Object)styleState, (String)"styleState");
        this.styleState = styleState;
        this.maxHistoryLinesCount = maxHistoryLinesCount;
        this.textProcessing = textProcessing;
        this.width = initialWidth;
        this.height = initialHeight;
        this.historyLinesStorage = this.createHistoryLinesStorage();
        this.screenLinesStorage = this.createScreenLinesStorage();
        this.historyBuffer = this.createLinesBuffer(this.historyLinesStorage);
        this.screenBuffer = this.createLinesBuffer(this.screenLinesStorage);
        this.myLock = new ReentrantLock();
        this.listeners = new CopyOnWriteArrayList();
        this.typeAheadListeners = new CopyOnWriteArrayList();
        this.historyBufferListeners = new CopyOnWriteArrayList();
        this.changesMulticaster = new TextBufferChangesMulticaster();
    }

    @Nullable
    public final TextProcessing getTextProcessing() {
        return this.textProcessing;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final LinesStorage getHistoryLinesStorage() {
        return this.historyLinesStorage;
    }

    @NotNull
    public final LinesStorage getScreenLinesStorage() {
        return this.screenLinesStorage;
    }

    @NotNull
    public final LinesBuffer getHistoryBuffer() {
        return this.historyBuffer;
    }

    @Deprecated(message="Use historyLinesStorage instead", replaceWith=@ReplaceWith(expression="historyLinesStorage", imports={}))
    public static /* synthetic */ void getHistoryBuffer$annotations() {
    }

    @NotNull
    public final LinesBuffer getScreenBuffer() {
        return this.screenBuffer;
    }

    @Deprecated(message="Use screenLinesStorage instead", replaceWith=@ReplaceWith(expression="screenLinesStorage", imports={}))
    public static /* synthetic */ void getScreenBuffer$annotations() {
    }

    @NotNull
    public final LinesStorage getHistoryLinesStorageOrBackup$core() {
        LinesStorage linesStorage;
        if (this.isUsingAlternateBuffer) {
            LinesStorage linesStorage2 = this.historyLinesStorageBackup;
            linesStorage = linesStorage2;
            Intrinsics.checkNotNull((Object)linesStorage2);
        } else {
            linesStorage = this.historyLinesStorage;
        }
        return linesStorage;
    }

    @NotNull
    public final LinesStorage getScreenLinesStorageOrBackup$core() {
        LinesStorage linesStorage;
        if (this.isUsingAlternateBuffer) {
            LinesStorage linesStorage2 = this.screenLinesStorageBackup;
            linesStorage = linesStorage2;
            Intrinsics.checkNotNull((Object)linesStorage2);
        } else {
            linesStorage = this.screenLinesStorage;
        }
        return linesStorage;
    }

    public final int getHistoryLinesCount() {
        return this.historyLinesStorage.getSize();
    }

    public final int getScreenLinesCount() {
        return this.screenLinesStorage.getSize();
    }

    public final boolean isUsingAlternateBuffer() {
        return this.isUsingAlternateBuffer;
    }

    @JvmOverloads
    public TerminalTextBuffer(int width, int height, @NotNull StyleState styleState, @Nullable TextProcessing textProcessing) {
        Intrinsics.checkNotNullParameter((Object)styleState, (String)"styleState");
        this(width, height, styleState, 5000, textProcessing);
    }

    public /* synthetic */ TerminalTextBuffer(int n, int n2, StyleState styleState, TextProcessing textProcessing, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            textProcessing = null;
        }
        this(n, n2, styleState, textProcessing);
    }

    private final LinesStorage createScreenLinesStorage() {
        return new CyclicBufferLinesStorage(-1);
    }

    private final LinesStorage createHistoryLinesStorage() {
        return new CyclicBufferLinesStorage(this.maxHistoryLinesCount);
    }

    private final LinesBuffer createLinesBuffer(LinesStorage delegate) {
        return new LinesBuffer(delegate, this.textProcessing);
    }

    @NotNull
    public final TerminalResizeResult resize(@NotNull TermSize newTermSize, @NotNull CellPosition oldCursor, @Nullable TerminalSelection selection) {
        int oldHeight;
        Intrinsics.checkNotNullParameter((Object)newTermSize, (String)"newTermSize");
        Intrinsics.checkNotNullParameter((Object)oldCursor, (String)"oldCursor");
        int newWidth = newTermSize.getColumns();
        int newHeight = newTermSize.getRows();
        int newCursorX = oldCursor.getX();
        int newCursorY = oldCursor.getY();
        int oldCursorY = oldCursor.getY();
        if (this.width != newWidth) {
            ChangeWidthOperation changeWidthOperation = new ChangeWidthOperation(this, newWidth, newHeight);
            Point cursorPoint = new Point(oldCursor.getX() - 1, oldCursor.getY() - 1);
            changeWidthOperation.addPointToTrack(cursorPoint, true);
            if (selection != null) {
                changeWidthOperation.addPointToTrack(selection.getStart(), false);
                changeWidthOperation.addPointToTrack(selection.getEnd(), false);
            }
            changeWidthOperation.run();
            this.width = newWidth;
            this.height = newHeight;
            Point point = changeWidthOperation.getTrackedPoint(cursorPoint);
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getTrackedPoint(...)");
            Point newCursor = point;
            newCursorX = newCursor.x + 1;
            newCursorY = newCursor.y + 1;
            if (selection != null) {
                selection.getStart().setLocation(changeWidthOperation.getTrackedPoint(selection.getStart()));
                selection.getEnd().setLocation(changeWidthOperation.getTrackedPoint(selection.getEnd()));
            }
            this.changesMulticaster.widthResized();
        }
        if (newHeight < (oldHeight = this.height)) {
            if (!this.alternateBuffer) {
                int lineDiffCount = oldHeight - newHeight;
                int maxBottomLinesToRemove = Math.min(lineDiffCount, Math.max(0, oldHeight - oldCursorY));
                int emptyLinesCount = Math.min(maxBottomLinesToRemove, oldHeight - this.screenLinesStorage.getSize());
                int actualLinesToRemove = maxBottomLinesToRemove - emptyLinesCount;
                int emptyLinesDeleted = emptyLinesCount + this.removeBottomEmptyLines(actualLinesToRemove);
                int screenLinesToMove = lineDiffCount - emptyLinesDeleted;
                List<TerminalLine> removedLines = LinesStorageKt.removeFromTop(this.screenLinesStorage, screenLinesToMove);
                this.addLinesToHistory(removedLines);
                newCursorY = oldCursorY - screenLinesToMove;
                TerminalSelection terminalSelection = selection;
                if (terminalSelection != null) {
                    terminalSelection.shiftY(-screenLinesToMove);
                }
            } else {
                newCursorY = oldCursorY;
            }
        } else if (newHeight > oldHeight) {
            newCursorY = oldCursorY;
        }
        this.width = newWidth;
        this.height = newHeight;
        this.fireModelChangeEvent();
        return new TerminalResizeResult(new CellPosition(newCursorX, newCursorY));
    }

    public final void addModelListener(@NotNull TerminalModelListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    public final void removeModelListener(@NotNull TerminalModelListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.remove(listener);
    }

    public final void addChangesListener(@NotNull TextBufferChangesListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.changesMulticaster.addListener(listener);
    }

    public final void removeChangesListener(@NotNull TextBufferChangesListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.changesMulticaster.removeListener(listener);
    }

    public final void addHistoryBufferListener(@NotNull TerminalHistoryBufferListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.historyBufferListeners.add(listener);
    }

    public final void removeHistoryBufferListener(@NotNull TerminalHistoryBufferListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.historyBufferListeners.remove(listener);
    }

    public final void addTypeAheadModelListener(@NotNull TerminalModelListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.typeAheadListeners.add(listener);
    }

    public final void removeTypeAheadModelListener(@NotNull TerminalModelListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.typeAheadListeners.remove(listener);
    }

    private final void fireModelChangeEvent() {
        for (TerminalModelListener modelListener : this.listeners) {
            modelListener.modelChanged();
        }
    }

    @ApiStatus.Internal
    public final void fireTypeAheadModelChangeEvent() {
        for (TerminalModelListener modelListener : this.typeAheadListeners) {
            modelListener.modelChanged();
        }
    }

    private final TextStyle createEmptyStyleWithCurrentColor() {
        TextStyle textStyle = this.styleState.getCurrent().createEmptyWithColors();
        Intrinsics.checkNotNullExpressionValue((Object)textStyle, (String)"createEmptyWithColors(...)");
        return textStyle;
    }

    private final TerminalLine.TextEntry createFillerEntry() {
        return new TerminalLine.TextEntry(this.createEmptyStyleWithCurrentColor(), new CharBuffer('\u0000', this.width));
    }

    public final void deleteCharacters(int x, int y, int count) {
        if (y > this.height - 1 || y < 0) {
            LOG.error("Attempt to delete in line " + y + " args were x: " + x + " count: " + count);
        } else if (count < 0) {
            LOG.error("Attempt to delete negative chars number: count: " + count);
        } else if (count > 0) {
            this.screenLinesStorage.get(y).deleteCharacters(x, count, this.createEmptyStyleWithCurrentColor());
            this.fireModelChangeEvent();
            this.changesMulticaster.linesChanged(y);
        }
    }

    public final void insertBlankCharacters(int x, int y, int count) {
        if (y > this.height - 1 || y < 0) {
            LOG.error("Attempt to insert blank chars in line " + y + " args were x: " + x + " count: " + count);
        } else if (count < 0) {
            LOG.error("Attempt to insert negative blank chars number: count:" + count);
        } else if (count > 0) {
            this.screenLinesStorage.get(y).insertBlankCharacters(x, count, this.width, this.createEmptyStyleWithCurrentColor());
            this.fireModelChangeEvent();
            this.changesMulticaster.linesChanged(y);
        }
    }

    public final void writeString(int x, int y, @NotNull CharBuffer str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        TextStyle textStyle = this.styleState.getCurrent();
        Intrinsics.checkNotNullExpressionValue((Object)textStyle, (String)"getCurrent(...)");
        this.writeString(x, y, str, textStyle);
    }

    public final void addLine(@NotNull TerminalLine line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        this.screenLinesStorage.addToBottom(line);
        this.fireModelChangeEvent();
        this.changesMulticaster.linesChanged(this.screenLinesStorage.getSize() - 1);
    }

    private final void writeString(int x, int y, CharBuffer str, TextStyle style) {
        TerminalLine line = this.screenLinesStorage.get(y - 1);
        line.writeString(x, str, style);
        TextProcessing textProcessing = this.textProcessing;
        if (textProcessing != null) {
            textProcessing.processHyperlinks(this.screenLinesStorage, line);
        }
        this.fireModelChangeEvent();
        this.changesMulticaster.linesChanged(y - 1);
    }

    public final void scrollArea(int scrollRegionTop, int dy, int scrollRegionBottom) {
        if (dy == 0) {
            return;
        }
        if (dy > 0) {
            this.insertLines(scrollRegionTop - 1, dy, scrollRegionBottom);
        } else {
            List<TerminalLine> deletedLines = this.deleteLines(scrollRegionTop - 1, -dy, scrollRegionBottom);
            if (scrollRegionTop == 1) {
                this.addLinesToHistory(deletedLines);
            }
            this.fireModelChangeEvent();
        }
    }

    @NotNull
    public final TerminalLine getLine(int index) {
        if (index >= 0) {
            if (index >= this.height) {
                LOG.error("Attempt to get line out of bounds: " + index + " >= " + this.height);
                TerminalLine terminalLine = TerminalLine.createEmpty();
                Intrinsics.checkNotNullExpressionValue((Object)terminalLine, (String)"createEmpty(...)");
                return terminalLine;
            }
            return this.screenLinesStorage.get(index);
        }
        if (index < -this.getHistoryLinesCount()) {
            LOG.error("Attempt to get line out of bounds: " + index + " < " + -this.getHistoryLinesCount());
            TerminalLine terminalLine = TerminalLine.createEmpty();
            Intrinsics.checkNotNullExpressionValue((Object)terminalLine, (String)"createEmpty(...)");
            return terminalLine;
        }
        return this.historyLinesStorage.get(this.getHistoryLinesCount() + index);
    }

    public final void setLineWrapped(int index, boolean isWrapped) {
        this.getLine(index).setWrapped(isWrapped);
        this.changesMulticaster.linesChanged(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getScreenLines() {
        this.myLock.lock();
        try {
            StringBuilder sb = new StringBuilder();
            int n = this.height;
            for (int row = 0; row < n; ++row) {
                StringBuilder line = new StringBuilder(this.screenLinesStorage.get(row).getText());
                int n2 = this.width;
                for (int i = line.length(); i < n2; ++i) {
                    line.append(' ');
                }
                if (line.length() > this.width) {
                    line.setLength(this.width);
                }
                sb.append((CharSequence)line);
                sb.append('\n');
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string;
            return string2;
        }
        finally {
            this.myLock.unlock();
        }
    }

    public final void processScreenLines(int yStart, int yCount, @NotNull StyledTextConsumer consumer) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        LinesStorageKt.processLines$default(this.screenLinesStorage, yStart, yCount, consumer, 0, 8, null);
    }

    public final void lock() {
        this.myLock.lock();
    }

    public final void unlock() {
        this.myLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void modify(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.myLock.lock();
        try {
            runnable.run();
        }
        finally {
            this.myLock.unlock();
        }
    }

    public final void modify(@NotNull Function0<Unit> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        this.modify(() -> TerminalTextBuffer.modify$lambda$0(runnable));
    }

    public final boolean tryLock() {
        return this.myLock.tryLock();
    }

    public final char getBuffersCharAt(int x, int y) {
        return this.getLine(y).charAt(x);
    }

    @Nullable
    public final TextStyle getStyleAt(int x, int y) {
        return this.getLine(y).getStyleAt(x);
    }

    @NotNull
    public final Pair<Character, TextStyle> getStyledCharAt(int x, int y) {
        TerminalLine line = this.getLine(y);
        return new Pair((Object)Character.valueOf(line.charAt(x)), (Object)line.getStyleAt(x));
    }

    public final char getCharAt(int x, int y) {
        return this.getLine(y).charAt(x);
    }

    public final void useAlternateBuffer(boolean enabled) {
        this.alternateBuffer = enabled;
        if (enabled) {
            if (!this.isUsingAlternateBuffer) {
                this.screenLinesStorageBackup = this.screenLinesStorage;
                this.historyLinesStorageBackup = this.historyLinesStorage;
                this.screenLinesStorage = this.createScreenLinesStorage();
                this.historyLinesStorage = this.createHistoryLinesStorage();
                this.screenBufferBackup = this.screenBuffer;
                this.historyBufferBackup = this.historyBuffer;
                this.screenBuffer = this.createLinesBuffer(this.screenLinesStorage);
                this.historyBuffer = this.createLinesBuffer(this.historyLinesStorage);
                this.isUsingAlternateBuffer = true;
            }
        } else if (this.isUsingAlternateBuffer) {
            LinesStorage linesStorage = this.screenLinesStorageBackup;
            Intrinsics.checkNotNull((Object)linesStorage);
            this.screenLinesStorage = linesStorage;
            LinesStorage linesStorage2 = this.historyLinesStorageBackup;
            Intrinsics.checkNotNull((Object)linesStorage2);
            this.historyLinesStorage = linesStorage2;
            this.screenLinesStorageBackup = this.createScreenLinesStorage();
            this.historyLinesStorageBackup = this.createHistoryLinesStorage();
            LinesBuffer linesBuffer = this.screenBufferBackup;
            Intrinsics.checkNotNull((Object)linesBuffer);
            this.screenBuffer = linesBuffer;
            LinesBuffer linesBuffer2 = this.historyBufferBackup;
            Intrinsics.checkNotNull((Object)linesBuffer2);
            this.historyBuffer = linesBuffer2;
            LinesStorage linesStorage3 = this.screenLinesStorageBackup;
            Intrinsics.checkNotNull((Object)linesStorage3);
            this.screenBufferBackup = this.createLinesBuffer(linesStorage3);
            LinesStorage linesStorage4 = this.historyLinesStorageBackup;
            Intrinsics.checkNotNull((Object)linesStorage4);
            this.historyBufferBackup = this.createLinesBuffer(linesStorage4);
            this.isUsingAlternateBuffer = false;
        }
        this.fireModelChangeEvent();
    }

    public final void insertLines(int y, int count, int scrollRegionBottom) {
        LinesStorageKt.insertLines(this.screenLinesStorage, y, count, scrollRegionBottom - 1, this.createFillerEntry());
        this.fireModelChangeEvent();
        this.changesMulticaster.linesChanged(y);
    }

    @NotNull
    public final List<TerminalLine> deleteLines(int y, int count, int scrollRegionBottom) {
        List<TerminalLine> deletedLines = LinesStorageKt.deleteLines(this.screenLinesStorage, y, count, scrollRegionBottom - 1, this.createFillerEntry());
        this.fireModelChangeEvent();
        this.changesMulticaster.linesChanged(y);
        return deletedLines;
    }

    public final void clearLines(int startRow, int endRow) {
        TerminalLine.TextEntry filler = this.createFillerEntry();
        int ind = startRow;
        if (ind <= endRow) {
            while (true) {
                this.screenLinesStorage.get(ind).clear(filler);
                this.setLineWrapped(ind, false);
                if (ind == endRow) break;
                ++ind;
            }
        }
        this.fireModelChangeEvent();
        this.changesMulticaster.linesChanged(startRow);
    }

    public final void eraseCharacters(int leftX, int rightX, int y) {
        TextStyle style = this.createEmptyStyleWithCurrentColor();
        if (y >= 0) {
            this.screenLinesStorage.get(y).clearArea(leftX, rightX, style);
            this.fireModelChangeEvent();
            this.changesMulticaster.linesChanged(y);
            if (this.textProcessing != null && y < this.height) {
                this.textProcessing.processHyperlinks(this.screenLinesStorage, this.getLine(y));
            }
        } else {
            LOG.error("Attempt to erase characters in line: " + y);
        }
    }

    public final void clearScreenAndHistoryBuffers() {
        this.screenLinesStorage.clear();
        this.historyLinesStorage.clear();
        this.fireModelChangeEvent();
        this.changesMulticaster.linesChanged(0);
    }

    public final void clearScreenBuffer() {
        this.screenLinesStorage.clear();
        this.fireModelChangeEvent();
        this.changesMulticaster.linesChanged(0);
    }

    public final void processHistoryAndScreenLines(int scrollOrigin, int maximalLinesToProcess, @NotNull StyledTextConsumer consumer) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        int linesToProcess = maximalLinesToProcess < 0 ? this.historyLinesStorage.getSize() + this.screenLinesStorage.getSize() : maximalLinesToProcess;
        int linesFromHistory = Math.min(-scrollOrigin, linesToProcess);
        int y = this.historyLinesStorage.getSize() + scrollOrigin;
        if (y < 0) {
            y = 0;
        }
        LinesStorageKt.processLines(this.historyLinesStorage, y, linesFromHistory, consumer, y);
        if (linesFromHistory < linesToProcess) {
            LinesStorageKt.processLines(this.screenLinesStorage, 0, linesToProcess - linesFromHistory, consumer, -linesFromHistory);
        }
    }

    public final void clearHistory() {
        this.modify((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ TerminalTextBuffer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                int lineCount = this.this$0.getHistoryLinesStorage().getSize();
                this.this$0.getHistoryLinesStorage().clear();
                if (lineCount > 0) {
                    TerminalTextBuffer.access$fireHistoryBufferLineCountChanged(this.this$0);
                }
            }
        }));
        this.fireModelChangeEvent();
        this.changesMulticaster.linesChanged(0);
    }

    public final void moveScreenLinesToHistory() {
        this.modify((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ TerminalTextBuffer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                TerminalTextBuffer.access$removeBottomEmptyLines(this.this$0, this.this$0.getScreenLinesStorage().getSize());
                List<TerminalLine> removedScreenLines = LinesStorageKt.removeFromTop(this.this$0.getScreenLinesStorage(), this.this$0.getScreenLinesStorage().getSize());
                TerminalTextBuffer.access$addLinesToHistory(this.this$0, removedScreenLines);
                if (this.this$0.getHistoryLinesStorage().getSize() > 0) {
                    this.this$0.setLineWrapped(-1, false);
                }
                if (!((Collection)removedScreenLines).isEmpty()) {
                    TerminalTextBuffer.access$fireHistoryBufferLineCountChanged(this.this$0);
                }
            }
        }));
    }

    private final int removeBottomEmptyLines(int maxCount) {
        int removedLinesCount = LinesStorageKt.removeBottomEmptyLines(this.screenLinesStorage, maxCount);
        if (removedLinesCount > 0) {
            this.changesMulticaster.linesChanged(this.screenLinesStorage.getSize());
        }
        return removedLinesCount;
    }

    private final void addLinesToHistory(List<TerminalLine> linesToAdd) {
        List list;
        if (this.historyLinesStorage.getSize() + linesToAdd.size() > this.maxHistoryLinesCount) {
            int discardedLinesCount = this.historyLinesStorage.getSize() + linesToAdd.size() - this.maxHistoryLinesCount;
            if (discardedLinesCount == 1) {
                TerminalLine line = this.historyLinesStorage.getSize() > 0 ? this.historyLinesStorage.get(0) : linesToAdd.get(0);
                list = CollectionsKt.listOf((Object)line);
            } else {
                ArrayList<TerminalLine> linesToDiscard = new ArrayList<TerminalLine>(discardedLinesCount);
                int countOfLinesFromHistory = Math.min(discardedLinesCount, this.historyLinesStorage.getSize());
                for (int ind = 0; ind < countOfLinesFromHistory; ++ind) {
                    linesToDiscard.add(this.historyLinesStorage.get(ind));
                }
                if (countOfLinesFromHistory < discardedLinesCount) {
                    linesToDiscard.addAll((Collection)linesToAdd.subList(0, discardedLinesCount - countOfLinesFromHistory));
                }
                list = linesToDiscard;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        List linesToDiscard = list;
        LinesStorageKt.addAllToBottom(this.historyLinesStorage, linesToAdd);
        if (!((Collection)linesToDiscard).isEmpty()) {
            this.changesMulticaster.linesDiscardedFromHistory(linesToDiscard);
        }
    }

    private final void fireHistoryBufferLineCountChanged() {
        for (TerminalHistoryBufferListener historyBufferListener : this.historyBufferListeners) {
            historyBufferListener.historyBufferLineCountChanged();
        }
    }

    public final int findScreenLineIndex(@NotNull TerminalLine line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return this.screenLinesStorage.indexOf(line);
    }

    public final void clearTypeAheadPredictions() {
        this.clearTypeAheadPredictions(this.screenLinesStorage);
        this.clearTypeAheadPredictions(this.historyLinesStorage);
        this.fireModelChangeEvent();
    }

    private final void clearTypeAheadPredictions(LinesStorage storage) {
        for (TerminalLine line : storage) {
            line.myTypeAheadLine = null;
        }
    }

    @JvmOverloads
    public TerminalTextBuffer(int width, int height, @NotNull StyleState styleState) {
        Intrinsics.checkNotNullParameter((Object)styleState, (String)"styleState");
        this(width, height, styleState, null, 8, null);
    }

    private static final void modify$lambda$0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    public static final /* synthetic */ void access$fireHistoryBufferLineCountChanged(TerminalTextBuffer $this) {
        $this.fireHistoryBufferLineCountChanged();
    }

    public static final /* synthetic */ int access$removeBottomEmptyLines(TerminalTextBuffer $this, int maxCount) {
        return $this.removeBottomEmptyLines(maxCount);
    }

    public static final /* synthetic */ void access$addLinesToHistory(TerminalTextBuffer $this, List linesToAdd) {
        $this.addLinesToHistory(linesToAdd);
    }

    static {
        Logger logger = LoggerFactory.getLogger(TerminalTextBuffer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jediterm/terminal/model/TerminalTextBuffer$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "USE_CONPTY_COMPATIBLE_RESIZE", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

