/*
 * Decompiled with CFR 0.152.
 */
package fleet.ai.frontend.api.agent.project;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lfleet/ai/frontend/api/agent/project/AiProjectDebugData;", "", "()V", "devcontainer", "", "getDevcontainer", "()Ljava/lang/String;", "dockerfile", "getDockerfile", "projectResponse", "getProjectResponse", "equals", "", "other", "hashCode", "", "toString", "fleet.plugins.ai.frontend"})
public final class AiProjectDebugData {
    @NotNull
    public static final AiProjectDebugData INSTANCE = new AiProjectDebugData();
    @NotNull
    private static final String projectResponse = "```\nPLANNING\n```\n\n- **End Goal:** Create a Kotlin Ktor project with a simple \"Hello World\" server and a test case for it, utilizing libs.versions.toml for dependencies management.\n- **Step-by-step Action Plan:**\n  - **Setup Environment:**\n    - Install the latest version of Gradle (8.9).\n    - Install the latest version of Kotlin (2.0.10).\n    \n  - **Project Initialization:**\n    - Initialize a new Gradle project.\n    - Configure the project structure.\n    \n  - **Configure Build:**\n    - Add necessary Ktor plugin and configurations in `build.gradle.kts`.\n    - Set up `settings.gradle.kts` with version catalog.\n    - Create `libs.versions.toml` to manage library versions.\n    \n  - **Implement Server:**\n    - Create a simple \"Hello World\" Ktor server in the `main` source set.\n    \n  - **Implement Tests:**\n    - Add a basic test to verify the server response in the `test` source set.\n    \n  - **Documentation:**\n    - Add a `README.md` to describe the project.\n    - Add a `README_BUILD.md` to describe how to build the project.\n    \n  - **Fleet Configuration:**\n    - Add a `.fleet/run.json` to configure JetBrains Fleet IDE for the project.\n\n```\nSTRUCTURE_GENERATION\n```\n\n```PROJECT\n/kotlin-ktor\n\u251c\u2500\u2500 .fleet\n\u2502   \u2514\u2500\u2500 run.json\n\u251c\u2500\u2500 gradle\n\u2502   \u2514\u2500\u2500 libs.versions.toml\n\u251c\u2500\u2500 src\n\u2502   \u251c\u2500\u2500 main\n\u2502   \u2502   \u251c\u2500\u2500 kotlin\n\u2502   \u2502   \u2502   \u2514\u2500\u2500 com\n\u2502   \u2502   \u2502       \u2514\u2500\u2500 example\n\u2502   \u2502   \u2502           \u2514\u2500\u2500 Application.kt\n\u2502   \u2502   \u2514\u2500\u2500 resources\n\u2502   \u2514\u2500\u2500 test\n\u2502       \u251c\u2500\u2500 kotlin\n\u2502       \u2502   \u2514\u2500\u2500 com\n\u2502       \u2502       \u2514\u2500\u2500 example\n\u2502       \u2502           \u2514\u2500\u2500 ApplicationTest.kt\n\u2502       \u2514\u2500\u2500 resources\n\u251c\u2500\u2500 build.gradle.kts\n\u251c\u2500\u2500 gradle.properties\n\u251c\u2500\u2500 settings.gradle.kts\n\u251c\u2500\u2500 README.md\n\u2514\u2500\u2500 README_BUILD.md\n```\n\n```\nCONTENT_GENERATION\n```\n\n```kotlin-ktor/build.gradle.kts\nplugins {\n    kotlin(\"jvm\") version \"2.0.10\"\n    id(\"io.ktor.plugin\") version \"2.3.12\"\n    application\n}\n\ngroup = \"com.example\"\nversion = \"1.0-SNAPSHOT\"\n\nrepositories {\n    mavenCentral()\n}\n\ndependencies {\n    implementation(libs.ktor.server.core)\n    implementation(libs.ktor.server.netty)\n    testImplementation(libs.ktor.server.tests)\n    testImplementation(libs.kotlin.test.junit5)\n}\n\napplication {\n    mainClass.set(\"com.example.ApplicationKt\")\n}\n\ntasks.test {\n    useJUnitPlatform()\n}\n\nkotlin {\n    jvmToolchain(18)\n}\n```\n\n```kotlin-ktor/gradle.properties\nkotlin.code.style=official\n```\n  \n```kotlin-ktor/README.md\n# Kotlin Ktor Project\n\nThis project is a basic Kotlin Ktor application with a \"Hello World\" server and a corresponding test case.\n\n## Structure\n\n- `.fleet/` - Configuration for JetBrains Fleet IDE.\n- `build.gradle.kts` - Gradle build configuration.\n- `gradle.properties` - Properties for the Gradle build system.\n- `gradle/` - Directory containing `libs.versions.toml` for managing library versions.\n- `settings.gradle.kts` - Settings for the Gradle build system.\n- `src/` - Source directory containing main and test source sets.\n- `README.md` - Project description.\n- `README_BUILD.md` - Instructions on how to build the project.\n\n## Server\n\nThe server has a single endpoint:\n- `GET /` - Returns \"Hello, World!\".\n```\n\n```kotlin-ktor/README_BUILD.md\n# Build Instructions\n\n## Requirements\n- Java Development Kit (JDK) 18\n- Gradle 8.9\n\n## Instructions\n1. Clone the repository.\n2. Navigate to the project directory.\n3. To build the project, run:\n   ```shell\n   ./gradlew build\n   ```\n4. To run the server, use:\n   ```shell\n   ./gradlew run\n   ```\n\nThe server will start at `http://localhost:8080`.\n```\n\n```kotlin-ktor/.fleet/run.json\n{\n  \"configurations\": [\n    {\n      \"type\": \"gradle\",\n      \"name\": \"Run project\",\n      \"tasks\": [\"run\"]\n    }\n  ]\n}\n```\n\n```kotlin-ktor/settings.gradle.kts\ndependencyResolutionManagement {\n    versionCatalogs {\n        create(\"libs\") {\n            from(files(\"gradle/libs.versions.toml\"))\n        }\n    }\n}\n\nrootProject.name = \"kotlin-ktor\"\n```\n\n```kotlin-ktor/gradle/libs.versions.toml\n[versions]\nkotlin = \"2.0.10\"\nktor = \"2.3.12\"\n\n[libraries]\nktor-server-core = { module = \"io.ktor:ktor-server-core\", version.ref = \"ktor\" }\nktor-server-netty = { module = \"io.ktor:ktor-server-netty\", version.ref = \"ktor\" }\nktor-server-tests = { module = \"io.ktor:ktor-server-tests\", version.ref = \"ktor\" }\nkotlin-test-junit5 = { module = \"org.jetbrains.kotlin:kotlin-test-junit5\", version.ref = \"kotlin\" }\n```\n\n```kotlin-ktor/src/main/kotlin/com/example/Application.kt\npackage com.example\n\nimport io.ktor.application.*\nimport io.ktor.response.*\nimport io.ktor.routing.*\nimport io.ktor.server.engine.*\nimport io.ktor.server.netty.*\n\nfun main() {\n    embeddedServer(Netty, port = 8080) {\n        routing {\n            get(\"/\") {\n                call.respondText(\"Hello, World!\")\n            }\n        }\n    }.start(wait = true)\n}\n```\n\n```kotlin-ktor/src/test/kotlin/com/example/ApplicationTest.kt\npackage com.example\n\nimport io.ktor.application.*\nimport io.ktor.http.*\nimport io.ktor.server.testing.*\nimport io.ktor.server.engine.*\nimport io.ktor.server.netty.*\nimport kotlin.test.Test\nimport kotlin.test.assertEquals\n\nclass ApplicationTest {\n    @Test\n    fun testRoot() {\n        withTestApplication({ configureRouting() }) {\n            handleRequest(HttpMethod.Get, \"/\").apply {\n                assertEquals(HttpStatusCode.OK, response.status())\n                assertEquals(\"Hello, World!\", response.content)\n            }\n        }\n    }\n\n    private fun Application.configureRouting() {\n        routing {\n            get(\"/\") {\n                call.respondText(\"Hello, World!\")\n            }\n        }\n    }\n}\n```";
    @NotNull
    private static final String dockerfile = "# Use the latest stable Ubuntu image\nFROM ubuntu:latest\n\n# Update package list and install essential packages\nRUN apt-get update && apt-get install -y \\\n    git \\\n    zip \\\n    unzip \\\n    curl \\\n    wget \\\n    && rm -rf /var/lib/apt/lists/*\n\n# Install Java SDK version 18\nRUN apt-get update && apt-get install -y openjdk-18-jdk && rm -rf /var/lib/apt/lists/*\n\n# Install Gradle\nRUN wget https://services.gradle.org/distributions/gradle-8.9-bin.zip -P /tmp \\\n    && unzip -d /opt/gradle /tmp/gradle-8.9-bin.zip \\\n    && ln -s /opt/gradle/gradle-8.9/bin/gradle /usr/bin/gradle\n\n# Set the working directory\nWORKDIR /home/root/app\n\n# Expose the necessary port\nEXPOSE 8080\n\n# Define the entry point to build the Ktor application using Gradle\nCMD [\"gradle\", \"build\"]";
    @NotNull
    private static final String devcontainer = "{\n  \"name\": \"fleet-ktor\",\n  \"appPort\": [8080],\n  \"build\": {\n    \"dockerfile\": \".fleet/Dockerfile\"\n  }\n}";

    private AiProjectDebugData() {
    }

    @NotNull
    public final String getProjectResponse() {
        return projectResponse;
    }

    @NotNull
    public final String getDockerfile() {
        return dockerfile;
    }

    @NotNull
    public final String getDevcontainer() {
        return devcontainer;
    }

    @NotNull
    public String toString() {
        return "AiProjectDebugData";
    }

    public int hashCode() {
        return 724436084;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AiProjectDebugData)) {
            return false;
        }
        AiProjectDebugData cfr_ignored_0 = (AiProjectDebugData)other;
        return true;
    }
}

