/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.markdown.frontend.language;

import andel.editor.Caret;
import andel.editor.CaretPosition;
import andel.editor.EditorExtKt;
import andel.editor.MutableEditor;
import andel.editor.TransientEditor;
import andel.operation.Operation;
import andel.text.Text;
import andel.text.TextFragmentCharSequence;
import andel.text.TextLine;
import andel.text.TextRange;
import fleet.ast.SyntexNodeExtKt;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.com.jetbrains.lang.syntax.SyntaxNodeExtKt;
import fleet.frontend.lang.enterHandler.EnterHandler;
import fleet.plugins.markdown.frontend.language.MarkdownListEnterHandler;
import fleet.plugins.markdown.frontend.language.MarkdownListEnterHandlerKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\f\u0010\f\u001a\u00020\u0007*\u00020\u0004H\u0002J\u0012\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u00020\u000e*\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lfleet/plugins/markdown/frontend/language/MarkdownListEnterHandler;", "Lfleet/frontend/lang/enterHandler/EnterHandler;", "()V", "findListMarker", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "item", "isEmptyListItem", "", "obtainNextListMarkerText", "", "obtainNextNumberedListMarkerText", "marker", "isListMarker", "postProcessEnter", "", "Landel/editor/TransientEditor;", "(Landel/editor/TransientEditor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "preprocessEnter", "fleet.plugins.markdown.frontend"})
@SourceDebugExtension(value={"SMAP\nMarkdownListEnterHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownListEnterHandler.kt\nfleet/plugins/markdown/frontend/language/MarkdownListEnterHandler\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,111:1\n630#2,5:112\n*S KotlinDebug\n*F\n+ 1 MarkdownListEnterHandler.kt\nfleet/plugins/markdown/frontend/language/MarkdownListEnterHandler\n*L\n60#1:112,5\n*E\n"})
public final class MarkdownListEnterHandler
implements EnterHandler {
    @Nullable
    public Object preprocessEnter(@NotNull TransientEditor $this$preprocessEnter, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @Nullable
    public Object postProcessEnter(@NotNull TransientEditor $this$postProcessEnter, @NotNull Continuation<? super Unit> $completion) {
        TextLine textLine = Text.lineAtCharOffset$default((Text)$this$postProcessEnter.getDocument().getText(), (long)$this$postProcessEnter.getCurrentCaret().getOffset(), (boolean)false, (int)2, null).prev();
        if (textLine == null) {
            return Unit.INSTANCE;
        }
        TextLine previousLine = textLine;
        SyntaxNode syntaxNode = MarkdownListEnterHandlerKt.access$findListItem($this$postProcessEnter, previousLine.withoutSeparator().getRange().getEnd());
        if (syntaxNode == null) {
            return Unit.INSTANCE;
        }
        SyntaxNode item = syntaxNode;
        TextRange range = SyntexNodeExtKt.getTextRange((SyntaxNode)item);
        TextLine line = Text.lineAtCharOffset$default((Text)$this$postProcessEnter.getDocument().getText(), (long)range.getStart(), (boolean)false, (int)2, null).withoutSeparator();
        long lineStartOffset = line.getRange().getStart();
        TextFragmentCharSequence indent = $this$postProcessEnter.getDocument().getText().charSequence(lineStartOffset, range.getStart());
        if (this.isEmptyListItem(item)) {
            Operation operation = Operation.Companion.replaceAt$default((Operation.Companion)Operation.Companion, (long)range.getStart(), (String)(item.getText() + "\n"), (String)"", (long)$this$postProcessEnter.getDocument().getText().charsCount(), (boolean)false, (int)16, null);
            $this$postProcessEnter.getDocument().edit(operation);
            Caret updatedCaret = Caret.move$default((Caret)$this$postProcessEnter.getCurrentCaret(), (CaretPosition)new CaretPosition(range.getStart()), null, (int)2, null);
            EditorExtKt.moveCarets((MutableEditor)((MutableEditor)$this$postProcessEnter), (List)CollectionsKt.listOf((Object)updatedCaret));
            return Unit.INSTANCE;
        }
        CharSequence marker = this.obtainNextListMarkerText(item);
        String text2 = "" + indent + marker;
        $this$postProcessEnter.getDocument().edit(Operation.Companion.insertAt($this$postProcessEnter.getCurrentCaret().getOffset(), text2, $this$postProcessEnter.getDocument().getText().charsCount()));
        Caret updatedCaret = Caret.move$default((Caret)$this$postProcessEnter.getCurrentCaret(), (CaretPosition)new CaretPosition($this$postProcessEnter.getCurrentCaret().getOffset() + (long)text2.length()), null, (int)2, null);
        EditorExtKt.moveCarets((MutableEditor)((MutableEditor)$this$postProcessEnter), (List)CollectionsKt.listOf((Object)updatedCaret));
        return Unit.INSTANCE;
    }

    private final boolean isEmptyListItem(SyntaxNode item) {
        Sequence children2 = SequencesKt.filterNot((Sequence)SyntaxNodeExtKt.children((SyntaxNode)item), (Function1)((Function1)new Function1<SyntaxNode, Boolean>(this){
            final /* synthetic */ MarkdownListEnterHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull SyntaxNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return MarkdownListEnterHandler.access$isListMarker(this.this$0, it);
            }
        }));
        String text2 = SequencesKt.joinToString$default((Sequence)children2, (CharSequence)"", null, null, (int)0, null, (Function1)isEmptyListItem.text.1.INSTANCE, (int)30, null);
        return ((CharSequence)text2).length() == 0;
    }

    private final CharSequence obtainNextListMarkerText(SyntaxNode item) {
        SyntaxNode syntaxNode = this.findListMarker(item);
        if (syntaxNode == null) {
            return "";
        }
        SyntaxNode marker = syntaxNode;
        return Intrinsics.areEqual((Object)marker.getType(), (Object)MarkdownTokenTypes.LIST_NUMBER) ? this.obtainNextNumberedListMarkerText(marker) : marker.getText();
    }

    private final CharSequence obtainNextNumberedListMarkerText(SyntaxNode marker) {
        CharSequence charSequence;
        CharSequence text2;
        block2: {
            CharSequence $this$takeWhile$iv = text2 = marker.getText();
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (Character.isDigit(it)) continue;
                charSequence = $this$takeWhile$iv.subSequence(0, index$iv);
                break block2;
            }
            charSequence = $this$takeWhile$iv.subSequence(0, $this$takeWhile$iv.length());
        }
        CharSequence number = charSequence;
        CharSequence tail = StringsKt.removePrefix((CharSequence)text2, (CharSequence)number);
        Integer n = StringsKt.toIntOrNull((String)((Object)number).toString());
        if (n == null) {
            return tail;
        }
        int value = n;
        return "" + (value + 1) + tail;
    }

    private final SyntaxNode findListMarker(SyntaxNode item) {
        Sequence elements2 = SequencesKt.filter((Sequence)SyntaxNodeExtKt.descendants$default((SyntaxNode)item, null, (int)1, null), (Function1)((Function1)new Function1<SyntaxNode, Boolean>(this){
            final /* synthetic */ MarkdownListEnterHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull SyntaxNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return MarkdownListEnterHandler.access$isListMarker(this.this$0, it);
            }
        }));
        return (SyntaxNode)SequencesKt.firstOrNull((Sequence)elements2);
    }

    private final boolean isListMarker(SyntaxNode $this$isListMarker) {
        return Intrinsics.areEqual((Object)$this$isListMarker.getType(), (Object)MarkdownTokenTypes.LIST_BULLET) || Intrinsics.areEqual((Object)$this$isListMarker.getType(), (Object)MarkdownTokenTypes.LIST_NUMBER);
    }

    public static final /* synthetic */ boolean access$isListMarker(MarkdownListEnterHandler $this, SyntaxNode $receiver) {
        return $this.isListMarker($receiver);
    }
}

