/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.devkit.frontend.header;

import fleet.compose.theme.util.RoundingKt;
import fleet.plugins.devkit.frontend.header.MetricStats;
import java.math.RoundingMode;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lfleet/plugins/devkit/frontend/header/StatsCalculator;", "", "<init>", "()V", "metrics", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lfleet/plugins/devkit/frontend/header/StatsCalculator$Metric;", "reset", "", "handle", "Lfleet/plugins/devkit/frontend/header/MetricStats;", "name", "value", "", "Metric", "fleet.plugins.devkit.frontend"})
@SourceDebugExtension(value={"SMAP\nActionLatencyWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionLatencyWidget.kt\nfleet/plugins/devkit/frontend/header/StatsCalculator\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n72#2,2:169\n1#3:171\n*S KotlinDebug\n*F\n+ 1 ActionLatencyWidget.kt\nfleet/plugins/devkit/frontend/header/StatsCalculator\n*L\n131#1:169,2\n131#1:171\n*E\n"})
final class StatsCalculator {
    @NotNull
    public static final StatsCalculator INSTANCE = new StatsCalculator();
    @NotNull
    private static final ConcurrentHashMap<String, Metric> metrics = new ConcurrentHashMap();

    private StatsCalculator() {
    }

    public final void reset() {
        metrics.clear();
    }

    @NotNull
    public final MetricStats handle(@NotNull String name, double value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ConcurrentMap $this$getOrPut$iv = metrics;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(name);
        if (object == null) {
            boolean bl = false;
            Metric default$iv = new Metric(name);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(name, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Metric metric = (Metric)object;
        return metric.handle(value);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lfleet/plugins/devkit/frontend/header/StatsCalculator$Metric;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "maxCount", "", "min", "max", "avg", "queue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "acc", "handle", "Lfleet/plugins/devkit/frontend/header/MetricStats;", "value", "", "fleet.plugins.devkit.frontend"})
    private static final class Metric {
        @NotNull
        private final String name;
        private final int maxCount;
        private int min;
        private int max;
        private int avg;
        @NotNull
        private final ConcurrentLinkedQueue<Integer> queue;
        private int acc;

        public Metric(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.maxCount = 200;
            this.min = Integer.MAX_VALUE;
            this.max = Integer.MIN_VALUE;
            this.queue = new ConcurrentLinkedQueue();
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final MetricStats handle(double value) {
            int ivalue = RoundingKt.round((double)value, (RoundingMode)RoundingMode.HALF_EVEN);
            if (this.queue.add(ivalue)) {
                this.acc += ivalue;
                if (ivalue < this.min) {
                    this.min = ivalue;
                }
                if (ivalue > this.max) {
                    this.max = ivalue;
                }
                if (this.maxCount < this.queue.size()) {
                    Integer valueToRemove = (Integer)this.queue.remove();
                    Intrinsics.checkNotNull((Object)valueToRemove);
                    this.acc -= valueToRemove.intValue();
                    int n = ivalue;
                    if (valueToRemove != n) {
                        n = this.min;
                        if (valueToRemove == n) {
                            this.min = ((Number)((Object)CollectionsKt.minOrThrow((Iterable)this.queue))).intValue();
                        }
                        n = this.max;
                        if (valueToRemove == n) {
                            this.max = ((Number)((Object)CollectionsKt.maxOrThrow((Iterable)this.queue))).intValue();
                        }
                    }
                }
                this.avg = this.acc / this.queue.size();
            }
            return new MetricStats(this.name, this.min, this.avg, this.max);
        }
    }
}

