/*
 * Decompiled with CFR 0.152.
 */
package fleet.git.frontend;

import andel.text.Text;
import fleet.api.FileAddress;
import fleet.api.ProtocolPath;
import fleet.git.frontend.GitPullOptions;
import fleet.git.frontend.GitPushOptions;
import fleet.git.frontend.GitResetMode;
import fleet.git.protocol.VcsAuthor;
import fleet.util.UID;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u000b\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u0082\u0001\u000b#$%&'()*+,-\u00a8\u0006."}, d2={"Lfleet/git/frontend/GitCommand;", "", "<init>", "()V", "id", "Lfleet/util/UID;", "getId", "()Lfleet/util/UID;", "allowBatching", "", "getAllowBatching", "()Z", "commandCreated", "", "getCommandCreated", "()J", "executionStarted", "getExecutionStarted", "setExecutionStarted", "(J)V", "executionSucceeded", "Lkotlinx/coroutines/CompletableDeferred;", "getExecutionSucceeded", "()Lkotlinx/coroutines/CompletableDeferred;", "Stage", "StageFile", "Unstage", "Revert", "Commit", "Continue", "Pull", "Push", "Sync", "Checkout", "Reset", "Lfleet/git/frontend/GitCommand$Checkout;", "Lfleet/git/frontend/GitCommand$Commit;", "Lfleet/git/frontend/GitCommand$Continue;", "Lfleet/git/frontend/GitCommand$Pull;", "Lfleet/git/frontend/GitCommand$Push;", "Lfleet/git/frontend/GitCommand$Reset;", "Lfleet/git/frontend/GitCommand$Revert;", "Lfleet/git/frontend/GitCommand$Stage;", "Lfleet/git/frontend/GitCommand$StageFile;", "Lfleet/git/frontend/GitCommand$Sync;", "Lfleet/git/frontend/GitCommand$Unstage;", "fleet.git.frontend"})
public abstract class GitCommand {
    private final long commandCreated = System.currentTimeMillis();
    private long executionStarted;
    @NotNull
    private final CompletableDeferred<Boolean> executionSucceeded = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);

    private GitCommand() {
    }

    @NotNull
    public abstract UID getId();

    public abstract boolean getAllowBatching();

    public final long getCommandCreated() {
        return this.commandCreated;
    }

    public final long getExecutionStarted() {
        return this.executionStarted;
    }

    public final void setExecutionStarted(long l) {
        this.executionStarted = l;
    }

    @NotNull
    public final CompletableDeferred<Boolean> getExecutionSucceeded() {
        return this.executionSucceeded;
    }

    public /* synthetic */ GitCommand(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lfleet/git/frontend/GitCommand$Checkout;", "Lfleet/git/frontend/GitCommand;", "id", "Lfleet/util/UID;", "branch", "", "upstream", "<init>", "(Lfleet/util/UID;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Lfleet/util/UID;", "getBranch", "()Ljava/lang/String;", "getUpstream", "allowBatching", "", "getAllowBatching", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "fleet.git.frontend"})
    public static final class Checkout
    extends GitCommand {
        @NotNull
        private final UID id;
        @NotNull
        private final String branch;
        @Nullable
        private final String upstream;
        private final boolean allowBatching;

        public Checkout(@NotNull UID id, @NotNull String branch, @Nullable String upstream) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
            super(null);
            this.id = id;
            this.branch = branch;
            this.upstream = upstream;
        }

        @Override
        @NotNull
        public UID getId() {
            return this.id;
        }

        @NotNull
        public final String getBranch() {
            return this.branch;
        }

        @Nullable
        public final String getUpstream() {
            return this.upstream;
        }

        @Override
        public boolean getAllowBatching() {
            return this.allowBatching;
        }

        @NotNull
        public final UID component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.branch;
        }

        @Nullable
        public final String component3() {
            return this.upstream;
        }

        @NotNull
        public final Checkout copy(@NotNull UID id, @NotNull String branch, @Nullable String upstream) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
            return new Checkout(id, branch, upstream);
        }

        public static /* synthetic */ Checkout copy$default(Checkout checkout2, UID uID, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                uID = checkout2.id;
            }
            if ((n & 2) != 0) {
                string = checkout2.branch;
            }
            if ((n & 4) != 0) {
                string2 = checkout2.upstream;
            }
            return checkout2.copy(uID, string, string2);
        }

        @NotNull
        public String toString() {
            return "Checkout(id=" + this.id + ", branch=" + this.branch + ", upstream=" + this.upstream + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.branch.hashCode();
            result2 = result2 * 31 + (this.upstream == null ? 0 : this.upstream.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Checkout)) {
                return false;
            }
            Checkout checkout2 = (Checkout)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)checkout2.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.branch, (Object)checkout2.branch)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.upstream, (Object)checkout2.upstream);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J1\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006!"}, d2={"Lfleet/git/frontend/GitCommand$Commit;", "Lfleet/git/frontend/GitCommand;", "id", "Lfleet/util/UID;", "message", "", "user", "Lfleet/git/protocol/VcsAuthor;", "amend", "", "<init>", "(Lfleet/util/UID;Ljava/lang/String;Lfleet/git/protocol/VcsAuthor;Z)V", "getId", "()Lfleet/util/UID;", "getMessage", "()Ljava/lang/String;", "getUser", "()Lfleet/git/protocol/VcsAuthor;", "getAmend", "()Z", "allowBatching", "getAllowBatching", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "fleet.git.frontend"})
    public static final class Commit
    extends GitCommand {
        @NotNull
        private final UID id;
        @NotNull
        private final String message;
        @NotNull
        private final VcsAuthor user;
        private final boolean amend;
        private final boolean allowBatching;

        public Commit(@NotNull UID id, @NotNull String message, @NotNull VcsAuthor user, boolean amend) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            super(null);
            this.id = id;
            this.message = message;
            this.user = user;
            this.amend = amend;
        }

        @Override
        @NotNull
        public UID getId() {
            return this.id;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final VcsAuthor getUser() {
            return this.user;
        }

        public final boolean getAmend() {
            return this.amend;
        }

        @Override
        public boolean getAllowBatching() {
            return this.allowBatching;
        }

        @NotNull
        public final UID component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @NotNull
        public final VcsAuthor component3() {
            return this.user;
        }

        public final boolean component4() {
            return this.amend;
        }

        @NotNull
        public final Commit copy(@NotNull UID id, @NotNull String message, @NotNull VcsAuthor user, boolean amend) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            return new Commit(id, message, user, amend);
        }

        public static /* synthetic */ Commit copy$default(Commit commit2, UID uID, String string, VcsAuthor vcsAuthor, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                uID = commit2.id;
            }
            if ((n & 2) != 0) {
                string = commit2.message;
            }
            if ((n & 4) != 0) {
                vcsAuthor = commit2.user;
            }
            if ((n & 8) != 0) {
                bl = commit2.amend;
            }
            return commit2.copy(uID, string, vcsAuthor, bl);
        }

        @NotNull
        public String toString() {
            return "Commit(id=" + this.id + ", message=" + this.message + ", user=" + this.user + ", amend=" + this.amend + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.message.hashCode();
            result2 = result2 * 31 + this.user.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.amend);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Commit)) {
                return false;
            }
            Commit commit2 = (Commit)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)commit2.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)commit2.message)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.user, (Object)commit2.user)) {
                return false;
            }
            return this.amend == commit2.amend;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lfleet/git/frontend/GitCommand$Continue;", "Lfleet/git/frontend/GitCommand;", "id", "Lfleet/util/UID;", "operation", "", "commit", "", "message", "<init>", "(Lfleet/util/UID;Ljava/lang/String;ZLjava/lang/String;)V", "getId", "()Lfleet/util/UID;", "getOperation", "()Ljava/lang/String;", "getCommit", "()Z", "getMessage", "allowBatching", "getAllowBatching", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "fleet.git.frontend"})
    public static final class Continue
    extends GitCommand {
        @NotNull
        private final UID id;
        @NotNull
        private final String operation;
        private final boolean commit;
        @NotNull
        private final String message;
        private final boolean allowBatching;

        public Continue(@NotNull UID id, @NotNull String operation, boolean commit2, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(null);
            this.id = id;
            this.operation = operation;
            this.commit = commit2;
            this.message = message;
        }

        @Override
        @NotNull
        public UID getId() {
            return this.id;
        }

        @NotNull
        public final String getOperation() {
            return this.operation;
        }

        public final boolean getCommit() {
            return this.commit;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @Override
        public boolean getAllowBatching() {
            return this.allowBatching;
        }

        @NotNull
        public final UID component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.operation;
        }

        public final boolean component3() {
            return this.commit;
        }

        @NotNull
        public final String component4() {
            return this.message;
        }

        @NotNull
        public final Continue copy(@NotNull UID id, @NotNull String operation, boolean commit2, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new Continue(id, operation, commit2, message);
        }

        public static /* synthetic */ Continue copy$default(Continue continue_, UID uID, String string, boolean bl, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                uID = continue_.id;
            }
            if ((n & 2) != 0) {
                string = continue_.operation;
            }
            if ((n & 4) != 0) {
                bl = continue_.commit;
            }
            if ((n & 8) != 0) {
                string2 = continue_.message;
            }
            return continue_.copy(uID, string, bl, string2);
        }

        @NotNull
        public String toString() {
            return "Continue(id=" + this.id + ", operation=" + this.operation + ", commit=" + this.commit + ", message=" + this.message + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.operation.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.commit);
            result2 = result2 * 31 + this.message.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Continue)) {
                return false;
            }
            Continue continue_ = (Continue)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)continue_.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.operation, (Object)continue_.operation)) {
                return false;
            }
            if (this.commit != continue_.commit) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)continue_.message);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lfleet/git/frontend/GitCommand$Pull;", "Lfleet/git/frontend/GitCommand;", "id", "Lfleet/util/UID;", "user", "Lfleet/git/protocol/VcsAuthor;", "options", "Lfleet/git/frontend/GitPullOptions;", "<init>", "(Lfleet/util/UID;Lfleet/git/protocol/VcsAuthor;Lfleet/git/frontend/GitPullOptions;)V", "getId", "()Lfleet/util/UID;", "getUser", "()Lfleet/git/protocol/VcsAuthor;", "getOptions", "()Lfleet/git/frontend/GitPullOptions;", "allowBatching", "", "getAllowBatching", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "", "fleet.git.frontend"})
    public static final class Pull
    extends GitCommand {
        @NotNull
        private final UID id;
        @Nullable
        private final VcsAuthor user;
        @NotNull
        private final GitPullOptions options;
        private final boolean allowBatching;

        public Pull(@NotNull UID id, @Nullable VcsAuthor user, @NotNull GitPullOptions options) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            super(null);
            this.id = id;
            this.user = user;
            this.options = options;
        }

        @Override
        @NotNull
        public UID getId() {
            return this.id;
        }

        @Nullable
        public final VcsAuthor getUser() {
            return this.user;
        }

        @NotNull
        public final GitPullOptions getOptions() {
            return this.options;
        }

        @Override
        public boolean getAllowBatching() {
            return this.allowBatching;
        }

        @NotNull
        public final UID component1() {
            return this.id;
        }

        @Nullable
        public final VcsAuthor component2() {
            return this.user;
        }

        @NotNull
        public final GitPullOptions component3() {
            return this.options;
        }

        @NotNull
        public final Pull copy(@NotNull UID id, @Nullable VcsAuthor user, @NotNull GitPullOptions options) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return new Pull(id, user, options);
        }

        public static /* synthetic */ Pull copy$default(Pull pull2, UID uID, VcsAuthor vcsAuthor, GitPullOptions gitPullOptions, int n, Object object) {
            if ((n & 1) != 0) {
                uID = pull2.id;
            }
            if ((n & 2) != 0) {
                vcsAuthor = pull2.user;
            }
            if ((n & 4) != 0) {
                gitPullOptions = pull2.options;
            }
            return pull2.copy(uID, vcsAuthor, gitPullOptions);
        }

        @NotNull
        public String toString() {
            return "Pull(id=" + this.id + ", user=" + this.user + ", options=" + this.options + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + (this.user == null ? 0 : this.user.hashCode());
            result2 = result2 * 31 + this.options.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Pull)) {
                return false;
            }
            Pull pull2 = (Pull)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)pull2.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.user, (Object)pull2.user)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.options, (Object)pull2.options);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lfleet/git/frontend/GitCommand$Push;", "Lfleet/git/frontend/GitCommand;", "id", "Lfleet/util/UID;", "options", "Lfleet/git/frontend/GitPushOptions;", "<init>", "(Lfleet/util/UID;Lfleet/git/frontend/GitPushOptions;)V", "getId", "()Lfleet/util/UID;", "getOptions", "()Lfleet/git/frontend/GitPushOptions;", "allowBatching", "", "getAllowBatching", "()Z", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "fleet.git.frontend"})
    public static final class Push
    extends GitCommand {
        @NotNull
        private final UID id;
        @NotNull
        private final GitPushOptions options;
        private final boolean allowBatching;

        public Push(@NotNull UID id, @NotNull GitPushOptions options) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            super(null);
            this.id = id;
            this.options = options;
        }

        @Override
        @NotNull
        public UID getId() {
            return this.id;
        }

        @NotNull
        public final GitPushOptions getOptions() {
            return this.options;
        }

        @Override
        public boolean getAllowBatching() {
            return this.allowBatching;
        }

        @NotNull
        public final UID component1() {
            return this.id;
        }

        @NotNull
        public final GitPushOptions component2() {
            return this.options;
        }

        @NotNull
        public final Push copy(@NotNull UID id, @NotNull GitPushOptions options) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return new Push(id, options);
        }

        public static /* synthetic */ Push copy$default(Push push2, UID uID, GitPushOptions gitPushOptions, int n, Object object) {
            if ((n & 1) != 0) {
                uID = push2.id;
            }
            if ((n & 2) != 0) {
                gitPushOptions = push2.options;
            }
            return push2.copy(uID, gitPushOptions);
        }

        @NotNull
        public String toString() {
            return "Push(id=" + this.id + ", options=" + this.options + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.options.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Push)) {
                return false;
            }
            Push push2 = (Push)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)push2.id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.options, (Object)push2.options);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0007H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lfleet/git/frontend/GitCommand$Reset;", "Lfleet/git/frontend/GitCommand;", "id", "Lfleet/util/UID;", "mode", "Lfleet/git/frontend/GitResetMode;", "oid", "", "<init>", "(Lfleet/util/UID;Lfleet/git/frontend/GitResetMode;Ljava/lang/String;)V", "getId", "()Lfleet/util/UID;", "getMode", "()Lfleet/git/frontend/GitResetMode;", "getOid", "()Ljava/lang/String;", "allowBatching", "", "getAllowBatching", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "fleet.git.frontend"})
    public static final class Reset
    extends GitCommand {
        @NotNull
        private final UID id;
        @NotNull
        private final GitResetMode mode;
        @NotNull
        private final String oid;
        private final boolean allowBatching;

        public Reset(@NotNull UID id, @NotNull GitResetMode mode, @NotNull String oid) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Intrinsics.checkNotNullParameter((Object)oid, (String)"oid");
            super(null);
            this.id = id;
            this.mode = mode;
            this.oid = oid;
        }

        @Override
        @NotNull
        public UID getId() {
            return this.id;
        }

        @NotNull
        public final GitResetMode getMode() {
            return this.mode;
        }

        @NotNull
        public final String getOid() {
            return this.oid;
        }

        @Override
        public boolean getAllowBatching() {
            return this.allowBatching;
        }

        @NotNull
        public final UID component1() {
            return this.id;
        }

        @NotNull
        public final GitResetMode component2() {
            return this.mode;
        }

        @NotNull
        public final String component3() {
            return this.oid;
        }

        @NotNull
        public final Reset copy(@NotNull UID id, @NotNull GitResetMode mode, @NotNull String oid) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Intrinsics.checkNotNullParameter((Object)oid, (String)"oid");
            return new Reset(id, mode, oid);
        }

        public static /* synthetic */ Reset copy$default(Reset reset, UID uID, GitResetMode gitResetMode, String string, int n, Object object) {
            if ((n & 1) != 0) {
                uID = reset.id;
            }
            if ((n & 2) != 0) {
                gitResetMode = reset.mode;
            }
            if ((n & 4) != 0) {
                string = reset.oid;
            }
            return reset.copy(uID, gitResetMode, string);
        }

        @NotNull
        public String toString() {
            return "Reset(id=" + this.id + ", mode=" + this.mode + ", oid=" + this.oid + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.mode.hashCode();
            result2 = result2 * 31 + this.oid.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Reset)) {
                return false;
            }
            Reset reset = (Reset)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)reset.id)) {
                return false;
            }
            if (this.mode != reset.mode) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.oid, (Object)reset.oid);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003JC\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lfleet/git/frontend/GitCommand$Revert;", "Lfleet/git/frontend/GitCommand;", "id", "Lfleet/util/UID;", "addedPaths", "", "Lfleet/api/ProtocolPath;", "removedPaths", "modifiedPaths", "<init>", "(Lfleet/util/UID;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getId", "()Lfleet/util/UID;", "getAddedPaths", "()Ljava/util/List;", "getRemovedPaths", "getModifiedPaths", "allowBatching", "", "getAllowBatching", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "", "fleet.git.frontend"})
    public static final class Revert
    extends GitCommand {
        @NotNull
        private final UID id;
        @NotNull
        private final List<ProtocolPath> addedPaths;
        @NotNull
        private final List<ProtocolPath> removedPaths;
        @NotNull
        private final List<ProtocolPath> modifiedPaths;
        private final boolean allowBatching;

        public Revert(@NotNull UID id, @NotNull List<ProtocolPath> addedPaths, @NotNull List<ProtocolPath> removedPaths, @NotNull List<ProtocolPath> modifiedPaths) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(addedPaths, (String)"addedPaths");
            Intrinsics.checkNotNullParameter(removedPaths, (String)"removedPaths");
            Intrinsics.checkNotNullParameter(modifiedPaths, (String)"modifiedPaths");
            super(null);
            this.id = id;
            this.addedPaths = addedPaths;
            this.removedPaths = removedPaths;
            this.modifiedPaths = modifiedPaths;
            this.allowBatching = true;
        }

        @Override
        @NotNull
        public UID getId() {
            return this.id;
        }

        @NotNull
        public final List<ProtocolPath> getAddedPaths() {
            return this.addedPaths;
        }

        @NotNull
        public final List<ProtocolPath> getRemovedPaths() {
            return this.removedPaths;
        }

        @NotNull
        public final List<ProtocolPath> getModifiedPaths() {
            return this.modifiedPaths;
        }

        @Override
        public boolean getAllowBatching() {
            return this.allowBatching;
        }

        @NotNull
        public final UID component1() {
            return this.id;
        }

        @NotNull
        public final List<ProtocolPath> component2() {
            return this.addedPaths;
        }

        @NotNull
        public final List<ProtocolPath> component3() {
            return this.removedPaths;
        }

        @NotNull
        public final List<ProtocolPath> component4() {
            return this.modifiedPaths;
        }

        @NotNull
        public final Revert copy(@NotNull UID id, @NotNull List<ProtocolPath> addedPaths, @NotNull List<ProtocolPath> removedPaths, @NotNull List<ProtocolPath> modifiedPaths) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(addedPaths, (String)"addedPaths");
            Intrinsics.checkNotNullParameter(removedPaths, (String)"removedPaths");
            Intrinsics.checkNotNullParameter(modifiedPaths, (String)"modifiedPaths");
            return new Revert(id, addedPaths, removedPaths, modifiedPaths);
        }

        public static /* synthetic */ Revert copy$default(Revert revert2, UID uID, List list, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                uID = revert2.id;
            }
            if ((n & 2) != 0) {
                list = revert2.addedPaths;
            }
            if ((n & 4) != 0) {
                list2 = revert2.removedPaths;
            }
            if ((n & 8) != 0) {
                list3 = revert2.modifiedPaths;
            }
            return revert2.copy(uID, list, list2, list3);
        }

        @NotNull
        public String toString() {
            return "Revert(id=" + this.id + ", addedPaths=" + this.addedPaths + ", removedPaths=" + this.removedPaths + ", modifiedPaths=" + this.modifiedPaths + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + ((Object)this.addedPaths).hashCode();
            result2 = result2 * 31 + ((Object)this.removedPaths).hashCode();
            result2 = result2 * 31 + ((Object)this.modifiedPaths).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Revert)) {
                return false;
            }
            Revert revert2 = (Revert)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)revert2.id)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.addedPaths, revert2.addedPaths)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.removedPaths, revert2.removedPaths)) {
                return false;
            }
            return Intrinsics.areEqual(this.modifiedPaths, revert2.modifiedPaths);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lfleet/git/frontend/GitCommand$Stage;", "Lfleet/git/frontend/GitCommand;", "id", "Lfleet/util/UID;", "paths", "", "Lfleet/api/ProtocolPath;", "<init>", "(Lfleet/util/UID;Ljava/util/List;)V", "getId", "()Lfleet/util/UID;", "getPaths", "()Ljava/util/List;", "allowBatching", "", "getAllowBatching", "()Z", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "fleet.git.frontend"})
    public static final class Stage
    extends GitCommand {
        @NotNull
        private final UID id;
        @NotNull
        private final List<ProtocolPath> paths;
        private final boolean allowBatching;

        public Stage(@NotNull UID id, @NotNull List<ProtocolPath> paths) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            super(null);
            this.id = id;
            this.paths = paths;
            this.allowBatching = true;
        }

        @Override
        @NotNull
        public UID getId() {
            return this.id;
        }

        @NotNull
        public final List<ProtocolPath> getPaths() {
            return this.paths;
        }

        @Override
        public boolean getAllowBatching() {
            return this.allowBatching;
        }

        @NotNull
        public final UID component1() {
            return this.id;
        }

        @NotNull
        public final List<ProtocolPath> component2() {
            return this.paths;
        }

        @NotNull
        public final Stage copy(@NotNull UID id, @NotNull List<ProtocolPath> paths) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            return new Stage(id, paths);
        }

        public static /* synthetic */ Stage copy$default(Stage stage2, UID uID, List list, int n, Object object) {
            if ((n & 1) != 0) {
                uID = stage2.id;
            }
            if ((n & 2) != 0) {
                list = stage2.paths;
            }
            return stage2.copy(uID, list);
        }

        @NotNull
        public String toString() {
            return "Stage(id=" + this.id + ", paths=" + this.paths + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + ((Object)this.paths).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Stage)) {
                return false;
            }
            Stage stage2 = (Stage)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)stage2.id)) {
                return false;
            }
            return Intrinsics.areEqual(this.paths, stage2.paths);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lfleet/git/frontend/GitCommand$StageFile;", "Lfleet/git/frontend/GitCommand;", "id", "Lfleet/util/UID;", "path", "Lfleet/api/FileAddress;", "text", "Landel/text/Text;", "<init>", "(Lfleet/util/UID;Lfleet/api/FileAddress;Landel/text/Text;)V", "getId", "()Lfleet/util/UID;", "getPath", "()Lfleet/api/FileAddress;", "getText", "()Landel/text/Text;", "allowBatching", "", "getAllowBatching", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "", "fleet.git.frontend"})
    public static final class StageFile
    extends GitCommand {
        @NotNull
        private final UID id;
        @NotNull
        private final FileAddress path;
        @NotNull
        private final Text text;
        private final boolean allowBatching;

        public StageFile(@NotNull UID id, @NotNull FileAddress path, @NotNull Text text2) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            super(null);
            this.id = id;
            this.path = path;
            this.text = text2;
        }

        @Override
        @NotNull
        public UID getId() {
            return this.id;
        }

        @NotNull
        public final FileAddress getPath() {
            return this.path;
        }

        @NotNull
        public final Text getText() {
            return this.text;
        }

        @Override
        public boolean getAllowBatching() {
            return this.allowBatching;
        }

        @NotNull
        public final UID component1() {
            return this.id;
        }

        @NotNull
        public final FileAddress component2() {
            return this.path;
        }

        @NotNull
        public final Text component3() {
            return this.text;
        }

        @NotNull
        public final StageFile copy(@NotNull UID id, @NotNull FileAddress path, @NotNull Text text2) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return new StageFile(id, path, text2);
        }

        public static /* synthetic */ StageFile copy$default(StageFile stageFile, UID uID, FileAddress fileAddress, Text text2, int n, Object object) {
            if ((n & 1) != 0) {
                uID = stageFile.id;
            }
            if ((n & 2) != 0) {
                fileAddress = stageFile.path;
            }
            if ((n & 4) != 0) {
                text2 = stageFile.text;
            }
            return stageFile.copy(uID, fileAddress, text2);
        }

        @NotNull
        public String toString() {
            return "StageFile(id=" + this.id + ", path=" + this.path + ", text=" + this.text + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.path.hashCode();
            result2 = result2 * 31 + this.text.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StageFile)) {
                return false;
            }
            StageFile stageFile = (StageFile)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)stageFile.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.path, (Object)stageFile.path)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.text, (Object)stageFile.text);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\tH\u00c6\u0003J5\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lfleet/git/frontend/GitCommand$Sync;", "Lfleet/git/frontend/GitCommand;", "id", "Lfleet/util/UID;", "user", "Lfleet/git/protocol/VcsAuthor;", "pushOptions", "Lfleet/git/frontend/GitPushOptions;", "pullOptions", "Lfleet/git/frontend/GitPullOptions;", "<init>", "(Lfleet/util/UID;Lfleet/git/protocol/VcsAuthor;Lfleet/git/frontend/GitPushOptions;Lfleet/git/frontend/GitPullOptions;)V", "getId", "()Lfleet/util/UID;", "getUser", "()Lfleet/git/protocol/VcsAuthor;", "getPushOptions", "()Lfleet/git/frontend/GitPushOptions;", "getPullOptions", "()Lfleet/git/frontend/GitPullOptions;", "allowBatching", "", "getAllowBatching", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "", "fleet.git.frontend"})
    public static final class Sync
    extends GitCommand {
        @NotNull
        private final UID id;
        @Nullable
        private final VcsAuthor user;
        @Nullable
        private final GitPushOptions pushOptions;
        @NotNull
        private final GitPullOptions pullOptions;
        private final boolean allowBatching;

        public Sync(@NotNull UID id, @Nullable VcsAuthor user, @Nullable GitPushOptions pushOptions, @NotNull GitPullOptions pullOptions) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)pullOptions, (String)"pullOptions");
            super(null);
            this.id = id;
            this.user = user;
            this.pushOptions = pushOptions;
            this.pullOptions = pullOptions;
        }

        @Override
        @NotNull
        public UID getId() {
            return this.id;
        }

        @Nullable
        public final VcsAuthor getUser() {
            return this.user;
        }

        @Nullable
        public final GitPushOptions getPushOptions() {
            return this.pushOptions;
        }

        @NotNull
        public final GitPullOptions getPullOptions() {
            return this.pullOptions;
        }

        @Override
        public boolean getAllowBatching() {
            return this.allowBatching;
        }

        @NotNull
        public final UID component1() {
            return this.id;
        }

        @Nullable
        public final VcsAuthor component2() {
            return this.user;
        }

        @Nullable
        public final GitPushOptions component3() {
            return this.pushOptions;
        }

        @NotNull
        public final GitPullOptions component4() {
            return this.pullOptions;
        }

        @NotNull
        public final Sync copy(@NotNull UID id, @Nullable VcsAuthor user, @Nullable GitPushOptions pushOptions, @NotNull GitPullOptions pullOptions) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)pullOptions, (String)"pullOptions");
            return new Sync(id, user, pushOptions, pullOptions);
        }

        public static /* synthetic */ Sync copy$default(Sync sync, UID uID, VcsAuthor vcsAuthor, GitPushOptions gitPushOptions, GitPullOptions gitPullOptions, int n, Object object) {
            if ((n & 1) != 0) {
                uID = sync.id;
            }
            if ((n & 2) != 0) {
                vcsAuthor = sync.user;
            }
            if ((n & 4) != 0) {
                gitPushOptions = sync.pushOptions;
            }
            if ((n & 8) != 0) {
                gitPullOptions = sync.pullOptions;
            }
            return sync.copy(uID, vcsAuthor, gitPushOptions, gitPullOptions);
        }

        @NotNull
        public String toString() {
            return "Sync(id=" + this.id + ", user=" + this.user + ", pushOptions=" + this.pushOptions + ", pullOptions=" + this.pullOptions + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + (this.user == null ? 0 : this.user.hashCode());
            result2 = result2 * 31 + (this.pushOptions == null ? 0 : this.pushOptions.hashCode());
            result2 = result2 * 31 + this.pullOptions.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Sync)) {
                return false;
            }
            Sync sync = (Sync)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)sync.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.user, (Object)sync.user)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pushOptions, (Object)sync.pushOptions)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.pullOptions, (Object)sync.pullOptions);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lfleet/git/frontend/GitCommand$Unstage;", "Lfleet/git/frontend/GitCommand;", "id", "Lfleet/util/UID;", "paths", "", "Lfleet/api/ProtocolPath;", "<init>", "(Lfleet/util/UID;Ljava/util/List;)V", "getId", "()Lfleet/util/UID;", "getPaths", "()Ljava/util/List;", "allowBatching", "", "getAllowBatching", "()Z", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "fleet.git.frontend"})
    public static final class Unstage
    extends GitCommand {
        @NotNull
        private final UID id;
        @NotNull
        private final List<ProtocolPath> paths;
        private final boolean allowBatching;

        public Unstage(@NotNull UID id, @NotNull List<ProtocolPath> paths) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            super(null);
            this.id = id;
            this.paths = paths;
            this.allowBatching = true;
        }

        @Override
        @NotNull
        public UID getId() {
            return this.id;
        }

        @NotNull
        public final List<ProtocolPath> getPaths() {
            return this.paths;
        }

        @Override
        public boolean getAllowBatching() {
            return this.allowBatching;
        }

        @NotNull
        public final UID component1() {
            return this.id;
        }

        @NotNull
        public final List<ProtocolPath> component2() {
            return this.paths;
        }

        @NotNull
        public final Unstage copy(@NotNull UID id, @NotNull List<ProtocolPath> paths) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            return new Unstage(id, paths);
        }

        public static /* synthetic */ Unstage copy$default(Unstage unstage, UID uID, List list, int n, Object object) {
            if ((n & 1) != 0) {
                uID = unstage.id;
            }
            if ((n & 2) != 0) {
                list = unstage.paths;
            }
            return unstage.copy(uID, list);
        }

        @NotNull
        public String toString() {
            return "Unstage(id=" + this.id + ", paths=" + this.paths + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + ((Object)this.paths).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Unstage)) {
                return false;
            }
            Unstage unstage = (Unstage)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)unstage.id)) {
                return false;
            }
            return Intrinsics.areEqual(this.paths, unstage.paths);
        }
    }
}

