/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.Arch;
import org.jetbrains.skiko.GpuPriority;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010'\u001a\u00020 H\u0002J\u001b\u0010(\u001a\b\u0012\u0004\u0012\u00020 0)2\u0006\u0010*\u001a\u00020 H\u0000\u00a2\u0006\u0002\b+J\u0017\u0010,\u001a\u00020 2\b\u0010-\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b.R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R(\u0010\u0019\u001a\u0004\u0018\u00010\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00048F@@X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u0006\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\nR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\nR\u0011\u0010%\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\n\u00a8\u0006/"}, d2={"Lorg/jetbrains/skiko/SkikoProperties;", "", "()V", "dataPath", "", "getDataPath", "()Ljava/lang/String;", "fpsEnabled", "", "getFpsEnabled", "()Z", "fpsLongFramesMillis", "", "getFpsLongFramesMillis", "()Ljava/lang/Double;", "fpsLongFramesShow", "getFpsLongFramesShow", "fpsPeriodSeconds", "getFpsPeriodSeconds", "()D", "gpuPriority", "Lorg/jetbrains/skiko/GpuPriority;", "getGpuPriority", "()Lorg/jetbrains/skiko/GpuPriority;", "value", "libraryPath", "getLibraryPath", "setLibraryPath$skiko", "(Ljava/lang/String;)V", "macOsOpenGLEnabled", "getMacOsOpenGLEnabled", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "vsyncEnabled", "getVsyncEnabled", "vsyncFramelimitFallbackEnabled", "getVsyncFramelimitFallbackEnabled", "bestRenderApiForCurrentOS", "fallbackRenderApiQueue", "", "initialApi", "fallbackRenderApiQueue$skiko", "parseRenderApi", "text", "parseRenderApi$skiko", "skiko"})
@SourceDebugExtension(value={"SMAP\nSkikoProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkikoProperties.kt\norg/jetbrains/skiko/SkikoProperties\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
public final class SkikoProperties {
    @NotNull
    public static final SkikoProperties INSTANCE = new SkikoProperties();

    private SkikoProperties() {
    }

    @Nullable
    public final String getLibraryPath() {
        return System.getProperty("skiko.library.path");
    }

    public final void setLibraryPath$skiko(@Nullable String value) {
        if (value != null) {
            System.setProperty("skiko.library.path", value);
        } else {
            System.clearProperty("skiko.library.path");
        }
    }

    @NotNull
    public final String getDataPath() {
        String string = System.getProperty("skiko.data.path");
        if (string == null) {
            string = System.getProperty("user.home") + "/.skiko/";
        }
        return string;
    }

    public final boolean getVsyncEnabled() {
        String string = System.getProperty("skiko.vsync.enabled");
        return string != null ? Boolean.parseBoolean(string) : true;
    }

    public final boolean getVsyncFramelimitFallbackEnabled() {
        String string = System.getProperty("skiko.vsync.framelimit.fallback.enabled");
        return string != null ? Boolean.parseBoolean(string) : true;
    }

    public final boolean getFpsEnabled() {
        String string = System.getProperty("skiko.fps.enabled");
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    public final double getFpsPeriodSeconds() {
        String string = System.getProperty("skiko.fps.periodSeconds");
        return string != null ? Double.parseDouble(string) : 2.0;
    }

    public final boolean getFpsLongFramesShow() {
        String string = System.getProperty("skiko.fps.longFrames.show");
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    @Nullable
    public final Double getFpsLongFramesMillis() {
        String string = System.getProperty("skiko.fps.longFrames.millis");
        return string != null ? Double.valueOf(Double.parseDouble(string)) : null;
    }

    @NotNull
    public final GraphicsApi getRenderApi() {
        String environment = System.getenv("SKIKO_RENDER_API");
        String property = System.getProperty("skiko.renderApi");
        String string = environment;
        if (string == null) {
            string = property;
        }
        return this.parseRenderApi$skiko(string);
    }

    @NotNull
    public final GpuPriority getGpuPriority() {
        Object object;
        block5: {
            block4: {
                String value;
                String string = System.getProperty("skiko.gpu.priority");
                if (string == null && (string = System.getProperty("skiko.metal.gpu.priority")) == null) {
                    string = System.getProperty("skiko.directx.gpu.priority");
                }
                if ((object = (value = string)) == null) break block4;
                String string2 = object;
                GpuPriority.Companion companion = GpuPriority.Companion;
                String p0 = string2;
                boolean bl = false;
                GpuPriority gpuPriority = companion.parseOrNull(p0);
                object = gpuPriority;
                if (gpuPriority != null) break block5;
            }
            object = GpuPriority.Auto;
        }
        return object;
    }

    public final boolean getMacOsOpenGLEnabled() {
        String string = System.getProperty("skiko.macos.opengl.enabled");
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    @NotNull
    public final GraphicsApi parseRenderApi$skiko(@Nullable String text) {
        block27: {
            String string = text;
            if (string == null) break block27;
            int n = -1;
            switch (string.hashCode()) {
                case -1019861004: {
                    if (string.equals("SOFTWARE_FAST")) {
                        n = 1;
                    }
                    break;
                }
                case -907020006: {
                    if (string.equals("SOFTWARE_COMPAT")) {
                        n = 2;
                    }
                    break;
                }
                case -1957249873: {
                    if (string.equals("OPENGL")) {
                        n = 3;
                    }
                    break;
                }
                case 1028669466: {
                    if (string.equals("DIRECT3D")) {
                        n = 4;
                    }
                    break;
                }
                case 73249511: {
                    if (string.equals("METAL")) {
                        n = 5;
                    }
                    break;
                }
                case 2101957031: {
                    if (string.equals("SOFTWARE")) {
                        n = 6;
                    }
                    break;
                }
                case 1644349757: {
                    if (string.equals("DIRECT_SOFTWARE")) {
                        n = 1;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    return GraphicsApi.SOFTWARE_COMPAT;
                }
                case 1: {
                    return GraphicsApi.SOFTWARE_FAST;
                }
                case 6: {
                    return OsArch_jvmKt.getHostOs() == OS.MacOS ? GraphicsApi.SOFTWARE_COMPAT : GraphicsApi.SOFTWARE_FAST;
                }
                case 3: {
                    if (OsArch_jvmKt.getHostOs() == OS.Windows && OsArch_jvmKt.getHostArch() == Arch.Arm64) {
                        throw new Exception((Object)((Object)OsArch_jvmKt.getHostOs()) + '-' + (Object)((Object)OsArch_jvmKt.getHostArch()) + " does not support OpenGL rendering API.");
                    }
                    return GraphicsApi.OPENGL;
                }
                case 4: {
                    if (OsArch_jvmKt.getHostOs() != OS.Windows) {
                        throw new Exception((Object)((Object)OsArch_jvmKt.getHostOs()) + " does not support DirectX rendering API.");
                    }
                    return GraphicsApi.DIRECT3D;
                }
                case 5: {
                    if (OsArch_jvmKt.getHostOs() != OS.MacOS) {
                        throw new Exception((Object)((Object)OsArch_jvmKt.getHostOs()) + " does not support Metal rendering API.");
                    }
                    return GraphicsApi.METAL;
                }
            }
        }
        return this.bestRenderApiForCurrentOS();
    }

    private final GraphicsApi bestRenderApiForCurrentOS() {
        switch (WhenMappings.$EnumSwitchMapping$0[OsArch_jvmKt.getHostOs().ordinal()]) {
            case 1: {
                return GraphicsApi.METAL;
            }
            case 2: {
                return GraphicsApi.OPENGL;
            }
            case 3: {
                return GraphicsApi.DIRECT3D;
            }
            case 4: {
                return GraphicsApi.OPENGL;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                String string = "commonize me";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public final List<GraphicsApi> fallbackRenderApiQueue$skiko(@NotNull GraphicsApi initialApi) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)((Object)initialApi), (String)"initialApi");
        switch (WhenMappings.$EnumSwitchMapping$0[OsArch_jvmKt.getHostOs().ordinal()]) {
            case 2: {
                GraphicsApi[] graphicsApiArray = new GraphicsApi[]{GraphicsApi.OPENGL, GraphicsApi.SOFTWARE_FAST, GraphicsApi.SOFTWARE_COMPAT};
                list2 = CollectionsKt.listOf((Object[])graphicsApiArray);
                break;
            }
            case 1: {
                GraphicsApi[] graphicsApiArray = new GraphicsApi[]{GraphicsApi.METAL, GraphicsApi.SOFTWARE_COMPAT};
                list2 = CollectionsKt.listOf((Object[])graphicsApiArray);
                break;
            }
            case 3: {
                GraphicsApi[] graphicsApiArray;
                if (WhenMappings.$EnumSwitchMapping$1[OsArch_jvmKt.getHostArch().ordinal()] == 1) {
                    graphicsApiArray = new GraphicsApi[]{GraphicsApi.DIRECT3D, GraphicsApi.SOFTWARE_FAST, GraphicsApi.SOFTWARE_COMPAT};
                    list2 = CollectionsKt.listOf((Object[])graphicsApiArray);
                    break;
                }
                graphicsApiArray = new GraphicsApi[]{GraphicsApi.DIRECT3D, GraphicsApi.OPENGL, GraphicsApi.SOFTWARE_FAST, GraphicsApi.SOFTWARE_COMPAT};
                list2 = CollectionsKt.listOf((Object[])graphicsApiArray);
                break;
            }
            case 4: {
                return CollectionsKt.listOf((Object)((Object)GraphicsApi.OPENGL));
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                String string = "commonize me";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List fallbackApis = list2;
        int indexOfInitialApi = fallbackApis.indexOf((Object)initialApi);
        if (!(indexOfInitialApi >= 0)) {
            boolean bl = false;
            String string = (Object)((Object)OsArch_jvmKt.getHostOs()) + " does not support " + (Object)((Object)initialApi) + " rendering API.";
            throw new IllegalArgumentException(string.toString());
        }
        fallbackApis = CollectionsKt.drop((Iterable)fallbackApis, (int)(indexOfInitialApi + 1));
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)((Object)initialApi)), (Iterable)fallbackApis);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.MacOS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Android.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.JS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Ios.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Tvos.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Unknown.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Arch.values().length];
            try {
                nArray[Arch.Arm64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

