/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.pass;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.ir.Function;
import org.llvm.ir.Module$IR;
import org.llvm.ir.PMDataManager;
import org.llvm.ir.PMStack;
import org.llvm.pass.AnalysisResolver;
import org.llvm.pass.AnalysisUsage;
import org.llvm.pass.ImmutablePass;
import org.llvm.pass.PassInfo;
import org.llvm.pass.PassKind;
import org.llvm.pass.PassManagerType;
import org.llvm.pass.PassRegistry;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public abstract class Pass
implements Destructors.ClassWithDestructor {
    private AnalysisResolver Resolver;
    private final Class<? extends Pass> PassID;
    private PassKind Kind;

    protected void $assign(Pass $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected Pass(Pass $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    public Pass(PassKind K, Class<? extends Pass> pid) {
        this.Resolver = null;
        this.PassID = pid;
        this.Kind = K;
    }

    public void $destroy() {
        Destructors.$destroy((Destructors.ClassWithDestructor)this.Resolver);
    }

    public PassKind getPassKind() {
        return this.Kind;
    }

    public char.ptr getPassName() {
        Object AID = this.getPassID();
        PassInfo PI = PassRegistry.getPassRegistry().getPassInfo(AID);
        if (PI != null) {
            return PI.getPassName();
        }
        return NativePointer.$((String)"Unnamed pass: implement Pass::getPassName()");
    }

    public Object getPassID() {
        return this.PassID;
    }

    public boolean doInitialization(Module$IR $Prm0) {
        return false;
    }

    public boolean doFinalization(Module$IR $Prm0) {
        return false;
    }

    public void print(raw_ostream O, Module$IR $Prm1) {
        O.$out("Pass::print not implemented for pass: '").$out(this.getPassName()).$out("'!\n");
    }

    public void dump() {
        this.print(llvm.dbgs(), null);
    }

    public abstract Pass createPrinterPass(raw_ostream var1, std.string var2);

    public void assignPassManager(PMStack $Prm0, PassManagerType $Prm1) {
    }

    public void preparePassManager(PMStack $Prm0) {
    }

    public PassManagerType getPotentialPassManagerType() {
        return PassManagerType.PMT_Unknown;
    }

    public void setResolver(AnalysisResolver AR) {
        assert (this.Resolver == null) : "Resolver is already set";
        this.Resolver = AR;
    }

    public AnalysisResolver getResolver() {
        return this.Resolver;
    }

    public void getAnalysisUsage(AnalysisUsage $Prm0) {
    }

    public void releaseMemory() {
    }

    public Object getAdjustedAnalysisPointer(Object AID) {
        return this;
    }

    public ImmutablePass getAsImmutablePass() {
        return null;
    }

    public PMDataManager getAsPMDataManager() {
        return null;
    }

    public void verifyAnalysis() {
    }

    public void dumpPassStructure() {
        this.dumpPassStructure(0);
    }

    public void dumpPassStructure(int Offset) {
        llvm.dbgs().indent(Offset * 2).$out(this.getPassName()).$out(NativePointer.$LF);
    }

    public static PassInfo lookupPassInfo(Object TI) {
        return PassRegistry.getPassRegistry().getPassInfo(TI);
    }

    public static PassInfo lookupPassInfo(StringRef Arg) {
        return PassRegistry.getPassRegistry().getPassInfo(new StringRef(Arg));
    }

    public static Pass createPass(Object ID2) {
        PassInfo PI = PassRegistry.getPassRegistry().getPassInfo(ID2);
        if (PI == null) {
            return null;
        }
        return PI.createPass();
    }

    public <AnalysisType> AnalysisType getAnalysisIfAvailable(Class<AnalysisType> cls) {
        assert (this.Resolver != null) : "Pass not resident in a PassManager object!";
        Class<AnalysisType> PI = cls;
        Pass ResultPass = this.Resolver.getAnalysisIfAvailable(PI, true);
        if (ResultPass == null) {
            return null;
        }
        return (AnalysisType)ResultPass.getAdjustedAnalysisPointer(PI);
    }

    public boolean mustPreserveAnalysisID(char.ref AID) {
        return this.Resolver.getAnalysisIfAvailable(AID.deref$ptr(), true) != null;
    }

    public <AnalysisType> AnalysisType getAnalysis(Class<AnalysisType> cls) {
        assert (this.Resolver != null) : "Pass has not been inserted into a PassManager object!";
        return this.getAnalysisID(cls);
    }

    public <AnalysisType> AnalysisType getAnalysis(Class<AnalysisType> cls, Function F) {
        assert (this.Resolver != null) : "Pass has not been inserted into a PassManager object!";
        return this.getAnalysisID(cls);
    }

    public <AnalysisType> AnalysisType getAnalysisID(Object PI) {
        assert (PI != null) : "getAnalysis for unregistered pass!";
        assert (this.Resolver != null) : "Pass has not been inserted into a PassManager object!";
        Pass ResultPass = this.Resolver.findImplPass(PI);
        assert (ResultPass != null) : "getAnalysis*() called on an analysis that was not 'required' by pass!";
        return (AnalysisType)Native.$Deref((Object)ResultPass.getAdjustedAnalysisPointer(PI));
    }

    public <AnalysisType> AnalysisType getAnalysisID(Object PI, Function F) {
        assert (PI != null) : "getAnalysis for unregistered pass!";
        assert (this.Resolver != null) : "Pass has not been inserted into a PassManager object!";
        Pass ResultPass = this.Resolver.findImplPass(this, PI, F);
        assert (ResultPass != null) : "Unable to find requested analysis info";
        return (AnalysisType)Native.$Deref((Object)ResultPass.getAdjustedAnalysisPointer(PI));
    }

    public String toString() {
        return "Resolver=" + this.Resolver + ", PassID=" + NativeTrace.getIdentityStr(this.PassID) + ", Kind=" + (Object)((Object)this.Kind);
    }
}

