/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.patternmatch;

import org.clank.support.Native;
import org.llvm.ir.OverflowingBinaryOperator;
import org.llvm.ir.Value;
import org.llvm.ir.java.IrRTTI;
import org.llvm.ir.java.match;

public class OverflowingBinaryOp_match<LHS_t extends match<LHS_t>, RHS_t extends match<RHS_t>>
implements match<OverflowingBinaryOp_match> {
    private final int Opcode;
    private final int WrapFlags;
    public LHS_t L;
    public RHS_t R;

    public OverflowingBinaryOp_match(int Opcode, int WrapFlags, LHS_t LHS, RHS_t RHS) {
        this.Opcode = Opcode;
        this.WrapFlags = WrapFlags;
        this.L = (match)Native.$Clone(LHS);
        this.R = (match)Native.$Clone(RHS);
    }

    @Override
    public <OpTy extends Value> boolean match(OpTy V) {
        OverflowingBinaryOperator Op = IrRTTI.dyn_cast_OverflowingBinaryOperator(V);
        if (Op != null) {
            if (Native.$noteq((int)Op.getOpcode(), (int)this.Opcode)) {
                return false;
            }
            if (Native.$bool((int)(this.WrapFlags & 1)) && Native.$not((boolean)Op.hasNoUnsignedWrap())) {
                return false;
            }
            if (Native.$bool((int)(this.WrapFlags & 2)) && Native.$not((boolean)Op.hasNoSignedWrap())) {
                return false;
            }
            return Native.$bool((boolean)this.L.match((Value)Op.getOperand(0))) && Native.$bool((boolean)this.R.match((Value)Op.getOperand(1)));
        }
        return false;
    }

    public OverflowingBinaryOp_match(OverflowingBinaryOp_match<LHS_t, RHS_t> other) {
        this.Opcode = other.Opcode;
        this.WrapFlags = other.WrapFlags;
        this.L = (match)Native.$Clone(other.L);
        this.R = (match)Native.$Clone(other.R);
    }

    public OverflowingBinaryOp_match clone() {
        return new OverflowingBinaryOp_match<LHS_t, RHS_t>(this);
    }

    public String toString() {
        return "L=" + this.L + ", R=" + this.R;
    }
}

