/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.intrinsic.impl;

import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.llvm.adt.OptionalPtr;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.ArrayRefUChar;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.SmallVectorImplUChar;
import org.llvm.adt.aliases.SmallVectorUChar;
import org.llvm.adt.java.SmallVectorImplCommon;
import org.llvm.ir.Function;
import org.llvm.ir.FunctionType;
import org.llvm.ir.IntegerType;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.Module$IR;
import org.llvm.ir.PointerType;
import org.llvm.ir.StructType;
import org.llvm.ir.Type;
import org.llvm.ir.VectorType;
import org.llvm.ir.gen.IntrinsicsGlobals;
import org.llvm.ir.impl.FunctionStatics;
import org.llvm.ir.intrinsic.IITDescriptor;
import org.llvm.ir.intrinsic.IntrinsicGlobals;
import org.llvm.ir.intrinsic.impl.FunctionIntrinsicGlobals$isOverloaded$$;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public final class FunctionIntrinsicGlobals {
    public static std.string getName(int id) {
        return FunctionIntrinsicGlobals.getName(id, (ArrayRef<Type>)new ArrayRef(llvm.None, true));
    }

    public static std.string getName(int id, ArrayRef<Type> Tys) {
        assert (Unsigned.$less_int((int)id, (int)6083)) : "Invalid intrinsic ID!";
        std.string Result2 = new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (char.ptr)FunctionStatics.IntrinsicNameTable.$at(id));
        for (Type Ty : Tys) {
            Result2.$addassign(std.$add_T$C$P_string((String)".", (std.string)FunctionStatics.getMangledTypeStr(Ty)));
        }
        return Result2;
    }

    public static FunctionType getType(LLVMContext Context, int id) {
        return FunctionIntrinsicGlobals.getType(Context, id, (ArrayRef<Type>)new ArrayRef(llvm.None, true));
    }

    public static FunctionType getType(LLVMContext Context, int id, ArrayRef<Type> Tys) {
        SmallVector Table = new SmallVector(8, (Object)new IITDescriptor());
        IntrinsicGlobals.getIntrinsicInfoTableEntries(id, (SmallVectorImpl<IITDescriptor>)Table);
        ArrayRef TableRef = new ArrayRef((SmallVectorImplCommon)Table, false);
        Type ResultTy = FunctionStatics.DecodeFixedType((ArrayRef<IITDescriptor>)TableRef, (ArrayRef<Type>)new ArrayRef(Tys), Context);
        SmallVector ArgTys = new SmallVector(8, (Object)null);
        while (!TableRef.empty()) {
            ArgTys.push_back((Object)FunctionStatics.DecodeFixedType((ArrayRef<IITDescriptor>)TableRef, (ArrayRef<Type>)new ArrayRef(Tys), Context));
        }
        if (!ArgTys.empty() && ((Type)ArgTys.back()).isVoidTy()) {
            ArgTys.pop_back();
            return FunctionType.get(ResultTy, (ArrayRef<Type>)new ArrayRef((SmallVectorImplCommon)ArgTys, true), true);
        }
        return FunctionType.get(ResultTy, (ArrayRef<Type>)new ArrayRef((SmallVectorImplCommon)ArgTys, true), false);
    }

    public static boolean isOverloaded(int id) {
        byte[] OTable = FunctionIntrinsicGlobals$isOverloaded$$.OTable;
        return (Unsigned.$uchar2int((byte)OTable[Unsigned.$div_int_uint((int)id, (int)8)]) & 1 << Unsigned.$rem_int_uint((int)id, (int)8)) != 0;
    }

    public static boolean isLeaf(int id) {
        switch (id) {
            default: {
                return true;
            }
            case 48: 
            case 50: 
            case 51: 
        }
        return false;
    }

    public static Function getDeclaration(Module$IR M, int id) {
        return FunctionIntrinsicGlobals.getDeclaration(M, id, (ArrayRef<Type>)new ArrayRef(llvm.None, true));
    }

    public static Function getDeclaration(Module$IR M, int id, ArrayRef<Type> Tys) {
        return IrRTTI.cast_Function(M.getOrInsertFunction(new StringRef(FunctionIntrinsicGlobals.getName(id, (ArrayRef<Type>)new ArrayRef(Tys))), IntrinsicGlobals.getType(M.getContext(), id, (ArrayRef<Type>)new ArrayRef(Tys))));
    }

    public static void getIntrinsicInfoTableEntries(int id, SmallVectorImpl<IITDescriptor> T2) {
        int TableVal = IntrinsicsGlobals.IIT_Table[id - 1];
        SmallVectorUChar IITValues = new SmallVectorUChar(8, 0);
        ArrayRefUChar IITEntries = new ArrayRefUChar();
        uint.ref NextElt = NativePointer.create_uint$ref((int)0);
        if (TableVal >>> 31 != 0) {
            IITEntries.$assignMove(new ArrayRefUChar(IntrinsicsGlobals.IIT_LongEncodingTable));
            NextElt.$set(TableVal << 1 >>> 1);
        } else {
            do {
                IITValues.push_back(Unsigned.$uint2uchar((int)(TableVal & 0xF)));
            } while ((TableVal >>>= 4) != 0);
            IITEntries.$assignMove(new ArrayRefUChar((SmallVectorImplUChar)IITValues));
            NextElt.$set(0);
        }
        FunctionStatics.DecodeIITType(NextElt, new ArrayRefUChar(IITEntries), T2);
        while (NextElt.$deref() != IITEntries.size() && Unsigned.$uchar2int((byte)IITEntries.$at(NextElt.$deref())) != 0) {
            FunctionStatics.DecodeIITType(NextElt, new ArrayRefUChar(IITEntries), T2);
        }
    }

    public static boolean matchIntrinsicType(Type Ty, ArrayRef<IITDescriptor> Infos, SmallVectorImpl<Type> ArgTys) {
        if (Infos.empty()) {
            return true;
        }
        IITDescriptor D2 = new IITDescriptor((IITDescriptor)Infos.front());
        Infos.$assignMove(Infos.slice(1));
        switch (D2.Kind) {
            case Void: {
                return !Ty.isVoidTy();
            }
            case VarArg: {
                return true;
            }
            case MMX: {
                return !Ty.isX86_MMXTy();
            }
            case Token: {
                return !Ty.isTokenTy();
            }
            case Metadata: {
                return !Ty.isMetadataTy();
            }
            case Half: {
                return !Ty.isHalfTy();
            }
            case Float: {
                return !Ty.isFloatTy();
            }
            case Double: {
                return !Ty.isDoubleTy();
            }
            case Integer: {
                return !Ty.isIntegerTy(D2.Unnamed_field1.Integer_Width);
            }
            case Vector: {
                VectorType VT = IrRTTI.dyn_cast_VectorType(Ty);
                return VT == null || VT.getNumElements() != D2.Unnamed_field1.Vector_Width || IntrinsicGlobals.matchIntrinsicType(VT.getElementType(), Infos, ArgTys);
            }
            case Pointer: {
                PointerType PT = IrRTTI.dyn_cast_PointerType(Ty);
                return PT == null || PT.getAddressSpace() != D2.Unnamed_field1.Pointer_AddressSpace || IntrinsicGlobals.matchIntrinsicType(PT.getElementType(), Infos, ArgTys);
            }
            case Struct: {
                StructType ST = IrRTTI.dyn_cast_StructType(Ty);
                if (ST == null || ST.getNumElements() != D2.Unnamed_field1.Struct_NumElements) {
                    return true;
                }
                int e = D2.Unnamed_field1.Struct_NumElements;
                for (int i = 0; i != e; ++i) {
                    if (!IntrinsicGlobals.matchIntrinsicType(ST.getElementType(i), Infos, ArgTys)) continue;
                    return true;
                }
                return false;
            }
            case Argument: {
                if (Unsigned.$less_uint((int)D2.getArgumentNumber(), (int)ArgTys.size())) {
                    return Ty != ArgTys.$at(D2.getArgumentNumber());
                }
                assert (D2.getArgumentNumber() == ArgTys.size()) : "Table consistency error";
                ArgTys.push_back((Object)Ty);
                switch (D2.getArgumentKind()) {
                    case AK_Any: {
                        return false;
                    }
                    case AK_AnyInteger: {
                        return !Ty.isIntOrIntVectorTy();
                    }
                    case AK_AnyFloat: {
                        return !Ty.isFPOrFPVectorTy();
                    }
                    case AK_AnyVector: {
                        return !IrRTTI.isa_VectorType(Ty);
                    }
                    case AK_AnyPointer: {
                        return !IrRTTI.isa_PointerType(Ty);
                    }
                }
                throw new llvm_unreachable("all argument kinds not covered");
            }
            case ExtendArgument: {
                if (Unsigned.$greatereq_uint((int)D2.getArgumentNumber(), (int)ArgTys.size())) {
                    return true;
                }
                Type NewTy = (Type)ArgTys.$at(D2.getArgumentNumber());
                VectorType VTy = IrRTTI.dyn_cast_VectorType(NewTy);
                if (VTy != null) {
                    NewTy = VectorType.getExtendedElementVectorType(VTy);
                } else {
                    IntegerType ITy = IrRTTI.dyn_cast_IntegerType(NewTy);
                    if (ITy != null) {
                        NewTy = IntegerType.get(ITy.getContext(), 2 * ITy.getBitWidth());
                    } else {
                        return true;
                    }
                }
                return Ty != NewTy;
            }
            case TruncArgument: {
                if (Unsigned.$greatereq_uint((int)D2.getArgumentNumber(), (int)ArgTys.size())) {
                    return true;
                }
                Type NewTy = (Type)ArgTys.$at(D2.getArgumentNumber());
                VectorType VTy = IrRTTI.dyn_cast_VectorType(NewTy);
                if (VTy != null) {
                    NewTy = VectorType.getTruncatedElementVectorType(VTy);
                } else {
                    IntegerType ITy = IrRTTI.dyn_cast_IntegerType(NewTy);
                    if (ITy != null) {
                        NewTy = IntegerType.get(ITy.getContext(), Unsigned.$div_uint((int)ITy.getBitWidth(), (int)2));
                    } else {
                        return true;
                    }
                }
                return Ty != NewTy;
            }
            case HalfVecArgument: {
                return Unsigned.$greatereq_uint((int)D2.getArgumentNumber(), (int)ArgTys.size()) || !IrRTTI.isa_VectorType((Type)ArgTys.$at(D2.getArgumentNumber())) || VectorType.getHalfElementsVectorType(IrRTTI.cast_VectorType((Type)ArgTys.$at(D2.getArgumentNumber()))) != Ty;
            }
            case SameVecWidthArgument: {
                if (Unsigned.$greatereq_uint((int)D2.getArgumentNumber(), (int)ArgTys.size())) {
                    return true;
                }
                VectorType ReferenceType = IrRTTI.dyn_cast_VectorType((Type)ArgTys.$at(D2.getArgumentNumber()));
                VectorType ThisArgType = IrRTTI.dyn_cast_VectorType(Ty);
                if (ThisArgType == null || ReferenceType == null || ReferenceType.getVectorNumElements() != ThisArgType.getVectorNumElements()) {
                    return true;
                }
                return IntrinsicGlobals.matchIntrinsicType(ThisArgType.getVectorElementType(), Infos, ArgTys);
            }
            case PtrToArgument: {
                if (Unsigned.$greatereq_uint((int)D2.getArgumentNumber(), (int)ArgTys.size())) {
                    return true;
                }
                Type ReferenceType = (Type)ArgTys.$at(D2.getArgumentNumber());
                PointerType ThisArgType = IrRTTI.dyn_cast_PointerType(Ty);
                return ThisArgType == null || ThisArgType.getElementType() != ReferenceType;
            }
            case VecOfPtrsToElt: {
                if (Unsigned.$greatereq_uint((int)D2.getArgumentNumber(), (int)ArgTys.size())) {
                    return true;
                }
                VectorType ReferenceType = IrRTTI.dyn_cast_VectorType((Type)ArgTys.$at(D2.getArgumentNumber()));
                VectorType ThisArgVecTy = IrRTTI.dyn_cast_VectorType(Ty);
                if (ThisArgVecTy == null || ReferenceType == null || ReferenceType.getVectorNumElements() != ThisArgVecTy.getVectorNumElements()) {
                    return true;
                }
                PointerType ThisArgEltTy = IrRTTI.dyn_cast_PointerType(ThisArgVecTy.getVectorElementType());
                if (ThisArgEltTy == null) {
                    return true;
                }
                return ThisArgEltTy.getElementType() != ReferenceType.getVectorElementType();
            }
        }
        throw new llvm_unreachable("unhandled");
    }

    public static boolean matchIntrinsicVarArg(boolean isVarArg, ArrayRef<IITDescriptor> Infos) {
        if (Infos.empty()) {
            return isVarArg;
        }
        if (Infos.size() != 1) {
            return true;
        }
        IITDescriptor D2 = new IITDescriptor((IITDescriptor)Infos.front());
        Infos.$assignMove(Infos.slice(1));
        if (D2.Kind == IITDescriptor.IITDescriptorKind.VarArg) {
            return !isVarArg;
        }
        return true;
    }

    public static OptionalPtr<Function> remangleIntrinsicFunction(Function F) {
        int ID2 = F.getIntrinsicID();
        if (ID2 == 0) {
            return new OptionalPtr(llvm.None);
        }
        FunctionType FTy = F.getFunctionType();
        SmallVector ArgTys = new SmallVector(4, (Object)null);
        SmallVector Table = new SmallVector(8, (Object)new IITDescriptor());
        IntrinsicGlobals.getIntrinsicInfoTableEntries(ID2, (SmallVectorImpl<IITDescriptor>)Table);
        ArrayRef TableRef = new ArrayRef((SmallVectorImplCommon)Table, false);
        if (FunctionIntrinsicGlobals.matchIntrinsicType(FTy.getReturnType(), (ArrayRef<IITDescriptor>)TableRef, (SmallVectorImpl<Type>)ArgTys)) {
            return new OptionalPtr(llvm.None);
        }
        for (Type Ty : FTy.params()) {
            if (!FunctionIntrinsicGlobals.matchIntrinsicType(Ty, (ArrayRef<IITDescriptor>)TableRef, (SmallVectorImpl<Type>)ArgTys)) continue;
            return new OptionalPtr(llvm.None);
        }
        if (FunctionIntrinsicGlobals.matchIntrinsicVarArg(FTy.isVarArg(), (ArrayRef<IITDescriptor>)TableRef)) {
            return new OptionalPtr(llvm.None);
        }
        StringRef Name = F.getName();
        if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(FunctionIntrinsicGlobals.getName(ID2, (ArrayRef<Type>)new ArrayRef((SmallVectorImplCommon)ArgTys, true))))) {
            return new OptionalPtr(llvm.None);
        }
        Function NewDecl = FunctionIntrinsicGlobals.getDeclaration((Module$IR)F.getParent(), ID2, (ArrayRef<Type>)new ArrayRef((SmallVectorImplCommon)ArgTys, true));
        NewDecl.setCallingConv(F.getCallingConv());
        assert (NewDecl.getFunctionType() == FTy) : "Shouldn't change the signature";
        return new OptionalPtr(JavaDifferentiators.JD$T$RR.INSTANCE, (Object)NewDecl);
    }
}

