/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.ir.DiagnosticInfoIgnoringInvalidDebugMetadata;
import org.llvm.ir.Function;
import org.llvm.ir.Module$IR;
import org.llvm.ir.impl.Verifier;
import org.llvm.pass.AnalysisUsage;
import org.llvm.pass.FunctionPass;
import org.llvm.pass.IrLlvmGlobals;
import org.llvm.pass.PassRegistry;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class VerifierLegacyPass
extends FunctionPass
implements Destructors.ClassWithDestructor {
    public Verifier V = new Verifier((raw_ostream)Native.$AddrOf((Object)llvm.dbgs()), false);
    public boolean FatalErrors;
    public static final Class<VerifierLegacyPass> ID = VerifierLegacyPass.class;

    public VerifierLegacyPass() {
        super(ID);
        this.FatalErrors = true;
        IrLlvmGlobals.initializeVerifierLegacyPassPass((PassRegistry)Native.$Deref((Object)PassRegistry.getPassRegistry()));
    }

    public VerifierLegacyPass(boolean FatalErrors) {
        super(ID);
        this.FatalErrors = FatalErrors;
        IrLlvmGlobals.initializeVerifierLegacyPassPass((PassRegistry)Native.$Deref((Object)PassRegistry.getPassRegistry()));
    }

    @Override
    public boolean runOnFunction(Function F) {
        if (!this.V.verify(F) && this.FatalErrors) {
            llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Broken function found, compilation aborted!"));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doFinalization(Module$IR M) {
        boolean HasErrors = false;
        for (Function F : M) {
            if (!F.isDeclaration()) continue;
            HasErrors |= !this.V.verify(F);
        }
        HasErrors |= !this.V.verify(M);
        if (this.FatalErrors) {
            if (HasErrors) {
                llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Broken module found, compilation aborted!"));
            }
            assert (!this.V.hasBrokenDebugInfo()) : "Module contains invalid debug info";
        }
        if (this.V.hasBrokenDebugInfo()) {
            DiagnosticInfoIgnoringInvalidDebugMetadata DiagInvalid = null;
            try {
                DiagInvalid = new DiagnosticInfoIgnoringInvalidDebugMetadata(M);
                M.getContext().diagnose(DiagInvalid);
                if (!IrLlvmGlobals.StripDebugInfo(M)) {
                    llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Failed to strip malformed debug info"));
                }
            }
            finally {
                if (DiagInvalid != null) {
                    DiagInvalid.$destroy();
                }
            }
        }
        return false;
    }

    @Override
    public void getAnalysisUsage(AnalysisUsage AU) {
        AU.setPreservesAll();
    }

    @Override
    public void $destroy() {
        this.V.$destroy();
        super.$destroy();
    }

    @Override
    public String toString() {
        return "V=" + this.V + ", FatalErrors=" + this.FatalErrors + super.toString();
    }
}

