/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.java.std;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.aliases.DenseMapInfo;
import org.llvm.adt.aliases.DenseMapIteratorTypeUInt;
import org.llvm.adt.aliases.DenseMapTypeUInt;
import org.llvm.ir.ArrayType;
import org.llvm.ir.FunctionType;
import org.llvm.ir.Module$IR;
import org.llvm.ir.PointerType;
import org.llvm.ir.StructType;
import org.llvm.ir.Type;
import org.llvm.ir.TypeFinder;
import org.llvm.ir.VectorType;
import org.llvm.ir.impl.AsmWriterStatics;
import org.llvm.ir.impl.PrefixType;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;

public class TypePrinting
implements Destructors.ClassWithDestructor {
    public TypeFinder NamedTypes;
    public DenseMapTypeUInt<StructType> NumberedTypes;

    protected TypePrinting(TypePrinting $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected void $assign(TypePrinting $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    public TypePrinting() {
        this.NamedTypes = new TypeFinder();
        this.NumberedTypes = new DenseMapTypeUInt((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 0);
    }

    public void incorporateTypes(Module$IR M) {
        this.NamedTypes.run(M, false);
        int NextNumber = 0;
        StdVector.iterator<StructType> NextToUse = this.NamedTypes.begin();
        StdVector.iterator<StructType> I = this.NamedTypes.begin();
        StdVector.iterator<StructType> E = this.NamedTypes.end();
        while (std.$noteq___normal_iterator$C(I, E)) {
            StructType STy = (StructType)I.$star();
            if (!STy.isLiteral()) {
                if (STy.getName().empty()) {
                    this.NumberedTypes.$set((Object)STy, NextNumber++);
                } else {
                    ((StdVector.iterator)NextToUse.$postInc(0)).star$ref().$set((Object)STy);
                }
            }
            I.$preInc();
        }
        this.NamedTypes.erase((StdVector.iterator<StructType>)new StdVector.iterator(NextToUse), this.NamedTypes.end());
    }

    public void print(Type Ty, raw_ostream OS) {
        switch (Ty.getTypeID()) {
            case VoidTyID: {
                OS.$out(NativePointer.$void);
                return;
            }
            case HalfTyID: {
                OS.$out(NativePointer.$half);
                return;
            }
            case FloatTyID: {
                OS.$out(NativePointer.$float);
                return;
            }
            case DoubleTyID: {
                OS.$out(NativePointer.$double);
                return;
            }
            case X86_FP80TyID: {
                OS.$out("x86_fp80");
                return;
            }
            case FP128TyID: {
                OS.$out("fp128");
                return;
            }
            case PPC_FP128TyID: {
                OS.$out("ppc_fp128");
                return;
            }
            case LabelTyID: {
                OS.$out("label");
                return;
            }
            case MetadataTyID: {
                OS.$out("metadata");
                return;
            }
            case X86_MMXTyID: {
                OS.$out("x86_mmx");
                return;
            }
            case TokenTyID: {
                OS.$out("token");
                return;
            }
            case IntegerTyID: {
                OS.$out_char((byte)105).$out_uint(IrRTTI.cast_IntegerType(Ty).getBitWidth());
                return;
            }
            case FunctionTyID: {
                FunctionType FTy = IrRTTI.cast_FunctionType(Ty);
                this.print(FTy.getReturnType(), OS);
                OS.$out(" (");
                type.ptr I = (type.ptr)Native.$tryClone(FTy.param_begin());
                type.ptr E = (type.ptr)Native.$tryClone(FTy.param_end());
                while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
                    if (Native.$noteq_ptr((void.ptr)I, FTy.param_begin())) {
                        OS.$out(NativePointer.$COMMA_SPACE);
                    }
                    this.print((Type)I.$star(), OS);
                    I.$preInc();
                }
                if (FTy.isVarArg()) {
                    if (FTy.getNumParams() != 0) {
                        OS.$out(NativePointer.$COMMA_SPACE);
                    }
                    OS.$out(NativePointer.$ELLIPSIS);
                }
                OS.$out_char((byte)41);
                return;
            }
            case StructTyID: {
                StructType STy = IrRTTI.cast_StructType(Ty);
                if (STy.isLiteral()) {
                    this.printStructBody(STy, OS);
                    return;
                }
                if (!STy.getName().empty()) {
                    AsmWriterStatics.PrintLLVMName(OS, STy.getName(), PrefixType.LocalPrefix);
                    return;
                }
                DenseMapIteratorTypeUInt I = this.NumberedTypes.find((Object)STy);
                if (I.$noteq(this.NumberedTypes.end())) {
                    OS.$out_char((byte)37).$out_uint(I.$arrow().second);
                } else {
                    OS.$out("%\"type ").$out((Object)STy).$out_char((byte)34);
                }
                return;
            }
            case PointerTyID: {
                PointerType PTy = IrRTTI.cast_PointerType(Ty);
                this.print(PTy.getElementType(), OS);
                int AddressSpace = PTy.getAddressSpace();
                if (AddressSpace != 0) {
                    OS.$out(" addrspace(").$out_uint(AddressSpace).$out_char((byte)41);
                }
                OS.$out_char((byte)42);
                return;
            }
            case ArrayTyID: {
                ArrayType ATy = IrRTTI.cast_ArrayType(Ty);
                OS.$out_char((byte)91).$out_ullong(ATy.getNumElements()).$out(" x ");
                this.print(ATy.getElementType(), OS);
                OS.$out_char((byte)93);
                return;
            }
            case VectorTyID: {
                VectorType PTy = IrRTTI.cast_VectorType(Ty);
                OS.$out(NativePointer.$LT).$out_uint(PTy.getNumElements()).$out(" x ");
                this.print(PTy.getElementType(), OS);
                OS.$out_char((byte)62);
                return;
            }
        }
        throw new llvm_unreachable("Invalid TypeID");
    }

    public void printStructBody(StructType STy, raw_ostream OS) {
        if (STy.isOpaque()) {
            OS.$out("opaque");
            return;
        }
        if (STy.isPacked()) {
            OS.$out_char((byte)60);
        }
        if (STy.getNumElements() == 0) {
            OS.$out("{}");
        } else {
            type.ptr I = (type.ptr)Native.$tryClone(STy.element_begin());
            OS.$out("{ ");
            this.print((Type)((type.ptr)I.$postInc()).$star(), OS);
            type.ptr E = (type.ptr)Native.$tryClone(STy.element_end());
            while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
                OS.$out(NativePointer.$COMMA_SPACE);
                this.print((Type)I.$star(), OS);
                I.$preInc();
            }
            OS.$out(" }");
        }
        if (STy.isPacked()) {
            OS.$out_char((byte)62);
        }
    }

    public void $destroy() {
        this.NumberedTypes.$destroy();
        this.NamedTypes.$destroy();
    }

    public String toString() {
        return "NamedTypes=" + this.NamedTypes + ", NumberedTypes=" + this.NumberedTypes;
    }
}

