/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.NativePointer;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class LineConsumer
implements Destructors.ClassWithDestructor {
    private std_ptr.unique_ptr<MemoryBuffer> Buffer;
    private StringRef Remaining;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineConsumer(StringRef Filename) {
        this.Buffer = new std_ptr.unique_ptr();
        this.Remaining = new StringRef();
        ErrorOr BufferOrErr = null;
        try {
            BufferOrErr = MemoryBuffer.getFileOrSTDIN((Twine)new Twine(Filename));
            std_errors.error_code EC = BufferOrErr.getError();
            if (EC.$bool()) {
                llvm.errs().$out(Filename).$out(": ").$out(EC.message()).$out(NativePointer.$LF);
                this.Remaining.$assignMove(NativePointer.$EMPTY);
            } else {
                this.Buffer.$assignMove((std_ptr.unique_ptr)std.move((Object)((std_ptr.unique_ptr)BufferOrErr.get())));
                this.Remaining.$assignMove(((MemoryBuffer)this.Buffer.$arrow()).getBuffer());
            }
        }
        finally {
            if (BufferOrErr != null) {
                BufferOrErr.$destroy();
            }
        }
    }

    public boolean empty() {
        return this.Remaining.empty();
    }

    public void printNext(raw_ostream OS, int LineNum) {
        StringRef Line = new StringRef();
        if (this.empty()) {
            Line.$assignMove("/*EOF*/");
        } else {
            std.tie((Object)Line, (Object)this.Remaining).$assign((std_pair.pair)this.Remaining.split("\n"));
        }
        OS.$out(llvm.format_uint((String)"%5u:", (int)LineNum)).$out(Line).$out(NativePointer.$LF);
    }

    public LineConsumer(JavaDifferentiators.JD.Move _dparam, LineConsumer $Prm0) {
        this.Buffer = new std_ptr.unique_ptr(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Buffer);
        this.Remaining = new StringRef(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Remaining);
    }

    public void $destroy() {
        this.Buffer.$destroy();
    }

    public String toString() {
        return "Buffer=" + this.Buffer + ", Remaining=" + this.Remaining;
    }
}

