/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.HashingGlobals;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.ArrayRefUInt;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantExpr;
import org.llvm.ir.Instruction;
import org.llvm.ir.Type;
import org.llvm.ir.impl.BinaryConstantExpr;
import org.llvm.ir.impl.CompareConstantExpr;
import org.llvm.ir.impl.ExtractElementConstantExpr;
import org.llvm.ir.impl.ExtractValueConstantExpr;
import org.llvm.ir.impl.GetElementPtrConstantExpr;
import org.llvm.ir.impl.InsertElementConstantExpr;
import org.llvm.ir.impl.InsertValueConstantExpr;
import org.llvm.ir.impl.SelectConstantExpr;
import org.llvm.ir.impl.ShuffleVectorConstantExpr;
import org.llvm.ir.impl.UnaryConstantExpr;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public class ConstantExprKeyType
implements Native.NativeComparable<ConstantExprKeyType> {
    public byte Opcode;
    public byte SubclassOptionalData;
    public char SubclassData;
    public ArrayRef<Constant> Ops;
    public ArrayRefUInt Indexes;
    public Type ExplicitTy;

    public ConstantExprKeyType(int Opcode, ArrayRef<Constant> Ops) {
        this(Opcode, Ops, Unsigned.$int2ushort((int)0), Unsigned.$int2ushort((int)0), new ArrayRefUInt(llvm.None), null);
    }

    public ConstantExprKeyType(int Opcode, ArrayRef<Constant> Ops, char SubclassData) {
        this(Opcode, Ops, SubclassData, Unsigned.$int2ushort((int)0), new ArrayRefUInt(llvm.None), null);
    }

    public ConstantExprKeyType(int Opcode, ArrayRef<Constant> Ops, char SubclassData, char SubclassOptionalData) {
        this(Opcode, Ops, SubclassData, SubclassOptionalData, new ArrayRefUInt(llvm.None), null);
    }

    public ConstantExprKeyType(int Opcode, ArrayRef<Constant> Ops, char SubclassData, char SubclassOptionalData, ArrayRefUInt Indexes) {
        this(Opcode, Ops, SubclassData, SubclassOptionalData, Indexes, null);
    }

    public ConstantExprKeyType(int Opcode, ArrayRef<Constant> Ops, char SubclassData, char SubclassOptionalData, ArrayRefUInt Indexes, Type ExplicitTy) {
        this.Opcode = Unsigned.$uint2uchar((int)Opcode);
        this.SubclassOptionalData = Unsigned.$ushort2uchar((char)SubclassOptionalData);
        this.SubclassData = SubclassData;
        this.Ops = new ArrayRef(Ops);
        this.Indexes = new ArrayRefUInt(Indexes);
        this.ExplicitTy = ExplicitTy;
    }

    public ConstantExprKeyType(ArrayRef<Constant> Operands, ConstantExpr CE) {
        this.Opcode = Unsigned.$uint2uchar((int)CE.getOpcode());
        this.SubclassOptionalData = Unsigned.$uint2uchar((int)CE.getRawSubclassOptionalData());
        this.SubclassData = Unsigned.$uint2ushort((int)(CE.isCompare() ? CE.getPredicate() : 0));
        this.Ops = new ArrayRef(Operands);
        this.Indexes = CE.hasIndices() ? CE.getIndices() : new ArrayRefUInt();
    }

    public ConstantExprKeyType(ConstantExpr CE, SmallVectorImpl<Constant> Storage) {
        this.Opcode = Unsigned.$uint2uchar((int)CE.getOpcode());
        this.SubclassOptionalData = Unsigned.$uint2uchar((int)CE.getRawSubclassOptionalData());
        this.SubclassData = Unsigned.$uint2ushort((int)(CE.isCompare() ? CE.getPredicate() : 0));
        this.Ops = new ArrayRef(true);
        ArrayRefUInt arrayRefUInt = this.Indexes = CE.hasIndices() ? CE.getIndices() : new ArrayRefUInt();
        assert (Storage.empty()) : "Expected empty storage";
        int E = CE.getNumOperands();
        for (int I = 0; I != E; ++I) {
            Storage.push_back((Object)CE.getOperand_Constant(I));
        }
        this.Ops.$assignMove(new ArrayRef(Storage, true));
    }

    public boolean $eq(ConstantExprKeyType X) {
        return Unsigned.$uchar2int((byte)this.Opcode) == Unsigned.$uchar2int((byte)X.Opcode) && Unsigned.$ushort2int((char)this.SubclassData) == Unsigned.$ushort2int((char)X.SubclassData) && Unsigned.$uchar2int((byte)this.SubclassOptionalData) == Unsigned.$uchar2int((byte)X.SubclassOptionalData) && llvm.$eq_ArrayRef$T(this.Ops, X.Ops) && llvm.$eq_ArrayRef$T((ArrayRefUInt)this.Indexes, (ArrayRefUInt)X.Indexes);
    }

    public boolean $eq(ConstantExpr CE) {
        if (Unsigned.$uchar2uint((byte)this.Opcode) != CE.getOpcode()) {
            return false;
        }
        if (Unsigned.$uchar2uint((byte)this.SubclassOptionalData) != CE.getRawSubclassOptionalData()) {
            return false;
        }
        if (this.Ops.size() != CE.getNumOperands()) {
            return false;
        }
        if (Unsigned.$ushort2uint((char)this.SubclassData) != (CE.isCompare() ? CE.getPredicate() : 0)) {
            return false;
        }
        int E = this.Ops.size();
        for (int I = 0; I != E; ++I) {
            if (this.Ops.$at(I) == CE.getOperand_Constant(I)) continue;
            return false;
        }
        return !llvm.$noteq_ArrayRef$T((ArrayRefUInt)this.Indexes, (ArrayRefUInt)(CE.hasIndices() ? CE.getIndices() : new ArrayRefUInt()));
    }

    public int getHash() {
        return HashingGlobals.hash_combine((byte)this.Opcode, (byte)this.SubclassOptionalData, (char)this.SubclassData, (HashingGlobals.hash_code)HashingGlobals.hash_combine_range_ptrs((type.ptr)this.Ops.begin(), (type.ptr)this.Ops.end()), (HashingGlobals.hash_code)HashingGlobals.hash_combine_range((uint.ptr)this.Indexes.begin(), (uint.ptr)this.Indexes.end())).$uint();
    }

    public ConstantExpr create(Type Ty) {
        switch (Unsigned.$uchar2int((byte)this.Opcode)) {
            default: {
                if (Instruction.isCast(Unsigned.$uchar2uint((byte)this.Opcode))) {
                    return UnaryConstantExpr.$new_UnaryConstantExpr(New$Mem -> new UnaryConstantExpr(Unsigned.$uchar2uint((byte)this.Opcode), (Constant)this.Ops.$at(0), Ty));
                }
                if (Unsigned.$uchar2int((byte)this.Opcode) >= 11 && Unsigned.$uchar2int((byte)this.Opcode) < 29) {
                    return BinaryConstantExpr.$new_BinaryConstantExpr(New$Mem -> new BinaryConstantExpr(Unsigned.$uchar2uint((byte)this.Opcode), (Constant)this.Ops.$at(0), (Constant)this.Ops.$at(1), Unsigned.$uchar2uint((byte)this.SubclassOptionalData)));
                }
                throw new llvm_unreachable("Invalid ConstantExpr!");
            }
            case 55: {
                return SelectConstantExpr.$new_SelectConstantExpr(New$Mem -> new SelectConstantExpr((Constant)this.Ops.$at(0), (Constant)this.Ops.$at(1), (Constant)this.Ops.$at(2)));
            }
            case 59: {
                return ExtractElementConstantExpr.$new_ExtractElementConstantExpr(New$Mem -> new ExtractElementConstantExpr((Constant)this.Ops.$at(0), (Constant)this.Ops.$at(1)));
            }
            case 60: {
                return InsertElementConstantExpr.$new_InsertElementConstantExpr(New$Mem -> new InsertElementConstantExpr((Constant)this.Ops.$at(0), (Constant)this.Ops.$at(1), (Constant)this.Ops.$at(2)));
            }
            case 61: {
                return ShuffleVectorConstantExpr.$new_ShuffleVectorConstantExpr(New$Mem -> new ShuffleVectorConstantExpr((Constant)this.Ops.$at(0), (Constant)this.Ops.$at(1), (Constant)this.Ops.$at(2)));
            }
            case 63: {
                return InsertValueConstantExpr.$new_InsertValueConstantExpr(New$Mem -> new InsertValueConstantExpr((Constant)this.Ops.$at(0), (Constant)this.Ops.$at(1), new ArrayRefUInt(this.Indexes), Ty));
            }
            case 62: {
                return ExtractValueConstantExpr.$new_ExtractValueConstantExpr(New$Mem -> new ExtractValueConstantExpr((Constant)this.Ops.$at(0), new ArrayRefUInt(this.Indexes), Ty));
            }
            case 32: {
                return GetElementPtrConstantExpr.Create(this.ExplicitTy != null ? this.ExplicitTy : IrRTTI.cast_PointerType(((Constant)this.Ops.$at(0)).getType().getScalarType()).getElementType(), (Constant)this.Ops.$at(0), (ArrayRef<Constant>)this.Ops.slice(1), Ty, Unsigned.$uchar2uint((byte)this.SubclassOptionalData));
            }
            case 51: {
                return CompareConstantExpr.$new_CompareConstantExpr(New$Mem -> new CompareConstantExpr(Ty, 51, this.SubclassData, (Constant)this.Ops.$at(0), (Constant)this.Ops.$at(1)));
            }
            case 52: 
        }
        return CompareConstantExpr.$new_CompareConstantExpr(New$Mem -> new CompareConstantExpr(Ty, 52, this.SubclassData, (Constant)this.Ops.$at(0), (Constant)this.Ops.$at(1)));
    }

    public ConstantExprKeyType(ConstantExprKeyType $Prm0) {
        this.Opcode = $Prm0.Opcode;
        this.SubclassOptionalData = $Prm0.SubclassOptionalData;
        this.SubclassData = $Prm0.SubclassData;
        this.Ops = new ArrayRef($Prm0.Ops);
        this.Indexes = new ArrayRefUInt($Prm0.Indexes);
        this.ExplicitTy = $Prm0.ExplicitTy;
    }

    public ConstantExprKeyType(JavaDifferentiators.JD.Move _dparam, ConstantExprKeyType $Prm0) {
        this.Opcode = $Prm0.Opcode;
        this.SubclassOptionalData = $Prm0.SubclassOptionalData;
        this.SubclassData = $Prm0.SubclassData;
        this.Ops = new ArrayRef(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Ops);
        this.Indexes = new ArrayRefUInt(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Indexes);
        this.ExplicitTy = $Prm0.ExplicitTy;
    }

    public String toString() {
        return "Opcode=" + Unsigned.$uchar2uint((byte)this.Opcode) + ", SubclassOptionalData=" + Unsigned.$uchar2uint((byte)this.SubclassOptionalData) + ", SubclassData=" + Unsigned.$ushort2uint((char)this.SubclassData) + ", Ops=" + this.Ops + ", Indexes=" + this.Indexes + ", ExplicitTy=" + this.ExplicitTy;
    }
}

