/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.support.NativeCallback;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.ir.IntegerType;
import org.llvm.ir.SequentialType;
import org.llvm.ir.Type;
import org.llvm.ir.impl.LLVMContextImpl;
import org.llvm.support.BumpPtrAllocatorImpl;

public class VectorType
extends SequentialType {
    private int NumElements;

    protected VectorType(VectorType $Prm0) {
        super($Prm0);
        throw new UnsupportedOperationException("Deleted");
    }

    protected VectorType $assign(VectorType $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private VectorType(Type ElType, int NumEl) {
        super(Type.TypeID.VectorTyID, ElType);
        this.NumElements = NumEl;
    }

    public static VectorType get(Type ElementType, int NumElements) {
        assert (Unsigned.$greater_uint((int)NumElements, (int)0)) : "#Elements of a VectorType must be greater than 0";
        assert (VectorType.isValidElementType(ElementType)) : "Element type of a VectorType must be an integer, floating point, or pointer type.";
        LLVMContextImpl pImpl = ElementType.getContext().pImpl;
        type.ref Entry2 = ElementType.getContext().pImpl.VectorTypes.ref$at((Object)std.make_pair_Ptr_uint((Object)ElementType, (int)NumElements));
        if (Entry2.$deref() == null) {
            Entry2.$set((Object)((VectorType)VectorType.$new_uint_BumpPtrAllocatorImpl$AllocatorT(pImpl.TypeAllocator, New$Mem -> new VectorType(ElementType, NumElements))));
        }
        return (VectorType)Entry2.$deref();
    }

    public static VectorType getInteger(VectorType VTy) {
        int EltBits = VTy.getElementType().getPrimitiveSizeInBits();
        assert (EltBits != 0) : "Element size must be of a non-zero size";
        IntegerType EltTy = IntegerType.get(VTy.getContext(), EltBits);
        return VectorType.get(EltTy, VTy.getNumElements());
    }

    public static VectorType getExtendedElementVectorType(VectorType VTy) {
        int EltBits = VTy.getElementType().getPrimitiveSizeInBits();
        IntegerType EltTy = IntegerType.get(VTy.getContext(), EltBits * 2);
        return VectorType.get(EltTy, VTy.getNumElements());
    }

    public static VectorType getTruncatedElementVectorType(VectorType VTy) {
        int EltBits = VTy.getElementType().getPrimitiveSizeInBits();
        assert ((EltBits & 1) == 0) : "Cannot truncate vector element with odd bit-width";
        IntegerType EltTy = IntegerType.get(VTy.getContext(), Unsigned.$div_uint((int)EltBits, (int)2));
        return VectorType.get(EltTy, VTy.getNumElements());
    }

    public static VectorType getHalfElementsVectorType(VectorType VTy) {
        int NumElts = VTy.getNumElements();
        assert ((NumElts & 1) == 0) : "Cannot halve vector with odd number of elements.";
        return VectorType.get(VTy.getElementType(), Unsigned.$div_uint((int)NumElts, (int)2));
    }

    public static VectorType getDoubleElementsVectorType(VectorType VTy) {
        int NumElts = VTy.getNumElements();
        return VectorType.get(VTy.getElementType(), NumElts * 2);
    }

    public static boolean isValidElementType(Type ElemTy) {
        return ElemTy.isIntegerTy() || ElemTy.isFloatingPointTy() || ElemTy.isPointerTy();
    }

    public int getNumElements() {
        return this.NumElements;
    }

    public int getBitWidth() {
        return this.NumElements * this.getElementType().getPrimitiveSizeInBits();
    }

    public static boolean classof(Type T2) {
        return T2.getTypeID() == Type.TypeID.VectorTyID;
    }

    protected static <T> T $new_uint_BumpPtrAllocatorImpl$AllocatorT(BumpPtrAllocatorImpl alloc, NativeCallback.New.ConstructorCallback<T> New$Type) {
        return (T)New$Type.$call(null);
    }

    @Override
    public String toString() {
        return "NumElements=" + this.NumElements + super.toString();
    }
}

