/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.type;
import org.clank.support.type;
import org.clank.support.void;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.DenseMapInfo;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.ir.CallbackVH;
import org.llvm.ir.Type;
import org.llvm.ir.Value;
import org.llvm.ir.impl.LLVMContextImpl;
import org.llvm.pass.IrLlvmGlobals;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public class ValueHandleBase
implements NativeCloneable<ValueHandleBase>,
NativeMoveable<ValueHandleBase>,
Destructors.ClassWithDestructor {
    private final ADTAliases.PointerEnum2Pair<type.ref<ValueHandleBase>, HandleBaseKind> PrevPair;
    private ValueHandleBase Next;
    private Value V;
    private final type.ref<ValueHandleBase> Next$Ref = new type.ptr.inout<ValueHandleBase>((Object)this){

        protected ValueHandleBase $star$impl() {
            return ValueHandleBase.this.Next;
        }

        protected ValueHandleBase $set$impl(ValueHandleBase u) {
            return ValueHandleBase.this.Next = u;
        }
    };

    protected ValueHandleBase(ValueHandleBase RHS) {
        this((HandleBaseKind)RHS.PrevPair.getInt(), RHS);
    }

    protected ValueHandleBase(HandleBaseKind Kind2, ValueHandleBase RHS) {
        this.PrevPair = new ADTAliases.PointerEnum2Pair((Object)null, (Enum)Kind2);
        this.Next = null;
        this.V = RHS.V;
        if (ValueHandleBase.isValid(this.V)) {
            this.AddToExistingUseList(RHS.getPrevPtr());
        }
    }

    public ValueHandleBase(HandleBaseKind Kind2) {
        this.PrevPair = new ADTAliases.PointerEnum2Pair((Object)null, (Enum)Kind2);
        this.Next = null;
        this.V = null;
    }

    public ValueHandleBase(HandleBaseKind Kind2, Value V) {
        this.PrevPair = new ADTAliases.PointerEnum2Pair((Object)null, (Enum)Kind2);
        this.Next = null;
        this.V = V;
        if (ValueHandleBase.isValid(V)) {
            this.AddToUseList();
        }
    }

    public void $destroy() {
        if (ValueHandleBase.isValid(this.V)) {
            this.RemoveFromUseList();
        }
    }

    public Value $assign(Value RHS) {
        if (this.V == RHS) {
            return RHS;
        }
        if (ValueHandleBase.isValid(this.V)) {
            this.RemoveFromUseList();
        }
        this.V = RHS;
        if (ValueHandleBase.isValid(this.V)) {
            this.AddToUseList();
        }
        return RHS;
    }

    public Value $assign(ValueHandleBase RHS) {
        if (this.V == RHS.V) {
            return RHS.V;
        }
        if (ValueHandleBase.isValid(this.V)) {
            this.RemoveFromUseList();
        }
        this.V = RHS.V;
        if (ValueHandleBase.isValid(this.V)) {
            this.AddToExistingUseList(RHS.getPrevPtr());
        }
        return this.V;
    }

    public Value $arrow() {
        return this.V;
    }

    public Value $star() {
        return (Value)Native.$Deref((Object)this.V);
    }

    protected Value getValPtr() {
        return this.V;
    }

    protected static boolean isValid(Value V) {
        return V != null && V != DenseMapInfo.LikePtr.$Info().getEmptyKey() && V != DenseMapInfo.LikePtr.$Info().getTombstoneKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ValueIsDeleted(Value V) {
        assert (V.HasValueHandle) : "Should only be called if ValueHandles present";
        LLVMContextImpl pImpl = V.getContext().pImpl;
        ValueHandleBase Entry2 = (ValueHandleBase)pImpl.ValueHandles.$at_T1$C$R((Object)V);
        assert (Entry2 != null) : "Value bit set but no entries exist";
        ValueHandleBase Iterator2 = null;
        try {
            Iterator2 = new ValueHandleBase(HandleBaseKind.Assert, (ValueHandleBase)Native.$Deref((Object)Entry2));
            while (Entry2 != null) {
                Iterator2.RemoveFromUseList();
                Iterator2.AddToExistingUseListAfter(Entry2);
                assert (Entry2.Next == Native.$AddrOf((Object)Iterator2)) : "Loop invariant broken.";
                switch (Entry2.getKind()) {
                    case Assert: {
                        break;
                    }
                    case Tracking: {
                        Entry2.$arrow().$assign((Value)DenseMapInfo.LikePtr.$Info().getTombstoneKey());
                        break;
                    }
                    case Weak: {
                        Entry2.$arrow().$assign(null);
                        break;
                    }
                    case Callback: {
                        ((CallbackVH)Entry2).deleted();
                    }
                }
                Entry2 = Iterator2.Next;
            }
        }
        finally {
            if (Iterator2 != null) {
                Iterator2.$destroy();
            }
        }
        if (V.HasValueHandle) {
            if (!NativeTrace.NDEBUG()) {
                IrLlvmGlobals.$out_raw_ostream_Type(llvm.dbgs().$out("While deleting: "), (Type)Native.$Deref((Object)V.getType())).$out(" %").$out(V.getName()).$out(NativePointer.$LF);
                if (((ValueHandleBase)pImpl.ValueHandles.$at_T1$C$R((Object)V)).getKind() == HandleBaseKind.Assert) {
                    throw new llvm_unreachable("An asserting value handle still pointed to this value!");
                }
            }
            throw new llvm_unreachable("All references to V were not removed?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ValueIsRAUWd(Value Old, Value New2) {
        assert (Old.HasValueHandle) : "Should only be called if ValueHandles present";
        assert (Old != New2) : "Changing value into itself!";
        assert (Old.getType() == New2.getType()) : "replaceAllUses of value with new value of different type!";
        LLVMContextImpl pImpl = Old.getContext().pImpl;
        ValueHandleBase Entry2 = (ValueHandleBase)pImpl.ValueHandles.$at_T1$C$R((Object)Old);
        assert (Entry2 != null) : "Value bit set but no entries exist";
        ValueHandleBase Iterator2 = null;
        try {
            Iterator2 = new ValueHandleBase(HandleBaseKind.Assert, (ValueHandleBase)Native.$Deref((Object)Entry2));
            while (Entry2 != null) {
                Iterator2.RemoveFromUseList();
                Iterator2.AddToExistingUseListAfter(Entry2);
                assert (Entry2.Next == Native.$AddrOf((Object)Iterator2)) : "Loop invariant broken.";
                switch (Entry2.getKind()) {
                    case Assert: {
                        break;
                    }
                    case Tracking: 
                    case Weak: {
                        Entry2.$assign(New2);
                        break;
                    }
                    case Callback: {
                        ((CallbackVH)Entry2).allUsesReplacedWith(New2);
                    }
                }
                Entry2 = Iterator2.Next;
            }
        }
        finally {
            if (Iterator2 != null) {
                Iterator2.$destroy();
            }
        }
        if (!NativeTrace.NDEBUG() && Old.HasValueHandle) {
            Entry2 = (ValueHandleBase)pImpl.ValueHandles.$at_T1$C$R((Object)Old);
            while (Entry2 != null) {
                switch (Entry2.getKind()) {
                    case Tracking: 
                    case Weak: {
                        IrLlvmGlobals.$out_raw_ostream_Type(IrLlvmGlobals.$out_raw_ostream_Type(llvm.dbgs().$out("After RAUW from "), (Type)Native.$Deref((Object)Old.getType())).$out(" %").$out(Old.getName()).$out(" to "), (Type)Native.$Deref((Object)New2.getType())).$out(" %").$out(New2.getName()).$out(NativePointer.$LF);
                        throw new llvm_unreachable("A tracking or weak value handle still pointed to the old value!\n");
                    }
                }
                Entry2 = Entry2.Next;
            }
        }
    }

    private type.ref<ValueHandleBase> getPrevPtr() {
        return (type.ref)this.PrevPair.getPointer();
    }

    private HandleBaseKind getKind() {
        return (HandleBaseKind)this.PrevPair.getInt();
    }

    private void setPrevPtr(type.ref<ValueHandleBase> Ptr) {
        this.PrevPair.setPointer(Ptr);
    }

    private void AddToExistingUseList(type.ref<ValueHandleBase> List2) {
        assert (List2 != null) : "Handle list is null?";
        this.Next = (ValueHandleBase)List2.$deref();
        List2.$set((Object)this);
        this.setPrevPtr(List2);
        if (this.Next != null) {
            this.Next.setPrevPtr(this.Next$Ref);
            assert (this.V == this.Next.V) : "Added to wrong list?";
        }
    }

    private void AddToExistingUseListAfter(ValueHandleBase List2) {
        assert (List2 != null) : "Must insert after existing node";
        this.Next = List2.Next;
        this.setPrevPtr((type.ref<ValueHandleBase>)((type.ref)Native.$AddrOf(List2.Next$Ref)));
        List2.Next = this;
        if (this.Next != null) {
            this.Next.setPrevPtr((type.ref<ValueHandleBase>)((type.ref)Native.$AddrOf(List2.Next$Ref)));
        }
    }

    private void AddToUseList() {
        assert (this.V != null) : "Null pointer doesn't have a use list!";
        LLVMContextImpl pImpl = this.V.getContext().pImpl;
        if (this.V.HasValueHandle) {
            type.ref Entry2 = pImpl.ValueHandles.ref$at((Object)this.V);
            assert (Entry2.$deref() != null) : "Value doesn't have any handles?";
            this.AddToExistingUseList((type.ref<ValueHandleBase>)Entry2);
            return;
        }
        DenseMap<Value, ValueHandleBase> Handles = pImpl.ValueHandles;
        void.ptr OldBucketPtr = Handles.getPointerIntoBucketsArray();
        type.ref Entry3 = Handles.ref$at((Object)this.V);
        assert (Entry3.$deref() == null) : "Value really did already have handles?";
        this.AddToExistingUseList((type.ref<ValueHandleBase>)Entry3);
        this.V.HasValueHandle = true;
        if (Handles.isPointerIntoBucketsArray((Object)OldBucketPtr) || Handles.size() == 1) {
            return;
        }
        DenseMapIterator I = Handles.begin();
        DenseMapIterator E = Handles.end();
        while (I.$noteq(E)) {
            assert (I.$arrow().second != null && I.$arrow().first == ((ValueHandleBase)I.$arrow().second).V) : "List invariant broken!";
            ((ValueHandleBase)I.$arrow().second).setPrevPtr((type.ref<ValueHandleBase>)((type.ref)Native.$AddrOf((Object)I.$arrow().second$ref())));
            I.$preInc();
        }
    }

    private void RemoveFromUseList() {
        assert (this.V != null && this.V.HasValueHandle) : "Pointer doesn't have a use list!";
        type.ref PrevPtr = (type.ref)Native.$noClone(this.getPrevPtr());
        assert (PrevPtr.$deref() == this) : "List invariant broken";
        PrevPtr.$set((Object)this.Next);
        if (this.Next != null) {
            assert (Native.$eq_ptr(this.Next.getPrevPtr(), (Object)Native.$AddrOf(this.Next$Ref))) : "List invariant broken";
            this.Next.setPrevPtr((type.ref<ValueHandleBase>)PrevPtr);
            return;
        }
        LLVMContextImpl pImpl = this.V.getContext().pImpl;
        DenseMap<Value, ValueHandleBase> Handles = pImpl.ValueHandles;
        if (Handles.isPointerIntoBucketsArray((Object)PrevPtr)) {
            Handles.erase((Object)this.V);
            this.V.HasValueHandle = false;
        }
    }

    public ValueHandleBase clone() {
        throw new UnsupportedOperationException("why not overridden in derived " + this.getClass());
    }

    public ValueHandleBase move() {
        throw new UnsupportedOperationException("why not overridden in derived " + this.getClass());
    }

    public String toString() {
        return "PrevPair=" + this.PrevPair + ", Next=" + this.Next + ", V=" + this.V;
    }

    protected static final class HandleBaseKind
    extends Enum<HandleBaseKind>
    implements Native.NativeUIntEnum {
        public static final /* enum */ HandleBaseKind Assert = new HandleBaseKind(0);
        public static final /* enum */ HandleBaseKind Callback = new HandleBaseKind(Assert.getValue() + 1);
        public static final /* enum */ HandleBaseKind Tracking = new HandleBaseKind(Callback.getValue() + 1);
        public static final /* enum */ HandleBaseKind Weak = new HandleBaseKind(Tracking.getValue() + 1);
        private final int value;
        private static final /* synthetic */ HandleBaseKind[] $VALUES;

        public static HandleBaseKind[] values() {
            return (HandleBaseKind[])$VALUES.clone();
        }

        public static HandleBaseKind valueOf(String name) {
            return Enum.valueOf(HandleBaseKind.class, name);
        }

        public static HandleBaseKind valueOf(int val) {
            HandleBaseKind out;
            HandleBaseKind handleBaseKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private HandleBaseKind(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new HandleBaseKind[]{Assert, Callback, Tracking, Weak};
        }

        private static final class Values {
            private static final HandleBaseKind[] VALUES;
            private static final HandleBaseKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (HandleBaseKind kind : HandleBaseKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new HandleBaseKind[min < 0 ? 1 - min : 0];
                VALUES = new HandleBaseKind[max >= 0 ? 1 + max : 0];
                for (HandleBaseKind kind : HandleBaseKind.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((HandleBaseKind)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((HandleBaseKind)kind).value] = kind;
                }
            }
        }
    }
}

