/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeMemory;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.APFloat;
import org.llvm.adt.SmallPtrSetImpl;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.ir.ArrayType;
import org.llvm.ir.IntegerType;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.PointerType;
import org.llvm.ir.StructType;
import org.llvm.ir.VectorType;
import org.llvm.ir.impl.TypePrinting;
import org.llvm.ir.java.IrRTTI;
import org.llvm.llvmc.LLVMOpaqueType;
import org.llvm.support.fltSemantics;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;

public class Type
implements Destructors.ClassWithDestructor,
LLVMOpaqueType {
    private final LLVMContext Context;
    private TypeID ID;
    private int SubclassData;
    protected int NumContainedTys;
    protected type.ptr<Type> ContainedTys;

    public Type(LLVMContext C2, TypeID tid) {
        this.Context = C2;
        this.ID = tid;
        this.SubclassData = 0;
        this.NumContainedTys = 0;
        this.ContainedTys = null;
    }

    public void $destroy() {
    }

    protected int getSubclassData() {
        return this.SubclassData;
    }

    protected void setSubclassData(int val) {
        this.SubclassData = val;
        assert (this.getSubclassData() == val) : "Subclass data too large for field";
    }

    protected static boolean isSequentialType(TypeID TyID) {
        return TyID == TypeID.ArrayTyID || TyID == TypeID.PointerTyID || TyID == TypeID.VectorTyID;
    }

    public void print(raw_ostream OS) {
        this.print(OS, false, false);
    }

    public void print(raw_ostream OS, boolean $Prm1) {
        this.print(OS, $Prm1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(raw_ostream OS, boolean $Prm1, boolean NoDetails) {
        TypePrinting TP = null;
        try {
            TP = new TypePrinting();
            TP.print(this, OS);
            if (NoDetails) {
                return;
            }
            StructType STy = IrRTTI.dyn_cast_StructType(this);
            if (STy != null && !STy.isLiteral()) {
                OS.$out(" = type ");
                TP.printStructBody(STy, OS);
            }
        }
        finally {
            if (TP != null) {
                TP.$destroy();
            }
        }
    }

    public void dump() {
        this.print(llvm.dbgs(), true);
        llvm.dbgs().$out_char((byte)10);
    }

    public LLVMContext getContext() {
        return this.Context;
    }

    public TypeID getTypeID() {
        return this.ID;
    }

    public boolean isVoidTy() {
        return this.getTypeID() == TypeID.VoidTyID;
    }

    public boolean isHalfTy() {
        return this.getTypeID() == TypeID.HalfTyID;
    }

    public boolean isFloatTy() {
        return this.getTypeID() == TypeID.FloatTyID;
    }

    public boolean isDoubleTy() {
        return this.getTypeID() == TypeID.DoubleTyID;
    }

    public boolean isX86_FP80Ty() {
        return this.getTypeID() == TypeID.X86_FP80TyID;
    }

    public boolean isFP128Ty() {
        return this.getTypeID() == TypeID.FP128TyID;
    }

    public boolean isPPC_FP128Ty() {
        return this.getTypeID() == TypeID.PPC_FP128TyID;
    }

    public boolean isFloatingPointTy() {
        return this.getTypeID() == TypeID.HalfTyID || this.getTypeID() == TypeID.FloatTyID || this.getTypeID() == TypeID.DoubleTyID || this.getTypeID() == TypeID.X86_FP80TyID || this.getTypeID() == TypeID.FP128TyID || this.getTypeID() == TypeID.PPC_FP128TyID;
    }

    public fltSemantics getFltSemantics() {
        switch (this.getTypeID()) {
            case HalfTyID: {
                return APFloat.IEEEhalf;
            }
            case FloatTyID: {
                return APFloat.IEEEsingle;
            }
            case DoubleTyID: {
                return APFloat.IEEEdouble;
            }
            case X86_FP80TyID: {
                return APFloat.x87DoubleExtended;
            }
            case FP128TyID: {
                return APFloat.IEEEquad;
            }
            case PPC_FP128TyID: {
                return APFloat.PPCDoubleDouble;
            }
        }
        throw new llvm_unreachable("Invalid floating type");
    }

    public boolean isX86_MMXTy() {
        return this.getTypeID() == TypeID.X86_MMXTyID;
    }

    public boolean isFPOrFPVectorTy() {
        return this.getScalarType().isFloatingPointTy();
    }

    public boolean isLabelTy() {
        return this.getTypeID() == TypeID.LabelTyID;
    }

    public boolean isMetadataTy() {
        return this.getTypeID() == TypeID.MetadataTyID;
    }

    public boolean isTokenTy() {
        return this.getTypeID() == TypeID.TokenTyID;
    }

    public boolean isIntegerTy() {
        return this.getTypeID() == TypeID.IntegerTyID;
    }

    public boolean isIntegerTy(int Bitwidth) {
        return this.isIntegerTy() && IrRTTI.cast_IntegerType(this).getBitWidth() == Bitwidth;
    }

    public boolean isIntOrIntVectorTy() {
        return this.getScalarType().isIntegerTy();
    }

    public boolean isFunctionTy() {
        return this.getTypeID() == TypeID.FunctionTyID;
    }

    public boolean isStructTy() {
        return this.getTypeID() == TypeID.StructTyID;
    }

    public boolean isArrayTy() {
        return this.getTypeID() == TypeID.ArrayTyID;
    }

    public boolean isPointerTy() {
        return this.getTypeID() == TypeID.PointerTyID;
    }

    public boolean isPtrOrPtrVectorTy() {
        return this.getScalarType().isPointerTy();
    }

    public boolean isVectorTy() {
        return this.getTypeID() == TypeID.VectorTyID;
    }

    public boolean canLosslesslyBitCastTo(Type Ty) {
        VectorType thatPTy;
        if (this == Ty) {
            return true;
        }
        if (!this.isFirstClassType() || !Ty.isFirstClassType()) {
            return false;
        }
        VectorType thisPTy = IrRTTI.dyn_cast_VectorType(this);
        if (thisPTy != null) {
            VectorType thatPTy2 = IrRTTI.dyn_cast_VectorType(Ty);
            if (thatPTy2 != null) {
                return thisPTy.getBitWidth() == thatPTy2.getBitWidth();
            }
            if (Ty.getTypeID() == TypeID.X86_MMXTyID && thisPTy.getBitWidth() == 64) {
                return true;
            }
        }
        if (this.getTypeID() == TypeID.X86_MMXTyID && (thatPTy = IrRTTI.dyn_cast_VectorType(Ty)) != null && thatPTy.getBitWidth() == 64) {
            return true;
        }
        PointerType PTy = IrRTTI.dyn_cast_PointerType(this);
        if (PTy != null) {
            PointerType OtherPTy = IrRTTI.dyn_cast_PointerType(Ty);
            if (OtherPTy != null) {
                return PTy.getAddressSpace() == OtherPTy.getAddressSpace();
            }
            return false;
        }
        return false;
    }

    public boolean isEmptyTy() {
        ArrayType ATy = IrRTTI.dyn_cast_ArrayType(this);
        if (ATy != null) {
            int NumElements = Unsigned.$ulong2uint((long)ATy.getNumElements());
            return NumElements == 0 || ATy.getElementType().isEmptyTy();
        }
        StructType STy = IrRTTI.dyn_cast_StructType(this);
        if (STy != null) {
            int NumElements = STy.getNumElements();
            int i = 0;
            while (Unsigned.$less_uint((int)i, (int)NumElements)) {
                if (!STy.getElementType(i).isEmptyTy()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isFirstClassType() {
        return this.getTypeID() != TypeID.FunctionTyID && this.getTypeID() != TypeID.VoidTyID;
    }

    public boolean isSingleValueType() {
        return this.isFloatingPointTy() || this.isX86_MMXTy() || this.isIntegerTy() || this.isPointerTy() || this.isVectorTy();
    }

    public boolean isAggregateType() {
        return this.getTypeID() == TypeID.StructTyID || this.getTypeID() == TypeID.ArrayTyID;
    }

    public boolean isSized() {
        return this.isSized((SmallPtrSetImpl<Type>)((SmallPtrSetImpl)null));
    }

    public boolean isSized(SmallPtrSetImpl<Type> Visited) {
        if (this.getTypeID() == TypeID.IntegerTyID || this.isFloatingPointTy() || this.getTypeID() == TypeID.PointerTyID || this.getTypeID() == TypeID.X86_MMXTyID) {
            return true;
        }
        if (this.getTypeID() != TypeID.StructTyID && this.getTypeID() != TypeID.ArrayTyID && this.getTypeID() != TypeID.VectorTyID) {
            return false;
        }
        return this.isSizedDerivedType(Visited);
    }

    public int getPrimitiveSizeInBits() {
        switch (this.getTypeID()) {
            case HalfTyID: {
                return 16;
            }
            case FloatTyID: {
                return 32;
            }
            case DoubleTyID: {
                return 64;
            }
            case X86_FP80TyID: {
                return 80;
            }
            case FP128TyID: {
                return 128;
            }
            case PPC_FP128TyID: {
                return 128;
            }
            case X86_MMXTyID: {
                return 64;
            }
            case IntegerTyID: {
                return IrRTTI.cast_IntegerType(this).getBitWidth();
            }
            case VectorTyID: {
                return IrRTTI.cast_VectorType(this).getBitWidth();
            }
        }
        return 0;
    }

    public int getScalarSizeInBits() {
        return this.getScalarType().getPrimitiveSizeInBits();
    }

    public int getFPMantissaWidth() {
        VectorType VTy = IrRTTI.dyn_cast_VectorType(this);
        if (VTy != null) {
            return VTy.getElementType().getFPMantissaWidth();
        }
        assert (this.isFloatingPointTy()) : "Not a floating point type!";
        if (this.getTypeID() == TypeID.HalfTyID) {
            return 11;
        }
        if (this.getTypeID() == TypeID.FloatTyID) {
            return 24;
        }
        if (this.getTypeID() == TypeID.DoubleTyID) {
            return 53;
        }
        if (this.getTypeID() == TypeID.X86_FP80TyID) {
            return 64;
        }
        if (this.getTypeID() == TypeID.FP128TyID) {
            return 113;
        }
        assert (this.getTypeID() == TypeID.PPC_FP128TyID) : "unknown fp type";
        return -1;
    }

    public Type getScalarType() {
        VectorType VTy = IrRTTI.dyn_cast_VectorType(this);
        if (VTy != null) {
            return VTy.getElementType();
        }
        return this;
    }

    public type.ptr<Type> subtype_begin() {
        return this.ContainedTys;
    }

    public type.ptr<Type> subtype_end() {
        return this.NumContainedTys == 0 ? this.ContainedTys : (type.ptr)this.ContainedTys.$add(this.NumContainedTys);
    }

    public ArrayRef<Type> subtypes() {
        return llvm.makeArrayRef(this.subtype_begin(), this.subtype_end());
    }

    public std.reverse_iterator<Type> subtype_rbegin() {
        return new std.reverse_iterator(this.subtype_end());
    }

    public std.reverse_iterator<Type> subtype_rend() {
        return new std.reverse_iterator(this.subtype_begin());
    }

    public Type getContainedType(int i) {
        assert (Unsigned.$less_uint((int)i, (int)this.NumContainedTys)) : "Index out of range!";
        return (Type)this.ContainedTys.$at(i);
    }

    public int getNumContainedTypes() {
        return this.NumContainedTys;
    }

    public int getIntegerBitWidth() {
        return IrRTTI.cast_IntegerType(this).getBitWidth();
    }

    public Type getFunctionParamType(int i) {
        return IrRTTI.cast_FunctionType(this).getParamType(i);
    }

    public int getFunctionNumParams() {
        return IrRTTI.cast_FunctionType(this).getNumParams();
    }

    public boolean isFunctionVarArg() {
        return IrRTTI.cast_FunctionType(this).isVarArg();
    }

    public StringRef getStructName() {
        return IrRTTI.cast_StructType(this).getName();
    }

    public int getStructNumElements() {
        return IrRTTI.cast_StructType(this).getNumElements();
    }

    public Type getStructElementType(int N) {
        return IrRTTI.cast_StructType(this).getElementType(N);
    }

    public Type getSequentialElementType() {
        assert (Type.isSequentialType(this.getTypeID())) : "Not a sequential type!";
        return (Type)this.ContainedTys.$at(0);
    }

    public long getArrayNumElements() {
        return IrRTTI.cast_ArrayType(this).getNumElements();
    }

    public Type getArrayElementType() {
        return this.getSequentialElementType();
    }

    public int getVectorNumElements() {
        return IrRTTI.cast_VectorType(this).getNumElements();
    }

    public Type getVectorElementType() {
        return this.getSequentialElementType();
    }

    public Type getPointerElementType() {
        return this.getSequentialElementType();
    }

    public int getPointerAddressSpace() {
        return IrRTTI.cast_PointerType(this.getScalarType()).getAddressSpace();
    }

    public static Type getPrimitiveType(LLVMContext C2, TypeID IDNumber) {
        switch (IDNumber) {
            case VoidTyID: {
                return Type.getVoidTy(C2);
            }
            case HalfTyID: {
                return Type.getHalfTy(C2);
            }
            case FloatTyID: {
                return Type.getFloatTy(C2);
            }
            case DoubleTyID: {
                return Type.getDoubleTy(C2);
            }
            case X86_FP80TyID: {
                return Type.getX86_FP80Ty(C2);
            }
            case FP128TyID: {
                return Type.getFP128Ty(C2);
            }
            case PPC_FP128TyID: {
                return Type.getPPC_FP128Ty(C2);
            }
            case LabelTyID: {
                return Type.getLabelTy(C2);
            }
            case MetadataTyID: {
                return Type.getMetadataTy(C2);
            }
            case X86_MMXTyID: {
                return Type.getX86_MMXTy(C2);
            }
            case TokenTyID: {
                return Type.getTokenTy(C2);
            }
        }
        return null;
    }

    public static Type getVoidTy(LLVMContext C2) {
        return C2.pImpl.VoidTy;
    }

    public static Type getLabelTy(LLVMContext C2) {
        return C2.pImpl.LabelTy;
    }

    public static Type getHalfTy(LLVMContext C2) {
        return C2.pImpl.HalfTy;
    }

    public static Type getFloatTy(LLVMContext C2) {
        return C2.pImpl.FloatTy;
    }

    public static Type getDoubleTy(LLVMContext C2) {
        return C2.pImpl.DoubleTy;
    }

    public static Type getMetadataTy(LLVMContext C2) {
        return C2.pImpl.MetadataTy;
    }

    public static Type getX86_FP80Ty(LLVMContext C2) {
        return C2.pImpl.X86_FP80Ty;
    }

    public static Type getFP128Ty(LLVMContext C2) {
        return C2.pImpl.FP128Ty;
    }

    public static Type getPPC_FP128Ty(LLVMContext C2) {
        return C2.pImpl.PPC_FP128Ty;
    }

    public static Type getX86_MMXTy(LLVMContext C2) {
        return C2.pImpl.X86_MMXTy;
    }

    public static Type getTokenTy(LLVMContext C2) {
        return C2.pImpl.TokenTy;
    }

    public static IntegerType getIntNTy(LLVMContext C2, int N) {
        return IntegerType.get(C2, N);
    }

    public static IntegerType getInt1Ty(LLVMContext C2) {
        return C2.pImpl.Int1Ty;
    }

    public static IntegerType getInt8Ty(LLVMContext C2) {
        return C2.pImpl.Int8Ty;
    }

    public static IntegerType getInt16Ty(LLVMContext C2) {
        return C2.pImpl.Int16Ty;
    }

    public static IntegerType getInt32Ty(LLVMContext C2) {
        return C2.pImpl.Int32Ty;
    }

    public static IntegerType getInt64Ty(LLVMContext C2) {
        return C2.pImpl.Int64Ty;
    }

    public static IntegerType getInt128Ty(LLVMContext C2) {
        return C2.pImpl.Int128Ty;
    }

    public static PointerType getHalfPtrTy(LLVMContext C2) {
        return Type.getHalfPtrTy(C2, 0);
    }

    public static PointerType getHalfPtrTy(LLVMContext C2, int AS) {
        return Type.getHalfTy(C2).getPointerTo(AS);
    }

    public static PointerType getFloatPtrTy(LLVMContext C2) {
        return Type.getFloatPtrTy(C2, 0);
    }

    public static PointerType getFloatPtrTy(LLVMContext C2, int AS) {
        return Type.getFloatTy(C2).getPointerTo(AS);
    }

    public static PointerType getDoublePtrTy(LLVMContext C2) {
        return Type.getDoublePtrTy(C2, 0);
    }

    public static PointerType getDoublePtrTy(LLVMContext C2, int AS) {
        return Type.getDoubleTy(C2).getPointerTo(AS);
    }

    public static PointerType getX86_FP80PtrTy(LLVMContext C2) {
        return Type.getX86_FP80PtrTy(C2, 0);
    }

    public static PointerType getX86_FP80PtrTy(LLVMContext C2, int AS) {
        return Type.getX86_FP80Ty(C2).getPointerTo(AS);
    }

    public static PointerType getFP128PtrTy(LLVMContext C2) {
        return Type.getFP128PtrTy(C2, 0);
    }

    public static PointerType getFP128PtrTy(LLVMContext C2, int AS) {
        return Type.getFP128Ty(C2).getPointerTo(AS);
    }

    public static PointerType getPPC_FP128PtrTy(LLVMContext C2) {
        return Type.getPPC_FP128PtrTy(C2, 0);
    }

    public static PointerType getPPC_FP128PtrTy(LLVMContext C2, int AS) {
        return Type.getPPC_FP128Ty(C2).getPointerTo(AS);
    }

    public static PointerType getX86_MMXPtrTy(LLVMContext C2) {
        return Type.getX86_MMXPtrTy(C2, 0);
    }

    public static PointerType getX86_MMXPtrTy(LLVMContext C2, int AS) {
        return Type.getX86_MMXTy(C2).getPointerTo(AS);
    }

    public static PointerType getIntNPtrTy(LLVMContext C2, int N) {
        return Type.getIntNPtrTy(C2, N, 0);
    }

    public static PointerType getIntNPtrTy(LLVMContext C2, int N, int AS) {
        return Type.getIntNTy(C2, N).getPointerTo(AS);
    }

    public static PointerType getInt1PtrTy(LLVMContext C2) {
        return Type.getInt1PtrTy(C2, 0);
    }

    public static PointerType getInt1PtrTy(LLVMContext C2, int AS) {
        return Type.getInt1Ty(C2).getPointerTo(AS);
    }

    public static PointerType getInt8PtrTy(LLVMContext C2) {
        return Type.getInt8PtrTy(C2, 0);
    }

    public static PointerType getInt8PtrTy(LLVMContext C2, int AS) {
        return Type.getInt8Ty(C2).getPointerTo(AS);
    }

    public static PointerType getInt16PtrTy(LLVMContext C2) {
        return Type.getInt16PtrTy(C2, 0);
    }

    public static PointerType getInt16PtrTy(LLVMContext C2, int AS) {
        return Type.getInt16Ty(C2).getPointerTo(AS);
    }

    public static PointerType getInt32PtrTy(LLVMContext C2) {
        return Type.getInt32PtrTy(C2, 0);
    }

    public static PointerType getInt32PtrTy(LLVMContext C2, int AS) {
        return Type.getInt32Ty(C2).getPointerTo(AS);
    }

    public static PointerType getInt64PtrTy(LLVMContext C2) {
        return Type.getInt64PtrTy(C2, 0);
    }

    public static PointerType getInt64PtrTy(LLVMContext C2, int AS) {
        return Type.getInt64Ty(C2).getPointerTo(AS);
    }

    public PointerType getPointerTo() {
        return this.getPointerTo(0);
    }

    public PointerType getPointerTo(int addrs) {
        return PointerType.get(this, addrs);
    }

    private boolean isSizedDerivedType() {
        return this.isSizedDerivedType((SmallPtrSetImpl<Type>)((SmallPtrSetImpl)null));
    }

    private boolean isSizedDerivedType(SmallPtrSetImpl<Type> Visited) {
        ArrayType ATy = IrRTTI.dyn_cast_ArrayType(this);
        if (ATy != null) {
            return ATy.getElementType().isSized(Visited);
        }
        VectorType VTy = IrRTTI.dyn_cast_VectorType(this);
        if (VTy != null) {
            return VTy.getElementType().isSized(Visited);
        }
        return IrRTTI.cast_StructType(this).isSized(Visited);
    }

    protected Type(Type $Prm0) {
        this.Context = $Prm0.Context;
        this.ID = $Prm0.ID;
        this.SubclassData = $Prm0.SubclassData;
        this.NumContainedTys = $Prm0.NumContainedTys;
        this.ContainedTys = (type.ptr)Native.$Clone($Prm0.ContainedTys);
    }

    protected static <T> T $new_uint_BumpPtrAllocatorImpl$AllocatorT$SlabSize$SizeThreshold(NativeMemory.BumpAllocator alloc, NativeCallback.New.ConstructorCallback<T> New$Type) {
        return (T)New$Type.$call(null);
    }

    public String toString() {
        String printedType = "";
        printedType = llvm.DumpJavaString((Object)this, ($this, OS) -> $this.print(OS, true, false));
        return printedType;
    }

    public static final class TypeID
    extends Enum<TypeID>
    implements Native.NativeUIntEnum {
        public static final /* enum */ TypeID VoidTyID = new TypeID(0);
        public static final /* enum */ TypeID HalfTyID = new TypeID(VoidTyID.getValue() + 1);
        public static final /* enum */ TypeID FloatTyID = new TypeID(HalfTyID.getValue() + 1);
        public static final /* enum */ TypeID DoubleTyID = new TypeID(FloatTyID.getValue() + 1);
        public static final /* enum */ TypeID X86_FP80TyID = new TypeID(DoubleTyID.getValue() + 1);
        public static final /* enum */ TypeID FP128TyID = new TypeID(X86_FP80TyID.getValue() + 1);
        public static final /* enum */ TypeID PPC_FP128TyID = new TypeID(FP128TyID.getValue() + 1);
        public static final /* enum */ TypeID LabelTyID = new TypeID(PPC_FP128TyID.getValue() + 1);
        public static final /* enum */ TypeID MetadataTyID = new TypeID(LabelTyID.getValue() + 1);
        public static final /* enum */ TypeID X86_MMXTyID = new TypeID(MetadataTyID.getValue() + 1);
        public static final /* enum */ TypeID TokenTyID = new TypeID(X86_MMXTyID.getValue() + 1);
        public static final /* enum */ TypeID IntegerTyID = new TypeID(TokenTyID.getValue() + 1);
        public static final /* enum */ TypeID FunctionTyID = new TypeID(IntegerTyID.getValue() + 1);
        public static final /* enum */ TypeID StructTyID = new TypeID(FunctionTyID.getValue() + 1);
        public static final /* enum */ TypeID ArrayTyID = new TypeID(StructTyID.getValue() + 1);
        public static final /* enum */ TypeID PointerTyID = new TypeID(ArrayTyID.getValue() + 1);
        public static final /* enum */ TypeID VectorTyID = new TypeID(PointerTyID.getValue() + 1);
        private final int value;
        private static final /* synthetic */ TypeID[] $VALUES;

        public static TypeID[] values() {
            return (TypeID[])$VALUES.clone();
        }

        public static TypeID valueOf(String name) {
            return Enum.valueOf(TypeID.class, name);
        }

        public static TypeID valueOf(int val) {
            TypeID out;
            TypeID typeID = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private TypeID(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new TypeID[]{VoidTyID, HalfTyID, FloatTyID, DoubleTyID, X86_FP80TyID, FP128TyID, PPC_FP128TyID, LabelTyID, MetadataTyID, X86_MMXTyID, TokenTyID, IntegerTyID, FunctionTyID, StructTyID, ArrayTyID, PointerTyID, VectorTyID};
        }

        private static final class Values {
            private static final TypeID[] VALUES;
            private static final TypeID[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (TypeID kind : TypeID.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new TypeID[min < 0 ? 1 - min : 0];
                VALUES = new TypeID[max >= 0 ? 1 + max : 0];
                for (TypeID kind : TypeID.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((TypeID)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((TypeID)kind).value] = kind;
                }
            }
        }
    }
}

