/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.llvm.ir.Module$IR;
import org.llvm.ir.Value;
import org.llvm.ir.java.IrRTTI;
import org.llvm.pass.Pass;
import org.llvm.support.PrettyStackTraceEntry;
import org.llvm.support.raw_ostream;

public class PassManagerPrettyStackEntry
extends PrettyStackTraceEntry
implements Destructors.ClassWithDestructor {
    private Pass P;
    private Value V;
    private Module$IR M;

    public PassManagerPrettyStackEntry(Pass p) {
        this.P = p;
        this.V = null;
        this.M = null;
    }

    public PassManagerPrettyStackEntry(Pass p, Value v) {
        this.P = p;
        this.V = (Value)Native.$AddrOf((Object)v);
        this.M = null;
    }

    public PassManagerPrettyStackEntry(Pass p, Module$IR m) {
        this.P = p;
        this.V = null;
        this.M = (Module$IR)Native.$AddrOf((Object)m);
    }

    public void print(raw_ostream OS) {
        if (this.V == null && this.M == null) {
            OS.$out("Releasing pass '");
        } else {
            OS.$out("Running pass '");
        }
        OS.$out(this.P.getPassName()).$out(NativePointer.$SGL_QUOTE);
        if (this.M != null) {
            OS.$out(" on module '").$out(this.M.getModuleIdentifier()).$out("'.\n");
            return;
        }
        if (this.V == null) {
            OS.$out_char((byte)10);
            return;
        }
        OS.$out(" on ");
        if (IrRTTI.isa_Function(this.V)) {
            OS.$out("function");
        } else if (IrRTTI.isa_BasicBlock(this.V)) {
            OS.$out("basic block");
        } else {
            OS.$out("value");
        }
        OS.$out(" '");
        this.V.printAsOperand(OS, false, this.M);
        OS.$out("'\n");
    }

    public void $destroy() {
        super.$destroy();
    }

    public String toString() {
        return "P=" + this.P + ", V=" + this.V + ", M=" + this.M + super.toString();
    }
}

