/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.Twine;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.Instruction;
import org.llvm.ir.SynchronizationScope;
import org.llvm.ir.Type;
import org.llvm.ir.UnaryInstruction;
import org.llvm.ir.Value;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.AtomicOrdering;
import org.llvm.support.llvm;

public class LoadInst
extends UnaryInstruction
implements Destructors.ClassWithDestructor {
    private void AssertOK() {
        assert (this.getOperand(0).getType().isPointerTy()) : "Ptr must have pointer type.";
        assert (!this.isAtomic() || this.getAlignment() != 0) : "Alignment required for atomic load";
    }

    protected LoadInst cloneImpl() {
        return (LoadInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new LoadInst(this.getOperand(0), new Twine(), this.isVolatile(), this.getAlignment(), this.getOrdering(), this.getSynchScope()));
    }

    public LoadInst(Value Ptr, Twine Name, Instruction InsertBef) {
        this(Ptr, Name, false, InsertBef);
    }

    public LoadInst(Value Ptr, Twine Name, BasicBlock InsertAE) {
        this(Ptr, Name, false, InsertAE);
    }

    public LoadInst(Type Ty, Value Ptr, Twine Name) {
        this(Ty, Ptr, Name, false, (Instruction)null);
    }

    public LoadInst(Type Ty, Value Ptr, Twine Name, boolean isVolatile) {
        this(Ty, Ptr, Name, isVolatile, (Instruction)null);
    }

    public LoadInst(Type Ty, Value Ptr, Twine Name, boolean isVolatile, Instruction InsertBef) {
        this(Ty, Ptr, Name, isVolatile, 0, InsertBef);
    }

    public LoadInst(Value Ptr, Twine NameStr) {
        this(Ptr, NameStr, false, (Instruction)null);
    }

    public LoadInst(Value Ptr, Twine NameStr, boolean isVolatile) {
        this(Ptr, NameStr, isVolatile, (Instruction)null);
    }

    public LoadInst(Value Ptr, Twine NameStr, boolean isVolatile, Instruction InsertBefore) {
        this(IrRTTI.cast_PointerType(Ptr.getType()).getElementType(), Ptr, NameStr, isVolatile, InsertBefore);
    }

    public LoadInst(Value Ptr, Twine Name, boolean isVolatile, BasicBlock InsertAE) {
        this(Ptr, Name, isVolatile, 0, InsertAE);
    }

    public LoadInst(Value Ptr, Twine NameStr, boolean isVolatile, int Align) {
        this(Ptr, NameStr, isVolatile, Align, (Instruction)null);
    }

    public LoadInst(Value Ptr, Twine NameStr, boolean isVolatile, int Align, Instruction InsertBefore) {
        this(IrRTTI.cast_PointerType(Ptr.getType()).getElementType(), Ptr, NameStr, isVolatile, Align, InsertBefore);
    }

    public LoadInst(Type Ty, Value Ptr, Twine Name, boolean isVolatile, int Align) {
        this(Ty, Ptr, Name, isVolatile, Align, (Instruction)null);
    }

    public LoadInst(Type Ty, Value Ptr, Twine Name, boolean isVolatile, int Align, Instruction InsertBef) {
        this(Ty, Ptr, Name, isVolatile, Align, AtomicOrdering.NotAtomic, SynchronizationScope.CrossThread, InsertBef);
    }

    public LoadInst(Value Ptr, Twine Name, boolean isVolatile, int Align, BasicBlock InsertAE) {
        this(Ptr, Name, isVolatile, Align, AtomicOrdering.NotAtomic, SynchronizationScope.CrossThread, InsertAE);
    }

    public LoadInst(Value Ptr, Twine NameStr, boolean isVolatile, int Align, AtomicOrdering Order) {
        this(Ptr, NameStr, isVolatile, Align, Order, SynchronizationScope.CrossThread, (Instruction)null);
    }

    public LoadInst(Value Ptr, Twine NameStr, boolean isVolatile, int Align, AtomicOrdering Order, SynchronizationScope SynchScope) {
        this(Ptr, NameStr, isVolatile, Align, Order, SynchScope, (Instruction)null);
    }

    public LoadInst(Value Ptr, Twine NameStr, boolean isVolatile, int Align, AtomicOrdering Order, SynchronizationScope SynchScope, Instruction InsertBefore) {
        this(IrRTTI.cast_PointerType(Ptr.getType()).getElementType(), Ptr, NameStr, isVolatile, Align, Order, SynchScope, InsertBefore);
    }

    public LoadInst(Type Ty, Value Ptr, Twine Name, boolean isVolatile, int Align, AtomicOrdering Order) {
        this(Ty, Ptr, Name, isVolatile, Align, Order, SynchronizationScope.CrossThread, null);
    }

    public LoadInst(Type Ty, Value Ptr, Twine Name, boolean isVolatile, int Align, AtomicOrdering Order, SynchronizationScope SynchScope) {
        this(Ty, Ptr, Name, isVolatile, Align, Order, SynchScope, null);
    }

    public LoadInst(Type Ty, Value Ptr, Twine Name, boolean isVolatile, int Align, AtomicOrdering Order, SynchronizationScope SynchScope, Instruction InsertBef) {
        super(Ty, 30, Ptr, InsertBef);
        assert (Ty == IrRTTI.cast_PointerType(Ptr.getType()).getElementType());
        this.setVolatile(isVolatile);
        this.setAlignment(Align);
        this.setAtomic(Order, SynchScope);
        this.AssertOK();
        this.setName(Name);
    }

    public LoadInst(Value Ptr, Twine Name, boolean isVolatile, int Align, AtomicOrdering Order, SynchronizationScope SynchScope, BasicBlock InsertAE) {
        super(IrRTTI.cast_PointerType(Ptr.getType()).getElementType(), 30, Ptr, InsertAE);
        this.setVolatile(isVolatile);
        this.setAlignment(Align);
        this.setAtomic(Order, SynchScope);
        this.AssertOK();
        this.setName(Name);
    }

    public LoadInst(Value Ptr, char.ptr Name, Instruction InsertBef) {
        super(IrRTTI.cast_PointerType(Ptr.getType()).getElementType(), 30, Ptr, InsertBef);
        this.setVolatile(false);
        this.setAlignment(0);
        this.setAtomic(AtomicOrdering.NotAtomic);
        this.AssertOK();
        if (Native.$bool((Native.Native$Bool)Name) && Name.$at(0) != 0) {
            this.setName(new Twine(Name));
        }
    }

    public LoadInst(Value Ptr, char.ptr Name, BasicBlock InsertAE) {
        super(IrRTTI.cast_PointerType(Ptr.getType()).getElementType(), 30, Ptr, InsertAE);
        this.setVolatile(false);
        this.setAlignment(0);
        this.setAtomic(AtomicOrdering.NotAtomic);
        this.AssertOK();
        if (Native.$bool((Native.Native$Bool)Name) && Name.$at(0) != 0) {
            this.setName(new Twine(Name));
        }
    }

    public LoadInst(Type Ty, Value Ptr) {
        this(Ty, Ptr, (char.ptr)null, false, (Instruction)null);
    }

    public LoadInst(Type Ty, Value Ptr, char.ptr Name) {
        this(Ty, Ptr, Name, false, (Instruction)null);
    }

    public LoadInst(Type Ty, Value Ptr, char.ptr Name, boolean isVolatile) {
        this(Ty, Ptr, Name, isVolatile, (Instruction)null);
    }

    public LoadInst(Type Ty, Value Ptr, char.ptr Name, boolean isVolatile, Instruction InsertBef) {
        super(Ty, 30, Ptr, InsertBef);
        assert (Ty == IrRTTI.cast_PointerType(Ptr.getType()).getElementType());
        this.setVolatile(isVolatile);
        this.setAlignment(0);
        this.setAtomic(AtomicOrdering.NotAtomic);
        this.AssertOK();
        if (Native.$bool((Native.Native$Bool)Name) && Name.$at(0) != 0) {
            this.setName(new Twine(Name));
        }
    }

    public LoadInst(Value Ptr) {
        this(Ptr, (char.ptr)null, false, (Instruction)null);
    }

    public LoadInst(Value Ptr, char.ptr NameStr) {
        this(Ptr, NameStr, false, (Instruction)null);
    }

    public LoadInst(Value Ptr, char.ptr NameStr, boolean isVolatile) {
        this(Ptr, NameStr, isVolatile, (Instruction)null);
    }

    public LoadInst(Value Ptr, char.ptr NameStr, boolean isVolatile, Instruction InsertBefore) {
        this(IrRTTI.cast_PointerType(Ptr.getType()).getElementType(), Ptr, NameStr, isVolatile, InsertBefore);
    }

    public LoadInst(Value Ptr, char.ptr Name, boolean isVolatile, BasicBlock InsertAE) {
        super(IrRTTI.cast_PointerType(Ptr.getType()).getElementType(), 30, Ptr, InsertAE);
        this.setVolatile(isVolatile);
        this.setAlignment(0);
        this.setAtomic(AtomicOrdering.NotAtomic);
        this.AssertOK();
        if (Native.$bool((Native.Native$Bool)Name) && Name.$at(0) != 0) {
            this.setName(new Twine(Name));
        }
    }

    public boolean isVolatile() {
        return (this.getSubclassDataFromInstruction() & 1) != 0;
    }

    public void setVolatile(boolean V) {
        this.setInstructionSubclassData_LoadInst(Unsigned.$uint2ushort((int)(this.getSubclassDataFromInstruction() & 0xFFFFFFFE | (V ? 1 : 0))));
    }

    public int getAlignment() {
        return 1 << (this.getSubclassDataFromInstruction() >>> 1 & 0x1F) >> 1;
    }

    public void setAlignment(int Align) {
        assert ((Align & Align - 1) == 0) : "Alignment is not a power of 2!";
        assert (Unsigned.$lesseq_uint((int)Align, (int)Value.MaximumAlignment)) : "Alignment is greater than MaximumAlignment!";
        this.setInstructionSubclassData_LoadInst(Unsigned.$uint2ushort((int)(this.getSubclassDataFromInstruction() & 0xFFFFFFC1 | llvm.Log2_32((int)Align) + 1 << 1)));
        assert (this.getAlignment() == Align) : "Alignment representation error!";
    }

    public AtomicOrdering getOrdering() {
        return AtomicOrdering.valueOf((int)(this.getSubclassDataFromInstruction() >>> 7 & 7));
    }

    public void setOrdering(AtomicOrdering Ordering) {
        this.setInstructionSubclassData_LoadInst(Unsigned.$uint2ushort((int)(this.getSubclassDataFromInstruction() & 0xFFFFFC7F | Ordering.getValue() << 7)));
    }

    public SynchronizationScope getSynchScope() {
        return SynchronizationScope.valueOf(this.getSubclassDataFromInstruction() >>> 6 & 1);
    }

    public void setSynchScope(SynchronizationScope xthread) {
        this.setInstructionSubclassData_LoadInst(Unsigned.$uint2ushort((int)(this.getSubclassDataFromInstruction() & 0xFFFFFFBF | xthread.getValue() << 6)));
    }

    public void setAtomic(AtomicOrdering Ordering) {
        this.setAtomic(Ordering, SynchronizationScope.CrossThread);
    }

    public void setAtomic(AtomicOrdering Ordering, SynchronizationScope SynchScope) {
        this.setOrdering(Ordering);
        this.setSynchScope(SynchScope);
    }

    public boolean isSimple() {
        return !this.isAtomic() && !this.isVolatile();
    }

    public boolean isUnordered() {
        return (this.getOrdering() == AtomicOrdering.NotAtomic || this.getOrdering() == AtomicOrdering.Unordered) && !this.isVolatile();
    }

    public Value getPointerOperand() {
        return this.getOperand(0);
    }

    public Value getPointerOperand$Const() {
        return this.getOperand(0);
    }

    public static int getPointerOperandIndex() {
        return 0;
    }

    public int getPointerAddressSpace() {
        return this.getPointerOperand$Const().getType().getPointerAddressSpace();
    }

    public static boolean classof(Instruction I) {
        return I.getOpcode() == 30;
    }

    public static boolean classof(Value V) {
        return IrRTTI.isa_Instruction(V) && LoadInst.classof(IrRTTI.cast_Instruction(V));
    }

    private void setInstructionSubclassData_LoadInst(char D2) {
        super.setInstructionSubclassData(D2);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

