/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Native;
import org.clank.support.NativeMemory;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.APInt;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.Type;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.llvm;

public class IntegerType
extends Type {
    public IntegerType(LLVMContext C2, int NumBits) {
        super(C2, Type.TypeID.IntegerTyID);
        this.setSubclassData(NumBits);
    }

    public static IntegerType get(LLVMContext C2, int NumBits) {
        assert (Unsigned.$greatereq_uint((int)NumBits, (int)Unnamed_enum.MIN_INT_BITS.getValue())) : "bitwidth too small";
        assert (Unsigned.$lesseq_uint((int)NumBits, (int)Unnamed_enum.MAX_INT_BITS.getValue())) : "bitwidth too large";
        switch (NumBits) {
            case 1: {
                return IrRTTI.cast_IntegerType(Type.getInt1Ty(C2));
            }
            case 8: {
                return IrRTTI.cast_IntegerType(Type.getInt8Ty(C2));
            }
            case 16: {
                return IrRTTI.cast_IntegerType(Type.getInt16Ty(C2));
            }
            case 32: {
                return IrRTTI.cast_IntegerType(Type.getInt32Ty(C2));
            }
            case 64: {
                return IrRTTI.cast_IntegerType(Type.getInt64Ty(C2));
            }
            case 128: {
                return IrRTTI.cast_IntegerType(Type.getInt128Ty(C2));
            }
        }
        type.ref Entry2 = C2.pImpl.IntegerTypes.ref$at(NumBits);
        if (Entry2.$deref() == null) {
            Entry2.$set((Object)((IntegerType)IntegerType.$new_uint_BumpPtrAllocatorImpl$AllocatorT$SlabSize$SizeThreshold((NativeMemory.BumpAllocator)C2.pImpl.TypeAllocator, New$Mem -> new IntegerType(C2, NumBits))));
        }
        return (IntegerType)Entry2.$deref();
    }

    public int getBitWidth() {
        return this.getSubclassData();
    }

    public long getBitMask() {
        return -1L >>> 64 - this.getBitWidth();
    }

    public long getSignBit() {
        return 1L << this.getBitWidth() - 1;
    }

    public APInt getMask() {
        return APInt.getAllOnesValue((int)this.getBitWidth());
    }

    public boolean isPowerOf2ByteWidth() {
        int BitWidth = this.getBitWidth();
        return Unsigned.$greater_uint((int)BitWidth, (int)7) && llvm.isPowerOf2_32((int)BitWidth);
    }

    public static boolean classof(Type T2) {
        return T2.getTypeID() == Type.TypeID.IntegerTyID;
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }

    public static final class Unnamed_enum
    extends Enum<Unnamed_enum>
    implements Native.NativeUIntEnum {
        public static final /* enum */ Unnamed_enum MIN_INT_BITS = new Unnamed_enum(1);
        public static final /* enum */ Unnamed_enum MAX_INT_BITS = new Unnamed_enum(0x7FFFFF);
        private final int value;
        private static final /* synthetic */ Unnamed_enum[] $VALUES;

        public static Unnamed_enum[] values() {
            return (Unnamed_enum[])$VALUES.clone();
        }

        public static Unnamed_enum valueOf(String name) {
            return Enum.valueOf(Unnamed_enum.class, name);
        }

        public static Unnamed_enum valueOf(int val) {
            Unnamed_enum out;
            Unnamed_enum unnamed_enum = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private Unnamed_enum(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Unnamed_enum[]{MIN_INT_BITS, MAX_INT_BITS};
        }

        private static final class Values {
            private static final Unnamed_enum[] VALUES;
            private static final Unnamed_enum[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Unnamed_enum kind : Unnamed_enum.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Unnamed_enum[min < 0 ? 1 - min : 0];
                VALUES = new Unnamed_enum[max >= 0 ? 1 + max : 0];
                for (Unnamed_enum kind : Unnamed_enum.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((Unnamed_enum)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((Unnamed_enum)kind).value] = kind;
                }
            }
        }
    }
}

