/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Native;
import org.clank.support.aliases.type;
import org.llvm.adt.ilist_iterator;
import org.llvm.ir.AddrSpaceCastInst;
import org.llvm.ir.AllocaInst;
import org.llvm.ir.AtomicCmpXchgInst;
import org.llvm.ir.AtomicRMWInst;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.BinaryOperator;
import org.llvm.ir.BitCastInst;
import org.llvm.ir.BranchInst;
import org.llvm.ir.CallInst;
import org.llvm.ir.CallSite;
import org.llvm.ir.CastInst;
import org.llvm.ir.CatchPadInst;
import org.llvm.ir.CatchReturnInst;
import org.llvm.ir.CatchSwitchInst;
import org.llvm.ir.CleanupPadInst;
import org.llvm.ir.CleanupReturnInst;
import org.llvm.ir.CmpInst;
import org.llvm.ir.DbgDeclareInst;
import org.llvm.ir.DbgInfoIntrinsic;
import org.llvm.ir.DbgValueInst;
import org.llvm.ir.ExtractElementInst;
import org.llvm.ir.ExtractValueInst;
import org.llvm.ir.FCmpInst;
import org.llvm.ir.FPExtInst;
import org.llvm.ir.FPToSIInst;
import org.llvm.ir.FPToUIInst;
import org.llvm.ir.FPTruncInst;
import org.llvm.ir.FenceInst;
import org.llvm.ir.FuncletPadInst;
import org.llvm.ir.Function;
import org.llvm.ir.GetElementPtrInst;
import org.llvm.ir.ICmpInst;
import org.llvm.ir.IndirectBrInst;
import org.llvm.ir.InsertElementInst;
import org.llvm.ir.InsertValueInst;
import org.llvm.ir.Instruction;
import org.llvm.ir.IntToPtrInst;
import org.llvm.ir.IntrinsicInst;
import org.llvm.ir.InvokeInst;
import org.llvm.ir.LandingPadInst;
import org.llvm.ir.LoadInst;
import org.llvm.ir.MemCpyInst;
import org.llvm.ir.MemIntrinsic;
import org.llvm.ir.MemMoveInst;
import org.llvm.ir.MemSetInst;
import org.llvm.ir.MemTransferInst;
import org.llvm.ir.Module$IR;
import org.llvm.ir.PHINode;
import org.llvm.ir.PtrToIntInst;
import org.llvm.ir.ResumeInst;
import org.llvm.ir.ReturnInst;
import org.llvm.ir.SExtInst;
import org.llvm.ir.SIToFPInst;
import org.llvm.ir.SelectInst;
import org.llvm.ir.ShuffleVectorInst;
import org.llvm.ir.StoreInst;
import org.llvm.ir.SwitchInst;
import org.llvm.ir.TerminatorInst;
import org.llvm.ir.TruncInst;
import org.llvm.ir.UIToFPInst;
import org.llvm.ir.UnaryInstruction;
import org.llvm.ir.UnreachableInst;
import org.llvm.ir.VAArgInst;
import org.llvm.ir.VACopyInst;
import org.llvm.ir.VAEndInst;
import org.llvm.ir.VAStartInst;
import org.llvm.ir.ZExtInst;
import org.llvm.support.llvm_unreachable;

public interface InstVisitor<SubClass extends InstVisitor<SubClass, RetTy>, RetTy> {
    default public <Iterator extends ilist_iterator<Function>> void visit_Functions(Iterator Start, Iterator End) {
        while (Native.$noteq_iter(Start, End)) {
            this.visit_Function((Function)Native.$Deref((type.iterator)((type.iterator)Start.$postInc())));
        }
    }

    default public <Iterator extends ilist_iterator<BasicBlock>> void visit_BasicBlocks(Iterator Start, Iterator End) {
        while (Native.$noteq_iter(Start, End)) {
            this.visit_BasicBlock((BasicBlock)Native.$Deref((type.iterator)((type.iterator)Start.$postInc())));
        }
    }

    default public <Iterator extends ilist_iterator<Instruction>> void visit_Instructions(Iterator Start, Iterator End) {
        while (Native.$noteq_iter(Start, End)) {
            this.visit_Instruction((Instruction)Native.$Deref((type.iterator)((type.iterator)Start.$postInc())));
        }
    }

    default public void visit_Module(Module$IR M) {
        this.visitModule(M);
        this.visit_Functions(M.begin(), M.end());
    }

    default public void visit_Function(Function F) {
        this.visitFunction(F);
        this.visit_BasicBlocks(F.begin(), F.end());
    }

    default public void visit_BasicBlock(BasicBlock BB) {
        this.visitBasicBlock(BB);
        this.visit_Instructions(BB.begin(), BB.end());
    }

    default public void visit_Module$P(Module$IR M) {
        this.visit_Module((Module$IR)Native.$Deref((Object)M));
    }

    default public void visit_Function$P(Function F) {
        this.visit_Function((Function)Native.$Deref((Object)F));
    }

    default public void visit_BasicBlock$P(BasicBlock BB) {
        this.visit_BasicBlock((BasicBlock)Native.$Deref((Object)BB));
    }

    default public RetTy visit_Instruction$P(Instruction I) {
        return this.visit_Instruction((Instruction)Native.$Deref((Object)I));
    }

    default public RetTy visit_Instruction(Instruction I) {
        switch (I.getOpcode()) {
            default: {
                throw new llvm_unreachable("Unknown instruction type encountered!");
            }
            case 1: {
                return this.visitRet((ReturnInst)I);
            }
            case 2: {
                return this.visitBr((BranchInst)I);
            }
            case 3: {
                return this.visitSwitch((SwitchInst)I);
            }
            case 4: {
                return this.visitIndirectBr((IndirectBrInst)I);
            }
            case 5: {
                return this.visitInvoke((InvokeInst)I);
            }
            case 6: {
                return this.visitResume((ResumeInst)I);
            }
            case 7: {
                return this.visitUnreachable((UnreachableInst)I);
            }
            case 8: {
                return this.visitCleanupRet((CleanupReturnInst)I);
            }
            case 9: {
                return this.visitCatchRet((CatchReturnInst)I);
            }
            case 10: {
                return this.visitCatchSwitch((CatchSwitchInst)I);
            }
            case 11: {
                return this.visitAdd((BinaryOperator)I);
            }
            case 12: {
                return this.visitFAdd((BinaryOperator)I);
            }
            case 13: {
                return this.visitSub((BinaryOperator)I);
            }
            case 14: {
                return this.visitFSub((BinaryOperator)I);
            }
            case 15: {
                return this.visitMul((BinaryOperator)I);
            }
            case 16: {
                return this.visitFMul((BinaryOperator)I);
            }
            case 17: {
                return this.visitUDiv((BinaryOperator)I);
            }
            case 18: {
                return this.visitSDiv((BinaryOperator)I);
            }
            case 19: {
                return this.visitFDiv((BinaryOperator)I);
            }
            case 20: {
                return this.visitURem((BinaryOperator)I);
            }
            case 21: {
                return this.visitSRem((BinaryOperator)I);
            }
            case 22: {
                return this.visitFRem((BinaryOperator)I);
            }
            case 23: {
                return this.visitShl((BinaryOperator)I);
            }
            case 24: {
                return this.visitLShr((BinaryOperator)I);
            }
            case 25: {
                return this.visitAShr((BinaryOperator)I);
            }
            case 26: {
                return this.visitAnd((BinaryOperator)I);
            }
            case 27: {
                return this.visitOr((BinaryOperator)I);
            }
            case 28: {
                return this.visitXor((BinaryOperator)I);
            }
            case 29: {
                return this.visitAlloca((AllocaInst)I);
            }
            case 30: {
                return this.visitLoad((LoadInst)I);
            }
            case 31: {
                return this.visitStore((StoreInst)I);
            }
            case 32: {
                return this.visitGetElementPtr((GetElementPtrInst)I);
            }
            case 33: {
                return this.visitFence((FenceInst)I);
            }
            case 34: {
                return this.visitAtomicCmpXchg((AtomicCmpXchgInst)I);
            }
            case 35: {
                return this.visitAtomicRMW((AtomicRMWInst)I);
            }
            case 36: {
                return this.visitTrunc((TruncInst)I);
            }
            case 37: {
                return this.visitZExt((ZExtInst)I);
            }
            case 38: {
                return this.visitSExt((SExtInst)I);
            }
            case 39: {
                return this.visitFPToUI((FPToUIInst)I);
            }
            case 40: {
                return this.visitFPToSI((FPToSIInst)I);
            }
            case 41: {
                return this.visitUIToFP((UIToFPInst)I);
            }
            case 42: {
                return this.visitSIToFP((SIToFPInst)I);
            }
            case 43: {
                return this.visitFPTrunc((FPTruncInst)I);
            }
            case 44: {
                return this.visitFPExt((FPExtInst)I);
            }
            case 45: {
                return this.visitPtrToInt((PtrToIntInst)I);
            }
            case 46: {
                return this.visitIntToPtr((IntToPtrInst)I);
            }
            case 47: {
                return this.visitBitCast((BitCastInst)I);
            }
            case 48: {
                return this.visitAddrSpaceCast((AddrSpaceCastInst)I);
            }
            case 49: {
                return this.visitCleanupPad((CleanupPadInst)I);
            }
            case 50: {
                return this.visitCatchPad((CatchPadInst)I);
            }
            case 51: {
                return this.visitICmp((ICmpInst)I);
            }
            case 52: {
                return this.visitFCmp((FCmpInst)I);
            }
            case 53: {
                return this.visitPHI((PHINode)I);
            }
            case 54: {
                return this.visitCall((CallInst)I);
            }
            case 55: {
                return this.visitSelect((SelectInst)I);
            }
            case 56: {
                return this.visitUserOp1(I);
            }
            case 57: {
                return this.visitUserOp2(I);
            }
            case 58: {
                return this.visitVAArg((VAArgInst)I);
            }
            case 59: {
                return this.visitExtractElement((ExtractElementInst)I);
            }
            case 60: {
                return this.visitInsertElement((InsertElementInst)I);
            }
            case 61: {
                return this.visitShuffleVector((ShuffleVectorInst)I);
            }
            case 62: {
                return this.visitExtractValue((ExtractValueInst)I);
            }
            case 63: {
                return this.visitInsertValue((InsertValueInst)I);
            }
            case 64: 
        }
        return this.visitLandingPad((LandingPadInst)I);
    }

    default public void visitModule(Module$IR M) {
    }

    default public void visitFunction(Function F) {
    }

    default public void visitBasicBlock(BasicBlock BB) {
    }

    default public RetTy visitRet(ReturnInst I) {
        return this.visitReturnInst(I);
    }

    default public RetTy visitBr(BranchInst I) {
        return this.visitBranchInst(I);
    }

    default public RetTy visitSwitch(SwitchInst I) {
        return this.visitSwitchInst(I);
    }

    default public RetTy visitIndirectBr(IndirectBrInst I) {
        return this.visitIndirectBrInst(I);
    }

    default public RetTy visitInvoke(InvokeInst I) {
        return this.visitInvokeInst(I);
    }

    default public RetTy visitResume(ResumeInst I) {
        return this.visitResumeInst(I);
    }

    default public RetTy visitUnreachable(UnreachableInst I) {
        return this.visitUnreachableInst(I);
    }

    default public RetTy visitCleanupRet(CleanupReturnInst I) {
        return this.visitCleanupReturnInst(I);
    }

    default public RetTy visitCatchRet(CatchReturnInst I) {
        return this.visitCatchReturnInst(I);
    }

    default public RetTy visitCatchSwitch(CatchSwitchInst I) {
        return this.visitCatchSwitchInst(I);
    }

    default public RetTy visitAdd(BinaryOperator I) {
        return this.visitBinaryOperator(I);
    }

    default public RetTy visitFAdd(BinaryOperator I) {
        return this.visitBinaryOperator(I);
    }

    default public RetTy visitSub(BinaryOperator I) {
        return this.visitBinaryOperator(I);
    }

    default public RetTy visitFSub(BinaryOperator I) {
        return this.visitBinaryOperator(I);
    }

    default public RetTy visitMul(BinaryOperator I) {
        return this.visitBinaryOperator(I);
    }

    default public RetTy visitFMul(BinaryOperator I) {
        return this.visitBinaryOperator(I);
    }

    default public RetTy visitUDiv(BinaryOperator I) {
        return this.visitBinaryOperator(I);
    }

    default public RetTy visitSDiv(BinaryOperator I) {
        return this.visitBinaryOperator(I);
    }

    default public RetTy visitFDiv(BinaryOperator I) {
        return this.visitBinaryOperator(I);
    }

    default public RetTy visitURem(BinaryOperator I) {
        return this.visitBinaryOperator(I);
    }

    default public RetTy visitSRem(BinaryOperator I) {
        return this.visitBinaryOperator(I);
    }

    default public RetTy visitFRem(BinaryOperator I) {
        return this.visitBinaryOperator(I);
    }

    default public RetTy visitShl(BinaryOperator I) {
        return this.visitBinaryOperator(I);
    }

    default public RetTy visitLShr(BinaryOperator I) {
        return this.visitBinaryOperator(I);
    }

    default public RetTy visitAShr(BinaryOperator I) {
        return this.visitBinaryOperator(I);
    }

    default public RetTy visitAnd(BinaryOperator I) {
        return this.visitBinaryOperator(I);
    }

    default public RetTy visitOr(BinaryOperator I) {
        return this.visitBinaryOperator(I);
    }

    default public RetTy visitXor(BinaryOperator I) {
        return this.visitBinaryOperator(I);
    }

    default public RetTy visitAlloca(AllocaInst I) {
        return this.visitAllocaInst(I);
    }

    default public RetTy visitLoad(LoadInst I) {
        return this.visitLoadInst(I);
    }

    default public RetTy visitStore(StoreInst I) {
        return this.visitStoreInst(I);
    }

    default public RetTy visitGetElementPtr(GetElementPtrInst I) {
        return this.visitGetElementPtrInst(I);
    }

    default public RetTy visitFence(FenceInst I) {
        return this.visitFenceInst(I);
    }

    default public RetTy visitAtomicCmpXchg(AtomicCmpXchgInst I) {
        return this.visitAtomicCmpXchgInst(I);
    }

    default public RetTy visitAtomicRMW(AtomicRMWInst I) {
        return this.visitAtomicRMWInst(I);
    }

    default public RetTy visitTrunc(TruncInst I) {
        return this.visitTruncInst(I);
    }

    default public RetTy visitZExt(ZExtInst I) {
        return this.visitZExtInst(I);
    }

    default public RetTy visitSExt(SExtInst I) {
        return this.visitSExtInst(I);
    }

    default public RetTy visitFPToUI(FPToUIInst I) {
        return this.visitFPToUIInst(I);
    }

    default public RetTy visitFPToSI(FPToSIInst I) {
        return this.visitFPToSIInst(I);
    }

    default public RetTy visitUIToFP(UIToFPInst I) {
        return this.visitUIToFPInst(I);
    }

    default public RetTy visitSIToFP(SIToFPInst I) {
        return this.visitSIToFPInst(I);
    }

    default public RetTy visitFPTrunc(FPTruncInst I) {
        return this.visitFPTruncInst(I);
    }

    default public RetTy visitFPExt(FPExtInst I) {
        return this.visitFPExtInst(I);
    }

    default public RetTy visitPtrToInt(PtrToIntInst I) {
        return this.visitPtrToIntInst(I);
    }

    default public RetTy visitIntToPtr(IntToPtrInst I) {
        return this.visitIntToPtrInst(I);
    }

    default public RetTy visitBitCast(BitCastInst I) {
        return this.visitBitCastInst(I);
    }

    default public RetTy visitAddrSpaceCast(AddrSpaceCastInst I) {
        return this.visitAddrSpaceCastInst(I);
    }

    default public RetTy visitCleanupPad(CleanupPadInst I) {
        return this.visitCleanupPadInst(I);
    }

    default public RetTy visitCatchPad(CatchPadInst I) {
        return this.visitCatchPadInst(I);
    }

    default public RetTy visitICmp(ICmpInst I) {
        return this.visitICmpInst(I);
    }

    default public RetTy visitFCmp(FCmpInst I) {
        return this.visitFCmpInst(I);
    }

    default public RetTy visitPHI(PHINode I) {
        return this.visitPHINode(I);
    }

    default public RetTy visitCall(CallInst I) {
        return this.delegateCallInst(I);
    }

    default public RetTy visitSelect(SelectInst I) {
        return this.visitSelectInst(I);
    }

    default public RetTy visitUserOp1(Instruction I) {
        return this.visitInstruction(I);
    }

    default public RetTy visitUserOp2(Instruction I) {
        return this.visitInstruction(I);
    }

    default public RetTy visitVAArg(VAArgInst I) {
        return this.visitVAArgInst(I);
    }

    default public RetTy visitExtractElement(ExtractElementInst I) {
        return this.visitExtractElementInst(I);
    }

    default public RetTy visitInsertElement(InsertElementInst I) {
        return this.visitInsertElementInst(I);
    }

    default public RetTy visitShuffleVector(ShuffleVectorInst I) {
        return this.visitShuffleVectorInst(I);
    }

    default public RetTy visitExtractValue(ExtractValueInst I) {
        return this.visitExtractValueInst(I);
    }

    default public RetTy visitInsertValue(InsertValueInst I) {
        return this.visitInsertValueInst(I);
    }

    default public RetTy visitLandingPad(LandingPadInst I) {
        return this.visitLandingPadInst(I);
    }

    default public RetTy visitReturnInst(ReturnInst I) {
        return this.visitTerminatorInst(I);
    }

    default public RetTy visitBranchInst(BranchInst I) {
        return this.visitTerminatorInst(I);
    }

    default public RetTy visitSwitchInst(SwitchInst I) {
        return this.visitTerminatorInst(I);
    }

    default public RetTy visitIndirectBrInst(IndirectBrInst I) {
        return this.visitTerminatorInst(I);
    }

    default public RetTy visitResumeInst(ResumeInst I) {
        return this.visitTerminatorInst(I);
    }

    default public RetTy visitUnreachableInst(UnreachableInst I) {
        return this.visitTerminatorInst(I);
    }

    default public RetTy visitCleanupReturnInst(CleanupReturnInst I) {
        return this.visitTerminatorInst(I);
    }

    default public RetTy visitCatchReturnInst(CatchReturnInst I) {
        return this.visitTerminatorInst(I);
    }

    default public RetTy visitCatchSwitchInst(CatchSwitchInst I) {
        return this.visitTerminatorInst(I);
    }

    default public RetTy visitICmpInst(ICmpInst I) {
        return this.visitCmpInst(I);
    }

    default public RetTy visitFCmpInst(FCmpInst I) {
        return this.visitCmpInst(I);
    }

    default public RetTy visitAllocaInst(AllocaInst I) {
        return this.visitUnaryInstruction(I);
    }

    default public RetTy visitLoadInst(LoadInst I) {
        return this.visitUnaryInstruction(I);
    }

    default public RetTy visitStoreInst(StoreInst I) {
        return this.visitInstruction(I);
    }

    default public RetTy visitAtomicCmpXchgInst(AtomicCmpXchgInst I) {
        return this.visitInstruction(I);
    }

    default public RetTy visitAtomicRMWInst(AtomicRMWInst I) {
        return this.visitInstruction(I);
    }

    default public RetTy visitFenceInst(FenceInst I) {
        return this.visitInstruction(I);
    }

    default public RetTy visitGetElementPtrInst(GetElementPtrInst I) {
        return this.visitInstruction(I);
    }

    default public RetTy visitPHINode(PHINode I) {
        return this.visitInstruction(I);
    }

    default public RetTy visitTruncInst(TruncInst I) {
        return this.visitCastInst(I);
    }

    default public RetTy visitZExtInst(ZExtInst I) {
        return this.visitCastInst(I);
    }

    default public RetTy visitSExtInst(SExtInst I) {
        return this.visitCastInst(I);
    }

    default public RetTy visitFPTruncInst(FPTruncInst I) {
        return this.visitCastInst(I);
    }

    default public RetTy visitFPExtInst(FPExtInst I) {
        return this.visitCastInst(I);
    }

    default public RetTy visitFPToUIInst(FPToUIInst I) {
        return this.visitCastInst(I);
    }

    default public RetTy visitFPToSIInst(FPToSIInst I) {
        return this.visitCastInst(I);
    }

    default public RetTy visitUIToFPInst(UIToFPInst I) {
        return this.visitCastInst(I);
    }

    default public RetTy visitSIToFPInst(SIToFPInst I) {
        return this.visitCastInst(I);
    }

    default public RetTy visitPtrToIntInst(PtrToIntInst I) {
        return this.visitCastInst(I);
    }

    default public RetTy visitIntToPtrInst(IntToPtrInst I) {
        return this.visitCastInst(I);
    }

    default public RetTy visitBitCastInst(BitCastInst I) {
        return this.visitCastInst(I);
    }

    default public RetTy visitAddrSpaceCastInst(AddrSpaceCastInst I) {
        return this.visitCastInst(I);
    }

    default public RetTy visitSelectInst(SelectInst I) {
        return this.visitInstruction(I);
    }

    default public RetTy visitVAArgInst(VAArgInst I) {
        return this.visitUnaryInstruction(I);
    }

    default public RetTy visitExtractElementInst(ExtractElementInst I) {
        return this.visitInstruction(I);
    }

    default public RetTy visitInsertElementInst(InsertElementInst I) {
        return this.visitInstruction(I);
    }

    default public RetTy visitShuffleVectorInst(ShuffleVectorInst I) {
        return this.visitInstruction(I);
    }

    default public RetTy visitExtractValueInst(ExtractValueInst I) {
        return this.visitUnaryInstruction(I);
    }

    default public RetTy visitInsertValueInst(InsertValueInst I) {
        return this.visitInstruction(I);
    }

    default public RetTy visitLandingPadInst(LandingPadInst I) {
        return this.visitInstruction(I);
    }

    default public RetTy visitFuncletPadInst(FuncletPadInst I) {
        return this.visitInstruction(I);
    }

    default public RetTy visitCleanupPadInst(CleanupPadInst I) {
        return this.visitFuncletPadInst(I);
    }

    default public RetTy visitCatchPadInst(CatchPadInst I) {
        return this.visitFuncletPadInst(I);
    }

    default public RetTy visitDbgDeclareInst(DbgDeclareInst I) {
        return this.visitDbgInfoIntrinsic(I);
    }

    default public RetTy visitDbgValueInst(DbgValueInst I) {
        return this.visitDbgInfoIntrinsic(I);
    }

    default public RetTy visitDbgInfoIntrinsic(DbgInfoIntrinsic I) {
        return this.visitIntrinsicInst(I);
    }

    default public RetTy visitMemSetInst(MemSetInst I) {
        return this.visitMemIntrinsic(I);
    }

    default public RetTy visitMemCpyInst(MemCpyInst I) {
        return this.visitMemTransferInst(I);
    }

    default public RetTy visitMemMoveInst(MemMoveInst I) {
        return this.visitMemTransferInst(I);
    }

    default public RetTy visitMemTransferInst(MemTransferInst I) {
        return this.visitMemIntrinsic(I);
    }

    default public RetTy visitMemIntrinsic(MemIntrinsic I) {
        return this.visitIntrinsicInst(I);
    }

    default public RetTy visitVAStartInst(VAStartInst I) {
        return this.visitIntrinsicInst(I);
    }

    default public RetTy visitVAEndInst(VAEndInst I) {
        return this.visitIntrinsicInst(I);
    }

    default public RetTy visitVACopyInst(VACopyInst I) {
        return this.visitIntrinsicInst(I);
    }

    default public RetTy visitIntrinsicInst(IntrinsicInst I) {
        return this.visitCallInst(I);
    }

    default public RetTy visitCallInst(CallInst I) {
        return this.visitCallSite((CallSite)Native.$AddrOf((Object)new CallSite(I)));
    }

    default public RetTy visitInvokeInst(InvokeInst I) {
        return this.visitCallSite((CallSite)Native.$AddrOf((Object)new CallSite(I)));
    }

    default public RetTy visitCastInst(CastInst I) {
        return this.visitUnaryInstruction(I);
    }

    default public RetTy visitBinaryOperator(BinaryOperator I) {
        return this.visitInstruction(I);
    }

    default public RetTy visitCmpInst(CmpInst I) {
        return this.visitInstruction(I);
    }

    default public RetTy visitTerminatorInst(TerminatorInst I) {
        return this.visitInstruction(I);
    }

    default public RetTy visitUnaryInstruction(UnaryInstruction I) {
        return this.visitInstruction(I);
    }

    default public RetTy visitCallSite(CallSite CS) {
        if (!1.$assertionsDisabled && !CS.$bool()) {
            throw new AssertionError();
        }
        Instruction I = (Instruction)Native.$Deref(CS.getInstruction());
        if (CS.isCall()) {
            return this.visitInstruction(I);
        }
        if (!1.$assertionsDisabled && !CS.isInvoke()) {
            throw new AssertionError();
        }
        return this.visitTerminatorInst((TerminatorInst)I);
    }

    default public RetTy visitInstruction(Instruction I) {
        return null;
    }

    default public RetTy delegateCallInst(CallInst I) {
        Function F = I.getCalledFunction();
        if (F != null) {
            switch (F.getIntrinsicID()) {
                default: {
                    return this.visitIntrinsicInst((IntrinsicInst)I);
                }
                case 25: {
                    return this.visitDbgDeclareInst((DbgDeclareInst)I);
                }
                case 26: {
                    return this.visitDbgValueInst((DbgValueInst)I);
                }
                case 84: {
                    return this.visitMemCpyInst((MemCpyInst)I);
                }
                case 85: {
                    return this.visitMemMoveInst((MemMoveInst)I);
                }
                case 86: {
                    return this.visitMemSetInst((MemSetInst)I);
                }
                case 122: {
                    return this.visitVAStartInst((VAStartInst)I);
                }
                case 121: {
                    return this.visitVAEndInst((VAEndInst)I);
                }
                case 120: {
                    return this.visitVACopyInst((VACopyInst)I);
                }
                case 0: 
            }
        }
        return this.visitCallInst(I);
    }

    default public RetTy delegateCallInst(Instruction I) {
        throw new llvm_unreachable("delegateCallInst called for non-CallInst");
    }

    default public void $InstVisitor() {
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

