/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.DenseSet;
import org.llvm.ir.GlobalValue;
import org.llvm.ir.Value;
import org.llvm.ir.ValueInfo;

public class GlobalValueSummary
implements Destructors.ClassWithDestructor {
    private SummaryKind Kind;
    private long OriginalName;
    private StringRef ModulePath;
    private GVFlags Flags;
    private std.vector<ValueInfo> RefEdgeList;

    protected GlobalValueSummary(SummaryKind K, GVFlags Flags) {
        this.Kind = K;
        this.ModulePath = new StringRef();
        this.Flags = new GVFlags(Flags);
        this.RefEdgeList = new std.vector((Object)new ValueInfo());
    }

    public void $destroy() {
        this.RefEdgeList.$destroy();
    }

    public long getOriginalName() {
        return this.OriginalName;
    }

    public void setOriginalName(long Name) {
        this.OriginalName = Name;
    }

    public SummaryKind getSummaryKind() {
        return this.Kind;
    }

    public void setModulePath(StringRef ModPath) {
        this.ModulePath.$assign(ModPath);
    }

    public StringRef modulePath() {
        return new StringRef(this.ModulePath);
    }

    public GVFlags flags() {
        return new GVFlags(this.Flags);
    }

    public GlobalValue.LinkageTypes linkage() {
        return GlobalValue.LinkageTypes.valueOf(Unsigned.$4bits_uint2uint((byte)this.Flags.Linkage));
    }

    public void setLinkage(GlobalValue.LinkageTypes Linkage) {
        this.Flags.Linkage = Unsigned.$uint2uint_4bits((int)Linkage.getValue());
    }

    public boolean needsRenaming() {
        return GlobalValue.isLocalLinkage(this.linkage());
    }

    public boolean hasSection() {
        return this.Flags.HasSection;
    }

    public void addRefEdge(long RefGUID) {
        this.RefEdgeList.push_back_T$RR((Object)new ValueInfo(RefGUID));
    }

    public void addRefEdge(Value RefV) {
        this.RefEdgeList.push_back_T$RR((Object)new ValueInfo(RefV));
    }

    public void addRefEdges(DenseSet<Value> RefEdges) {
        for (Value RI : RefEdges) {
            this.addRefEdge(RI);
        }
    }

    public std.vector<ValueInfo> refs() {
        return this.RefEdgeList;
    }

    public std.vector<ValueInfo> refs$Const() {
        return this.RefEdgeList;
    }

    public String toString() {
        return "Kind=" + (Object)((Object)this.Kind) + ", OriginalName=" + this.OriginalName + ", ModulePath=" + this.ModulePath + ", Flags=" + this.Flags + ", RefEdgeList=" + this.RefEdgeList;
    }

    public static class GVFlags {
        public byte Linkage;
        public boolean HasSection;

        public GVFlags(GlobalValue.LinkageTypes Linkage, boolean HasSection) {
            this.Linkage = Unsigned.$uint2uint_4bits((int)Linkage.getValue());
            this.HasSection = HasSection;
        }

        public GVFlags(GlobalValue GV) {
            this.Linkage = Unsigned.$uint2uint_4bits((int)GV.getLinkage().getValue());
            this.HasSection = GV.hasSection();
        }

        public GVFlags(GVFlags $Prm0) {
            this.Linkage = Unsigned.$uint2uint_4bits((int)Unsigned.$4bits_uint2uint((byte)$Prm0.Linkage));
            this.HasSection = $Prm0.HasSection;
        }

        public GVFlags(JavaDifferentiators.JD.Move _dparam, GVFlags $Prm0) {
            this.Linkage = Unsigned.$uint2uint_4bits((int)Unsigned.$4bits_uint2uint((byte)$Prm0.Linkage));
            this.HasSection = $Prm0.HasSection;
        }

        public String toString() {
            return "Linkage=" + Unsigned.$uchar2uint((byte)this.Linkage) + ", HasSection=" + this.HasSection;
        }
    }

    public static final class SummaryKind
    extends Enum<SummaryKind>
    implements Native.NativeUIntEnum {
        public static final /* enum */ SummaryKind AliasKind = new SummaryKind(0);
        public static final /* enum */ SummaryKind FunctionKind = new SummaryKind(AliasKind.getValue() + 1);
        public static final /* enum */ SummaryKind GlobalVarKind = new SummaryKind(FunctionKind.getValue() + 1);
        private final int value;
        private static final /* synthetic */ SummaryKind[] $VALUES;

        public static SummaryKind[] values() {
            return (SummaryKind[])$VALUES.clone();
        }

        public static SummaryKind valueOf(String name) {
            return Enum.valueOf(SummaryKind.class, name);
        }

        public static SummaryKind valueOf(int val) {
            SummaryKind out;
            SummaryKind summaryKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private SummaryKind(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new SummaryKind[]{AliasKind, FunctionKind, GlobalVarKind};
        }

        private static final class Values {
            private static final SummaryKind[] VALUES;
            private static final SummaryKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (SummaryKind kind : SummaryKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new SummaryKind[min < 0 ? 1 - min : 0];
                VALUES = new SummaryKind[max >= 0 ? 1 + max : 0];
                for (SummaryKind kind : SummaryKind.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((SummaryKind)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((SummaryKind)kind).value] = kind;
                }
            }
        }
    }
}

