/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.JavaDifferentiators;

public class FastMathFlags {
    public int Flags;
    public static final int UnsafeAlgebra = 1;
    public static final int NoNaNs = 2;
    public static final int NoInfs = 4;
    public static final int NoSignedZeros = 8;
    public static final int AllowReciprocal = 16;

    public FastMathFlags(int F) {
        this.Flags = F;
    }

    public FastMathFlags() {
        this.Flags = 0;
    }

    public boolean any() {
        return this.Flags != 0;
    }

    public void clear() {
        this.Flags = 0;
    }

    public boolean noNaNs() {
        return 0 != (this.Flags & 2);
    }

    public boolean noInfs() {
        return 0 != (this.Flags & 4);
    }

    public boolean noSignedZeros() {
        return 0 != (this.Flags & 8);
    }

    public boolean allowReciprocal() {
        return 0 != (this.Flags & 0x10);
    }

    public boolean unsafeAlgebra() {
        return 0 != (this.Flags & 1);
    }

    public void setNoNaNs() {
        this.Flags |= 2;
    }

    public void setNoInfs() {
        this.Flags |= 4;
    }

    public void setNoSignedZeros() {
        this.Flags |= 8;
    }

    public void setAllowReciprocal() {
        this.Flags |= 0x10;
    }

    public void setUnsafeAlgebra() {
        this.Flags |= 1;
        this.setNoNaNs();
        this.setNoInfs();
        this.setNoSignedZeros();
        this.setAllowReciprocal();
    }

    public void $andassign(FastMathFlags OtherFlags) {
        this.Flags &= OtherFlags.Flags;
    }

    public FastMathFlags(FastMathFlags $Prm0) {
        this.Flags = $Prm0.Flags;
    }

    public FastMathFlags(JavaDifferentiators.JD.Move _dparam, FastMathFlags $Prm0) {
        this.Flags = $Prm0.Flags;
    }

    public FastMathFlags $assign(FastMathFlags $Prm0) {
        this.Flags = $Prm0.Flags;
        return this;
    }

    public FastMathFlags $assignMove(FastMathFlags $Prm0) {
        this.Flags = $Prm0.Flags;
        return this;
    }

    public String toString() {
        return "Flags=" + this.Flags;
    }
}

