/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.llvm.adt.ilist_iterator;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.BasicBlockEdge;
import org.llvm.ir.DominatorTreeBase$BasicBlock;
import org.llvm.ir.Function;
import org.llvm.ir.GraphTraitsFunction$P;
import org.llvm.ir.Instruction;
import org.llvm.ir.InvokeInst;
import org.llvm.ir.PHINode;
import org.llvm.ir.PredIterator;
import org.llvm.ir.Use;
import org.llvm.ir.User;
import org.llvm.ir.Value;
import org.llvm.ir.java.IrRTTI;
import org.llvm.pass.IrLlvmGlobals;
import org.llvm.support.DomTreeNodeBase;
import org.llvm.support.DominatorTreeBase;
import org.llvm.support.llvm;

public class DominatorTree
extends DominatorTreeBase$BasicBlock
implements Destructors.ClassWithDestructor {
    public DominatorTree() {
        super(false);
    }

    public DominatorTree(Function F) {
        super(false);
        this.recalculate(GraphTraitsFunction$P.$GTraits(), F);
    }

    public DominatorTree(JavaDifferentiators.JD.Move _dparam, DominatorTree Arg) {
        super(JavaDifferentiators.JD.Move.INSTANCE, (DominatorTreeBase$BasicBlock)((Object)std.move((Object)((Object)Arg))));
    }

    public DominatorTree $assignMove(DominatorTree RHS) {
        super.$assignMove((DominatorTreeBase)std.move((Object)((Object)RHS)));
        return this;
    }

    public boolean compare(DominatorTree Other) {
        DomTreeNodeBase R = this.getRootNode$Const();
        DomTreeNodeBase OtherR = Other.getRootNode$Const();
        if (R == null || OtherR == null || R.getBlock() != OtherR.getBlock()) {
            return true;
        }
        return super.compare((DominatorTreeBase)Other);
    }

    public boolean dominates(Instruction Def, Use U) {
        Instruction UserInst = IrRTTI.cast_Instruction(U.getUser());
        BasicBlock DefBB = Def.getParent$Const();
        PHINode PN = IrRTTI.dyn_cast_PHINode(UserInst);
        BasicBlock UseBB = PN != null ? PN.getIncomingBlock(U) : UserInst.getParent();
        if (!this.isReachableFromEntry(UseBB)) {
            return true;
        }
        if (!this.isReachableFromEntry(DefBB)) {
            return false;
        }
        InvokeInst II = IrRTTI.dyn_cast_InvokeInst(Def);
        if (II != null) {
            BasicBlock NormalDest = II.getNormalDest();
            BasicBlockEdge E = new BasicBlockEdge(DefBB, NormalDest);
            return this.dominates(E, U);
        }
        if (DefBB != UseBB) {
            return this.dominates(DefBB, UseBB);
        }
        if (IrRTTI.isa_PHINode(UserInst)) {
            return true;
        }
        ilist_iterator<Instruction> I = DefBB.begin$Const();
        while (Native.$AddrOf((Object)((Instruction)I.$star())) != Def && Native.$AddrOf((Object)((Instruction)I.$star())) != UserInst) {
            I.$preInc();
        }
        return Native.$AddrOf((Object)((Instruction)I.$star())) != UserInst;
    }

    public boolean dominates(Instruction Def, Instruction User2) {
        BasicBlock UseBB = User2.getParent$Const();
        BasicBlock DefBB = Def.getParent$Const();
        if (!this.isReachableFromEntry(UseBB)) {
            return true;
        }
        if (!this.isReachableFromEntry(DefBB)) {
            return false;
        }
        if (Def == User2) {
            return false;
        }
        if (IrRTTI.isa_InvokeInst(Def) || IrRTTI.isa_PHINode(User2)) {
            return this.dominates(Def, UseBB);
        }
        if (DefBB != UseBB) {
            return this.dominates(DefBB, UseBB);
        }
        ilist_iterator<Instruction> I = DefBB.begin$Const();
        while (Native.$AddrOf((Object)((Instruction)I.$star())) != Def && Native.$AddrOf((Object)((Instruction)I.$star())) != User2) {
            I.$preInc();
        }
        return Native.$AddrOf((Object)((Instruction)I.$star())) == Def;
    }

    public boolean dominates(Instruction Def, BasicBlock UseBB) {
        BasicBlock DefBB = Def.getParent$Const();
        if (!this.isReachableFromEntry(UseBB)) {
            return true;
        }
        if (!this.isReachableFromEntry(DefBB)) {
            return false;
        }
        if (DefBB == UseBB) {
            return false;
        }
        InvokeInst II = IrRTTI.dyn_cast_InvokeInst(Def);
        if (II != null) {
            BasicBlock NormalDest = II.getNormalDest();
            BasicBlockEdge E = new BasicBlockEdge(DefBB, NormalDest);
            return this.dominates(E, UseBB);
        }
        return this.dominates(DefBB, UseBB);
    }

    public boolean dominates(BasicBlockEdge BBE, Use U) {
        assert (BBE.isSingleEdge()) : "This function is not efficient in handling multiple edges";
        Instruction UserInst = IrRTTI.cast_Instruction(U.getUser());
        PHINode PN = IrRTTI.dyn_cast_PHINode(UserInst);
        if (PN != null && PN.getParent() == BBE.getEnd() && PN.getIncomingBlock(U) == BBE.getStart()) {
            return true;
        }
        BasicBlock UseBB = PN != null ? PN.getIncomingBlock(U) : UserInst.getParent();
        return this.dominates(BBE, UseBB);
    }

    public boolean dominates(BasicBlockEdge BBE, BasicBlock UseBB) {
        assert (BBE.isSingleEdge()) : "This function is not efficient in handling multiple edges";
        BasicBlock Start = BBE.getStart();
        BasicBlock End = BBE.getEnd();
        if (!this.dominates(End, UseBB)) {
            return false;
        }
        if (End.getSinglePredecessor$Const() != null) {
            return true;
        }
        PredIterator<BasicBlock, Value.user_iterator_impl<User>> PI = IrLlvmGlobals.pred_begin_BasicBlock$C$P(End);
        PredIterator<BasicBlock, Value.user_iterator_impl<User>> E = IrLlvmGlobals.pred_end_BasicBlock$C$P(End);
        while (PI.$noteq(E)) {
            BasicBlock BB = (BasicBlock)PI.$star();
            if (BB != Start && !this.dominates(End, BB)) {
                return false;
            }
            PI.$preInc();
        }
        return true;
    }

    public boolean isReachableFromEntry(Use U) {
        Instruction I = IrRTTI.dyn_cast_Instruction(U.getUser());
        if (I == null) {
            return true;
        }
        PHINode PN = IrRTTI.dyn_cast_PHINode(I);
        if (PN != null) {
            return this.isReachableFromEntry(PN.getIncomingBlock(U));
        }
        return this.isReachableFromEntry(I.getParent());
    }

    public void verifyDomTree() {
        DominatorTree OtherDT = null;
        try {
            Function F = (Function)Native.$Deref((Object)((BasicBlock)this.getRoot()).getParent());
            OtherDT = new DominatorTree();
            OtherDT.recalculate(GraphTraitsFunction$P.$GTraits(), F);
            if (this.compare(OtherDT)) {
                llvm.errs().$out("DominatorTree is not up to date!\nComputed:\n");
                this.print(llvm.errs());
                llvm.errs().$out("\nActual:\n");
                OtherDT.print(llvm.errs());
                std.abort();
            }
        }
        finally {
            if (OtherDT != null) {
                OtherDT.$destroy();
            }
        }
    }

    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

