/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.Unsigned;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.ir.DiagnosticInfo;
import org.llvm.ir.DiagnosticKind;
import org.llvm.ir.DiagnosticPrinter;
import org.llvm.ir.DiagnosticSeverity;

public class DiagnosticInfoSampleProfile
extends DiagnosticInfo
implements Destructors.ClassWithDestructor {
    private StringRef FileName;
    private int LineNum;
    private final Twine Msg;

    public DiagnosticInfoSampleProfile(StringRef FileName, int LineNum, Twine Msg) {
        this(FileName, LineNum, Msg, DiagnosticSeverity.DS_Error);
    }

    public DiagnosticInfoSampleProfile(StringRef FileName, int LineNum, Twine Msg, DiagnosticSeverity Severity) {
        super(DiagnosticKind.DK_SampleProfile.getValue(), Severity);
        this.FileName = new StringRef(FileName);
        this.LineNum = LineNum;
        this.Msg = Msg;
    }

    public DiagnosticInfoSampleProfile(StringRef FileName, Twine Msg) {
        this(FileName, Msg, DiagnosticSeverity.DS_Error);
    }

    public DiagnosticInfoSampleProfile(StringRef FileName, Twine Msg, DiagnosticSeverity Severity) {
        super(DiagnosticKind.DK_SampleProfile.getValue(), Severity);
        this.FileName = new StringRef(FileName);
        this.LineNum = 0;
        this.Msg = Msg;
    }

    public DiagnosticInfoSampleProfile(Twine Msg) {
        this(Msg, DiagnosticSeverity.DS_Error);
    }

    public DiagnosticInfoSampleProfile(Twine Msg, DiagnosticSeverity Severity) {
        super(DiagnosticKind.DK_SampleProfile.getValue(), Severity);
        this.FileName = new StringRef();
        this.LineNum = 0;
        this.Msg = Msg;
    }

    @Override
    public void print(DiagnosticPrinter DP) {
        if (!this.FileName.empty()) {
            DP.$out(this.getFileName());
            if (Unsigned.$greater_uint((int)this.LineNum, (int)0)) {
                DP.$out(":").$out_uint(this.getLineNum());
            }
            DP.$out(": ");
        }
        DP.$out(this.getMsg());
    }

    public static boolean classof(DiagnosticInfo DI) {
        return DI.getKind() == DiagnosticKind.DK_SampleProfile.getValue();
    }

    public StringRef getFileName() {
        return new StringRef(this.FileName);
    }

    public int getLineNum() {
        return this.LineNum;
    }

    public Twine getMsg() {
        return this.Msg;
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "FileName=" + this.FileName + ", LineNum=" + this.LineNum + ", Msg=" + this.Msg + super.toString();
    }
}

