/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.llvm.ir.DILocation;
import org.llvm.ir.DIScope;
import org.llvm.ir.DISubprogram;
import org.llvm.ir.MDNode;
import org.llvm.ir.TypedTrackingMDRef;
import org.llvm.ir.java.IrRTTI;
import org.llvm.pass.IrLlvmGlobals;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class DebugLoc
implements Destructors.ClassWithDestructor,
Native.NativeComparable<DebugLoc>,
Native.Native$Bool {
    private TypedTrackingMDRef<MDNode> Loc;

    public DebugLoc() {
        this.Loc = new TypedTrackingMDRef();
    }

    public DebugLoc(JavaDifferentiators.JD.Move _dparam, DebugLoc X) {
        this.Loc = new TypedTrackingMDRef(JavaDifferentiators.JD.Move.INSTANCE, (TypedTrackingMDRef)std.move(X.Loc));
    }

    public DebugLoc(DebugLoc X) {
        this.Loc = new TypedTrackingMDRef<MDNode>(X.Loc);
    }

    public DebugLoc $assignMove(DebugLoc X) {
        this.Loc.$assignMove((TypedTrackingMDRef)std.move(X.Loc));
        return this;
    }

    public DebugLoc $assign(DebugLoc X) {
        this.Loc.$assign(X.Loc);
        return this;
    }

    public DebugLoc(DILocation L) {
        this.Loc = new TypedTrackingMDRef<DILocation>(L);
    }

    public DebugLoc(MDNode L) {
        this.Loc = new TypedTrackingMDRef<MDNode>(L);
    }

    public DILocation get() {
        return IrRTTI.cast_or_null_DILocation(this.Loc.get());
    }

    public DILocation $DILocation$P() {
        return this.get();
    }

    public DILocation $arrow() {
        return this.get();
    }

    public DILocation $star() {
        return (DILocation)Native.$Deref((Object)this.get());
    }

    public boolean $bool() {
        return this.Loc.$T$P() != null;
    }

    public boolean hasTrivialDestructor() {
        return this.Loc.hasTrivialDestructor();
    }

    public static DebugLoc get(int Line, int Col, MDNode Scope) {
        return DebugLoc.get(Line, Col, Scope, null);
    }

    public static DebugLoc get(int Line, int Col, MDNode Scope, MDNode InlinedAt) {
        if (Scope == null) {
            return new DebugLoc();
        }
        return new DebugLoc(DILocation.get(Scope.getContext(), Line, Col, Scope, InlinedAt));
    }

    public int getLine() {
        assert (this.get() != null) : "Expected valid DebugLoc";
        return this.get().getLine();
    }

    public int getCol() {
        assert (this.get() != null) : "Expected valid DebugLoc";
        return this.get().getColumn();
    }

    public MDNode getScope() {
        assert (this.get() != null) : "Expected valid DebugLoc";
        return this.get().getScope();
    }

    public DILocation getInlinedAt() {
        assert (this.get() != null) : "Expected valid DebugLoc";
        return this.get().getInlinedAt();
    }

    public MDNode getInlinedAtScope() {
        return IrRTTI.cast_DILocation(this.Loc.$star()).getInlinedAtScope();
    }

    public DebugLoc getFnDebugLoc() {
        MDNode Scope = this.getInlinedAtScope();
        DISubprogram SP = IrLlvmGlobals.getDISubprogram(Scope);
        if (SP != null) {
            return DebugLoc.get(SP.getScopeLine(), 0, SP);
        }
        return new DebugLoc();
    }

    public MDNode getAsMDNode() {
        return this.Loc.$T$P();
    }

    public boolean $eq(DebugLoc DL) {
        return this.Loc.$eq(DL.Loc);
    }

    public boolean $noteq(DebugLoc DL) {
        return this.Loc.$noteq(DL.Loc);
    }

    public void dump() {
        if (this.Loc.$T$P() == null) {
            return;
        }
        llvm.dbgs().$out_uint(this.getLine());
        if (this.getCol() != 0) {
            llvm.dbgs().$out_char((byte)44).$out_uint(this.getCol());
        }
        DebugLoc InlinedAtDL = null;
        try {
            InlinedAtDL = new DebugLoc(this.getInlinedAt());
            if (InlinedAtDL.$bool()) {
                llvm.dbgs().$out(" @ ");
                InlinedAtDL.dump();
            } else {
                llvm.dbgs().$out(NativePointer.$LF);
            }
        }
        finally {
            if (InlinedAtDL != null) {
                InlinedAtDL.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(raw_ostream OS) {
        if (this.Loc.$T$P() == null) {
            return;
        }
        DIScope Scope = IrRTTI.cast_DIScope(this.getScope());
        OS.$out(Scope.getFilename());
        OS.$out_char((byte)58).$out_uint(this.getLine());
        if (this.getCol() != 0) {
            OS.$out_char((byte)58).$out_uint(this.getCol());
        }
        DebugLoc InlinedAtDL = null;
        try {
            InlinedAtDL = new DebugLoc(this.getInlinedAt());
            if (InlinedAtDL.$bool()) {
                OS.$out(" @[ ");
                InlinedAtDL.print(OS);
                OS.$out(" ]");
            }
        }
        finally {
            if (InlinedAtDL != null) {
                InlinedAtDL.$destroy();
            }
        }
    }

    public void $destroy() {
        this.Loc.$destroy();
    }

    public String toString() {
        return "Loc=" + this.Loc;
    }
}

