/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.ir.DIScope;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.MDString;
import org.llvm.ir.Metadata;
import org.llvm.ir.TypedDINodeRef;
import org.llvm.ir.java.IrRTTI;

public class DIType
extends DIScope
implements Destructors.ClassWithDestructor {
    private int Line;
    private int Flags;
    private long SizeInBits;
    private long AlignInBits;
    private long OffsetInBits;

    protected DIType(LLVMContext C2, int ID2, Metadata.StorageType Storage, int Tag, int Line, long SizeInBits, long AlignInBits, long OffsetInBits, int Flags, ArrayRef<Metadata> Ops) {
        super(C2, ID2, Storage, Tag, (ArrayRef<Metadata>)new ArrayRef(Ops));
        this.init(Line, SizeInBits, AlignInBits, OffsetInBits, Flags);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    protected void init(int Line, long SizeInBits, long AlignInBits, long OffsetInBits, int Flags) {
        this.Line = Line;
        this.Flags = Flags;
        this.SizeInBits = SizeInBits;
        this.AlignInBits = AlignInBits;
        this.OffsetInBits = OffsetInBits;
    }

    protected void mutate(int Tag, int Line, long SizeInBits, long AlignInBits, long OffsetInBits, int Flags) {
        assert (this.isDistinct()) : "Only distinct nodes can mutate";
        this.setTag(Tag);
        this.init(Line, SizeInBits, AlignInBits, OffsetInBits, Flags);
    }

    public std_ptr.unique_ptr_with_deleter<? extends DIType> clone() {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter2 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter((Object)IrRTTI.cast_DIType((Metadata)$c$.track(super.clone()).release())));
            return unique_ptr_with_deleter2;
        }
        finally {
            $c$.$destroy();
        }
    }

    public int getLine() {
        return this.Line;
    }

    public long getSizeInBits() {
        return this.SizeInBits;
    }

    public long getAlignInBits() {
        return this.AlignInBits;
    }

    public long getOffsetInBits() {
        return this.OffsetInBits;
    }

    public int getFlags() {
        return this.Flags;
    }

    public TypedDINodeRef<DIScope> getScope() {
        return new TypedDINodeRef<DIScope>(DIScope.class, this.getRawScope());
    }

    @Override
    public StringRef getName() {
        return this.getStringOperand(2);
    }

    public Metadata getRawScope() {
        return this.getOperand(1).$Metadata$P();
    }

    public MDString getRawName() {
        return this.getOperandAs(MDString.class, 2);
    }

    public void setFlags(int NewFlags) {
        assert (!this.isUniqued()) : "Cannot set flags on uniqued nodes";
        this.Flags = NewFlags;
    }

    public boolean isPrivate() {
        return (this.getFlags() & 3) == 1;
    }

    public boolean isProtected() {
        return (this.getFlags() & 3) == 2;
    }

    public boolean isPublic() {
        return (this.getFlags() & 3) == 3;
    }

    public boolean isForwardDecl() {
        return (this.getFlags() & 4) != 0;
    }

    public boolean isAppleBlockExtension() {
        return (this.getFlags() & 8) != 0;
    }

    public boolean isBlockByrefStruct() {
        return (this.getFlags() & 0x10) != 0;
    }

    public boolean isVirtual() {
        return (this.getFlags() & 0x20) != 0;
    }

    public boolean isArtificial() {
        return (this.getFlags() & 0x40) != 0;
    }

    public boolean isObjectPointer() {
        return (this.getFlags() & 0x400) != 0;
    }

    public boolean isObjcClassComplete() {
        return (this.getFlags() & 0x200) != 0;
    }

    public boolean isVector() {
        return (this.getFlags() & 0x800) != 0;
    }

    public boolean isBitField() {
        return (this.getFlags() & 0x80000) != 0;
    }

    public boolean isStaticMember() {
        return (this.getFlags() & 0x1000) != 0;
    }

    public boolean isLValueReference() {
        return (this.getFlags() & 0x2000) != 0;
    }

    public boolean isRValueReference() {
        return (this.getFlags() & 0x4000) != 0;
    }

    public boolean isExternalTypeRef() {
        return (this.getFlags() & 0x8000) != 0;
    }

    public static boolean classof(Metadata MD) {
        switch (Metadata.MetadataKind.valueOf(MD.getMetadataID())) {
            default: {
                return false;
            }
            case DIBasicTypeKind: 
            case DIDerivedTypeKind: 
            case DICompositeTypeKind: 
            case DISubroutineTypeKind: 
        }
        return true;
    }

    @Override
    public String toString() {
        return "Line=" + this.Line + ", Flags=" + this.Flags + ", SizeInBits=" + this.SizeInBits + ", AlignInBits=" + this.AlignInBits + ", OffsetInBits=" + this.OffsetInBits + super.toString();
    }
}

