/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.ir.DIFile;
import org.llvm.ir.DILocalScope;
import org.llvm.ir.DILocation;
import org.llvm.ir.DINode;
import org.llvm.ir.DIScope;
import org.llvm.ir.DIType;
import org.llvm.ir.DIVariable;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.MDNode;
import org.llvm.ir.MDString;
import org.llvm.ir.Metadata;
import org.llvm.ir.TypedDINodeRef;
import org.llvm.ir.impl.DebugInfoMetadataStatics;
import org.llvm.ir.impl.IrLlvmStatics;
import org.llvm.ir.impl.MDNodeKeyImplDILocalVariable;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.llvm;

public class DILocalVariable
extends DIVariable
implements Destructors.ClassWithDestructor {
    private char Arg;
    private char Flags;

    private DILocalVariable(LLVMContext C2, Metadata.StorageType Storage, int Line, int Arg, int Flags, ArrayRef<Metadata> Ops) {
        super(C2, Metadata.MetadataKind.DILocalVariableKind.getValue(), Storage, Line, (ArrayRef<Metadata>)new ArrayRef(Ops));
        this.Arg = Unsigned.$uint2uint_16bits((int)Arg);
        this.Flags = Unsigned.$uint2uint_16bits((int)Flags);
        assert (Unsigned.$less_uint((int)Flags, (int)65536)) : "DILocalVariable: Flags out of range";
        assert (Unsigned.$less_uint((int)Arg, (int)65536)) : "DILocalVariable: Arg out of range";
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    private static DILocalVariable getImpl(LLVMContext Context, DIScope Scope, StringRef Name, DIFile File, int Line, TypedDINodeRef<DIType> Type2, int Arg, int Flags, Metadata.StorageType Storage) {
        return DILocalVariable.getImpl(Context, Scope, Name, File, Line, Type2, Arg, Flags, Storage, true);
    }

    private static DILocalVariable getImpl(LLVMContext Context, DIScope Scope, StringRef Name, DIFile File, int Line, TypedDINodeRef<DIType> Type2, int Arg, int Flags, Metadata.StorageType Storage, boolean ShouldCreate) {
        return DILocalVariable.getImpl(Context, (Metadata)Scope, DINode.getCanonicalMDString(Context, new StringRef(Name)), (Metadata)File, Line, Type2.$Metadata$P(), Arg, Flags, Storage, ShouldCreate);
    }

    private static DILocalVariable getImpl(LLVMContext Context, Metadata Scope, MDString Name, Metadata File, int Line, Metadata Type2, int Arg, int Flags, Metadata.StorageType Storage) {
        return DILocalVariable.getImpl(Context, Scope, Name, File, Line, Type2, Arg, Flags, Storage, true);
    }

    private static DILocalVariable getImpl(LLVMContext Context, Metadata Scope, MDString Name, Metadata File, int Line, Metadata Type2, int Arg, int Flags, Metadata.StorageType Storage, boolean ShouldCreate) {
        assert (Unsigned.$lesseq_uint((int)Arg, (int)65535)) : "Expected argument number to fit in 16-bits";
        assert (Scope != null) : "Expected scope";
        assert (DebugInfoMetadataStatics.isCanonical(Name)) : "Expected canonical MDString";
        if (Storage == Metadata.StorageType.Uniqued) {
            DILocalVariable N = IrLlvmStatics.getUniqued(Context.pImpl.DILocalVariables, new MDNodeKeyImplDILocalVariable(Scope, Name, File, Line, Type2, Arg, Flags));
            if (N != null) {
                return N;
            }
            if (!ShouldCreate) {
                return null;
            }
        } else assert (ShouldCreate) : "Expected non-uniqued nodes to always be created";
        Object[] Ops = new Metadata[]{Scope, Name, File, Type2};
        return DILocalVariable.storeImpl((DILocalVariable)MDNode.$new(llvm.array_lengthof((Object[])Ops), arg_0 -> DILocalVariable.lambda$getImpl$0(Context, Storage, Line, Arg, Flags, (Metadata[])Ops, arg_0)), Storage, Context.pImpl.DILocalVariables);
    }

    std_ptr.unique_ptr_with_deleter<DILocalVariable> cloneImpl() {
        return DILocalVariable.getTemporary(this.getContext(), this.getScope(), this.getName(), this.getFile(), this.getLine(), this.getType(), this.getArg(), this.getFlags());
    }

    public static DILocalVariable get(LLVMContext Context, DILocalScope Scope, StringRef Name, DIFile File, int Line, TypedDINodeRef<DIType> Type2, int Arg, int Flags) {
        return DILocalVariable.getImpl(Context, Scope, new StringRef(Name), File, Line, new TypedDINodeRef<DIType>(Type2), Arg, Flags, Metadata.StorageType.Uniqued);
    }

    public static DILocalVariable getIfExists(LLVMContext Context, DILocalScope Scope, StringRef Name, DIFile File, int Line, TypedDINodeRef<DIType> Type2, int Arg, int Flags) {
        return DILocalVariable.getImpl(Context, Scope, new StringRef(Name), File, Line, new TypedDINodeRef<DIType>(Type2), Arg, Flags, Metadata.StorageType.Uniqued, false);
    }

    public static DILocalVariable getDistinct(LLVMContext Context, DILocalScope Scope, StringRef Name, DIFile File, int Line, TypedDINodeRef<DIType> Type2, int Arg, int Flags) {
        return DILocalVariable.getImpl(Context, Scope, new StringRef(Name), File, Line, new TypedDINodeRef<DIType>(Type2), Arg, Flags, Metadata.StorageType.Distinct);
    }

    public static std_ptr.unique_ptr_with_deleter<DILocalVariable> getTemporary(LLVMContext Context, DILocalScope Scope, StringRef Name, DIFile File, int Line, TypedDINodeRef<DIType> Type2, int Arg, int Flags) {
        return new std_ptr.unique_ptr_with_deleter((Object)DILocalVariable.getImpl(Context, Scope, new StringRef(Name), File, Line, new TypedDINodeRef<DIType>(Type2), Arg, Flags, Metadata.StorageType.Temporary));
    }

    public static DILocalVariable get(LLVMContext Context, Metadata Scope, MDString Name, Metadata File, int Line, Metadata Type2, int Arg, int Flags) {
        return DILocalVariable.getImpl(Context, Scope, Name, File, Line, Type2, Arg, Flags, Metadata.StorageType.Uniqued);
    }

    public static DILocalVariable getIfExists(LLVMContext Context, Metadata Scope, MDString Name, Metadata File, int Line, Metadata Type2, int Arg, int Flags) {
        return DILocalVariable.getImpl(Context, Scope, Name, File, Line, Type2, Arg, Flags, Metadata.StorageType.Uniqued, false);
    }

    public static DILocalVariable getDistinct(LLVMContext Context, Metadata Scope, MDString Name, Metadata File, int Line, Metadata Type2, int Arg, int Flags) {
        return DILocalVariable.getImpl(Context, Scope, Name, File, Line, Type2, Arg, Flags, Metadata.StorageType.Distinct);
    }

    public static std_ptr.unique_ptr_with_deleter<DILocalVariable> getTemporary(LLVMContext Context, Metadata Scope, MDString Name, Metadata File, int Line, Metadata Type2, int Arg, int Flags) {
        return new std_ptr.unique_ptr_with_deleter((Object)DILocalVariable.getImpl(Context, Scope, Name, File, Line, Type2, Arg, Flags, Metadata.StorageType.Temporary));
    }

    public std_ptr.unique_ptr_with_deleter<DILocalVariable> clone() {
        return this.cloneImpl();
    }

    @Override
    public DILocalScope getScope() {
        return IrRTTI.cast_DILocalScope(super.getScope());
    }

    public boolean isParameter() {
        return Unsigned.$16bits_uint2uint((char)this.Arg) != 0;
    }

    public int getArg() {
        return Unsigned.$16bits_uint2uint((char)this.Arg);
    }

    public int getFlags() {
        return Unsigned.$16bits_uint2uint((char)this.Flags);
    }

    public boolean isArtificial() {
        return (this.getFlags() & 0x40) != 0;
    }

    public boolean isObjectPointer() {
        return (this.getFlags() & 0x400) != 0;
    }

    public boolean isValidLocationForIntrinsic(DILocation DL) {
        return DL != null && this.getScope().getSubprogram() == DL.getScope().getSubprogram();
    }

    public static boolean classof(Metadata MD) {
        return MD.getMetadataID() == Metadata.MetadataKind.DILocalVariableKind.getValue();
    }

    @Override
    public String toString() {
        return "Arg=" + Unsigned.$ushort2uint((char)this.Arg) + ", Flags=" + Unsigned.$ushort2uint((char)this.Flags) + super.toString();
    }

    private static /* synthetic */ DILocalVariable lambda$getImpl$0(LLVMContext Context, Metadata.StorageType Storage, int Line, int Arg, int Flags, Metadata[] Ops, type.ptr New$Mem) {
        return new DILocalVariable(Context, Storage, Line, Arg, Flags, (ArrayRef<Metadata>)new ArrayRef((Object[])Ops, true));
    }
}

