/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.ir.DIFile;
import org.llvm.ir.DILexicalBlockBase;
import org.llvm.ir.DILocalScope;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.MDNode;
import org.llvm.ir.Metadata;
import org.llvm.ir.impl.DebugInfoMetadataStatics;
import org.llvm.ir.impl.IrLlvmStatics;
import org.llvm.ir.impl.MDNodeKeyImplDILexicalBlock;
import org.llvm.support.llvm;

public class DILexicalBlock
extends DILexicalBlockBase
implements Destructors.ClassWithDestructor {
    private int Line;
    private char Column;

    private DILexicalBlock(LLVMContext C2, Metadata.StorageType Storage, int Line, int Column, ArrayRef<Metadata> Ops) {
        super(C2, Metadata.MetadataKind.DILexicalBlockKind.getValue(), Storage, (ArrayRef<Metadata>)new ArrayRef(Ops));
        this.Line = Line;
        this.Column = Unsigned.$uint2ushort((int)Column);
        assert (Unsigned.$less_uint((int)Column, (int)65536)) : "Expected 16-bit column";
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    private static DILexicalBlock getImpl(LLVMContext Context, DILocalScope Scope, DIFile File, int Line, int Column, Metadata.StorageType Storage) {
        return DILexicalBlock.getImpl(Context, Scope, File, Line, Column, Storage, true);
    }

    private static DILexicalBlock getImpl(LLVMContext Context, DILocalScope Scope, DIFile File, int Line, int Column, Metadata.StorageType Storage, boolean ShouldCreate) {
        return DILexicalBlock.getImpl(Context, (Metadata)Scope, (Metadata)File, Line, Column, Storage, ShouldCreate);
    }

    private static DILexicalBlock getImpl(LLVMContext Context, Metadata Scope, Metadata File, int Line, int Column, Metadata.StorageType Storage) {
        return DILexicalBlock.getImpl(Context, Scope, File, Line, Column, Storage, true);
    }

    private static DILexicalBlock getImpl(LLVMContext Context, Metadata Scope, Metadata File, int Line, int Column, Metadata.StorageType Storage, boolean ShouldCreate) {
        uint.ref Column$ref = NativePointer.create_uint$ref((int)Column);
        DebugInfoMetadataStatics.adjustColumn(Column$ref);
        Column = Column$ref.$deref();
        assert (Scope != null) : "Expected scope";
        if (Storage == Metadata.StorageType.Uniqued) {
            DILexicalBlock N = IrLlvmStatics.getUniqued(Context.pImpl.DILexicalBlocks, new MDNodeKeyImplDILexicalBlock(Scope, File, Line, Column));
            if (N != null) {
                return N;
            }
            if (!ShouldCreate) {
                return null;
            }
        } else assert (ShouldCreate) : "Expected non-uniqued nodes to always be created";
        Object[] Ops = new Metadata[]{File, Scope};
        int Column$final = Column;
        return MDNode.storeImpl((DILexicalBlock)MDNode.$new(llvm.array_lengthof((Object[])Ops), arg_0 -> DILexicalBlock.lambda$getImpl$0(Context, Storage, Line, Column$final, (Metadata[])Ops, arg_0)), Storage, Context.pImpl.DILexicalBlocks);
    }

    std_ptr.unique_ptr_with_deleter<DILexicalBlock> cloneImpl() {
        return DILexicalBlock.getTemporary(this.getContext(), this.getScope(), this.getFile(), this.getLine(), this.getColumn());
    }

    public static DILexicalBlock get(LLVMContext Context, DILocalScope Scope, DIFile File, int Line, int Column) {
        return DILexicalBlock.getImpl(Context, Scope, File, Line, Column, Metadata.StorageType.Uniqued);
    }

    public static DILexicalBlock getIfExists(LLVMContext Context, DILocalScope Scope, DIFile File, int Line, int Column) {
        return DILexicalBlock.getImpl(Context, Scope, File, Line, Column, Metadata.StorageType.Uniqued, false);
    }

    public static DILexicalBlock getDistinct(LLVMContext Context, DILocalScope Scope, DIFile File, int Line, int Column) {
        return DILexicalBlock.getImpl(Context, Scope, File, Line, Column, Metadata.StorageType.Distinct);
    }

    public static std_ptr.unique_ptr_with_deleter<DILexicalBlock> getTemporary(LLVMContext Context, DILocalScope Scope, DIFile File, int Line, int Column) {
        return new std_ptr.unique_ptr_with_deleter((Object)DILexicalBlock.getImpl(Context, Scope, File, Line, Column, Metadata.StorageType.Temporary));
    }

    public static DILexicalBlock get(LLVMContext Context, Metadata Scope, Metadata File, int Line, int Column) {
        return DILexicalBlock.getImpl(Context, Scope, File, Line, Column, Metadata.StorageType.Uniqued);
    }

    public static DILexicalBlock getIfExists(LLVMContext Context, Metadata Scope, Metadata File, int Line, int Column) {
        return DILexicalBlock.getImpl(Context, Scope, File, Line, Column, Metadata.StorageType.Uniqued, false);
    }

    public static DILexicalBlock getDistinct(LLVMContext Context, Metadata Scope, Metadata File, int Line, int Column) {
        return DILexicalBlock.getImpl(Context, Scope, File, Line, Column, Metadata.StorageType.Distinct);
    }

    public static std_ptr.unique_ptr_with_deleter<DILexicalBlock> getTemporary(LLVMContext Context, Metadata Scope, Metadata File, int Line, int Column) {
        return new std_ptr.unique_ptr_with_deleter((Object)DILexicalBlock.getImpl(Context, Scope, File, Line, Column, Metadata.StorageType.Temporary));
    }

    public std_ptr.unique_ptr_with_deleter<DILexicalBlock> clone() {
        return this.cloneImpl();
    }

    public int getLine() {
        return this.Line;
    }

    public int getColumn() {
        return Unsigned.$ushort2uint((char)this.Column);
    }

    public static boolean classof(Metadata MD) {
        return MD.getMetadataID() == Metadata.MetadataKind.DILexicalBlockKind.getValue();
    }

    @Override
    public String toString() {
        return "Line=" + this.Line + ", Column=" + Unsigned.$ushort2uint((char)this.Column) + super.toString();
    }

    private static /* synthetic */ DILexicalBlock lambda$getImpl$0(LLVMContext Context, Metadata.StorageType Storage, int Line, int Column$final, Metadata[] Ops, type.ptr New$Mem) {
        return new DILexicalBlock(Context, Storage, Line, Column$final, (ArrayRef<Metadata>)new ArrayRef((Object[])Ops, true));
    }
}

