/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.APInt;
import org.llvm.adt.APIntOps;
import org.llvm.ir.CmpInst;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;

public class ConstantRange
implements Destructors.ClassWithDestructor,
Native.NativeComparable<ConstantRange> {
    private APInt Lower;
    private APInt Upper;

    public ConstantRange(int BitWidth) {
        this(BitWidth, true);
    }

    public ConstantRange(int BitWidth, boolean Full) {
        this.Lower = new APInt();
        this.Upper = new APInt();
        if (Full) {
            this.Lower.$assign(this.Upper.$assignMove(APInt.getMaxValue((int)BitWidth)));
        } else {
            this.Lower.$assign(this.Upper.$assignMove(APInt.getMinValue((int)BitWidth)));
        }
    }

    public ConstantRange(APInt V) {
        this.Lower = new APInt(JavaDifferentiators.JD.Move.INSTANCE, (APInt)std.move((Object)V));
        this.Upper = this.Lower.$add(Unsigned.$int2ulong((int)1));
    }

    public ConstantRange(APInt L, APInt U) {
        this.Lower = new APInt(JavaDifferentiators.JD.Move.INSTANCE, (APInt)std.move((Object)L));
        this.Upper = new APInt(JavaDifferentiators.JD.Move.INSTANCE, (APInt)std.move((Object)U));
        assert (this.Lower.getBitWidth() == this.Upper.getBitWidth()) : "ConstantRange with unequal bit widths";
        assert (this.Lower.$noteq(this.Upper) || this.Lower.isMaxValue() || this.Lower.isMinValue()) : "Lower == Upper, but they aren't min or max value!";
    }

    public static ConstantRange makeAllowedICmpRegion(CmpInst.Predicate Pred, ConstantRange CR) {
        if (CR.isEmptySet()) {
            return new ConstantRange(CR);
        }
        int W = CR.getBitWidth();
        switch (Pred) {
            default: {
                throw new llvm_unreachable("Invalid ICmp predicate to makeAllowedICmpRegion()");
            }
            case ICMP_EQ: {
                return new ConstantRange(CR);
            }
            case ICMP_NE: {
                if (CR.isSingleElement()) {
                    return new ConstantRange(new APInt(CR.getUpper()), new APInt(CR.getLower()));
                }
                return new ConstantRange(W);
            }
            case ICMP_ULT: {
                APInt UMax = CR.getUnsignedMax();
                if (UMax.isMinValue()) {
                    return new ConstantRange(W, false);
                }
                return new ConstantRange(APInt.getMinValue((int)W), new APInt(UMax));
            }
            case ICMP_SLT: {
                APInt SMax = CR.getSignedMax();
                if (SMax.isMinSignedValue()) {
                    return new ConstantRange(W, false);
                }
                return new ConstantRange(APInt.getSignedMinValue((int)W), new APInt(SMax));
            }
            case ICMP_ULE: {
                APInt UMax = CR.getUnsignedMax();
                if (UMax.isMaxValue()) {
                    return new ConstantRange(W);
                }
                return new ConstantRange(APInt.getMinValue((int)W), UMax.$add(Unsigned.$int2ulong((int)1)));
            }
            case ICMP_SLE: {
                APInt SMax = CR.getSignedMax();
                if (SMax.isMaxSignedValue()) {
                    return new ConstantRange(W);
                }
                return new ConstantRange(APInt.getSignedMinValue((int)W), SMax.$add(Unsigned.$int2ulong((int)1)));
            }
            case ICMP_UGT: {
                APInt UMin = CR.getUnsignedMin();
                if (UMin.isMaxValue()) {
                    return new ConstantRange(W, false);
                }
                return new ConstantRange(UMin.$add(Unsigned.$int2ulong((int)1)), APInt.getNullValue((int)W));
            }
            case ICMP_SGT: {
                APInt SMin = CR.getSignedMin();
                if (SMin.isMaxSignedValue()) {
                    return new ConstantRange(W, false);
                }
                return new ConstantRange(SMin.$add(Unsigned.$int2ulong((int)1)), APInt.getSignedMinValue((int)W));
            }
            case ICMP_UGE: {
                APInt UMin = CR.getUnsignedMin();
                if (UMin.isMinValue()) {
                    return new ConstantRange(W);
                }
                return new ConstantRange(new APInt(UMin), APInt.getNullValue((int)W));
            }
            case ICMP_SGE: 
        }
        APInt SMin = CR.getSignedMin();
        if (SMin.isMinSignedValue()) {
            return new ConstantRange(W);
        }
        return new ConstantRange(new APInt(SMin), APInt.getSignedMinValue((int)W));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConstantRange makeSatisfyingICmpRegion(CmpInst.Predicate Pred, ConstantRange CR) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            ConstantRange constantRange = (ConstantRange)$c$.clean((Object)((ConstantRange)$c$.track((Object)ConstantRange.makeAllowedICmpRegion(CmpInst.getInversePredicate(Pred), CR))).inverse());
            return constantRange;
        }
        finally {
            $c$.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConstantRange makeExactICmpRegion(CmpInst.Predicate Pred, APInt C2) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            assert (((ConstantRange)$c$.track((Object)ConstantRange.makeAllowedICmpRegion(Pred, (ConstantRange)$c$.track((Object)new ConstantRange(new APInt(C2)))))).$eq((ConstantRange)$c$.track((Object)ConstantRange.makeSatisfyingICmpRegion(Pred, (ConstantRange)$c$.track((Object)new ConstantRange(new APInt(C2)))))));
            $c$.clean();
            ConstantRange constantRange = (ConstantRange)$c$.clean((Object)ConstantRange.makeAllowedICmpRegion(Pred, (ConstantRange)$c$.track((Object)new ConstantRange(new APInt(C2)))));
            return constantRange;
        }
        finally {
            $c$.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConstantRange makeGuaranteedNoWrapRegion(int BinOp2, ConstantRange Other, int NoWrapKind) {
        ConstantRange Result2 = null;
        try {
            NativeCallback.TypeType2Type SubsetIntersect = (CR0, CR1) -> {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    ConstantRange constantRange = (ConstantRange)$c$.clean((Object)((ConstantRange)$c$.track((Object)((ConstantRange)$c$.track((Object)CR0.inverse())).unionWith((ConstantRange)$c$.track((Object)CR1.inverse())))).inverse());
                    return constantRange;
                }
                finally {
                    $c$.$destroy();
                }
            };
            assert (BinOp2 >= 11 && BinOp2 < 29) : "Binary operators only!";
            assert (NoWrapKind == 2 || NoWrapKind == 1 || NoWrapKind == 3) : "NoWrapKind invalid!";
            int BitWidth = Other.getBitWidth();
            if (BinOp2 != 11) {
                ConstantRange constantRange = new ConstantRange(BitWidth, false);
                return constantRange;
            }
            APInt C2 = Other.getSingleElement();
            if (C2 != null && C2.isMinValue()) {
                ConstantRange constantRange = new ConstantRange(BitWidth);
                return constantRange;
            }
            Result2 = new ConstantRange(BitWidth);
            if ((NoWrapKind & 1) != 0) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)Result2.$assignMove((ConstantRange)$c$.track((Object)((ConstantRange)SubsetIntersect.$call((Object)Result2, (Object)((ConstantRange)$c$.track((Object)new ConstantRange(APInt.getNullValue((int)BitWidth), Other.getUnsignedMax().$sub()))))))));
                }
                finally {
                    $c$.$destroy();
                }
            }
            if ((NoWrapKind & 2) != 0) {
                JavaCleaner $c$;
                APInt SignedMin = Other.getSignedMin();
                APInt SignedMax = Other.getSignedMax();
                if (SignedMax.isStrictlyPositive()) {
                    $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)Result2.$assignMove((ConstantRange)$c$.track((Object)((ConstantRange)SubsetIntersect.$call((Object)Result2, (Object)((ConstantRange)$c$.track((Object)new ConstantRange(APInt.getSignedMinValue((int)BitWidth), APInt.getSignedMinValue((int)BitWidth).$sub(SignedMax)))))))));
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
                if (SignedMin.isNegative()) {
                    $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)Result2.$assignMove((ConstantRange)$c$.track((Object)((ConstantRange)SubsetIntersect.$call((Object)Result2, (Object)((ConstantRange)$c$.track((Object)new ConstantRange(APInt.getSignedMinValue((int)BitWidth).$sub(SignedMin), APInt.getSignedMinValue((int)BitWidth)))))))));
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
            }
            ConstantRange constantRange = new ConstantRange(JavaDifferentiators.JD.Move.INSTANCE, Result2);
            return constantRange;
        }
        finally {
            if (Result2 != null) {
                Result2.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getEquivalentICmp(type.ref<CmpInst.Predicate> Pred, APInt RHS) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            boolean Success = false;
            if (this.isFullSet() || this.isEmptySet()) {
                Pred.$set((Object)(this.isEmptySet() ? CmpInst.Predicate.ICMP_ULT : CmpInst.Predicate.ICMP_UGE));
                RHS.$assignMove(new APInt(JavaDifferentiators.JD$UInt_ULong.INSTANCE, this.getBitWidth(), Unsigned.$int2ulong((int)0)));
                Success = true;
            } else if (this.getLower().isMinSignedValue() || this.getLower().isMinValue()) {
                Pred.$set((Object)(this.getLower().isMinSignedValue() ? CmpInst.Predicate.ICMP_SLT : CmpInst.Predicate.ICMP_ULT));
                RHS.$assign(this.getUpper());
                Success = true;
            } else if (this.getUpper().isMinSignedValue() || this.getUpper().isMinValue()) {
                Pred.$set((Object)(this.getUpper().isMinSignedValue() ? CmpInst.Predicate.ICMP_SGE : CmpInst.Predicate.ICMP_UGE));
                RHS.$assign(this.getLower());
                Success = true;
            }
            assert (!Success || ((ConstantRange)$c$.track((Object)ConstantRange.makeExactICmpRegion((CmpInst.Predicate)((Object)Pred.$deref()), RHS))).$eq(this)) : "Bad result!";
            $c$.clean();
            boolean bl = Success;
            return bl;
        }
        finally {
            $c$.$destroy();
        }
    }

    public APInt getLower() {
        return this.Lower;
    }

    public APInt getUpper() {
        return this.Upper;
    }

    public int getBitWidth() {
        return this.Lower.getBitWidth();
    }

    public boolean isFullSet() {
        return this.Lower.$eq(this.Upper) && this.Lower.isMaxValue();
    }

    public boolean isEmptySet() {
        return this.Lower.$eq(this.Upper) && this.Lower.isMinValue();
    }

    public boolean isWrappedSet() {
        return this.Lower.ugt(this.Upper);
    }

    public boolean isSignWrappedSet() {
        return this.contains(APInt.getSignedMaxValue((int)this.getBitWidth())) && this.contains(APInt.getSignedMinValue((int)this.getBitWidth()));
    }

    public boolean contains(APInt V) {
        if (this.Lower.$eq(this.Upper)) {
            return this.isFullSet();
        }
        if (!this.isWrappedSet()) {
            return this.Lower.ule(V) && V.ult(this.Upper);
        }
        return this.Lower.ule(V) || V.ult(this.Upper);
    }

    public boolean contains(ConstantRange Other) {
        if (this.isFullSet() || Other.isEmptySet()) {
            return true;
        }
        if (this.isEmptySet() || Other.isFullSet()) {
            return false;
        }
        if (!this.isWrappedSet()) {
            if (Other.isWrappedSet()) {
                return false;
            }
            return this.Lower.ule(Other.getLower()) && Other.getUpper().ule(this.Upper);
        }
        if (!Other.isWrappedSet()) {
            return Other.getUpper().ule(this.Upper) || this.Lower.ule(Other.getLower());
        }
        return Other.getUpper().ule(this.Upper) && this.Lower.ule(Other.getLower());
    }

    public APInt getSingleElement() {
        if (this.Upper.$eq(this.Lower.$add(Unsigned.$int2ulong((int)1)))) {
            return (APInt)Native.$AddrOf((Object)this.Lower);
        }
        return null;
    }

    public boolean isSingleElement() {
        return this.getSingleElement() != null;
    }

    public APInt getSetSize() {
        if (this.isFullSet()) {
            APInt Size = new APInt(JavaDifferentiators.JD$UInt_ULong.INSTANCE, this.getBitWidth() + 1, Unsigned.$int2ulong((int)0));
            Size.setBit(this.getBitWidth());
            return Size;
        }
        return this.Upper.$sub(this.Lower).zext(this.getBitWidth() + 1);
    }

    public APInt getUnsignedMax() {
        if (this.isFullSet() || this.isWrappedSet()) {
            return APInt.getMaxValue((int)this.getBitWidth());
        }
        return this.getUpper().$sub(Unsigned.$int2ulong((int)1));
    }

    public APInt getUnsignedMin() {
        if (this.isFullSet() || this.isWrappedSet() && this.getUpper().$noteq(Unsigned.$int2ulong((int)0))) {
            return APInt.getMinValue((int)this.getBitWidth());
        }
        return new APInt(this.getLower());
    }

    public APInt getSignedMax() {
        APInt SignedMax = APInt.getSignedMaxValue((int)this.getBitWidth());
        if (!this.isWrappedSet()) {
            if (this.getLower().sle(this.getUpper().$sub(Unsigned.$int2ulong((int)1)))) {
                return this.getUpper().$sub(Unsigned.$int2ulong((int)1));
            }
            return SignedMax;
        }
        if (this.getLower().isNegative() == this.getUpper().isNegative()) {
            return SignedMax;
        }
        return this.getUpper().$sub(Unsigned.$int2ulong((int)1));
    }

    public APInt getSignedMin() {
        APInt SignedMin = APInt.getSignedMinValue((int)this.getBitWidth());
        if (!this.isWrappedSet()) {
            if (this.getLower().sle(this.getUpper().$sub(Unsigned.$int2ulong((int)1)))) {
                return new APInt(this.getLower());
            }
            return SignedMin;
        }
        if (this.getUpper().$sub(Unsigned.$int2ulong((int)1)).slt(this.getLower()) && this.getUpper().$noteq(SignedMin)) {
            return SignedMin;
        }
        return new APInt(this.getLower());
    }

    public boolean $eq(ConstantRange CR) {
        return this.Lower.$eq(CR.Lower) && this.Upper.$eq(CR.Upper);
    }

    public boolean $noteq(ConstantRange CR) {
        return !this.$eq(CR);
    }

    public ConstantRange subtract(APInt Val) {
        assert (Val.getBitWidth() == this.getBitWidth()) : "Wrong bit width";
        if (this.Lower.$eq(this.Upper)) {
            return new ConstantRange(this);
        }
        return new ConstantRange(this.Lower.$sub(Val), this.Upper.$sub(Val));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstantRange difference(ConstantRange CR) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            ConstantRange constantRange = (ConstantRange)$c$.clean((Object)this.intersectWith((ConstantRange)$c$.track((Object)CR.inverse())));
            return constantRange;
        }
        finally {
            $c$.$destroy();
        }
    }

    public ConstantRange intersectWith(ConstantRange CR) {
        assert (this.getBitWidth() == CR.getBitWidth()) : "ConstantRange types don't agree!";
        if (this.isEmptySet() || CR.isFullSet()) {
            return new ConstantRange(this);
        }
        if (CR.isEmptySet() || this.isFullSet()) {
            return new ConstantRange(CR);
        }
        if (!this.isWrappedSet() && CR.isWrappedSet()) {
            return CR.intersectWith(this);
        }
        if (!this.isWrappedSet() && !CR.isWrappedSet()) {
            if (this.Lower.ult(CR.Lower)) {
                if (this.Upper.ule(CR.Lower)) {
                    return new ConstantRange(this.getBitWidth(), false);
                }
                if (this.Upper.ult(CR.Upper)) {
                    return new ConstantRange(new APInt(CR.Lower), new APInt(this.Upper));
                }
                return new ConstantRange(CR);
            }
            if (this.Upper.ult(CR.Upper)) {
                return new ConstantRange(this);
            }
            if (this.Lower.ult(CR.Upper)) {
                return new ConstantRange(new APInt(this.Lower), new APInt(CR.Upper));
            }
            return new ConstantRange(this.getBitWidth(), false);
        }
        if (this.isWrappedSet() && !CR.isWrappedSet()) {
            if (CR.Lower.ult(this.Upper)) {
                if (CR.Upper.ult(this.Upper)) {
                    return new ConstantRange(CR);
                }
                if (CR.Upper.ule(this.Lower)) {
                    return new ConstantRange(new APInt(CR.Lower), new APInt(this.Upper));
                }
                if (this.getSetSize().ult(CR.getSetSize())) {
                    return new ConstantRange(this);
                }
                return new ConstantRange(CR);
            }
            if (CR.Lower.ult(this.Lower)) {
                if (CR.Upper.ule(this.Lower)) {
                    return new ConstantRange(this.getBitWidth(), false);
                }
                return new ConstantRange(new APInt(this.Lower), new APInt(CR.Upper));
            }
            return new ConstantRange(CR);
        }
        if (CR.Upper.ult(this.Upper)) {
            if (CR.Lower.ult(this.Upper)) {
                if (this.getSetSize().ult(CR.getSetSize())) {
                    return new ConstantRange(this);
                }
                return new ConstantRange(CR);
            }
            if (CR.Lower.ult(this.Lower)) {
                return new ConstantRange(new APInt(this.Lower), new APInt(CR.Upper));
            }
            return new ConstantRange(CR);
        }
        if (CR.Upper.ule(this.Lower)) {
            if (CR.Lower.ult(this.Lower)) {
                return new ConstantRange(this);
            }
            return new ConstantRange(new APInt(CR.Lower), new APInt(this.Upper));
        }
        if (this.getSetSize().ult(CR.getSetSize())) {
            return new ConstantRange(this);
        }
        return new ConstantRange(CR);
    }

    public ConstantRange unionWith(ConstantRange CR) {
        assert (this.getBitWidth() == CR.getBitWidth()) : "ConstantRange types don't agree!";
        if (this.isFullSet() || CR.isEmptySet()) {
            return new ConstantRange(this);
        }
        if (CR.isFullSet() || this.isEmptySet()) {
            return new ConstantRange(CR);
        }
        if (!this.isWrappedSet() && CR.isWrappedSet()) {
            return CR.unionWith(this);
        }
        if (!this.isWrappedSet() && !CR.isWrappedSet()) {
            if (CR.Upper.ult(this.Lower) || this.Upper.ult(CR.Lower)) {
                APInt d2;
                APInt d1 = CR.Lower.$sub(this.Upper);
                if (d1.ult(d2 = this.Lower.$sub(CR.Upper))) {
                    return new ConstantRange(new APInt(this.Lower), new APInt(CR.Upper));
                }
                return new ConstantRange(new APInt(CR.Lower), new APInt(this.Upper));
            }
            APInt L = new APInt(this.Lower);
            APInt U = new APInt(this.Upper);
            if (CR.Lower.ult(L)) {
                L.$assign(CR.Lower);
            }
            if (CR.Upper.$sub(Unsigned.$int2ulong((int)1)).ugt(U.$sub(Unsigned.$int2ulong((int)1)))) {
                U.$assign(CR.Upper);
            }
            if (L.$eq(Unsigned.$int2ulong((int)0)) && U.$eq(Unsigned.$int2ulong((int)0))) {
                return new ConstantRange(this.getBitWidth());
            }
            return new ConstantRange(new APInt(L), new APInt(U));
        }
        if (!CR.isWrappedSet()) {
            if (CR.Upper.ule(this.Upper) || CR.Lower.uge(this.Lower)) {
                return new ConstantRange(this);
            }
            if (CR.Lower.ule(this.Upper) && this.Lower.ule(CR.Upper)) {
                return new ConstantRange(this.getBitWidth());
            }
            if (this.Upper.ule(CR.Lower) && CR.Upper.ule(this.Lower)) {
                APInt d2;
                APInt d1 = CR.Lower.$sub(this.Upper);
                if (d1.ult(d2 = this.Lower.$sub(CR.Upper))) {
                    return new ConstantRange(new APInt(this.Lower), new APInt(CR.Upper));
                }
                return new ConstantRange(new APInt(CR.Lower), new APInt(this.Upper));
            }
            if (this.Upper.ult(CR.Lower) && this.Lower.ult(CR.Upper)) {
                return new ConstantRange(new APInt(CR.Lower), new APInt(this.Upper));
            }
            assert (CR.Lower.ult(this.Upper) && CR.Upper.ult(this.Lower)) : "ConstantRange::unionWith missed a case with one range wrapped";
            return new ConstantRange(new APInt(this.Lower), new APInt(CR.Upper));
        }
        if (CR.Lower.ule(this.Upper) || this.Lower.ule(CR.Upper)) {
            return new ConstantRange(this.getBitWidth());
        }
        APInt L = new APInt(this.Lower);
        APInt U = new APInt(this.Upper);
        if (CR.Upper.ugt(U)) {
            U.$assign(CR.Upper);
        }
        if (CR.Lower.ult(L)) {
            L.$assign(CR.Lower);
        }
        return new ConstantRange(new APInt(L), new APInt(U));
    }

    public ConstantRange zeroExtend(int DstTySize) {
        if (this.isEmptySet()) {
            return new ConstantRange(DstTySize, false);
        }
        int SrcTySize = this.getBitWidth();
        assert (Unsigned.$less_uint((int)SrcTySize, (int)DstTySize)) : "Not a value extension";
        if (this.isFullSet() || this.isWrappedSet()) {
            APInt LowerExt = new APInt(JavaDifferentiators.JD$UInt_ULong.INSTANCE, DstTySize, Unsigned.$int2ulong((int)0));
            if (this.Upper.$not()) {
                LowerExt.$assignMove(this.Lower.zext(DstTySize));
            }
            return new ConstantRange(new APInt(LowerExt), APInt.getOneBitSet((int)DstTySize, (int)SrcTySize));
        }
        return new ConstantRange(this.Lower.zext(DstTySize), this.Upper.zext(DstTySize));
    }

    public ConstantRange signExtend(int DstTySize) {
        if (this.isEmptySet()) {
            return new ConstantRange(DstTySize, false);
        }
        int SrcTySize = this.getBitWidth();
        assert (Unsigned.$less_uint((int)SrcTySize, (int)DstTySize)) : "Not a value extension";
        if (this.Upper.isMinSignedValue()) {
            return new ConstantRange(this.Lower.sext(DstTySize), this.Upper.zext(DstTySize));
        }
        if (this.isFullSet() || this.isSignWrappedSet()) {
            return new ConstantRange(APInt.getHighBitsSet((int)DstTySize, (int)(DstTySize - SrcTySize + 1)), APInt.getLowBitsSet((int)DstTySize, (int)(SrcTySize - 1)).$add(Unsigned.$int2ulong((int)1)));
        }
        return new ConstantRange(this.Lower.sext(DstTySize), this.Upper.sext(DstTySize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstantRange truncate(int DstTySize) {
        APInt UpperDiv;
        APInt LowerDiv;
        APInt MaxBitValue;
        ConstantRange Union;
        block28: {
            JavaCleaner $c$;
            APInt MaxValue;
            block27: {
                Union = null;
                assert (Unsigned.$greater_uint((int)this.getBitWidth(), (int)DstTySize)) : "Not a value truncation";
                if (this.isEmptySet()) {
                    ConstantRange constantRange = new ConstantRange(DstTySize, false);
                    return constantRange;
                }
                if (this.isFullSet()) {
                    ConstantRange constantRange = new ConstantRange(DstTySize, true);
                    return constantRange;
                }
                MaxValue = APInt.getMaxValue((int)DstTySize).zext(this.getBitWidth());
                MaxBitValue = new APInt(JavaDifferentiators.JD$UInt_ULong.INSTANCE, this.getBitWidth(), Unsigned.$int2ulong((int)0));
                MaxBitValue.setBit(DstTySize);
                LowerDiv = new APInt(this.Lower);
                UpperDiv = new APInt(this.Upper);
                Union = new ConstantRange(DstTySize, false);
                if (this.isWrappedSet()) {
                    $c$ = Native.$createJavaCleaner();
                    if (this.Upper.uge(MaxValue)) {
                        ConstantRange constantRange = new ConstantRange(DstTySize, true);
                        return constantRange;
                    }
                    $c$.clean((Object)Union.$assignMove((ConstantRange)$c$.track((Object)new ConstantRange(APInt.getMaxValue((int)DstTySize), this.Upper.trunc(DstTySize)))));
                    UpperDiv.$assignMove(APInt.getMaxValue((int)this.getBitWidth()));
                    if (!LowerDiv.$eq(UpperDiv)) break block27;
                    ConstantRange constantRange = new ConstantRange(JavaDifferentiators.JD.Move.INSTANCE, Union);
                    return constantRange;
                    finally {
                        $c$.$destroy();
                    }
                }
            }
            if (LowerDiv.uge(MaxValue)) {
                APInt Div = new APInt(JavaDifferentiators.JD$UInt_ULong.INSTANCE, this.getBitWidth(), Unsigned.$int2ulong((int)0));
                APInt.udivrem((APInt)LowerDiv, (APInt)MaxBitValue, (APInt)Div, (APInt)LowerDiv);
                UpperDiv.$assignMove(UpperDiv.$sub(MaxBitValue.$star(Div)));
            }
            if (!UpperDiv.ule(MaxValue)) break block28;
            $c$ = Native.$createJavaCleaner();
            try {
                ConstantRange constantRange = (ConstantRange)$c$.clean((Object)((ConstantRange)$c$.track((Object)new ConstantRange(LowerDiv.trunc(DstTySize), UpperDiv.trunc(DstTySize)))).unionWith(Union));
                return constantRange;
            }
            finally {
                $c$.$destroy();
            }
        }
        APInt UpperModulo = UpperDiv.$sub(MaxBitValue);
        if (UpperModulo.ult(LowerDiv)) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                ConstantRange constantRange = (ConstantRange)$c$.clean((Object)((ConstantRange)$c$.track((Object)new ConstantRange(LowerDiv.trunc(DstTySize), UpperModulo.trunc(DstTySize)))).unionWith(Union));
                return constantRange;
            }
            finally {
                $c$.$destroy();
            }
        }
        ConstantRange constantRange = new ConstantRange(DstTySize, true);
        return constantRange;
        finally {
            if (Union != null) {
                Union.$destroy();
            }
        }
    }

    public ConstantRange zextOrTrunc(int DstTySize) {
        int SrcTySize = this.getBitWidth();
        if (Unsigned.$greater_uint((int)SrcTySize, (int)DstTySize)) {
            return this.truncate(DstTySize);
        }
        if (Unsigned.$less_uint((int)SrcTySize, (int)DstTySize)) {
            return this.zeroExtend(DstTySize);
        }
        return new ConstantRange(this);
    }

    public ConstantRange sextOrTrunc(int DstTySize) {
        int SrcTySize = this.getBitWidth();
        if (Unsigned.$greater_uint((int)SrcTySize, (int)DstTySize)) {
            return this.truncate(DstTySize);
        }
        if (Unsigned.$less_uint((int)SrcTySize, (int)DstTySize)) {
            return this.signExtend(DstTySize);
        }
        return new ConstantRange(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstantRange add(ConstantRange Other) {
        ConstantRange X = null;
        try {
            APInt NewUpper;
            if (this.isEmptySet() || Other.isEmptySet()) {
                ConstantRange constantRange = new ConstantRange(this.getBitWidth(), false);
                return constantRange;
            }
            if (this.isFullSet() || Other.isFullSet()) {
                ConstantRange constantRange = new ConstantRange(this.getBitWidth(), true);
                return constantRange;
            }
            APInt Spread_X = this.getSetSize();
            APInt Spread_Y = Other.getSetSize();
            APInt NewLower = this.getLower().$add(Other.getLower());
            if (NewLower.$eq(NewUpper = this.getUpper().$add(Other.getUpper()).$sub(Unsigned.$int2ulong((int)1)))) {
                ConstantRange constantRange = new ConstantRange(this.getBitWidth(), true);
                return constantRange;
            }
            X = new ConstantRange(new APInt(NewLower), new APInt(NewUpper));
            if (X.getSetSize().ult(Spread_X) || X.getSetSize().ult(Spread_Y)) {
                ConstantRange constantRange = new ConstantRange(this.getBitWidth(), true);
                return constantRange;
            }
            ConstantRange constantRange = new ConstantRange(JavaDifferentiators.JD.Move.INSTANCE, X);
            return constantRange;
        }
        finally {
            if (X != null) {
                X.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstantRange sub(ConstantRange Other) {
        ConstantRange X = null;
        try {
            APInt NewUpper;
            if (this.isEmptySet() || Other.isEmptySet()) {
                ConstantRange constantRange = new ConstantRange(this.getBitWidth(), false);
                return constantRange;
            }
            if (this.isFullSet() || Other.isFullSet()) {
                ConstantRange constantRange = new ConstantRange(this.getBitWidth(), true);
                return constantRange;
            }
            APInt Spread_X = this.getSetSize();
            APInt Spread_Y = Other.getSetSize();
            APInt NewLower = this.getLower().$sub(Other.getUpper()).$add(Unsigned.$int2ulong((int)1));
            if (NewLower.$eq(NewUpper = this.getUpper().$sub(Other.getLower()))) {
                ConstantRange constantRange = new ConstantRange(this.getBitWidth(), true);
                return constantRange;
            }
            X = new ConstantRange(new APInt(NewLower), new APInt(NewUpper));
            if (X.getSetSize().ult(Spread_X) || X.getSetSize().ult(Spread_Y)) {
                ConstantRange constantRange = new ConstantRange(this.getBitWidth(), true);
                return constantRange;
            }
            ConstantRange constantRange = new ConstantRange(JavaDifferentiators.JD.Move.INSTANCE, X);
            return constantRange;
        }
        finally {
            if (X != null) {
                X.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstantRange multiply(ConstantRange Other) {
        ConstantRange Result_zext = null;
        ConstantRange UR = null;
        ConstantRange Result_sext = null;
        ConstantRange SR = null;
        try {
            if (this.isEmptySet() || Other.isEmptySet()) {
                ConstantRange constantRange = new ConstantRange(this.getBitWidth(), false);
                return constantRange;
            }
            APInt this_min = this.getUnsignedMin().zext(this.getBitWidth() * 2);
            APInt this_max = this.getUnsignedMax().zext(this.getBitWidth() * 2);
            APInt Other_min = Other.getUnsignedMin().zext(this.getBitWidth() * 2);
            APInt Other_max = Other.getUnsignedMax().zext(this.getBitWidth() * 2);
            Result_zext = new ConstantRange(this_min.$star(Other_min), this_max.$star(Other_max).$add(Unsigned.$int2ulong((int)1)));
            UR = Result_zext.truncate(this.getBitWidth());
            if (!UR.isWrappedSet() && UR.getLower().isNonNegative()) {
                ConstantRange constantRange = new ConstantRange(JavaDifferentiators.JD.Move.INSTANCE, UR);
                return constantRange;
            }
            this_min.$assignMove(this.getSignedMin().sext(this.getBitWidth() * 2));
            this_max.$assignMove(this.getSignedMax().sext(this.getBitWidth() * 2));
            Other_min.$assignMove(Other.getSignedMin().sext(this.getBitWidth() * 2));
            Other_max.$assignMove(Other.getSignedMax().sext(this.getBitWidth() * 2));
            Object[] L = new APInt[]{this_min.$star(Other_min), this_min.$star(Other_max), this_max.$star(Other_min), this_max.$star(Other_max)};
            std.Compare Compare2 = (A2, B2) -> A2.slt(B2);
            Result_sext = new ConstantRange((APInt)std.min((std.initializer_list)new std.initializer_list(L), (std.Compare)Compare2), ((APInt)std.max((std.initializer_list)new std.initializer_list(L), (std.Compare)Compare2)).$add(Unsigned.$int2ulong((int)1)));
            SR = Result_sext.truncate(this.getBitWidth());
            ConstantRange constantRange = new ConstantRange(UR.getSetSize().ult(SR.getSetSize()) ? UR : SR);
            return constantRange;
        }
        finally {
            if (SR != null) {
                SR.$destroy();
            }
            if (Result_sext != null) {
                Result_sext.$destroy();
            }
            if (UR != null) {
                UR.$destroy();
            }
            if (Result_zext != null) {
                Result_zext.$destroy();
            }
        }
    }

    public ConstantRange smax(ConstantRange Other) {
        if (this.isEmptySet() || Other.isEmptySet()) {
            return new ConstantRange(this.getBitWidth(), false);
        }
        APInt NewL = new APInt(APIntOps.smax((APInt)this.getSignedMin(), (APInt)Other.getSignedMin()));
        APInt NewU = APIntOps.smax((APInt)this.getSignedMax(), (APInt)Other.getSignedMax()).$add(Unsigned.$int2ulong((int)1));
        if (NewU.$eq(NewL)) {
            return new ConstantRange(this.getBitWidth(), true);
        }
        return new ConstantRange(new APInt(NewL), new APInt(NewU));
    }

    public ConstantRange umax(ConstantRange Other) {
        if (this.isEmptySet() || Other.isEmptySet()) {
            return new ConstantRange(this.getBitWidth(), false);
        }
        APInt NewL = new APInt(APIntOps.umax((APInt)this.getUnsignedMin(), (APInt)Other.getUnsignedMin()));
        APInt NewU = APIntOps.umax((APInt)this.getUnsignedMax(), (APInt)Other.getUnsignedMax()).$add(Unsigned.$int2ulong((int)1));
        if (NewU.$eq(NewL)) {
            return new ConstantRange(this.getBitWidth(), true);
        }
        return new ConstantRange(new APInt(NewL), new APInt(NewU));
    }

    public ConstantRange smin(ConstantRange Other) {
        if (this.isEmptySet() || Other.isEmptySet()) {
            return new ConstantRange(this.getBitWidth(), false);
        }
        APInt NewL = new APInt(APIntOps.smin((APInt)this.getSignedMin(), (APInt)Other.getSignedMin()));
        APInt NewU = APIntOps.smin((APInt)this.getSignedMax(), (APInt)Other.getSignedMax()).$add(Unsigned.$int2ulong((int)1));
        if (NewU.$eq(NewL)) {
            return new ConstantRange(this.getBitWidth(), true);
        }
        return new ConstantRange(new APInt(NewL), new APInt(NewU));
    }

    public ConstantRange umin(ConstantRange Other) {
        if (this.isEmptySet() || Other.isEmptySet()) {
            return new ConstantRange(this.getBitWidth(), false);
        }
        APInt NewL = new APInt(APIntOps.umin((APInt)this.getUnsignedMin(), (APInt)Other.getUnsignedMin()));
        APInt NewU = APIntOps.umin((APInt)this.getUnsignedMax(), (APInt)Other.getUnsignedMax()).$add(Unsigned.$int2ulong((int)1));
        if (NewU.$eq(NewL)) {
            return new ConstantRange(this.getBitWidth(), true);
        }
        return new ConstantRange(new APInt(NewL), new APInt(NewU));
    }

    public ConstantRange udiv(ConstantRange RHS) {
        APInt Upper;
        if (this.isEmptySet() || RHS.isEmptySet() || RHS.getUnsignedMax().$eq(Unsigned.$int2ulong((int)0))) {
            return new ConstantRange(this.getBitWidth(), false);
        }
        if (RHS.isFullSet()) {
            return new ConstantRange(this.getBitWidth(), true);
        }
        APInt Lower = this.getUnsignedMin().udiv(RHS.getUnsignedMax());
        APInt RHS_umin = RHS.getUnsignedMin();
        if (RHS_umin.$eq(Unsigned.$int2ulong((int)0))) {
            if (RHS.getUpper().$eq(Unsigned.$int2ulong((int)1))) {
                RHS_umin.$assign(RHS.getLower());
            } else {
                RHS_umin.$assignMove(new APInt(JavaDifferentiators.JD$UInt_ULong.INSTANCE, this.getBitWidth(), Unsigned.$int2ulong((int)1)));
            }
        }
        if (Lower.$eq(Upper = this.getUnsignedMax().udiv(RHS_umin).$add(Unsigned.$int2ulong((int)1)))) {
            return new ConstantRange(this.getBitWidth(), true);
        }
        return new ConstantRange(new APInt(Lower), new APInt(Upper));
    }

    public ConstantRange binaryAnd(ConstantRange Other) {
        if (this.isEmptySet() || Other.isEmptySet()) {
            return new ConstantRange(this.getBitWidth(), false);
        }
        APInt umin = new APInt(APIntOps.umin((APInt)Other.getUnsignedMax(), (APInt)this.getUnsignedMax()));
        if (umin.isAllOnesValue()) {
            return new ConstantRange(this.getBitWidth(), true);
        }
        return new ConstantRange(APInt.getNullValue((int)this.getBitWidth()), umin.$add(Unsigned.$int2ulong((int)1)));
    }

    public ConstantRange binaryOr(ConstantRange Other) {
        if (this.isEmptySet() || Other.isEmptySet()) {
            return new ConstantRange(this.getBitWidth(), false);
        }
        APInt umax = new APInt(APIntOps.umax((APInt)this.getUnsignedMin(), (APInt)Other.getUnsignedMin()));
        if (umax.isMinValue()) {
            return new ConstantRange(this.getBitWidth(), true);
        }
        return new ConstantRange(new APInt(umax), APInt.getNullValue((int)this.getBitWidth()));
    }

    public ConstantRange shl(ConstantRange Other) {
        if (this.isEmptySet() || Other.isEmptySet()) {
            return new ConstantRange(this.getBitWidth(), false);
        }
        APInt min = this.getUnsignedMin().shl(Other.getUnsignedMin());
        APInt max = this.getUnsignedMax().shl(Other.getUnsignedMax());
        APInt Zeros = new APInt(JavaDifferentiators.JD$UInt_ULong.INSTANCE, this.getBitWidth(), Unsigned.$uint2ulong((int)this.getUnsignedMax().countLeadingZeros()));
        if (Zeros.ugt(Other.getUnsignedMax())) {
            return new ConstantRange(new APInt(min), max.$add(Unsigned.$int2ulong((int)1)));
        }
        return new ConstantRange(this.getBitWidth(), true);
    }

    public ConstantRange lshr(ConstantRange Other) {
        if (this.isEmptySet() || Other.isEmptySet()) {
            return new ConstantRange(this.getBitWidth(), false);
        }
        APInt max = this.getUnsignedMax().lshr(Other.getUnsignedMin());
        APInt min = this.getUnsignedMin().lshr(Other.getUnsignedMax());
        if (min.$eq(max.$add(Unsigned.$int2ulong((int)1)))) {
            return new ConstantRange(this.getBitWidth(), true);
        }
        return new ConstantRange(new APInt(min), max.$add(Unsigned.$int2ulong((int)1)));
    }

    public ConstantRange inverse() {
        if (this.isFullSet()) {
            return new ConstantRange(this.getBitWidth(), false);
        }
        if (this.isEmptySet()) {
            return new ConstantRange(this.getBitWidth(), true);
        }
        return new ConstantRange(new APInt(this.Upper), new APInt(this.Lower));
    }

    public void print(raw_ostream OS) {
        if (this.isFullSet()) {
            OS.$out("full-set");
        } else if (this.isEmptySet()) {
            OS.$out("empty-set");
        } else {
            AdtsupportLlvmGlobals.$out_raw_ostream_APInt$C((raw_ostream)AdtsupportLlvmGlobals.$out_raw_ostream_APInt$C((raw_ostream)OS.$out(NativePointer.$LSQUARE), (APInt)this.Lower).$out(NativePointer.$COMMA), (APInt)this.Upper).$out(NativePointer.$RPAREN);
        }
    }

    public void dump() {
        this.print(llvm.dbgs());
    }

    public ConstantRange(JavaDifferentiators.JD.Move _dparam, ConstantRange $Prm0) {
        this.Lower = new APInt(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Lower);
        this.Upper = new APInt(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Upper);
    }

    public ConstantRange $assignMove(ConstantRange $Prm0) {
        this.Lower.$assignMove($Prm0.Lower);
        this.Upper.$assignMove($Prm0.Upper);
        return this;
    }

    public void $destroy() {
        this.Upper.$destroy();
        this.Lower.$destroy();
    }

    public ConstantRange(ConstantRange $Prm0) {
        this.Lower = new APInt($Prm0.Lower);
        this.Upper = new APInt($Prm0.Upper);
    }

    public ConstantRange $assign(ConstantRange $Prm0) {
        this.Lower.$assign($Prm0.Lower);
        this.Upper.$assign($Prm0.Upper);
        return this;
    }

    public String toString() {
        return "Lower=" + this.Lower + ", Upper=" + this.Upper;
    }
}

