/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std_pair;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.double;
import org.clank.support.aliases.float;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uchar;
import org.clank.support.aliases.uint;
import org.clank.support.aliases.ulong;
import org.clank.support.aliases.ushort;
import org.clank.support.type;
import org.clank.support.void;
import org.llvm.adt.APFloat;
import org.llvm.adt.APInt;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.StringMap;
import org.llvm.adt.aliases.StringMapConstIterator;
import org.llvm.adt.aliases.StringMapEntry;
import org.llvm.adt.aliases.StringMapIterator;
import org.llvm.ir.ArrayType;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantAggregateZero;
import org.llvm.ir.ConstantData;
import org.llvm.ir.ConstantDataArray;
import org.llvm.ir.ConstantDataVector;
import org.llvm.ir.ConstantFP;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.IntegerType;
import org.llvm.ir.SequentialType;
import org.llvm.ir.Type;
import org.llvm.ir.Value;
import org.llvm.ir.impl.ConstantsStatics;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.llvm_unreachable;

public class ConstantDataSequential
extends ConstantData
implements Destructors.ClassWithDestructor {
    private char.ptr DataElements;
    private ConstantDataSequential Next;
    private final type.ptr<ConstantDataSequential> Next$Ptr = new type.ptr.inout<ConstantDataSequential>(){

        protected ConstantDataSequential $star$impl() {
            return ConstantDataSequential.this.Next;
        }

        protected ConstantDataSequential $set$impl(ConstantDataSequential value) {
            return ConstantDataSequential.this.Next = value;
        }
    };

    protected ConstantDataSequential(ConstantDataSequential $Prm0) {
        super($Prm0);
        throw new UnsupportedOperationException("Deleted");
    }

    void destroyConstantImpl() {
        StringMap<ConstantDataSequential> CDSConstants = this.getType().getContext().pImpl.CDSConstants;
        StringMapIterator Slot = CDSConstants.find(this.getRawDataValues());
        assert (Slot.$noteq((StringMapConstIterator)CDSConstants.end())) : "CDS not found in uniquing table";
        type.ptr Entry2 = (type.ptr)Native.$AddrOf((Object)Slot.$arrow().getValue$Ptr());
        if (((ConstantDataSequential)Entry2.$star()).Next == null) {
            assert (Entry2.$star() == this) : "Hash mismatch in ConstantDataSequential";
            this.getContext().pImpl.CDSConstants.erase(Slot);
        } else {
            ConstantDataSequential Node2 = (ConstantDataSequential)Entry2.$star();
            while (true) {
                assert (Node2 != null) : "Didn't find entry in its uniquing hash table!";
                if (Node2 == this) {
                    Entry2.$set((Object)Node2.Next);
                    break;
                }
                Entry2 = (type.ptr)Native.$tryClone((NativeCloneable)((type.ptr)Native.$AddrOf(Node2.Next$Ptr)));
                Node2 = (ConstantDataSequential)Entry2.$star();
            }
        }
        this.Next = null;
    }

    protected ConstantDataSequential(Type ty, Value.ValueTy VT, char.ptr Data) {
        super(ty, VT);
        this.DataElements = Native.$tryClone((char.ptr)Data);
        this.Next = null;
    }

    @Override
    public void $destroy() {
        Destructors.$destroy((Destructors.ClassWithDestructor)this.Next);
        super.$destroy();
    }

    protected static Constant getImpl(StringRef Elements, Type Ty) {
        assert (ConstantDataSequential.isElementTypeCompatible(Ty.getSequentialElementType()));
        if (ConstantsStatics.isAllZeros(new StringRef(Elements))) {
            return ConstantAggregateZero.get(Ty);
        }
        StringMapEntry Slot = ((StringMapIterator)Ty.getContext().pImpl.CDSConstants.insert((std_pair.pair)new std_pair.pairTypePtr((JavaDifferentiators.JD$Pair$_U1$_U2)JavaDifferentiators.JD$Pair$_U1$_U2.INSTANCE, (Object)new StringRef((JavaDifferentiators.JD.Move)JavaDifferentiators.JD.Move.INSTANCE, (StringRef)new StringRef((StringRef)Elements)), (Object)((ConstantDataSequential)null))).first).$star();
        type.ptr Entry2 = (type.ptr)Native.$tryClone((NativeCloneable)((type.ptr)Native.$AddrOf((Object)Slot.getValue$Ptr())));
        ConstantDataSequential Node2 = (ConstantDataSequential)Entry2.$star();
        while (Node2 != null) {
            if (Node2.getType() == Ty) {
                return Node2;
            }
            Entry2 = (type.ptr)Native.$tryClone((NativeCloneable)((type.ptr)Native.$AddrOf(Node2.Next$Ptr)));
            Node2 = (ConstantDataSequential)Entry2.$star();
        }
        if (IrRTTI.isa_ArrayType(Ty)) {
            return (Constant)Entry2.$set((Object)ConstantDataArray.$new_ConstantDataArray((NativeCallback.New.ConstructorCallback<ConstantDataArray>)((NativeCallback.New.ConstructorCallback)New$Mem -> new ConstantDataArray(Ty, Slot.first().data()))));
        }
        assert (IrRTTI.isa_VectorType(Ty));
        return (Constant)Entry2.$set((Object)ConstantDataVector.$new_ConstantDataVector((NativeCallback.New.ConstructorCallback<ConstantDataVector>)((NativeCallback.New.ConstructorCallback)New$Mem -> new ConstantDataVector(Ty, Slot.first().data()))));
    }

    public static boolean isElementTypeCompatible(Type Ty) {
        if (Ty.isHalfTy() || Ty.isFloatTy() || Ty.isDoubleTy()) {
            return true;
        }
        IntegerType IT = IrRTTI.dyn_cast_IntegerType(Ty);
        if (IT != null) {
            switch (IT.getBitWidth()) {
                case 8: 
                case 16: 
                case 32: 
                case 64: {
                    return true;
                }
            }
        }
        return false;
    }

    public long getElementAsInteger(int Elt) {
        assert (IrRTTI.isa_IntegerType(this.getElementType())) : "Accessor can only be used when element is an integer";
        char.ptr EltPtr = Native.$tryClone((char.ptr)this.getElementPointer(Elt));
        switch (this.getElementType().getIntegerBitWidth()) {
            default: {
                throw new llvm_unreachable("Invalid bitwidth for CDS");
            }
            case 8: {
                return Unsigned.$uchar2ulong((byte)((uchar.ptr)Casts.reinterpret_cast(uchar.ptr.class, (void.ptr)EltPtr)).$star());
            }
            case 16: {
                return Unsigned.$ushort2ulong((char)((ushort.ptr)Casts.reinterpret_cast(ushort.ptr.class, (void.ptr)EltPtr)).$star());
            }
            case 32: {
                return Unsigned.$uint2ulong((int)((uint.ptr)Casts.reinterpret_cast(uint.ptr.class, (void.ptr)EltPtr)).$star());
            }
            case 64: 
        }
        return ((ulong.ptr)Casts.reinterpret_cast(ulong.ptr.class, (void.ptr)EltPtr)).$star();
    }

    public APFloat getElementAsAPFloat(int Elt) {
        char.ptr EltPtr = Native.$tryClone((char.ptr)this.getElementPointer(Elt));
        switch (this.getElementType().getTypeID()) {
            default: {
                throw new llvm_unreachable("Accessor can only be used when element is float/double!");
            }
            case HalfTyID: {
                char EltVal = ((ushort.ptr)Casts.reinterpret_cast(ushort.ptr.class, (void.ptr)EltPtr)).$star();
                return new APFloat(APFloat.IEEEhalf, new APInt(JavaDifferentiators.JD$UInt_ULong.INSTANCE, 16, Unsigned.$ushort2ulong((char)EltVal)));
            }
            case FloatTyID: {
                int EltVal = ((uint.ptr)Casts.reinterpret_cast(uint.ptr.class, (void.ptr)EltPtr)).$star();
                return new APFloat(APFloat.IEEEsingle, new APInt(JavaDifferentiators.JD$UInt_ULong.INSTANCE, 32, Unsigned.$uint2ulong((int)EltVal)));
            }
            case DoubleTyID: 
        }
        long EltVal = ((ulong.ptr)Casts.reinterpret_cast(ulong.ptr.class, (void.ptr)EltPtr)).$star();
        return new APFloat(APFloat.IEEEdouble, new APInt(JavaDifferentiators.JD$UInt_ULong.INSTANCE, 64, EltVal));
    }

    public float getElementAsFloat(int Elt) {
        assert (this.getElementType().isFloatTy()) : "Accessor can only be used when element is a 'float'";
        float.ptr EltPtr = (float.ptr)Native.$tryClone((NativeCloneable)((float.ptr)Casts.reinterpret_cast(float.ptr.class, (void.ptr)this.getElementPointer(Elt))));
        return EltPtr.$star();
    }

    public double getElementAsDouble(int Elt) {
        assert (this.getElementType().isDoubleTy()) : "Accessor can only be used when element is a 'float'";
        double.ptr EltPtr = (double.ptr)Native.$tryClone((NativeCloneable)((double.ptr)Casts.reinterpret_cast(double.ptr.class, (void.ptr)this.getElementPointer(Elt))));
        return EltPtr.$star();
    }

    public Constant getElementAsConstant(int Elt) {
        if (this.getElementType().isHalfTy() || this.getElementType().isFloatTy() || this.getElementType().isDoubleTy()) {
            return ConstantFP.get(this.getContext(), this.getElementAsAPFloat(Elt));
        }
        return ConstantInt.get(this.getElementType(), this.getElementAsInteger(Elt));
    }

    @Override
    public SequentialType getType() {
        return IrRTTI.cast_SequentialType(super.getType());
    }

    public Type getElementType() {
        return this.getType().getElementType();
    }

    public int getNumElements() {
        ArrayType AT = IrRTTI.dyn_cast_ArrayType(this.getType());
        if (AT != null) {
            return Unsigned.$ulong2uint((long)AT.getNumElements());
        }
        return this.getType().getVectorNumElements();
    }

    public long getElementByteSize() {
        return Unsigned.$uint2ulong((int)Unsigned.$div_uint((int)this.getElementType().getPrimitiveSizeInBits(), (int)8));
    }

    public boolean isString() {
        return IrRTTI.isa_ArrayType(this.getType()) && this.getElementType().isIntegerTy(8);
    }

    public boolean isCString() {
        if (!this.isString()) {
            return false;
        }
        StringRef Str = this.getAsString();
        if (Str.back() != 0) {
            return false;
        }
        return Str.drop_back().find(Unsigned.$int2char((int)0)) == StringRef.npos;
    }

    public StringRef getAsString() {
        assert (this.isString()) : "Not a string";
        return this.getRawDataValues();
    }

    public StringRef getAsCString() {
        assert (this.isCString()) : "Isn't a C string";
        StringRef Str = this.getAsString();
        return Str.substr(0, Str.size() - 1);
    }

    public StringRef getRawDataValues() {
        return new StringRef(this.DataElements, Unsigned.$ullong2uint((long)(Unsigned.$uint2ullong((int)this.getNumElements()) * this.getElementByteSize())));
    }

    public static boolean classof(Value V) {
        return V.getValueID() == Value.ValueTy.ConstantDataArrayVal.getValue() || V.getValueID() == Value.ValueTy.ConstantDataVectorVal.getValue();
    }

    private char.ptr getElementPointer(int Elt) {
        assert (Unsigned.$less_uint((int)Elt, (int)this.getNumElements())) : "Invalid Elt";
        return (char.ptr)this.DataElements.$add(Unsigned.$ulong2uint((long)(Unsigned.$uint2ullong((int)Elt) * this.getElementByteSize())));
    }

    @Override
    public String toString() {
        return "DataElements=" + this.DataElements + ", Next=" + this.Next + super.toString();
    }
}

