/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.java.SmallVectorImplCommon;
import org.llvm.ir.ArrayType;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantAggregate;
import org.llvm.ir.ConstantAggregateZero;
import org.llvm.ir.ConstantDataSequential;
import org.llvm.ir.UndefValue;
import org.llvm.ir.Use;
import org.llvm.ir.Value;
import org.llvm.ir.impl.ConstantAggrKeyType;
import org.llvm.ir.impl.ConstantsStatics;
import org.llvm.ir.java.IrRTTI;

public final class ConstantArray
extends ConstantAggregate
implements Destructors.ClassWithDestructor {
    void destroyConstantImpl() {
        this.getType().getContext().pImpl.ArrayConstants.remove(this);
    }

    Value handleOperandChangeImpl(Value From, Value To) {
        assert (IrRTTI.isa_Constant(To)) : "Cannot make Constant refer to non-constant!";
        Constant ToC = IrRTTI.cast_Constant(To);
        SmallVector Values2 = new SmallVector(8, (Object)null);
        Values2.reserve(this.getNumOperands());
        int NumUpdated = 0;
        boolean AllSame = true;
        type.ptr OperandList = (type.ptr)Native.$tryClone(this.getOperandList());
        int OperandNo = 0;
        type.ptr O = (type.ptr)Native.$tryClone((NativeCloneable)OperandList);
        type.ptr E = (type.ptr)Native.$tryClone((NativeCloneable)((type.ptr)OperandList.$add(this.getNumOperands())));
        while (Native.$noteq_ptr((void.ptr)O, (void.ptr)E)) {
            Constant Val = IrRTTI.cast_Constant(((Use)O.$star()).get());
            if (Val == From) {
                OperandNo = O.$sub((abstract_iterator)OperandList);
                Val = ToC;
                ++NumUpdated;
            }
            Values2.push_back((Object)Val);
            AllSame &= Val == ToC;
            O.$preInc();
        }
        if (AllSame && ToC.isNullValue()) {
            return ConstantAggregateZero.get(this.getType());
        }
        if (AllSame && IrRTTI.isa_UndefValue(ToC)) {
            return UndefValue.get(this.getType());
        }
        Constant C2 = ConstantArray.getImpl(this.getType(), (ArrayRef<Constant>)new ArrayRef((SmallVectorImplCommon)Values2, true));
        if (C2 != null) {
            return C2;
        }
        return this.getContext().pImpl.ArrayConstants.replaceOperandsInPlace((ArrayRef<Constant>)new ArrayRef((SmallVectorImplCommon)Values2, true), this, From, ToC, NumUpdated, OperandNo);
    }

    public ConstantArray(ArrayType T2, ArrayRef<Constant> V) {
        super(T2, Value.ValueTy.ConstantArrayVal, (ArrayRef<Constant>)new ArrayRef(V));
        assert (Unsigned.$uint2ullong((int)V.size()) == T2.getNumElements()) : "Invalid initializer for constant array";
    }

    public static Constant get(ArrayType Ty, ArrayRef<Constant> V) {
        Constant C2 = ConstantArray.getImpl(Ty, (ArrayRef<Constant>)new ArrayRef(V));
        if (C2 != null) {
            return C2;
        }
        return Ty.getContext().pImpl.ArrayConstants.getOrCreate(Ty, new ConstantAggrKeyType<ConstantArray, ArrayType>((ArrayRef<Constant>)new ArrayRef(V)));
    }

    private static Constant getImpl(ArrayType Ty, ArrayRef<Constant> V) {
        if (V.empty()) {
            return ConstantAggregateZero.get(Ty);
        }
        int e = V.size();
        for (int i = 0; i != e; ++i) {
            assert (((Constant)V.$at(i)).getType() == Ty.getElementType()) : "Wrong type in array element initializer";
        }
        Constant C2 = (Constant)V.$at(0);
        if (IrRTTI.isa_UndefValue(C2) && ConstantsStatics.rangeOnlyContains((type.ptr<Constant>)V.begin(), (type.ptr<Constant>)V.end(), C2)) {
            return UndefValue.get(Ty);
        }
        if (C2.isNullValue() && ConstantsStatics.rangeOnlyContains((type.ptr<Constant>)V.begin(), (type.ptr<Constant>)V.end(), C2)) {
            return ConstantAggregateZero.get(Ty);
        }
        if (ConstantDataSequential.isElementTypeCompatible(C2.getType())) {
            return ConstantsStatics.getSequenceIfElementsMatch(C2, (ArrayRef<Constant>)new ArrayRef(V));
        }
        return null;
    }

    @Override
    public ArrayType getType() {
        return IrRTTI.cast_ArrayType(super.getType());
    }

    public static boolean classof(Value V) {
        return V.getValueID() == Value.ValueTy.ConstantArrayVal.getValue();
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

