/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.clank.support.convert_iterator;
import org.clank.support.void;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.ArrayRefUInt;
import org.llvm.adt.iterator_range;
import org.llvm.ir.AttrBuilder;
import org.llvm.ir.Attribute;
import org.llvm.ir.AttributeSet;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.DebugLoc;
import org.llvm.ir.Function;
import org.llvm.ir.FunctionType;
import org.llvm.ir.Instruction;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.OperandBundleDefT;
import org.llvm.ir.OperandBundleUser;
import org.llvm.ir.OperandTraitsCallInst;
import org.llvm.ir.Type;
import org.llvm.ir.Use;
import org.llvm.ir.User;
import org.llvm.ir.Value;
import org.llvm.ir.impl.InstructionsStatics;
import org.llvm.ir.java.CallOrInvokeInst;
import org.llvm.ir.java.IRJavaDifferentiators;
import org.llvm.ir.java.IrRTTI;
import org.llvm.ir.java.IrSizeofAndAlignment;
import org.llvm.support.llvm;

public class CallInst
extends Instruction
implements CallOrInvokeInst,
OperandBundleUser<CallInst, type.ptr<Use>>,
Destructors.ClassWithDestructor {
    private AttributeSet AttributeList;
    private FunctionType FTy;

    protected CallInst(CallInst CI) {
        super(CI.getType(), 54, (type.ptr<Use>)((type.ptr)OperandTraitsCallInst.op_end(User.$BEING_CREATED()).$sub(CI.getNumOperands())), CI.getNumOperands());
        this.$OperandBundleUser();
        this.AttributeList = new AttributeSet(CI.AttributeList);
        this.FTy = CI.FTy;
        this.setTailCallKind(CI.getTailCallKind());
        this.setCallingConv(CI.getCallingConv());
        std.copy(CI.op_begin$Const(), CI.op_end$Const(), this.op_begin());
        std.copy((type.iterator)CI.bundle_op_info_begin$Const(), (type.iterator)CI.bundle_op_info_end$Const(), (type.iterator)this.bundle_op_info_begin());
        this.SubclassOptionalData = Unsigned.$uchar2uchar_7bits((byte)Unsigned.$7bits_uchar2uchar((byte)CI.SubclassOptionalData));
    }

    private void init(Value Func, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles, Twine NameStr) {
        this.init(IrRTTI.cast_FunctionType(IrRTTI.cast_PointerType(Func.getType()).getElementType()), Func, (ArrayRef<Value>)new ArrayRef(Args), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles), NameStr);
    }

    private void init(FunctionType FTy, Value Func, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles, Twine NameStr) {
        this.FTy = FTy;
        assert (this.getNumOperands() == Args.size() + OperandBundleUser.CountBundleInputs((ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles)) + 1) : "NumOperands not set up?";
        this.Op(-1).$assign(Func);
        assert (Args.size() == FTy.getNumParams() || FTy.isVarArg() && Unsigned.$greater_uint((int)Args.size(), (int)FTy.getNumParams())) : "Calling a function with bad signature!";
        for (int i = 0; i != Args.size(); ++i) {
            assert (Unsigned.$greatereq_uint((int)i, (int)FTy.getNumParams()) || FTy.getParamType(i) == ((Value)Args.$at(i)).getType()) : "Calling a function with a bad signature!";
        }
        std.copy((type.iterator)Args.begin(), (type.iterator)Args.end(), this.op_begin(), (source, dest) -> ((Use)dest.$star()).$assign((Value)source.$star()));
        type.ptr It = (type.ptr)Native.$tryClone((NativeCloneable)this.populateBundleOperandInfos(new ArrayRef(Bundles), Args.size()));
        assert (Native.$eq_ptr((void.ptr)((type.ptr)It.$add(1)), this.op_end())) : "Should add up!";
        this.setName(NameStr);
    }

    private void init(Value Func, Twine NameStr) {
        this.FTy = IrRTTI.cast_FunctionType(IrRTTI.cast_PointerType(Func.getType()).getElementType());
        assert (this.getNumOperands() == 1) : "NumOperands not set up?";
        this.Op(-1).$assign(Func);
        assert (this.FTy.getNumParams() == 0) : "Calling a function with bad signature";
        this.setName(NameStr);
    }

    protected CallInst(FunctionType Ty, Value Func, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles, Twine NameStr, Instruction InsertBefore) {
        super(Ty.getReturnType(), 54, (type.ptr<Use>)((type.ptr)OperandTraitsCallInst.op_end(User.$BEING_CREATED()).$sub(Args.size() + OperandBundleUser.CountBundleInputs((ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles)) + 1)), Args.size() + OperandBundleUser.CountBundleInputs((ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles)) + 1, InsertBefore);
        this.$OperandBundleUser();
        this.AttributeList = new AttributeSet();
        this.init(Ty, Func, (ArrayRef<Value>)new ArrayRef(Args), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles), NameStr);
    }

    protected CallInst(IRJavaDifferentiators.JD.Value.P_ArrayRef.Value.P_ArrayRef.OperandBundleDefT.P_Twine.C_Instruction.P _dparam, Value Func, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles, Twine NameStr, Instruction InsertBefore) {
        this(IrRTTI.cast_FunctionType(IrRTTI.cast_PointerType(Func.getType()).getElementType()), Func, (ArrayRef<Value>)new ArrayRef(Args), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles), NameStr, InsertBefore);
    }

    protected CallInst(Value Func, ArrayRef<Value> Args, Twine NameStr, Instruction InsertBefore) {
        this(IRJavaDifferentiators.JD.Value.P_ArrayRef.Value.P_ArrayRef.OperandBundleDefT.P_Twine.C_Instruction.P.INSTANCE, Func, (ArrayRef<Value>)new ArrayRef(Args), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(llvm.None, false), NameStr, InsertBefore);
    }

    protected CallInst(IRJavaDifferentiators.JD.Value.P_ArrayRef.Value.P_ArrayRef.OperandBundleDefT.P_Twine.C_BasicBlock.P _dparam, Value Func, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles, Twine NameStr, BasicBlock InsertAtEnd) {
        super(IrRTTI.cast_FunctionType(IrRTTI.cast_PointerType(Func.getType()).getElementType()).getReturnType(), 54, (type.ptr<Use>)((type.ptr)OperandTraitsCallInst.op_end(User.$BEING_CREATED()).$sub(Args.size() + OperandBundleUser.CountBundleInputs((ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles)) + 1)), Args.size() + OperandBundleUser.CountBundleInputs((ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles)) + 1, InsertAtEnd);
        this.$OperandBundleUser();
        this.AttributeList = new AttributeSet();
        this.init(Func, (ArrayRef<Value>)new ArrayRef(Args), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles), NameStr);
    }

    protected CallInst(Value Func, Twine Name, Instruction InsertBefore) {
        super(IrRTTI.cast_FunctionType(IrRTTI.cast_PointerType(Func.getType()).getElementType()).getReturnType(), 54, (type.ptr<Use>)((type.ptr)OperandTraitsCallInst.op_end(User.$BEING_CREATED()).$sub(1)), 1, InsertBefore);
        this.$OperandBundleUser();
        this.AttributeList = new AttributeSet();
        this.init(Func, Name);
    }

    protected CallInst(Value Func, Twine Name, BasicBlock InsertAtEnd) {
        super(IrRTTI.cast_FunctionType(IrRTTI.cast_PointerType(Func.getType()).getElementType()).getReturnType(), 54, (type.ptr<Use>)((type.ptr)OperandTraitsCallInst.op_end(User.$BEING_CREATED()).$sub(1)), 1, InsertAtEnd);
        this.$OperandBundleUser();
        this.AttributeList = new AttributeSet();
        this.init(Func, Name);
    }

    @Override
    public boolean hasDescriptor() {
        return this.HasDescriptor;
    }

    protected CallInst cloneImpl() {
        if (this.hasOperandBundles()) {
            int DescriptorBytes = this.getNumOperandBundles() * IrSizeofAndAlignment.$sizeof_BundleOpInfo();
            return (CallInst)User.$new_FixedUsesAndDesc(this.getNumOperands(), DescriptorBytes, New$Mem -> new CallInst(this));
        }
        return (CallInst)User.$new_FixedUses(this.getNumOperands(), New$Mem -> new CallInst(this));
    }

    public static CallInst Create_Value1(Value Func, ArrayRef<Value> Args) {
        return CallInst.Create_Value1(Func, Args, (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(llvm.None, false), new Twine(NativePointer.$EMPTY), null);
    }

    public static CallInst Create_Value1(Value Func, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles) {
        return CallInst.Create_Value1(Func, Args, Bundles, new Twine(NativePointer.$EMPTY), null);
    }

    public static CallInst Create_Value1(Value Func, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles, Twine NameStr) {
        return CallInst.Create_Value1(Func, Args, Bundles, NameStr, null);
    }

    public static CallInst Create_Value1(Value Func, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles, Twine NameStr, Instruction InsertBefore) {
        return CallInst.Create(IrRTTI.cast_FunctionType(IrRTTI.cast_PointerType(Func.getType()).getElementType()), Func, (ArrayRef<Value>)new ArrayRef(Args), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles), NameStr, InsertBefore);
    }

    public static CallInst Create_Value2(Value Func, ArrayRef<Value> Args, Twine NameStr) {
        return CallInst.Create_Value2(Func, Args, NameStr, null);
    }

    public static CallInst Create_Value2(Value Func, ArrayRef<Value> Args, Twine NameStr, Instruction InsertBefore) {
        return CallInst.Create(IrRTTI.cast_FunctionType(IrRTTI.cast_PointerType(Func.getType()).getElementType()), Func, (ArrayRef<Value>)new ArrayRef(Args), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(llvm.None, false), NameStr, InsertBefore);
    }

    public static CallInst Create(FunctionType Ty, Value Func, ArrayRef<Value> Args, Twine NameStr) {
        return CallInst.Create(Ty, Func, Args, NameStr, (Instruction)null);
    }

    public static CallInst Create(FunctionType Ty, Value Func, ArrayRef<Value> Args, Twine NameStr, Instruction InsertBefore) {
        return (CallInst)User.$new_FixedUses(Args.size() + 1, New$Mem -> new CallInst(Ty, Func, (ArrayRef<Value>)new ArrayRef(Args), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(llvm.None, false), NameStr, InsertBefore));
    }

    public static CallInst Create(FunctionType Ty, Value Func, ArrayRef<Value> Args) {
        return CallInst.Create(Ty, Func, Args, (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(llvm.None, false), new Twine(NativePointer.$EMPTY), null);
    }

    public static CallInst Create(FunctionType Ty, Value Func, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles) {
        return CallInst.Create(Ty, Func, Args, Bundles, new Twine(NativePointer.$EMPTY), null);
    }

    public static CallInst Create(FunctionType Ty, Value Func, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles, Twine NameStr) {
        return CallInst.Create(Ty, Func, Args, Bundles, NameStr, null);
    }

    public static CallInst Create(FunctionType Ty, Value Func, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles, Twine NameStr, Instruction InsertBefore) {
        int TotalOps = Args.size() + OperandBundleUser.CountBundleInputs((ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles)) + 1;
        int DescriptorBytes = Bundles.size() * IrSizeofAndAlignment.$sizeof_BundleOpInfo();
        return (CallInst)User.$new_FixedUsesAndDesc(TotalOps, DescriptorBytes, New$Mem -> new CallInst(Ty, Func, (ArrayRef<Value>)new ArrayRef(Args), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles), NameStr, InsertBefore));
    }

    public static CallInst Create_Value3(Value Func, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles, Twine NameStr, BasicBlock InsertAtEnd) {
        int TotalOps = Args.size() + OperandBundleUser.CountBundleInputs((ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles)) + 1;
        int DescriptorBytes = Bundles.size() * IrSizeofAndAlignment.$sizeof_BundleOpInfo();
        return (CallInst)User.$new_FixedUsesAndDesc(TotalOps, DescriptorBytes, New$Mem -> new CallInst(IRJavaDifferentiators.JD.Value.P_ArrayRef.Value.P_ArrayRef.OperandBundleDefT.P_Twine.C_BasicBlock.P.INSTANCE, Func, (ArrayRef<Value>)new ArrayRef(Args), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles), NameStr, InsertAtEnd));
    }

    public static CallInst Create_Value4(Value Func, ArrayRef<Value> Args, Twine NameStr, BasicBlock InsertAtEnd) {
        return (CallInst)User.$new_FixedUses(Args.size() + 1, New$Mem -> new CallInst(IRJavaDifferentiators.JD.Value.P_ArrayRef.Value.P_ArrayRef.OperandBundleDefT.P_Twine.C_BasicBlock.P.INSTANCE, Func, (ArrayRef<Value>)new ArrayRef(Args), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(llvm.None, false), NameStr, InsertAtEnd));
    }

    public static CallInst Create(Value F) {
        return CallInst.Create(F, new Twine(NativePointer.$EMPTY), (Instruction)null);
    }

    public static CallInst Create(Value F, Twine NameStr) {
        return CallInst.Create(F, NameStr, (Instruction)null);
    }

    public static CallInst Create(Value F, Twine NameStr, Instruction InsertBefore) {
        return (CallInst)User.$new_FixedUses(1, New$Mem -> new CallInst(F, NameStr, InsertBefore));
    }

    public static CallInst Create(Value F, Twine NameStr, BasicBlock InsertAtEnd) {
        return (CallInst)User.$new_FixedUses(1, New$Mem -> new CallInst(F, NameStr, InsertAtEnd));
    }

    public static CallInst Create_CallInst1(CallInst CI, ArrayRef<OperandBundleDefT<Value>> OpB) {
        return CallInst.Create_CallInst1(CI, OpB, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CallInst Create_CallInst1(CallInst CI, ArrayRef<OperandBundleDefT<Value>> OpB, Instruction InsertPt) {
        std.vector Args = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            NativeCallback.Converter $C = U -> U.$Value$P();
            Args = new std.vector((type.iterator)new convert_iterator(CI.arg_begin(), $C), (type.iterator)new convert_iterator(CI.arg_end(), $C), (Object)null);
            CallInst NewCI = CallInst.Create_Value1(CI.getCalledValue(), (ArrayRef<Value>)new ArrayRef(Args, true), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(OpB), new Twine(CI.getName()), InsertPt);
            NewCI.setTailCallKind(CI.getTailCallKind());
            NewCI.setCallingConv(CI.getCallingConv());
            NewCI.SubclassOptionalData = Unsigned.$uchar2uchar_7bits((byte)Unsigned.$7bits_uchar2uchar((byte)CI.SubclassOptionalData));
            NewCI.setAttributes(CI.getAttributes());
            NewCI.setDebugLoc((DebugLoc)$c$.track((Object)new DebugLoc(CI.getDebugLoc())));
            $c$.clean();
            CallInst callInst = NewCI;
            return callInst;
        }
        finally {
            if (Args != null) {
                Args.$destroy();
            }
            $c$.$destroy();
        }
    }

    public static Instruction CreateMalloc(Instruction InsertBefore, Type IntPtrTy, Type AllocTy, Value AllocSize) {
        return CallInst.CreateMalloc(InsertBefore, IntPtrTy, AllocTy, AllocSize, (Value)null, (Function)null, new Twine(NativePointer.$EMPTY));
    }

    public static Instruction CreateMalloc(Instruction InsertBefore, Type IntPtrTy, Type AllocTy, Value AllocSize, Value ArraySize) {
        return CallInst.CreateMalloc(InsertBefore, IntPtrTy, AllocTy, AllocSize, ArraySize, (Function)null, new Twine(NativePointer.$EMPTY));
    }

    public static Instruction CreateMalloc(Instruction InsertBefore, Type IntPtrTy, Type AllocTy, Value AllocSize, Value ArraySize, Function MallocF) {
        return CallInst.CreateMalloc(InsertBefore, IntPtrTy, AllocTy, AllocSize, ArraySize, MallocF, new Twine(NativePointer.$EMPTY));
    }

    public static Instruction CreateMalloc(Instruction InsertBefore, Type IntPtrTy, Type AllocTy, Value AllocSize, Value ArraySize, Function MallocF, Twine Name) {
        return InstructionsStatics.createMalloc(InsertBefore, null, IntPtrTy, AllocTy, AllocSize, ArraySize, (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(llvm.None, false), MallocF, Name);
    }

    public static Instruction CreateMalloc(BasicBlock InsertAtEnd, Type IntPtrTy, Type AllocTy, Value AllocSize) {
        return CallInst.CreateMalloc(InsertAtEnd, IntPtrTy, AllocTy, AllocSize, (Value)null, (Function)null, new Twine(NativePointer.$EMPTY));
    }

    public static Instruction CreateMalloc(BasicBlock InsertAtEnd, Type IntPtrTy, Type AllocTy, Value AllocSize, Value ArraySize) {
        return CallInst.CreateMalloc(InsertAtEnd, IntPtrTy, AllocTy, AllocSize, ArraySize, (Function)null, new Twine(NativePointer.$EMPTY));
    }

    public static Instruction CreateMalloc(BasicBlock InsertAtEnd, Type IntPtrTy, Type AllocTy, Value AllocSize, Value ArraySize, Function MallocF) {
        return CallInst.CreateMalloc(InsertAtEnd, IntPtrTy, AllocTy, AllocSize, ArraySize, MallocF, new Twine(NativePointer.$EMPTY));
    }

    public static Instruction CreateMalloc(BasicBlock InsertAtEnd, Type IntPtrTy, Type AllocTy, Value AllocSize, Value ArraySize, Function MallocF, Twine Name) {
        return InstructionsStatics.createMalloc(null, InsertAtEnd, IntPtrTy, AllocTy, AllocSize, ArraySize, (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(llvm.None, false), MallocF, Name);
    }

    public static Instruction CreateMalloc1(Instruction InsertBefore, Type IntPtrTy, Type AllocTy, Value AllocSize) {
        return CallInst.CreateMalloc1(InsertBefore, IntPtrTy, AllocTy, AllocSize, null, (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(llvm.None, false), null, new Twine(NativePointer.$EMPTY));
    }

    public static Instruction CreateMalloc1(Instruction InsertBefore, Type IntPtrTy, Type AllocTy, Value AllocSize, Value ArraySize) {
        return CallInst.CreateMalloc1(InsertBefore, IntPtrTy, AllocTy, AllocSize, ArraySize, (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(llvm.None, false), null, new Twine(NativePointer.$EMPTY));
    }

    public static Instruction CreateMalloc1(Instruction InsertBefore, Type IntPtrTy, Type AllocTy, Value AllocSize, Value ArraySize, ArrayRef<OperandBundleDefT<Value>> OpB) {
        return CallInst.CreateMalloc1(InsertBefore, IntPtrTy, AllocTy, AllocSize, ArraySize, OpB, null, new Twine(NativePointer.$EMPTY));
    }

    public static Instruction CreateMalloc1(Instruction InsertBefore, Type IntPtrTy, Type AllocTy, Value AllocSize, Value ArraySize, ArrayRef<OperandBundleDefT<Value>> OpB, Function MallocF) {
        return CallInst.CreateMalloc1(InsertBefore, IntPtrTy, AllocTy, AllocSize, ArraySize, OpB, MallocF, new Twine(NativePointer.$EMPTY));
    }

    public static Instruction CreateMalloc1(Instruction InsertBefore, Type IntPtrTy, Type AllocTy, Value AllocSize, Value ArraySize, ArrayRef<OperandBundleDefT<Value>> OpB, Function MallocF, Twine Name) {
        return InstructionsStatics.createMalloc(InsertBefore, null, IntPtrTy, AllocTy, AllocSize, ArraySize, (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(OpB), MallocF, Name);
    }

    public static Instruction CreateMalloc2(BasicBlock InsertAtEnd, Type IntPtrTy, Type AllocTy, Value AllocSize) {
        return CallInst.CreateMalloc2(InsertAtEnd, IntPtrTy, AllocTy, AllocSize, null, (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(llvm.None, false), null, new Twine(NativePointer.$EMPTY));
    }

    public static Instruction CreateMalloc2(BasicBlock InsertAtEnd, Type IntPtrTy, Type AllocTy, Value AllocSize, Value ArraySize) {
        return CallInst.CreateMalloc2(InsertAtEnd, IntPtrTy, AllocTy, AllocSize, ArraySize, (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(llvm.None, false), null, new Twine(NativePointer.$EMPTY));
    }

    public static Instruction CreateMalloc2(BasicBlock InsertAtEnd, Type IntPtrTy, Type AllocTy, Value AllocSize, Value ArraySize, ArrayRef<OperandBundleDefT<Value>> OpB) {
        return CallInst.CreateMalloc2(InsertAtEnd, IntPtrTy, AllocTy, AllocSize, ArraySize, OpB, null, new Twine(NativePointer.$EMPTY));
    }

    public static Instruction CreateMalloc2(BasicBlock InsertAtEnd, Type IntPtrTy, Type AllocTy, Value AllocSize, Value ArraySize, ArrayRef<OperandBundleDefT<Value>> OpB, Function MallocF) {
        return CallInst.CreateMalloc2(InsertAtEnd, IntPtrTy, AllocTy, AllocSize, ArraySize, OpB, MallocF, new Twine(NativePointer.$EMPTY));
    }

    public static Instruction CreateMalloc2(BasicBlock InsertAtEnd, Type IntPtrTy, Type AllocTy, Value AllocSize, Value ArraySize, ArrayRef<OperandBundleDefT<Value>> OpB, Function MallocF, Twine Name) {
        return InstructionsStatics.createMalloc(null, InsertAtEnd, IntPtrTy, AllocTy, AllocSize, ArraySize, (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(OpB), MallocF, Name);
    }

    public static Instruction CreateFree(Value Source, Instruction InsertBefore) {
        return InstructionsStatics.createFree(Source, (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(llvm.None, false), InsertBefore, null);
    }

    public static Instruction CreateFree(Value Source, BasicBlock InsertAtEnd) {
        Instruction FreeCall = InstructionsStatics.createFree(Source, (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(llvm.None, false), null, InsertAtEnd);
        assert (FreeCall != null) : "CreateFree did not create a CallInst";
        return FreeCall;
    }

    public static Instruction CreateFree_Value$P_ArrayRef$OperandBundleDefT$P_Instruction$P(Value Source, ArrayRef<OperandBundleDefT<Value>> Bundles, Instruction InsertBefore) {
        return InstructionsStatics.createFree(Source, (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles), InsertBefore, null);
    }

    public static Instruction CreateFree_Value$P_ArrayRef$OperandBundleDefT$P_BasicBlock$P(Value Source, ArrayRef<OperandBundleDefT<Value>> Bundles, BasicBlock InsertAtEnd) {
        Instruction FreeCall = InstructionsStatics.createFree(Source, (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles), null, InsertAtEnd);
        assert (FreeCall != null) : "CreateFree did not create a CallInst";
        return FreeCall;
    }

    @Override
    public void $destroy() {
        super.$destroy();
        OperandBundleUser.super.$destroy$OperandBundleUser();
    }

    public FunctionType getFunctionType() {
        return this.FTy;
    }

    public void mutateFunctionType(FunctionType FTy) {
        this.mutateType(FTy.getReturnType());
        this.FTy = FTy;
    }

    public TailCallKind getTailCallKind() {
        return TailCallKind.valueOf(this.getSubclassDataFromInstruction() & 3);
    }

    public boolean isTailCall() {
        int Kind2 = this.getSubclassDataFromInstruction() & 3;
        return Kind2 == TailCallKind.TCK_Tail.getValue() || Kind2 == TailCallKind.TCK_MustTail.getValue();
    }

    public boolean isMustTailCall() {
        return (this.getSubclassDataFromInstruction() & 3) == TailCallKind.TCK_MustTail.getValue();
    }

    public boolean isNoTailCall() {
        return (this.getSubclassDataFromInstruction() & 3) == TailCallKind.TCK_NoTail.getValue();
    }

    public void setTailCall() {
        this.setTailCall(true);
    }

    public void setTailCall(boolean isTC) {
        this.setInstructionSubclassData_CallInst(Unsigned.$uint2ushort((int)(this.getSubclassDataFromInstruction() & 0xFFFFFFFC | (isTC ? TailCallKind.TCK_Tail : TailCallKind.TCK_None).getValue())));
    }

    public void setTailCallKind(TailCallKind TCK) {
        this.setInstructionSubclassData_CallInst(Unsigned.$uint2ushort((int)(this.getSubclassDataFromInstruction() & 0xFFFFFFFC | TCK.getValue())));
    }

    @Override
    public Value getOperand(int i_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsCallInst.operands(this))) : "getOperand() out of range!";
        return IrRTTI.cast_or_null_Value(((Use)OperandTraitsCallInst.op_begin(this).$at(i_nocapture)).get());
    }

    @Override
    public void setOperand(int i_nocapture, Value Val_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsCallInst.operands(this))) : "setOperand() out of range!";
        ((Use)OperandTraitsCallInst.op_begin(this).$at(i_nocapture)).$assign(Val_nocapture);
    }

    @Override
    public type.ptr<Use> op_begin() {
        return OperandTraitsCallInst.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_begin$Const() {
        return OperandTraitsCallInst.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_end() {
        return OperandTraitsCallInst.op_end(this);
    }

    @Override
    public type.ptr<Use> op_end$Const() {
        return OperandTraitsCallInst.op_end(this);
    }

    @Override
    protected Use Op(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    protected Use Op$Const(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    public int getNumOperands() {
        return OperandTraitsCallInst.operands(this);
    }

    public int getNumArgOperands() {
        return this.getNumOperands() - this.getNumTotalBundleOperands() - 1;
    }

    public Value getArgOperand(int i) {
        assert (Unsigned.$less_uint((int)i, (int)this.getNumArgOperands())) : "Out of bounds!";
        return this.getOperand(i);
    }

    public void setArgOperand(int i, Value v) {
        assert (Unsigned.$less_uint((int)i, (int)this.getNumArgOperands())) : "Out of bounds!";
        this.setOperand(i, v);
    }

    public type.ptr<Use> arg_begin() {
        return this.op_begin();
    }

    public type.ptr<Use> arg_end() {
        return (type.ptr)((type.ptr)this.op_end().$sub(this.getNumTotalBundleOperands())).$sub(1);
    }

    public iterator_range<Use> arg_operands() {
        return llvm.make_range(this.arg_begin(), this.arg_end());
    }

    public type.ptr<Use> arg_begin$Const() {
        return this.op_begin$Const();
    }

    public type.ptr<Use> arg_end$Const() {
        return (type.ptr)((type.ptr)this.op_end$Const().$sub(this.getNumTotalBundleOperands())).$sub(1);
    }

    public iterator_range<Use> arg_operands$Const() {
        return llvm.make_range(this.arg_begin$Const(), this.arg_end$Const());
    }

    public Use getArgOperandUse$Const(int i) {
        assert (Unsigned.$less_uint((int)i, (int)this.getNumArgOperands())) : "Out of bounds!";
        return this.getOperandUse$Const(i);
    }

    public Use getArgOperandUse(int i) {
        assert (Unsigned.$less_uint((int)i, (int)this.getNumArgOperands())) : "Out of bounds!";
        return this.getOperandUse(i);
    }

    public Value getReturnedArgOperand() {
        uint.ptr Index = NativePointer.create_uint$ptr();
        if (this.AttributeList.hasAttrSomewhere(Attribute.AttrKind.Returned, (uint.ptr)Native.$AddrOf((Object)Index)) && Index.$star() != 0) {
            return this.getArgOperand(Index.$star() - 1);
        }
        Function F = this.getCalledFunction();
        if (F != null && F.getAttributes().hasAttrSomewhere(Attribute.AttrKind.Returned, (uint.ptr)Native.$AddrOf((Object)Index)) && Index.$star() != 0) {
            return this.getArgOperand(Index.$star() - 1);
        }
        return null;
    }

    public int getCallingConv() {
        return this.getSubclassDataFromInstruction() >>> 2;
    }

    public void setCallingConv(int CC) {
        int ID2 = CC;
        assert ((ID2 & 0xFFFFFC00) == 0) : "Unsupported calling convention";
        this.setInstructionSubclassData_CallInst(Unsigned.$uint2ushort((int)(this.getSubclassDataFromInstruction() & 3 | ID2 << 2)));
    }

    public AttributeSet getAttributes() {
        return this.AttributeList;
    }

    public void setAttributes(AttributeSet Attrs) {
        this.AttributeList.$assign(Attrs);
    }

    public void addAttribute(int i, Attribute.AttrKind Kind2) {
        AttributeSet PAL = new AttributeSet(this.getAttributes());
        PAL.$assignMove(PAL.addAttribute(this.getContext(), i, Kind2));
        this.setAttributes(PAL);
    }

    public void addAttribute(int i, StringRef Kind2, StringRef Value2) {
        AttributeSet PAL = new AttributeSet(this.getAttributes());
        PAL.$assignMove(PAL.addAttribute(this.getContext(), i, new StringRef(Kind2), new StringRef(Value2)));
        this.setAttributes(PAL);
    }

    public void addAttribute(int i, Attribute Attr) {
        AttributeSet PAL = new AttributeSet(this.getAttributes());
        PAL.$assignMove(PAL.addAttribute(this.getContext(), new ArrayRefUInt(i), new Attribute(Attr)));
        this.setAttributes(PAL);
    }

    public void removeAttribute(int i, Attribute.AttrKind Kind2) {
        AttributeSet PAL = new AttributeSet(this.getAttributes());
        PAL.$assignMove(PAL.removeAttribute(this.getContext(), i, Kind2));
        this.setAttributes(PAL);
    }

    public void removeAttribute(int i, StringRef Kind2) {
        AttributeSet PAL = new AttributeSet(this.getAttributes());
        PAL.$assignMove(PAL.removeAttribute(this.getContext(), i, new StringRef(Kind2)));
        this.setAttributes(PAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(int i, Attribute Attr) {
        AttrBuilder B2 = null;
        try {
            AttributeSet PAL = new AttributeSet(this.getAttributes());
            B2 = new AttrBuilder(Attr);
            LLVMContext Context = this.getContext();
            PAL.$assignMove(PAL.removeAttributes(Context, i, AttributeSet.get(Context, i, B2)));
            this.setAttributes(PAL);
        }
        finally {
            if (B2 != null) {
                B2.$destroy();
            }
        }
    }

    public void addDereferenceableAttr(int i, long Bytes) {
        AttributeSet PAL = new AttributeSet(this.getAttributes());
        PAL.$assignMove(PAL.addDereferenceableAttr(this.getContext(), i, Bytes));
        this.setAttributes(PAL);
    }

    public void addDereferenceableOrNullAttr(int i, long Bytes) {
        AttributeSet PAL = new AttributeSet(this.getAttributes());
        PAL.$assignMove(PAL.addDereferenceableOrNullAttr(this.getContext(), i, Bytes));
        this.setAttributes(PAL);
    }

    public boolean hasFnAttr(Attribute.AttrKind Kind2) {
        assert (Kind2 != Attribute.AttrKind.NoBuiltin) : "Use CallInst::isNoBuiltin() to check for Attribute::NoBuiltin";
        return this.hasFnAttrImpl(Kind2);
    }

    public boolean hasFnAttr(StringRef Kind2) {
        return this.hasFnAttrImpl(new StringRef(Kind2));
    }

    public boolean paramHasAttr(int i, Attribute.AttrKind Kind2) {
        assert (Unsigned.$less_uint((int)i, (int)(this.getNumArgOperands() + 1))) : "Param index out of bounds!";
        if (this.AttributeList.hasAttribute(i, Kind2)) {
            return true;
        }
        Function F = this.getCalledFunction();
        if (F != null) {
            return F.getAttributes().hasAttribute(i, Kind2);
        }
        return false;
    }

    public Attribute getAttribute(int i, Attribute.AttrKind Kind2) {
        return this.getAttributes().getAttribute(i, Kind2);
    }

    public Attribute getAttribute(int i, StringRef Kind2) {
        return this.getAttributes().getAttribute(i, new StringRef(Kind2));
    }

    public boolean dataOperandHasImpliedAttr(int i, Attribute.AttrKind Kind2) {
        assert (Unsigned.$less_uint((int)i, (int)this.getNumOperands())) : "Data operand index out of bounds!";
        if (Unsigned.$less_uint((int)i, (int)(this.getNumArgOperands() + 1))) {
            return this.paramHasAttr(i, Kind2);
        }
        assert (this.hasOperandBundles() && Unsigned.$greatereq_uint((int)i, (int)(this.getBundleOperandsStartIndex() + 1))) : "Must be either a call argument or an operand bundle!";
        return this.bundleOperandHasAttr(i - 1, Kind2);
    }

    public int getParamAlignment(int i) {
        return this.AttributeList.getParamAlignment(i);
    }

    public long getDereferenceableBytes(int i) {
        return this.AttributeList.getDereferenceableBytes(i);
    }

    public long getDereferenceableOrNullBytes(int i) {
        return this.AttributeList.getDereferenceableOrNullBytes(i);
    }

    public boolean doesNotAlias(int n) {
        return this.AttributeList.hasAttribute(n, Attribute.AttrKind.NoAlias);
    }

    public boolean isNoBuiltin() {
        return this.hasFnAttrImpl(Attribute.AttrKind.NoBuiltin) && !this.hasFnAttrImpl(Attribute.AttrKind.Builtin);
    }

    public boolean isNoInline() {
        return this.hasFnAttr(Attribute.AttrKind.NoInline);
    }

    public void setIsNoInline() {
        this.addAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.NoInline);
    }

    public boolean canReturnTwice() {
        return this.hasFnAttr(Attribute.AttrKind.ReturnsTwice);
    }

    public void setCanReturnTwice() {
        this.addAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.ReturnsTwice);
    }

    public boolean doesNotAccessMemory() {
        return this.hasFnAttr(Attribute.AttrKind.ReadNone);
    }

    public void setDoesNotAccessMemory() {
        this.addAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.ReadNone);
    }

    public boolean onlyReadsMemory() {
        return this.doesNotAccessMemory() || this.hasFnAttr(Attribute.AttrKind.ReadOnly);
    }

    public void setOnlyReadsMemory() {
        this.addAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.ReadOnly);
    }

    public boolean doesNotReadMemory() {
        return this.doesNotAccessMemory() || this.hasFnAttr(Attribute.AttrKind.WriteOnly);
    }

    public void setDoesNotReadMemory() {
        this.addAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.WriteOnly);
    }

    public boolean onlyAccessesArgMemory() {
        return this.hasFnAttr(Attribute.AttrKind.ArgMemOnly);
    }

    public void setOnlyAccessesArgMemory() {
        this.addAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.ArgMemOnly);
    }

    public boolean doesNotReturn() {
        return this.hasFnAttr(Attribute.AttrKind.NoReturn);
    }

    public void setDoesNotReturn() {
        this.addAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.NoReturn);
    }

    public boolean doesNotThrow() {
        return this.hasFnAttr(Attribute.AttrKind.NoUnwind);
    }

    public void setDoesNotThrow() {
        this.addAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.NoUnwind);
    }

    public boolean cannotDuplicate() {
        return this.hasFnAttr(Attribute.AttrKind.NoDuplicate);
    }

    public void setCannotDuplicate() {
        this.addAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.NoDuplicate);
    }

    public boolean isConvergent() {
        return this.hasFnAttr(Attribute.AttrKind.Convergent);
    }

    public void setConvergent() {
        this.addAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.Convergent);
    }

    public void setNotConvergent() {
        this.removeAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.get(this.getContext(), Attribute.AttrKind.Convergent));
    }

    public boolean hasStructRetAttr() {
        if (this.getNumArgOperands() == 0) {
            return false;
        }
        return this.paramHasAttr(1, Attribute.AttrKind.StructRet);
    }

    public boolean hasByValArgument() {
        return this.AttributeList.hasAttrSomewhere(Attribute.AttrKind.ByVal);
    }

    public Function getCalledFunction() {
        return IrRTTI.dyn_cast_Function(this.Op$Const(-1));
    }

    public Value getCalledValue$Const() {
        return this.Op$Const(-1).$Value$P();
    }

    public Value getCalledValue() {
        return this.Op(-1).$Value$P();
    }

    public void setCalledFunction(Value Fn) {
        this.setCalledFunction(IrRTTI.cast_FunctionType(IrRTTI.cast_PointerType(Fn.getType()).getElementType()), Fn);
    }

    public void setCalledFunction(FunctionType FTy, Value Fn) {
        this.FTy = FTy;
        assert (FTy == IrRTTI.cast_FunctionType(IrRTTI.cast_PointerType(Fn.getType()).getElementType()));
        this.Op(-1).$assign(Fn);
    }

    public boolean isInlineAsm() {
        return IrRTTI.isa_InlineAsm(this.Op$Const(-1));
    }

    public static boolean classof(Instruction I) {
        return I.getOpcode() == 54;
    }

    public static boolean classof(Value V) {
        return IrRTTI.isa_Instruction(V) && CallInst.classof(IrRTTI.cast_Instruction(V));
    }

    private boolean hasFnAttrImpl(Attribute.AttrKind A2) {
        if (this.AttributeList.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), A2)) {
            return true;
        }
        if (this.isFnAttrDisallowedByOpBundle(A2)) {
            return false;
        }
        Function F = this.getCalledFunction();
        if (F != null) {
            return F.getAttributes().hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), A2);
        }
        return false;
    }

    private void setInstructionSubclassData_CallInst(char D2) {
        super.setInstructionSubclassData(D2);
    }

    protected CallInst() {
        throw new UnsupportedOperationException("EmptyBody");
    }

    private boolean hasFnAttrImpl(StringRef A2) {
        if (this.AttributeList.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), A2)) {
            return true;
        }
        if (this.isFnAttrDisallowedByOpBundle(A2)) {
            return false;
        }
        Function F = this.getCalledFunction();
        if (F != null) {
            return F.getAttributes().hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), A2);
        }
        return false;
    }

    @Override
    public String toString() {
        return "AttributeList=" + this.AttributeList + ", FTy=" + this.FTy + super.toString();
    }

    public static final class TailCallKind
    extends Enum<TailCallKind>
    implements Native.NativeUIntEnum {
        public static final /* enum */ TailCallKind TCK_None = new TailCallKind(0);
        public static final /* enum */ TailCallKind TCK_Tail = new TailCallKind(1);
        public static final /* enum */ TailCallKind TCK_MustTail = new TailCallKind(2);
        public static final /* enum */ TailCallKind TCK_NoTail = new TailCallKind(3);
        private final int value;
        private static final /* synthetic */ TailCallKind[] $VALUES;

        public static TailCallKind[] values() {
            return (TailCallKind[])$VALUES.clone();
        }

        public static TailCallKind valueOf(String name) {
            return Enum.valueOf(TailCallKind.class, name);
        }

        public static TailCallKind valueOf(int val) {
            TailCallKind out;
            TailCallKind tailCallKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private TailCallKind(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new TailCallKind[]{TCK_None, TCK_Tail, TCK_MustTail, TCK_NoTail};
        }

        private static final class Values {
            private static final TailCallKind[] VALUES;
            private static final TailCallKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (TailCallKind kind : TailCallKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new TailCallKind[min < 0 ? 1 - min : 0];
                VALUES = new TailCallKind[max >= 0 ? 1 + max : 0];
                for (TailCallKind kind : TailCallKind.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((TailCallKind)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((TailCallKind)kind).value] = kind;
                }
            }
        }
    }
}

