/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.type;
import org.clank.support.type;
import org.llvm.adt.Twine;
import org.llvm.adt.ilist_iterator;
import org.llvm.adt.ilist_node;
import org.llvm.adt.ilist_node_with_parent;
import org.llvm.ir.BitCastInst;
import org.llvm.ir.BlockAddress;
import org.llvm.ir.BranchInst;
import org.llvm.ir.CallInst;
import org.llvm.ir.ConstantExpr;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.DebugLoc;
import org.llvm.ir.Function;
import org.llvm.ir.Instruction;
import org.llvm.ir.IntrinsicInst;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.LandingPadInst;
import org.llvm.ir.Module$IR;
import org.llvm.ir.PHINode;
import org.llvm.ir.PredIterator;
import org.llvm.ir.ReturnInst;
import org.llvm.ir.SymbolTableList;
import org.llvm.ir.TerminatorInst;
import org.llvm.ir.Type;
import org.llvm.ir.UndefValue;
import org.llvm.ir.User;
import org.llvm.ir.Value;
import org.llvm.ir.ValueSymbolTable;
import org.llvm.ir.impl.CFGLlvmGlobals;
import org.llvm.ir.impl.SymbolTableListTraits;
import org.llvm.ir.java.IChild;
import org.llvm.ir.java.IRMemberPointers;
import org.llvm.ir.java.IValueSymbolTableProvider;
import org.llvm.ir.java.IrRTTI;
import org.llvm.llvmc.LLVMOpaqueBasicBlock;

public class BasicBlock
extends Value
implements ilist_node_with_parent<BasicBlock, Function>,
IChild<Function>,
IValueSymbolTableProvider,
Iterable<Instruction>,
Destructors.ClassWithDestructor,
LLVMOpaqueBasicBlock {
    private final SymbolTableList<Instruction, BasicBlock> InstList;
    private Function Parent;
    private final ilist_node.ilist_node.Fields ilist_node$Flds;

    @Override
    public void setParent(Function parent) {
        this.InstList.setSymTabObject(this.InstList, (type.ptr)Native.$AddrOf((Object)new type.ptr.inout<Function>((Object)this){

            protected Function $star$impl() {
                return BasicBlock.this.Parent;
            }

            protected Function $set$impl(Function value) {
                return BasicBlock.this.Parent = value;
            }
        }), parent);
    }

    protected BasicBlock(BasicBlock $Prm0) {
        super($Prm0);
        throw new UnsupportedOperationException("Deleted");
    }

    protected void $assign(BasicBlock $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private BasicBlock(LLVMContext C2) {
        this(C2, new Twine(NativePointer.$EMPTY), null, null);
    }

    private BasicBlock(LLVMContext C2, Twine Name) {
        this(C2, Name, null, null);
    }

    private BasicBlock(LLVMContext C2, Twine Name, Function NewParent) {
        this(C2, Name, NewParent, null);
    }

    private BasicBlock(LLVMContext C2, Twine Name, Function NewParent, BasicBlock InsertBefore) {
        super(Type.getLabelTy(C2), Value.ValueTy.BasicBlockVal.getValue());
        this.ilist_node$Flds = this.$ilist_node_with_parent();
        this.InstList = new SymbolTableListTraits.Instruction.SymbolTableList.Instruction(this);
        this.Parent = null;
        if (NewParent != null) {
            this.insertInto(NewParent, InsertBefore);
        } else assert (InsertBefore == null) : "Cannot insert block before another block with no function!";
        this.setName(Name);
    }

    @Override
    public LLVMContext getContext() {
        return this.getType().getContext();
    }

    public static BasicBlock Create(LLVMContext Context) {
        return BasicBlock.Create(Context, new Twine(NativePointer.$EMPTY), null, null);
    }

    public static BasicBlock Create(LLVMContext Context, Twine Name) {
        return BasicBlock.Create(Context, Name, null, null);
    }

    public static BasicBlock Create(LLVMContext Context, Twine Name, Function Parent) {
        return BasicBlock.Create(Context, Name, Parent, null);
    }

    public static BasicBlock Create(LLVMContext Context, Twine Name, Function Parent, BasicBlock InsertBefore) {
        return new BasicBlock(Context, Name, Parent, InsertBefore);
    }

    @Override
    public void $destroy() {
        if (this.hasAddressTaken()) {
            assert (!this.use_empty()) : "There should be at least one blockaddress!";
            ConstantInt Replacement = ConstantInt.get(Type.getInt32Ty(this.getContext()), Unsigned.$int2ulong((int)1));
            while (!this.use_empty()) {
                BlockAddress BA = IrRTTI.cast_BlockAddress(this.user_back$Value());
                BA.replaceAllUsesWith(ConstantExpr.getIntToPtr(Replacement, BA.getType()));
                BA.destroyConstant();
            }
        }
        assert (this.getParent() == null) : "BasicBlock still linked into the program!";
        this.dropAllReferences();
        this.InstList.clear();
        this.InstList.$destroy();
        super.$destroy();
        super.$destroy$ilist_node_with_parent();
    }

    public Function getParent$Const() {
        return this.Parent;
    }

    @Override
    public Function getParent() {
        return this.Parent;
    }

    public Module$IR getModule$Const() {
        return this.getParent$Const().getParent$Const();
    }

    public Module$IR getModule() {
        return this.getParent().getParent();
    }

    public TerminatorInst getTerminator() {
        if (this.InstList.empty()) {
            return null;
        }
        return IrRTTI.dyn_cast_TerminatorInst((Instruction)Native.$AddrOf((Object)((Instruction)this.InstList.back())));
    }

    public TerminatorInst getTerminator$Const() {
        if (this.InstList.empty()) {
            return null;
        }
        return IrRTTI.dyn_cast_TerminatorInst((Instruction)Native.$AddrOf((Object)((Instruction)this.InstList.back$Const())));
    }

    public CallInst getTerminatingDeoptimizeCall() {
        Function F;
        if (this.InstList.empty()) {
            return null;
        }
        ReturnInst RI = IrRTTI.dyn_cast_ReturnInst((Instruction)Native.$AddrOf((Object)((Instruction)this.InstList.back())));
        if (RI == null || RI == Native.$AddrOf((Object)((Instruction)this.InstList.front()))) {
            return null;
        }
        CallInst CI = IrRTTI.dyn_cast_or_null_CallInst((Instruction)RI.getPrevNode());
        if (CI != null && (F = CI.getCalledFunction()) != null && F.getIntrinsicID() == 45) {
            return CI;
        }
        return null;
    }

    public CallInst getTerminatingDeoptimizeCall$Const() {
        return this.getTerminatingDeoptimizeCall();
    }

    public CallInst getTerminatingMustTailCall() {
        CallInst CI;
        if (this.InstList.empty()) {
            return null;
        }
        ReturnInst RI = IrRTTI.dyn_cast_ReturnInst((Instruction)Native.$AddrOf((Object)((Instruction)this.InstList.back())));
        if (RI == null || RI == Native.$AddrOf((Object)((Instruction)this.InstList.front()))) {
            return null;
        }
        Instruction Prev = (Instruction)RI.getPrevNode();
        if (Prev == null) {
            return null;
        }
        Value RV = RI.getReturnValue();
        if (RV != null) {
            if (RV != Prev) {
                return null;
            }
            BitCastInst BI = IrRTTI.dyn_cast_BitCastInst(Prev);
            if (BI != null) {
                RV = BI.getOperand(0);
                Prev = (Instruction)BI.getPrevNode();
                if (Prev == null || RV != Prev) {
                    return null;
                }
            }
        }
        if ((CI = IrRTTI.dyn_cast_CallInst(Prev)) != null && CI.isMustTailCall()) {
            return CI;
        }
        return null;
    }

    public CallInst getTerminatingMustTailCall$Const() {
        return this.getTerminatingMustTailCall();
    }

    public Instruction getFirstNonPHI() {
        for (Instruction I : this) {
            if (IrRTTI.isa_PHINode(I)) continue;
            return (Instruction)Native.$AddrOf((Object)I);
        }
        return null;
    }

    public Instruction getFirstNonPHI$Const() {
        return this.getFirstNonPHI();
    }

    public Instruction getFirstNonPHIOrDbg() {
        for (Instruction I : this) {
            if (IrRTTI.isa_PHINode(I) || IrRTTI.isa_DbgInfoIntrinsic(I)) continue;
            return (Instruction)Native.$AddrOf((Object)I);
        }
        return null;
    }

    public Instruction getFirstNonPHIOrDbg$Const() {
        return this.getFirstNonPHIOrDbg();
    }

    public Instruction getFirstNonPHIOrDbgOrLifetime() {
        for (Instruction I : this) {
            IntrinsicInst II;
            if (IrRTTI.isa_PHINode(I) || IrRTTI.isa_DbgInfoIntrinsic(I) || (II = IrRTTI.dyn_cast_IntrinsicInst((Instruction)Native.$AddrOf((Object)I))) != null && (II.getIntrinsicID() == 70 || II.getIntrinsicID() == 69)) continue;
            return (Instruction)Native.$AddrOf((Object)I);
        }
        return null;
    }

    public Instruction getFirstNonPHIOrDbgOrLifetime$Const() {
        return this.getFirstNonPHIOrDbgOrLifetime();
    }

    public ilist_iterator<Instruction> getFirstInsertionPt() {
        Instruction FirstNonPHI = this.getFirstNonPHI();
        if (FirstNonPHI == null) {
            return this.end();
        }
        ilist_iterator InsertPt = FirstNonPHI.getIterator();
        if (((Instruction)InsertPt.$arrow()).isEHPad()) {
            InsertPt.$preInc();
        }
        return InsertPt;
    }

    public ilist_iterator<Instruction> getFirstInsertionPt$Const() {
        return new ilist_iterator(this.getFirstInsertionPt());
    }

    public void removeFromParent() {
        this.getParent().getBasicBlockList().remove_ilist_iterator$NodeTy$C(this.getIterator());
    }

    public ilist_iterator<BasicBlock> eraseFromParent() {
        return this.getParent().getBasicBlockList().erase(this.getIterator());
    }

    public void moveBefore(BasicBlock MovePos) {
        MovePos.getParent().getBasicBlockList().splice(MovePos.getIterator(), this.getParent().getBasicBlockList(), this.getIterator());
    }

    public void moveAfter(BasicBlock MovePos) {
        MovePos.getParent().getBasicBlockList().splice(new ilist_iterator(MovePos.getIterator().$preInc()), this.getParent().getBasicBlockList(), this.getIterator());
    }

    public void insertInto(Function NewParent) {
        this.insertInto(NewParent, null);
    }

    public void insertInto(Function NewParent, BasicBlock InsertBefore) {
        assert (NewParent != null) : "Expected a parent";
        assert (this.Parent == null) : "Already has a parent";
        if (InsertBefore != null) {
            NewParent.getBasicBlockList().insert_ilist_iterator$NodeTy_T$P(InsertBefore.getIterator(), (ilist_node)this);
        } else {
            NewParent.getBasicBlockList().push_back((ilist_node)this);
        }
    }

    public BasicBlock getSinglePredecessor() {
        PredIterator<BasicBlock, Value.user_iterator_impl<User>> E;
        PredIterator<BasicBlock, Value.user_iterator_impl<User>> PI = CFGLlvmGlobals.pred_begin_BasicBlock$P(this);
        if (PI.$eq(E = CFGLlvmGlobals.pred_end_BasicBlock$P(this))) {
            return null;
        }
        BasicBlock ThePred = (BasicBlock)PI.$star();
        PI.$preInc();
        return PI.$eq(E) ? ThePred : null;
    }

    public BasicBlock getSinglePredecessor$Const() {
        return this.getSinglePredecessor();
    }

    public BasicBlock getUniquePredecessor() {
        PredIterator<BasicBlock, Value.user_iterator_impl<User>> E;
        PredIterator<BasicBlock, Value.user_iterator_impl<User>> PI = CFGLlvmGlobals.pred_begin_BasicBlock$P(this);
        if (PI.$eq(E = CFGLlvmGlobals.pred_end_BasicBlock$P(this))) {
            return null;
        }
        BasicBlock PredBB = (BasicBlock)PI.$star();
        PI.$preInc();
        while (PI.$noteq(E)) {
            if (PI.$star() != PredBB) {
                return null;
            }
            PI.$preInc();
        }
        return PredBB;
    }

    public BasicBlock getUniquePredecessor$Const() {
        return this.getUniquePredecessor();
    }

    public BasicBlock getSingleSuccessor() {
        TerminatorInst.SuccIterator<TerminatorInst, BasicBlock> E;
        TerminatorInst.SuccIterator<TerminatorInst, BasicBlock> SI = CFGLlvmGlobals.succ_begin_BasicBlock$P(this);
        if (SI.$eq(E = CFGLlvmGlobals.succ_end_BasicBlock$P(this))) {
            return null;
        }
        Object TheSucc = SI.$star();
        SI.$preInc();
        return SI.$eq(E) ? TheSucc : null;
    }

    public BasicBlock getSingleSuccessor$Const() {
        return this.getSingleSuccessor();
    }

    public BasicBlock getUniqueSuccessor() {
        TerminatorInst.SuccIterator<TerminatorInst, BasicBlock> E;
        TerminatorInst.SuccIterator<TerminatorInst, BasicBlock> SI = CFGLlvmGlobals.succ_begin_BasicBlock$P(this);
        if (SI.$eq(E = CFGLlvmGlobals.succ_end_BasicBlock$P(this))) {
            return null;
        }
        Object SuccBB = SI.$star();
        SI.$preInc();
        while (SI.$noteq(E)) {
            if (SI.$star() != SuccBB) {
                return null;
            }
            SI.$preInc();
        }
        return SuccBB;
    }

    public BasicBlock getUniqueSuccessor$Const() {
        return this.getUniqueSuccessor();
    }

    public ilist_iterator<Instruction> begin() {
        return this.InstList.begin();
    }

    public ilist_iterator<Instruction> begin$Const() {
        return this.InstList.begin$Const();
    }

    public ilist_iterator<Instruction> end() {
        return this.InstList.end();
    }

    public ilist_iterator<Instruction> end$Const() {
        return this.InstList.end$Const();
    }

    public std.reverse_iterator<Instruction> rbegin() {
        return this.InstList.rbegin();
    }

    public std.reverse_iterator<Instruction> rbegin$Const() {
        return this.InstList.rbegin$Const();
    }

    public std.reverse_iterator<Instruction> rend() {
        return this.InstList.rend();
    }

    public std.reverse_iterator<Instruction> rend$Const() {
        return this.InstList.rend$Const();
    }

    public int size() {
        return this.InstList.size();
    }

    public boolean empty() {
        return this.InstList.empty();
    }

    public Instruction front$Const() {
        return (Instruction)this.InstList.front$Const();
    }

    public Instruction front() {
        return (Instruction)this.InstList.front();
    }

    public Instruction back$Const() {
        return (Instruction)this.InstList.back$Const();
    }

    public Instruction back() {
        return (Instruction)this.InstList.back();
    }

    public SymbolTableList<Instruction, BasicBlock> getInstList$Const() {
        return this.InstList;
    }

    public SymbolTableList<Instruction, BasicBlock> getInstList() {
        return this.InstList;
    }

    public static IRMemberPointers.Void2SymbolTableList<Instruction, BasicBlock> getSublistAccess(Instruction $Prm0) {
        return $this -> $this.InstList;
    }

    @Override
    public ValueSymbolTable getValueSymbolTable() {
        Function F = this.getParent();
        if (F != null) {
            return (ValueSymbolTable)Native.$AddrOf((Object)F.getValueSymbolTable());
        }
        return null;
    }

    public static boolean classof(Value V) {
        return V.getValueID() == Value.ValueTy.BasicBlockVal.getValue();
    }

    public void dropAllReferences() {
        for (Instruction I : this) {
            I.dropAllReferences();
        }
    }

    public void removePredecessor(BasicBlock Pred) {
        this.removePredecessor(Pred, false);
    }

    public void removePredecessor(BasicBlock Pred, boolean DontDeleteUselessPHIs) {
        PHINode PN;
        BasicBlock Other;
        assert (this.hasNUsesOrMore(16) || ((PredIterator)std.find(CFGLlvmGlobals.pred_begin_BasicBlock$P(this), CFGLlvmGlobals.pred_end_BasicBlock$P(this), (Object)Pred)).$noteq(CFGLlvmGlobals.pred_end_BasicBlock$P(this))) : "removePredecessor: BB is not a predecessor!";
        if (this.InstList.empty()) {
            return;
        }
        PHINode APN = IrRTTI.dyn_cast_PHINode((Instruction)Native.$AddrOf((Object)this.front()));
        if (APN == null) {
            return;
        }
        int max_idx = APN.getNumIncomingValues();
        assert (max_idx != 0) : "PHI Node in block with 0 predecessors!?!?!";
        if (max_idx == 2 && this == (Other = APN.getIncomingBlock(APN.getIncomingBlock(0) == Pred ? 1 : 0))) {
            max_idx = 3;
        }
        if (Unsigned.$lesseq_uint((int)max_idx, (int)2) && !DontDeleteUselessPHIs) {
            while ((PN = IrRTTI.dyn_cast_PHINode((Instruction)Native.$AddrOf((Object)this.front()))) != null) {
                PN.removeIncomingValue(Pred, !DontDeleteUselessPHIs);
                if (max_idx != 2) continue;
                if (PN.getIncomingValue(0) != PN) {
                    PN.replaceAllUsesWith(PN.getIncomingValue(0));
                } else {
                    PN.replaceAllUsesWith(UndefValue.get(PN.getType()));
                }
                this.getInstList().pop_front();
            }
        } else {
            ilist_iterator<Instruction> II = this.begin();
            while ((PN = IrRTTI.dyn_cast_PHINode((Instruction)II.$star())) != null) {
                II.$preInc();
                PN.removeIncomingValue(Pred, false);
                Value PNV = null;
                if (DontDeleteUselessPHIs || (PNV = PN.hasConstantValue()) == null || PNV == PN) continue;
                PN.replaceAllUsesWith(PNV);
                PN.eraseFromParent();
            }
        }
    }

    public boolean canSplitPredecessors() {
        Instruction FirstNonPHI = this.getFirstNonPHI$Const();
        if (IrRTTI.isa_LandingPadInst(FirstNonPHI)) {
            return true;
        }
        return !FirstNonPHI.isEHPad();
    }

    public BasicBlock splitBasicBlock(ilist_iterator<Instruction> I) {
        return this.splitBasicBlock(I, new Twine(NativePointer.$EMPTY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicBlock splitBasicBlock(ilist_iterator<Instruction> I, Twine BBName) {
        DebugLoc Loc = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            assert (this.getTerminator() != null) : "Can't use splitBasicBlock on degenerate BB!";
            assert (I.$noteq(this.InstList.end())) : "Trying to get me to create degenerate basic block!";
            BasicBlock New2 = BasicBlock.Create(this.getContext(), BBName, this.getParent(), (BasicBlock)super.getNextNode());
            Loc = new DebugLoc(((Instruction)I.$arrow()).getDebugLoc());
            New2.getInstList().splice(New2.end(), this.getInstList(), new ilist_iterator(I), this.end());
            BranchInst BI = BranchInst.Create(New2, this);
            BI.setDebugLoc((DebugLoc)$c$.track((Object)new DebugLoc(Loc)));
            $c$.clean();
            TerminatorInst.SuccIterator<TerminatorInst, BasicBlock> I$1 = CFGLlvmGlobals.succ_begin_BasicBlock$P(New2);
            TerminatorInst.SuccIterator<TerminatorInst, BasicBlock> E = CFGLlvmGlobals.succ_end_BasicBlock$P(New2);
            while (I$1.$noteq(E)) {
                PHINode PN;
                Object Successor = I$1.$star();
                ilist_iterator<Instruction> II = ((BasicBlock)Successor).begin();
                while ((PN = IrRTTI.dyn_cast_PHINode((Instruction)II.$star())) != null) {
                    int IDX = PN.getBasicBlockIndex(this);
                    while (IDX != -1) {
                        PN.setIncomingBlock(IDX, New2);
                        IDX = PN.getBasicBlockIndex(this);
                    }
                    II.$preInc();
                }
                I$1.$preInc();
            }
            BasicBlock basicBlock = New2;
            return basicBlock;
        }
        finally {
            if (Loc != null) {
                Loc.$destroy();
            }
            $c$.$destroy();
        }
    }

    public BasicBlock splitBasicBlock(Instruction I) {
        return this.splitBasicBlock(I, new Twine(NativePointer.$EMPTY));
    }

    public BasicBlock splitBasicBlock(Instruction I, Twine BBName) {
        return this.splitBasicBlock((ilist_iterator<Instruction>)I.getIterator(), BBName);
    }

    public boolean hasAddressTaken() {
        return Unsigned.$ushort2int((char)this.getSubclassDataFromValue()) != 0;
    }

    public void replaceSuccessorsPhiUsesWith(BasicBlock New2) {
        TerminatorInst TI = this.getTerminator();
        if (TI == null) {
            return;
        }
        for (BasicBlock Succ : TI.successors()) {
            PHINode PN;
            ilist_iterator<Instruction> II = Succ.begin();
            ilist_iterator<Instruction> IE = Succ.end();
            while (II.$noteq(IE) && (PN = (PHINode)Native.$tryClone((Object)IrRTTI.dyn_cast_PHINode((Instruction)II.$star()))) != null) {
                int i;
                while ((i = PN.getBasicBlockIndex(this)) >= 0) {
                    PN.setIncomingBlock(i, New2);
                }
                II.$preInc();
            }
        }
    }

    public boolean isEHPad() {
        return this.getFirstNonPHI$Const().isEHPad();
    }

    public boolean isLandingPad() {
        return IrRTTI.isa_LandingPadInst(this.getFirstNonPHI$Const());
    }

    public LandingPadInst getLandingPadInst() {
        return IrRTTI.dyn_cast_LandingPadInst(this.getFirstNonPHI());
    }

    public LandingPadInst getLandingPadInst$Const() {
        return IrRTTI.dyn_cast_LandingPadInst(this.getFirstNonPHI$Const());
    }

    void AdjustBlockAddressRefCount(int Amt) {
        this.setValueSubclassData_BasicBlock(Unsigned.$int2ushort((int)(Unsigned.$ushort2int((char)this.getSubclassDataFromValue()) + Amt)));
        assert (Unsigned.$ushort2schar((char)this.getSubclassDataFromValue()) >= 0) : "Refcount wrap-around";
    }

    private void setValueSubclassData_BasicBlock(char D2) {
        super.setValueSubclassData(D2);
    }

    @Override
    public Iterator<Instruction> iterator() {
        return new JavaIterator(this.begin(), this.end());
    }

    public static BasicBlock $createSentinel() {
        return new BasicBlock();
    }

    private BasicBlock() {
        this.ilist_node$Flds = this.$ilist_node_with_parent();
        this.InstList = null;
    }

    public final ilist_node.ilist_node.Fields $ilist_node$Fields() {
        return this.ilist_node$Flds;
    }

    @Override
    public String toString() {
        if (this.$isSentinel()) {
            return "Sentinel " + this.getClass().getSimpleName();
        }
        return "InstList=" + this.InstList + ", Parent=" + this.Parent + super.toString();
    }
}

